/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.core.EngineObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SetImpl;
import com.filenet.apiimpl.core.SubListImpl;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectListImpl;
import com.filenet.apiimpl.property.PropertyEngineObjectSetImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.transport.GetObjectRequest;
import com.filenet.apiimpl.transport.GetObjectResponse;
import com.filenet.apiimpl.transport.ObjectRequest;
import com.filenet.apiimpl.transport.ObjectResponse;
import com.filenet.apiimpl.util.ClassKey;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.CollectionTerminatorSerialization;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import java.util.ArrayList;
import java.util.List;

public class GetObjectsResponseSerialization
extends Serialization {
    public static final GetObjectsResponseSerialization INSTANCE = new GetObjectsResponseSerialization();
    public static final Serialization ENGINE_OBJECT = new Serialization(){

        public void serialize(Object object, SerializerContext context) throws Exception {
            if (context.getVersion() > 300) {
                context.writeSchemaType("SingleObjectResponse");
            }
            context.serializeObject("Object", EngineObjectSerialization.INSTANCE, object);
        }
    };
    public static final Serialization PROPERTY_OBJECT = new Serialization(){

        public void serialize(Object object, SerializerContext context) throws Exception {
            if (context.getVersion() > 300) {
                context.writeSchemaType("SingleObjectResponse");
            }
            context.serializeObject("Object", EngineObjectSerialization.INSTANCE, ((PropertyEngineObjectImpl)object).getInstanceValue());
        }

        public Object deserialize(Object object, DeserializerContext context) throws Exception {
            PropertyDeserializerCall call = (PropertyDeserializerCall)object;
            UnevaluatedPropertyValue reference = (UnevaluatedPropertyValue)call.request;
            EngineObjectImpl value = (EngineObjectImpl)EngineObjectSerialization.INSTANCE.deserialize(object, context);
            PropertyEngineObjectImpl property = new PropertyEngineObjectImpl(reference.getPropertyName(), value, 7);
            property.setDirty(false);
            return property;
        }
    };
    public static final Serialization PROPERTY_LIST = new Serialization(){

        public void serialize(Object object, SerializerContext context) throws Exception {
            if (context.getVersion() > 300) {
                context.writeSchemaType("ObjectSetResponse");
                if (context.getVersion() > 350) {
                    context.writeAttribute("collectionType", "List");
                }
            }
            context.enterElement("ObjectSet", context.getOptionalSchemaType("ObjectSetType"));
            context.serializeObjectArray("Object", EngineObjectSerialization.INSTANCE, Util.objects((List)((PropertyImpl)object).getInstanceValue()));
            context.leaveElement();
        }

        public Object deserialize(Object object, DeserializerContext context) throws Exception {
            PropertyDeserializerCall call = (PropertyDeserializerCall)object;
            UnevaluatedPropertyValue reference = (UnevaluatedPropertyValue)call.request;
            context.nextElementToken();
            ArrayList<Object> list = new ArrayList<Object>();
            while (context.isStartToken("Object")) {
                call.propertyIndex = new Integer(list.size());
                Object value = context.deserializeObject(EngineObjectSerialization.INSTANCE, (Object)call);
                list.add(value);
            }
            call.propertyIndex = null;
            context.deserializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, null);
            PropertyEngineObjectListImpl property = new PropertyEngineObjectListImpl(reference.getPropertyName(), new SubListImpl(EngineObject.class, list), 7);
            property.setDirty(false);
            return property;
        }
    };
    public static final Serialization PROPERTY_SET = new Serialization(){

        public void serialize(Object object, SerializerContext context) throws Exception {
            if (context.getVersion() > 300) {
                context.writeSchemaType("ObjectSetResponse");
                if (context.getVersion() > 350) {
                    context.writeAttribute("collectionType", "Enum");
                }
            }
            SetImpl set = (SetImpl)((PropertyImpl)object).getInstanceValue();
            context.enterElement("ObjectSet", context.getOptionalSchemaType("ObjectSetType"));
            context.serializeObjectArray("Object", EngineObjectSerialization.INSTANCE, Util.objects(set));
            if (set.getTraversalError() == null) {
                context.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)Util.nullAsEmpty(Util.continuation(set)));
            } else {
                context.serializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, (Object)set.getTraversalError());
            }
            context.leaveElement();
        }

        public Object deserialize(Object object, DeserializerContext context) throws Exception {
            PropertyDeserializerCall call = (PropertyDeserializerCall)object;
            UnevaluatedPropertyValue reference = (UnevaluatedPropertyValue)call.request;
            context.nextElementToken();
            ArrayList list = (ArrayList)context.deserializeObjectList("Object", EngineObjectSerialization.INSTANCE, call);
            Object collectionTerm = context.deserializeObject("CollectionTerminator", CollectionTerminatorSerialization.INSTANCE, null);
            String continuation = null;
            EngineRuntimeException traversalError = null;
            if (collectionTerm instanceof String) {
                continuation = (String)collectionTerm;
            } else if (collectionTerm instanceof EngineRuntimeException) {
                traversalError = (EngineRuntimeException)collectionTerm;
            }
            SubSetImpl set = Util.createIndependentObjectSet(context.getConnection(), list, continuation, (ObjectReferenceBase)reference.getParentReference(), reference.getPropertyName(), call.filter, call.maxElements);
            set.setTraversalError(traversalError);
            PropertyEngineObjectSetImpl property = new PropertyEngineObjectSetImpl(reference.getPropertyName(), set, 7);
            property.setDirty(false);
            return property;
        }
    };
    public static final Serialization EXCEPTION = new Serialization(){

        public void serialize(Object object, SerializerContext context) throws Exception {
            if (context.getVersion() > 300) {
                context.writeSchemaType("ErrorStackResponse");
            }
            context.serializeObject("ErrorStack", ExceptionSerialization.INSTANCE, object);
        }
    };

    public void serialize(Object object, SerializerContext context) throws Exception {
        GetObjectResponse respones = (GetObjectResponse)object;
        ObjectResponse[] batch = respones.getBatch();
        for (int i = 0; i < batch.length; ++i) {
            ObjectResponse response = batch[i];
            Object value = response.getValue();
            if (value instanceof PropertyEngineObjectImpl && ((PropertyEngineObjectImpl)value).getInstanceValue() == null) {
                value = new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_FOUND);
            }
            context.clearObjects();
            context.enterElement("ObjectResponse");
            context.writeAttribute("id", response.getCorrelationId());
            if (context.getVersion() == 300) {
                context.writeOptionalSchemaType("ObjectResponseType");
            }
            context.serializeObject(new ClassKey("ObjectResponseType", value.getClass()), value);
            context.leaveElement();
        }
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        ObjectRequest[] requests = GetObjectsResponseSerialization.getRequests(context);
        ArrayList<ObjectResponse> responses = new ArrayList<ObjectResponse>();
        while (true) {
            if (!Util.isStartToken(context.nextElementToken())) break;
            ObjectRequest request = GetObjectsResponseSerialization.getRequest(requests, responses.size());
            ObjectReferenceBase reference = request.getObjectReference();
            boolean property = reference instanceof UnevaluatedPropertyValue;
            context.clearObjects();
            String id = Util.emptyAsNull(context.getAttribute("id"));
            String collectionType = Util.emptyAsNull(context.getAttribute("collectionType"));
            context.nextStartToken();
            Object value = context.deserializeObject(new DeserializerKey(context.getLocalName(), property, collectionType), (Object)new PropertyDeserializerCall(request));
            context.checkEndToken();
            ObjectResponse response = new ObjectResponse();
            response.putValue(value);
            response.setCorrelationId(id);
            responses.add(response);
        }
        context.checkEndToken();
        ObjectResponse[] batch = responses.toArray(new ObjectResponse[responses.size()]);
        return new GetObjectResponse(batch);
    }

    private static ObjectRequest[] getRequests(DeserializerContext context) {
        GetObjectRequest request = (GetObjectRequest)context.getRequest();
        if (request == null) {
            throw new IllegalStateException("request == null");
        }
        ObjectRequest[] requests = request.getBatch();
        if (requests == null) {
            throw new IllegalStateException("requests == null");
        }
        return requests;
    }

    private static ObjectRequest getRequest(ObjectRequest[] requests, int index) {
        if (index >= requests.length) {
            throw new IllegalStateException("index >= requests.length: index=" + index + " requests.length=" + requests.length);
        }
        ObjectRequest request = requests[index];
        if (request == null) {
            throw new IllegalStateException("request == null: index=" + index);
        }
        return request;
    }

    public static final class DeserializerKey {
        private final String element;
        private final boolean property;
        private final boolean list;
        private final int hash;

        public DeserializerKey(String element, boolean property, String collectionType) {
            this.element = element;
            this.property = property && !element.equals("ErrorStack");
            this.list = this.property && "List".equals(collectionType);
            this.hash = this.element.hashCode() + Boolean.valueOf(this.property).hashCode() + Boolean.valueOf(this.list).hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeserializerKey)) {
                return false;
            }
            DeserializerKey other = (DeserializerKey)o;
            return this.hash == other.hash && this.property == other.property && this.list == other.list && this.element.equals(other.element);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

