/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.transport.ContentRequest;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.util.ArrayList;

public class GetContentRequestSerialization
extends Serialization {
    public static final GetContentRequestSerialization INSTANCE = new GetContentRequestSerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        GetContentRequest gcr = (GetContentRequest)object;
        if (gcr.getValidateOnly()) {
            context.writeAttribute("validateOnly", Util.toBooleanString(Boolean.TRUE));
        }
        ContentRequest[] batch = gcr.getBatch();
        for (int i = 0; i < batch.length; ++i) {
            ContentRequest request = batch[i];
            context.enterElement("ContentRequest", null);
            context.writeAttribute("id", request.getCorrelationId());
            context.writeAttribute("cacheAllowed", Util.toBooleanString(request.getCacheAllowed()));
            context.writeAttribute("continueFrom", request.getContinueFrom());
            context.writeAttribute("startOffset", Util.toUnsignedLongString(request.getStartOffset()));
            context.writeAttribute("maxBytes", Util.toIntString(request.getMaxBytes()));
            context.serializeReference("SourceSpecification", request.getObjectReference());
            context.enterElement("ElementSpecification", null);
            context.writeAttribute("itemIndex", Util.toIntString(request.getItemIndex()));
            context.writeAttribute("elementSequenceNumber", Util.toIntString(request.getElementSequenceNumber()));
            context.leaveElement();
            context.leaveElement();
        }
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        Boolean validateOnly = Util.parseBoolean(context.getAttribute("validateOnly"));
        ArrayList<ContentRequest> requests = new ArrayList<ContentRequest>();
        while (true) {
            if (!Util.isStartToken(context.nextElementToken())) break;
            String correlationId = context.getAttribute("id");
            Boolean cacheAllowed = Util.parseBoolean(context.getAttribute("cacheAllowed"));
            String continueFrom = context.getAttribute("continueFrom");
            Long startOffset = Util.parseLong(context.getAttribute("startOffset"));
            Integer maxBytes = Util.parseInteger(context.getAttribute("maxBytes"));
            context.nextElementToken();
            ObjectReferenceBase reference = (ObjectReferenceBase)context.deserializeObject("SourceSpecification", ObjectReferenceSerialization.INSTANCE, null);
            Integer itemIndex = null;
            Integer elementSequenceNumber = null;
            if (!context.isStartToken("ElementSpecification")) {
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, "ElementSpecification");
            }
            itemIndex = Util.parseInteger(context.getAttribute("itemIndex"));
            elementSequenceNumber = Util.parseInteger(context.getAttribute("elementSequenceNumber"));
            context.nextElementToken();
            context.checkEndToken();
            context.nextElementToken();
            context.checkEndToken();
            ContentRequest request = new ContentRequest(reference, cacheAllowed, correlationId, elementSequenceNumber, itemIndex, startOffset, maxBytes, continueFrom);
            requests.add(request);
        }
        context.checkEndToken();
        ContentRequest[] batch = requests.toArray(new ContentRequest[requests.size()]);
        GetContentRequest request = new GetContentRequest(batch);
        if (validateOnly != null) {
            request.setValidateOnly(validateOnly);
        }
        return request;
    }
}

