/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.constants.GroupAction;
import com.filenet.api.constants.PrincipalSearchAttribute;
import com.filenet.api.constants.PrincipalSearchSortType;
import com.filenet.api.constants.PrincipalSearchType;
import com.filenet.api.constants.RequiredState;
import com.filenet.api.constants.SearchModifier;
import com.filenet.api.constants.SortOrder;
import com.filenet.api.constants.VersionSelection;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.Folder;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.query.SearchTemplateContent;
import com.filenet.api.query.SearchTemplateContentItem;
import com.filenet.api.query.SearchTemplateFolder;
import com.filenet.api.query.SearchTemplateParameters;
import com.filenet.api.query.SearchTemplateSelectProperty;
import com.filenet.api.query.SearchTemplateSubclass;
import com.filenet.api.query.SearchTemplateWhereProperty;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.constants.SearchMode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.query.PrincipalSearch;
import com.filenet.apiimpl.query.RepositorySearch;
import com.filenet.apiimpl.query.RepositoryStoredSearch;
import com.filenet.apiimpl.query.Search;
import com.filenet.apiimpl.query.SearchScope;
import com.filenet.apiimpl.transport.SearchRequest;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.SearchScopeSerialization;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.TokenReader;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.FilterSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteSearchRequestSerialization
extends Serialization {
    private static HashMap MAP_SEARCH_MODE = new HashMap();
    private static HashMap MAP_PRINCIPAL_SEARCH_TYPE = new HashMap();
    private static HashMap MAP_PRINCIPAL_SEARCH_ATTR = new HashMap();
    private static HashMap MAP_PRINCIPAL_SORT = new HashMap();
    public static final ExecuteSearchRequestSerialization INSTANCE;

    @Override
    public void serialize(Object object, SerializerContext context) throws Exception {
        SearchRequest request = (SearchRequest)object;
        Search search = request.getSearch();
        String searchType = null;
        searchType = search instanceof RepositorySearch ? "RepositorySearch" : (search instanceof RepositoryStoredSearch ? "StoredSearch" : "PrincipalSearch");
        context.writeSchemaType(searchType);
        context.writeAttribute("maxElements", Util.toIntString(request.getMaxElements()));
        context.writeAttribute("continueFrom", request.getContinueFrom());
        context.writeAttribute("continuable", Util.toBooleanString(request.getContinueable()));
        if (searchType.equals("RepositorySearch")) {
            if (request.getSearchMode() == SearchMode.OBJECTS) {
                context.writeAttribute("repositorySearchMode", "Objects");
            }
            context.serializeObject("SelectionFilter", FilterSerialization.INSTANCE, (Object)search.getPropertyFilter());
            context.serializeObject("SearchScope", SearchScopeSerialization.INSTANCE, (Object)request.getSearchScope());
            context.writeElement("SearchSQL", null, ((RepositorySearch)search).getSQL());
        } else if (searchType.equals("StoredSearch")) {
            if (request.getSearchMode() == SearchMode.OBJECTS) {
                context.writeAttribute("repositorySearchMode", "Objects");
            }
            context.serializeObject("SelectionFilter", FilterSerialization.INSTANCE, (Object)search.getPropertyFilter());
            ObjectReferenceBase searchObject = (ObjectReferenceBase)((RepositoryStoredSearch)search).getSearchObject();
            context.serializeReference("SearchObject", searchObject);
            this.writeExecuteData(context, request, search);
        } else {
            PrincipalSearch ps = (PrincipalSearch)search;
            context.writeAttribute("includeUsers", Util.toBooleanString(ps.getIncludeUsers()));
            context.writeAttribute("includeGroups", Util.toBooleanString(ps.getIncludeGroups()));
            ExecuteSearchRequestSerialization.writePrincipalSearchType(context, ps.getSearchType());
            ExecuteSearchRequestSerialization.writePrincipalSearchAttribute(context, ps.getSearchAttribute());
            ExecuteSearchRequestSerialization.writePrincipalSearchSortType(context, ps.getSearchSortType());
            context.serializeObject("SelectionFilter", FilterSerialization.INSTANCE, (Object)search.getPropertyFilter());
            context.writeElement("SearchRealm", null, ps.getSearchRealm());
            context.writeElement("SearchPattern", null, ps.getSearchPattern());
        }
        context.leaveElement();
    }

    private void writeExecuteData(SerializerContext context, SearchRequest request, Search search) throws Exception {
        context.enterElement("ExecuteXML");
        context.serializeObject("SearchScope", SearchScopeSerialization.INSTANCE, (Object)request.getSearchScope());
        SearchTemplateParameters parameters = ((RepositoryStoredSearch)search).getTemplateData();
        String maxRecordsValue = null;
        String versionSelectionValue = null;
        List<String> selectList = null;
        List<SearchTemplateFolder> folders = null;
        List<SearchTemplateSelectProperty> selectProps = null;
        List<SearchTemplateSubclass> subclasses = null;
        List<SearchTemplateWhereProperty> whereProps = null;
        SearchTemplateContent content = null;
        if (parameters != null) {
            VersionSelection versionSelection;
            Integer maxRecords = parameters.getMaximumRecords();
            if (maxRecords != null) {
                maxRecordsValue = maxRecords.toString();
            }
            if ((versionSelection = parameters.getVersionSelection()) != null) {
                versionSelectionValue = versionSelection.toString();
            }
            selectList = parameters.getAugmentedSelectList();
            folders = parameters.getFolders();
            selectProps = parameters.getSelectProperties();
            subclasses = parameters.getSubclasses();
            whereProps = parameters.getWhereProperties();
            content = parameters.getContent();
        }
        context.writeElement("FromClass", null, ((RepositoryStoredSearch)search).getFromClass());
        context.writeElement("VersionSelection", null, versionSelectionValue);
        context.writeElement("MaxRows", null, maxRecordsValue);
        this.writeSelectList(context, selectList);
        this.writeFolders(context, folders);
        this.writeSelectProps(context, selectProps);
        this.writeSubclasses(context, subclasses);
        this.writeWhereProps(context, whereProps);
        this.writeContentSearch(context, content);
        context.leaveElement();
    }

    private void writeSelectList(SerializerContext context, List<String> selectList) throws Exception {
        if (selectList != null) {
            context.enterElement("SelectList");
            int count = selectList.size();
            for (int ix = 0; ix < count; ++ix) {
                context.writeElement("Selection", null, selectList.get(ix));
            }
            context.leaveElement();
        }
    }

    private void writeFolders(SerializerContext context, List<SearchTemplateFolder> folders) throws Exception {
        if (folders != null) {
            context.enterElement("Folders");
            int count = folders.size();
            for (int ix = 0; ix < count; ++ix) {
                SearchTemplateFolder folder = folders.get(ix);
                context.enterElement("Folder");
                context.writeElement("ExcludeFromQuery", null, folder.getExcludeFromQuery() == null ? null : folder.getExcludeFromQuery().toString());
                context.writeElement("ItemId", null, folder.getItemId());
                Folder f = folder.getFolder();
                if (f != null) {
                    ObjectReferenceBase or = (ObjectReferenceBase)f.getObjectReference();
                    context.serializeReference("FolderObject", or);
                }
                context.writeElement("SearchSubfolders", null, folder.getSearchSubFolders() == null ? null : folder.getSearchSubFolders().toString());
                context.leaveElement();
            }
            context.leaveElement();
        }
    }

    private void writeSelectProps(SerializerContext context, List<SearchTemplateSelectProperty> selectProps) throws Exception {
        if (selectProps != null) {
            context.enterElement("SelectProperties");
            int count = selectProps.size();
            for (int ix = 0; ix < count; ++ix) {
                SearchTemplateSelectProperty selectProp = selectProps.get(ix);
                context.enterElement("SelectProperty");
                context.writeElement("ExcludeFromQuery", null, selectProp.getExcludeFromQuery() == null ? null : selectProp.getExcludeFromQuery().toString());
                context.writeElement("ItemId", null, selectProp.getItemId());
                context.writeElement("SymbolicName", null, selectProp.getSymbolicName());
                context.writeElement("SortLevel", null, selectProp.getSortLevel() == null ? null : selectProp.getSortLevel().toString());
                context.writeElement("SortOrder", null, selectProp.getSortOrder() == null ? null : selectProp.getSortOrder().toString());
                context.leaveElement();
            }
            context.leaveElement();
        }
    }

    private void writeSubclasses(SerializerContext context, List<SearchTemplateSubclass> subclasses) throws Exception {
        if (subclasses != null) {
            context.enterElement("Subclasses");
            int count = subclasses.size();
            for (int ix = 0; ix < count; ++ix) {
                SearchTemplateSubclass subclass = subclasses.get(ix);
                context.enterElement("Subclass");
                context.writeElement("ExcludeFromQuery", null, subclass.getExcludeFromQuery() == null ? null : subclass.getExcludeFromQuery().toString());
                context.writeElement("ItemId", null, subclass.getItemId());
                context.writeElement("SymbolicName", null, subclass.getSymbolicName());
                context.writeElement("IncludeSubclasses", null, subclass.getIncludeSubclasses() == null ? null : subclass.getIncludeSubclasses().toString());
                context.leaveElement();
            }
            context.leaveElement();
        }
    }

    private void writeWhereProps(SerializerContext context, List<SearchTemplateWhereProperty> whereProps) throws Exception {
        if (whereProps != null) {
            context.enterElement("WhereProperties");
            int count = whereProps.size();
            for (int ix = 0; ix < count; ++ix) {
                SearchTemplateWhereProperty whereProp = whereProps.get(ix);
                context.enterElement("WhereProperty");
                context.writeElement("ExcludeFromQuery", null, whereProp.getExcludeFromQuery() == null ? null : whereProp.getExcludeFromQuery().toString());
                context.writeElement("ItemId", null, whereProp.getItemId());
                context.writeElement("Literal", null, whereProp.getLiteral());
                context.leaveElement();
            }
            context.leaveElement();
        }
    }

    private void writeContentSearch(SerializerContext context, SearchTemplateContent contentSearch) throws Exception {
        if (contentSearch != null) {
            context.enterElement("ContentSearch");
            context.writeElement("Rank", null, contentSearch.getRank() == null ? null : contentSearch.getRank().toString());
            context.writeElement("Summary", null, contentSearch.getSummary() == null ? null : contentSearch.getSummary().toString());
            List<SearchTemplateContentItem> contentItems = contentSearch.getContentItems();
            if (contentItems != null) {
                context.enterElement("ContentItems");
                int count = contentItems.size();
                for (int ix = 0; ix < count; ++ix) {
                    SearchTemplateContentItem item = contentItems.get(ix);
                    context.enterElement("ContentItem");
                    context.writeElement("ExcludeFromQuery", null, item.getExcludeFromQuery() == null ? null : item.getExcludeFromQuery().toString());
                    context.writeElement("ItemId", null, item.getItemId());
                    context.writeElement("SearchModifier", null, item.getSearchModifier() == null ? null : item.getSearchModifier().toString());
                    context.writeElement("SearchModifierRange", null, item.getSearchModifierRange() == null ? null : item.getSearchModifierRange().toString());
                    context.writeElement("RequiredState", null, item.getRequiredState() == null ? null : item.getRequiredState().toString());
                    context.writeElement("GroupAction", null, item.getGroupAction() == null ? null : item.getGroupAction().toString());
                    List<String> itemData = item.getItemData();
                    if (itemData != null) {
                        context.enterElement("ItemData");
                        int size = itemData.size();
                        for (int i = 0; i < size; ++i) {
                            context.writeElement("Data", null, itemData.get(i));
                        }
                        context.leaveElement();
                    }
                    context.leaveElement();
                }
                context.leaveElement();
            }
            context.leaveElement();
        }
    }

    private static void writePrincipalSearchType(SerializerContext context, PrincipalSearchType pst) throws Exception {
        if (pst != null) {
            String value = null;
            switch (pst.getValue()) {
                case 1: {
                    value = "Custom";
                    break;
                }
                case 2: {
                    value = "PrefixMatch";
                    break;
                }
                case 3: {
                    value = "SuffixMatch";
                    break;
                }
                case 4: {
                    value = "Contains";
                    break;
                }
                case 5: {
                    value = "Exact";
                }
            }
            context.writeAttribute("principalSearchType", value);
        }
    }

    private static void writePrincipalSearchAttribute(SerializerContext context, PrincipalSearchAttribute psa) throws Exception {
        if (psa != null) {
            String value = null;
            switch (psa.getValue()) {
                case 1: {
                    value = "ShortName";
                    break;
                }
                case 2: {
                    value = "DisplayName";
                }
            }
            context.writeAttribute("principalSearchAttribute", value);
        }
    }

    private static void writePrincipalSearchSortType(SerializerContext context, PrincipalSearchSortType pst) throws Exception {
        if (pst != null) {
            String value = null;
            switch (pst.getValue()) {
                case 1: {
                    value = "Ascending";
                    break;
                }
                case 2: {
                    value = "Descending";
                }
            }
            context.writeAttribute("principalSort", value);
        }
    }

    @Override
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        Integer maxElements = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("maxElements")));
        String continueFrom = context.getAttribute("continueFrom");
        Boolean continuable = Util.parseBoolean(context.getAttribute("continuable"));
        String stype = context.getXsiType();
        if (stype.equals("RepositorySearch")) {
            SearchMode mode = (SearchMode)context.deserializeEnumAttribute("repositorySearchMode", false, MAP_SEARCH_MODE, SearchMode.ROWS);
            context.nextStartToken();
            PropertyFilter pf = (PropertyFilter)context.deserializeObject("SelectionFilter", FilterSerialization.INSTANCE, null);
            SearchScope scope = (SearchScope)context.deserializeObject("SearchScope", SearchScopeSerialization.INSTANCE, null);
            String searchSQL = context.readElement("SearchSQL");
            context.checkEndToken();
            RepositorySearch search = new RepositorySearch();
            search.setSQL(searchSQL);
            search.setPropertyFilter(pf);
            SearchRequest request = new SearchRequest(mode, search, scope, maxElements, continuable, continueFrom);
            return request;
        }
        if (stype.equals("StoredSearch")) {
            SearchMode mode = (SearchMode)context.deserializeEnumAttribute("repositorySearchMode", false, MAP_SEARCH_MODE, SearchMode.ROWS);
            context.nextStartToken();
            PropertyFilter pf = (PropertyFilter)context.deserializeObject("SelectionFilter", FilterSerialization.INSTANCE, null);
            ObjectReferenceBase searchObject = (ObjectReferenceBase)context.deserializeObject("SearchObject", ObjectReferenceSerialization.INSTANCE, null);
            context.nextElementToken();
            SearchScope scope = (SearchScope)context.deserializeObject("SearchScope", SearchScopeSerialization.INSTANCE, null);
            String fromClass = context.readElement("FromClass");
            VersionSelection vselect = this.getVersionSelection(context);
            Integer maxRecords = this.getInteger(context, "MaxRows");
            List<String> selectList = this.getSelectList(context);
            List<SearchTemplateFolder> folders = this.getFolders(context);
            List<SearchTemplateSelectProperty> selectProps = this.getSelectProps(context);
            List<SearchTemplateSubclass> subclasses = this.getSubclasses(context);
            List<SearchTemplateWhereProperty> whereProps = this.getWhereProps(context);
            SearchTemplateContent content = this.getContentSearch(context);
            context.checkEndToken();
            context.checkEndToken();
            SearchTemplateParameters parameters = this.setParameters(vselect, maxRecords, selectList, folders, selectProps, subclasses, whereProps, content);
            RepositoryStoredSearch search = new RepositoryStoredSearch();
            search.setStoredSearch(searchObject, fromClass, parameters);
            search.setPropertyFilter(pf);
            SearchRequest request = new SearchRequest(mode, search, scope, maxElements, continuable, continueFrom);
            return request;
        }
        if (stype.equals("PrincipalSearch")) {
            PrincipalSearchType pst = ExecuteSearchRequestSerialization.getPrincipalSearchType(context);
            PrincipalSearchAttribute psa = ExecuteSearchRequestSerialization.getPrincipalSearchAttribute(context);
            PrincipalSearchSortType pss = ExecuteSearchRequestSerialization.getPrincipalSearchSortType(context);
            Boolean includeUsers = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("includeUsers")));
            Boolean includeGroups = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("includeGroups")));
            context.nextElementToken();
            PropertyFilter pf = (PropertyFilter)context.deserializeObject("SelectionFilter", FilterSerialization.INSTANCE, null);
            String searchRealm = context.readElement("SearchRealm");
            String searchPattern = context.readElement("SearchPattern");
            context.checkEndToken();
            PrincipalSearch search = PrincipalSearch.getPrincipalSearchInstance();
            search.setIncludeUsers(includeUsers);
            search.setIncludeGroups(includeGroups);
            search.setSearchRealm(searchRealm);
            search.setSearchPattern(searchPattern);
            search.setSearchType(pst);
            search.setSearchAttribute(psa);
            search.setSearchSortType(pss);
            search.setPropertyFilter(pf);
            SearchRequest request = new SearchRequest(SearchMode.OBJECTS, search, null, maxElements, continuable, continueFrom);
            return request;
        }
        context.throwException(ExceptionCode.TRANSPORT_WSI_INVALID_SEARCH_REQUEST_TYPE, stype);
        return null;
    }

    private SearchTemplateParameters setParameters(VersionSelection vselect, Integer maxRecords, List<String> selectList, List<SearchTemplateFolder> folders, List<SearchTemplateSelectProperty> selectProps, List<SearchTemplateSubclass> subclasses, List<SearchTemplateWhereProperty> whereProps, SearchTemplateContent content) {
        SearchTemplateParameters parameters = null;
        if (vselect != null || maxRecords != null || selectList != null || folders != null || selectProps != null || subclasses != null || whereProps != null || content != null) {
            parameters = new SearchTemplateParameters();
            parameters.setAugmentedSelectList(selectList);
            parameters.setContent(content);
            parameters.setFolders(folders);
            parameters.setMaximumRecords(maxRecords);
            parameters.setSubclasses(subclasses);
            parameters.setSelectProperties(selectProps);
            parameters.setVersionSelection(vselect);
            parameters.setWhereProperties(whereProps);
        }
        return parameters;
    }

    private VersionSelection getVersionSelection(DeserializerContext context) {
        VersionSelection vs = null;
        String val = context.readElement("VersionSelection");
        if (val != null && val.length() > 0) {
            vs = val.equalsIgnoreCase(VersionSelection.ALL_VERSIONS.toString()) ? VersionSelection.ALL_VERSIONS : (val.equalsIgnoreCase(VersionSelection.CURRENT_VERSION.toString()) ? VersionSelection.CURRENT_VERSION : VersionSelection.RELEASED_VERSION);
        }
        return vs;
    }

    private SortOrder getSortOrder(DeserializerContext context) {
        SortOrder so = null;
        String val = context.readElement("SortOrder");
        if (val != null && val.length() > 0) {
            so = val.equalsIgnoreCase(SortOrder.ASCENDING.toString()) ? SortOrder.ASCENDING : (val.equalsIgnoreCase(SortOrder.DESCENDING.toString()) ? SortOrder.DESCENDING : SortOrder.NONE);
        }
        return so;
    }

    private SearchModifier getSearchModifier(DeserializerContext context) {
        SearchModifier sm = null;
        String val = context.readElement("SearchModifier");
        if (val != null && val.length() > 0) {
            sm = val.equalsIgnoreCase(SearchModifier.BOOST.toString()) ? SearchModifier.BOOST : (val.equalsIgnoreCase(SearchModifier.FUZZY.toString()) ? SearchModifier.FUZZY : SearchModifier.PROXIMITY);
        }
        return sm;
    }

    private RequiredState getRequiredState(DeserializerContext context) {
        RequiredState rs = null;
        String val = context.readElement("RequiredState");
        if (val != null && val.length() > 0) {
            rs = val.equalsIgnoreCase(RequiredState.PROHIBITED.toString()) ? RequiredState.PROHIBITED : (val.equalsIgnoreCase(RequiredState.REQUIRED.toString()) ? RequiredState.REQUIRED : RequiredState.NONE);
        }
        return rs;
    }

    private GroupAction getGroupAction(DeserializerContext context) {
        GroupAction ga = null;
        String val = context.readElement("GroupAction");
        if (val != null && val.length() > 0) {
            ga = val.equalsIgnoreCase(GroupAction.ALL.toString()) ? GroupAction.ALL : (val.equalsIgnoreCase(GroupAction.ANY.toString()) ? GroupAction.ANY : (val.equalsIgnoreCase(GroupAction.IN.toString()) ? GroupAction.IN : (val.equalsIgnoreCase(GroupAction.NEAR.toString()) ? GroupAction.NEAR : (val.equalsIgnoreCase(GroupAction.NONE.toString()) ? GroupAction.NONE : (val.equalsIgnoreCase(GroupAction.PARAGRAPH.toString()) ? GroupAction.PARAGRAPH : (val.equalsIgnoreCase(GroupAction.PHRASE.toString()) ? GroupAction.PHRASE : (val.equalsIgnoreCase(GroupAction.SENTENCE.toString()) ? GroupAction.SENTENCE : (val.equalsIgnoreCase(GroupAction.UNIT.toString()) ? GroupAction.UNIT : GroupAction.VQL))))))));
        }
        return ga;
    }

    private Integer getInteger(DeserializerContext context, String elementName) {
        Integer i = null;
        String val = context.readElement(elementName);
        if (val != null && val.length() > 0) {
            i = new Integer(val);
        }
        return i;
    }

    private Boolean getBoolean(DeserializerContext context, String elementName) {
        Boolean b = null;
        String val = context.readElement(elementName);
        if (val != null && val.length() > 0) {
            b = new Boolean(val);
        }
        return b;
    }

    private String getString(DeserializerContext context, String elementName) {
        String s = null;
        String val = context.readElement(elementName);
        if (val != null && val.length() > 0) {
            s = val;
        }
        return s;
    }

    private Double getDouble(DeserializerContext context, String elementName) {
        Double d = null;
        String val = context.readElement(elementName);
        if (val != null && val.length() > 0) {
            d = new Double(val);
        }
        return d;
    }

    private List<String> getSelectList(DeserializerContext context) {
        ArrayList<String> list = null;
        if (context.isStartToken("SelectList")) {
            context.nextElementToken();
            while (context.isStartToken("Selection")) {
                String selection = context.readElement("Selection");
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(selection);
            }
            context.checkEndToken();
            context.nextElementToken();
        }
        return list;
    }

    private List<String> getItemData(DeserializerContext context) {
        ArrayList<String> list = null;
        if (context.isStartToken("ItemData")) {
            context.nextElementToken();
            while (context.isStartToken("Data")) {
                String selection = context.readElement("Data");
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(selection);
            }
            context.checkEndToken();
            context.nextElementToken();
        }
        return list;
    }

    private List<SearchTemplateFolder> getFolders(DeserializerContext context) throws Exception {
        ArrayList<SearchTemplateFolder> list = null;
        if (context.isStartToken("Folders")) {
            context.nextElementToken();
            while (context.isStartToken("Folder")) {
                context.nextElementToken();
                SearchTemplateFolder folder = new SearchTemplateFolder();
                folder.setExcludeFromQuery(this.getBoolean(context, "ExcludeFromQuery"));
                folder.setItemId(this.getString(context, "ItemId"));
                folder.setFolder(this.getFolder(context));
                folder.setSearchSubFolders(this.getBoolean(context, "SearchSubfolders"));
                if (list == null) {
                    list = new ArrayList<SearchTemplateFolder>();
                }
                list.add(folder);
                context.checkEndToken();
                context.nextElementToken();
            }
            context.checkEndToken();
            context.nextElementToken();
        }
        return list;
    }

    private Folder getFolder(DeserializerContext context) throws Exception {
        ObjectReferenceBase folderObject;
        Folder folder = null;
        if (context.isStartToken("FolderObject") && (folderObject = (ObjectReferenceBase)context.deserializeObject("FolderObject", ObjectReferenceSerialization.INSTANCE, null)) != null) {
            String classId = "Folder";
            String identityString = folderObject.getObjectIdentity();
            String osIdentityString = folderObject.getObjectStoreIdentity();
            folder = (Folder)this.getEngineObject(context, classId, identityString, osIdentityString);
        }
        return folder;
    }

    private EngineObject getEngineObject(DeserializerContext context, String classId, String identityString, String osIdentityString) {
        IndependentObject engObj = null;
        Id identityId = null;
        if (Id.isId(identityString)) {
            identityId = new Id(identityString);
        }
        Id osIdentityId = null;
        if (Id.isId(osIdentityString)) {
            osIdentityId = new Id(osIdentityString);
        }
        Domain domain = this.getDomain(context);
        if (osIdentityString == null || osIdentityString.length() == 0) {
            engObj = identityId != null ? domain.getObject(classId, identityId) : domain.getObject(classId, identityString);
        } else {
            ObjectStore os = null;
            os = osIdentityId != null ? Factory.ObjectStore.getInstance(domain, osIdentityId) : Factory.ObjectStore.getInstance(domain, osIdentityString);
            engObj = identityId != null ? os.getObject(classId, identityId) : os.getObject(classId, identityString);
        }
        return engObj;
    }

    private Domain getDomain(DeserializerContext context) {
        String name = null;
        ConnectionImpl conn = (ConnectionImpl)context.getConnection();
        return Factory.Domain.getInstance(conn, name);
    }

    private List<SearchTemplateSelectProperty> getSelectProps(DeserializerContext context) {
        ArrayList<SearchTemplateSelectProperty> list = null;
        if (context.isStartToken("SelectProperties")) {
            context.nextElementToken();
            while (context.isStartToken("SelectProperty")) {
                context.nextElementToken();
                SearchTemplateSelectProperty selectProp = new SearchTemplateSelectProperty();
                selectProp.setExcludeFromQuery(this.getBoolean(context, "ExcludeFromQuery"));
                selectProp.setItemId(this.getString(context, "ItemId"));
                selectProp.setSymbolicName(this.getString(context, "SymbolicName"));
                selectProp.setSortLevel(this.getInteger(context, "SortLevel"));
                selectProp.setSortOrder(this.getSortOrder(context));
                if (list == null) {
                    list = new ArrayList<SearchTemplateSelectProperty>();
                }
                list.add(selectProp);
                context.checkEndToken();
                context.nextElementToken();
            }
            context.checkEndToken();
            context.nextElementToken();
        }
        return list;
    }

    private List<SearchTemplateSubclass> getSubclasses(DeserializerContext context) {
        ArrayList<SearchTemplateSubclass> list = null;
        if (context.isStartToken("Subclasses")) {
            context.nextElementToken();
            while (context.isStartToken("Subclass")) {
                context.nextElementToken();
                SearchTemplateSubclass subclass = new SearchTemplateSubclass();
                subclass.setExcludeFromQuery(this.getBoolean(context, "ExcludeFromQuery"));
                subclass.setItemId(this.getString(context, "ItemId"));
                subclass.setSymbolicName(this.getString(context, "SymbolicName"));
                subclass.setIncludeSubclasses(this.getBoolean(context, "IncludeSubclasses"));
                if (list == null) {
                    list = new ArrayList<SearchTemplateSubclass>();
                }
                list.add(subclass);
                context.checkEndToken();
                context.nextElementToken();
            }
            context.checkEndToken();
            context.nextElementToken();
        }
        return list;
    }

    private List<SearchTemplateWhereProperty> getWhereProps(DeserializerContext context) {
        ArrayList<SearchTemplateWhereProperty> list = null;
        if (context.isStartToken("WhereProperties")) {
            context.nextElementToken();
            while (context.isStartToken("WhereProperty")) {
                context.nextElementToken();
                SearchTemplateWhereProperty whereProp = new SearchTemplateWhereProperty();
                whereProp.setExcludeFromQuery(this.getBoolean(context, "ExcludeFromQuery"));
                whereProp.setItemId(this.getString(context, "ItemId"));
                whereProp.setLiteral(this.getString(context, "Literal"));
                if (list == null) {
                    list = new ArrayList<SearchTemplateWhereProperty>();
                }
                list.add(whereProp);
                context.checkEndToken();
                context.nextElementToken();
            }
            context.checkEndToken();
            context.nextElementToken();
        }
        return list;
    }

    private SearchTemplateContent getContentSearch(DeserializerContext context) {
        TokenReader.State state = null;
        SearchTemplateContent content = null;
        if (context.isStartToken("ContentSearch")) {
            context.nextElementToken();
            ArrayList<SearchTemplateContentItem> items = null;
            Boolean rank = this.getBoolean(context, "Rank");
            Boolean summary = this.getBoolean(context, "Summary");
            if (context.isStartToken("ContentItems")) {
                context.nextElementToken();
                while (context.isStartToken("ContentItem")) {
                    state = context.nextElementToken();
                    SearchTemplateContentItem item = new SearchTemplateContentItem();
                    item.setExcludeFromQuery(this.getBoolean(context, "ExcludeFromQuery"));
                    item.setItemId(this.getString(context, "ItemId"));
                    item.setSearchModifier(this.getSearchModifier(context));
                    item.setSearchModifierRange(this.getDouble(context, "SearchModifierRange"));
                    item.setRequiredState(this.getRequiredState(context));
                    item.setGroupAction(this.getGroupAction(context));
                    item.setItemData(this.getItemData(context));
                    context.checkEndToken();
                    state = context.nextElementToken();
                    if (items == null) {
                        items = new ArrayList<SearchTemplateContentItem>();
                    }
                    items.add(item);
                }
                context.checkEndToken();
            }
            context.checkEndToken();
            context.nextElementToken();
            if (rank != null || summary != null || items != null) {
                content = new SearchTemplateContent();
                content.setRank(rank);
                content.setSummary(summary);
                content.setContentItems(items);
            }
        }
        return content;
    }

    private static PrincipalSearchType getPrincipalSearchType(DeserializerContext context) throws Exception {
        return (PrincipalSearchType)context.deserializeEnumAttribute("principalSearchType", false, MAP_PRINCIPAL_SEARCH_TYPE, null);
    }

    private static PrincipalSearchAttribute getPrincipalSearchAttribute(DeserializerContext context) throws Exception {
        return (PrincipalSearchAttribute)context.deserializeEnumAttribute("principalSearchAttribute", false, MAP_PRINCIPAL_SEARCH_ATTR, PrincipalSearchAttribute.NONE);
    }

    private static PrincipalSearchSortType getPrincipalSearchSortType(DeserializerContext context) throws Exception {
        return (PrincipalSearchSortType)context.deserializeEnumAttribute("principalSort", false, MAP_PRINCIPAL_SORT, PrincipalSearchSortType.NONE);
    }

    static {
        MAP_SEARCH_MODE.put("Rows", SearchMode.ROWS);
        MAP_SEARCH_MODE.put("Objects", SearchMode.OBJECTS);
        MAP_PRINCIPAL_SEARCH_TYPE.put("Custom", PrincipalSearchType.CUSTOM);
        MAP_PRINCIPAL_SEARCH_TYPE.put("PrefixMatch", PrincipalSearchType.PREFIX_MATCH);
        MAP_PRINCIPAL_SEARCH_TYPE.put("SuffixMatch", PrincipalSearchType.SUFFIX_MATCH);
        MAP_PRINCIPAL_SEARCH_TYPE.put("Contains", PrincipalSearchType.CONTAINS);
        MAP_PRINCIPAL_SEARCH_TYPE.put("Exact", PrincipalSearchType.EXACT);
        MAP_PRINCIPAL_SEARCH_ATTR.put("ShortName", PrincipalSearchAttribute.SHORT_NAME);
        MAP_PRINCIPAL_SEARCH_ATTR.put("DisplayName", PrincipalSearchAttribute.DISPLAY_NAME);
        MAP_PRINCIPAL_SORT.put("Ascending", PrincipalSearchSortType.ASCENDING);
        MAP_PRINCIPAL_SORT.put("Descending", PrincipalSearchSortType.DESCENDING);
        INSTANCE = new ExecuteSearchRequestSerialization();
    }
}

