/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.ChangeResponse;
import com.filenet.apiimpl.transport.ExecuteChangesRequest;
import com.filenet.apiimpl.transport.ExecuteChangesResponse;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.EngineObjectSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import java.util.ArrayList;

public class ExecuteChangesResponseSerialization
extends Serialization {
    public static final ExecuteChangesResponseSerialization INSTANCE = new ExecuteChangesResponseSerialization();

    public void serialize(Object object, SerializerContext context) throws Exception {
        ExecuteChangesResponse responses = (ExecuteChangesResponse)object;
        ChangeResponse[] batch = responses.getBatch();
        if (batch != null) {
            for (int i = 0; i < batch.length; ++i) {
                ChangeResponse response = batch[i];
                EngineObjectImpl value = response.getEngineObject();
                context.clearObjects();
                context.enterElement("ChangeResponse");
                context.writeAttribute("id", response.getCorrelationId());
                if (context.getVersion() == 300) {
                    context.writeOptionalSchemaType("ChangeResponseType");
                }
                if (value != null) {
                    EngineObjectSerialization.INSTANCE.serialize(value, false, context);
                    continue;
                }
                context.leaveElement();
            }
        }
        context.leaveElement();
    }

    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        ChangeRequest[] requests = ((ExecuteChangesRequest)context.getRequest()).getBatch();
        ArrayList<ChangeResponse> responses = new ArrayList<ChangeResponse>();
        while (true) {
            if (!Util.isStartToken(context.nextElementToken())) break;
            String correlectionId = Util.emptyAsNull(context.getAttribute("id"));
            ChangeResponse response = new ChangeResponse();
            response.setCorrelationId(correlectionId);
            if (context.getAttribute("classId") != null) {
                PropertyDeserializerCall call = new PropertyDeserializerCall(requests[responses.size()].getObjectReference());
                Object value = EngineObjectSerialization.INSTANCE.deserialize(call, context);
                response.putValue(value);
            } else {
                context.nextElementToken();
            }
            context.checkEndToken();
            responses.add(response);
        }
        context.checkEndToken();
        ChangeResponse[] batch = responses.toArray(new ChangeResponse[responses.size()]);
        return new ExecuteChangesResponse(batch);
    }
}

