/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.operation;

import com.filenet.api.action.ApplySecurityTemplate;
import com.filenet.api.action.ChangeClass;
import com.filenet.api.action.ChangeState;
import com.filenet.api.action.Checkin;
import com.filenet.api.action.Checkout;
import com.filenet.api.action.Create;
import com.filenet.api.action.Delete;
import com.filenet.api.action.DemoteVersion;
import com.filenet.api.action.Freeze;
import com.filenet.api.action.InstallAddOn;
import com.filenet.api.action.Lock;
import com.filenet.api.action.MoveContent;
import com.filenet.api.action.PendingAction;
import com.filenet.api.action.PromoteVersion;
import com.filenet.api.action.RaiseEvent;
import com.filenet.api.action.TakeFederatedOwnership;
import com.filenet.api.action.Unlock;
import com.filenet.api.action.Update;
import com.filenet.api.constants.LifecycleChangeFlags;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.Properties;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.RepositoryIdentity;
import com.filenet.apiimpl.property.PropertiesImpl;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.ContentHandle;
import com.filenet.apiimpl.transport.ExecuteChangesRequest;
import com.filenet.apiimpl.util.IdGen;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.property.FilterSerialization;
import com.filenet.apiimpl.wsi.serialization.property.PropertyDeserializerCall;
import com.filenet.apiimpl.wsi.serialization.property.PropertySerializerCall;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ExecuteChangesRequestSerialization
extends Serialization {
    private static HashMap MAP_RESERVATION_TYPE = new HashMap();
    private static HashMap MAP_LIFECYCLE_CHANGE = new HashMap();
    public static final ExecuteChangesRequestSerialization INSTANCE;
    public static final Serialization CREATE_ACTION;
    public static final Serialization UPDATE_ACTION;
    public static final Serialization DELETE_ACTION;
    public static final Serialization CHECKOUT_ACTION;
    public static final Serialization CHECKIN_ACTION;
    public static final Serialization FREEZE_ACTION;
    public static final Serialization CHANGE_STATE_ACTION;
    public static final Serialization CHANGE_CLASS_ACTION;
    public static final Serialization MOVE_CONTENT_ACTION;
    public static final Serialization LOCK_ACTION;
    public static final Serialization UNLOCK_ACTION;
    public static final Serialization PROMOTE_VERSION_ACTION;
    public static final Serialization DEMOTE_VERSION_ACTION;
    public static final Serialization APPLY_SECURITY_TEMPLATE_ACTION;
    public static final Serialization RAISE_EVENT_ACTION;
    public static final Serialization INSTALL_ADD_ON_ACTION;
    public static final Serialization TAKE_FEDERATED_OWNERSHIP_ACTION;

    public void serialize(Object object, SerializerContext context) throws Exception {
        ExecuteChangesRequest ecr = (ExecuteChangesRequest)object;
        if (ecr.getRefresh()) {
            context.writeAttribute("refresh", "1");
        }
        ChangeRequest[] batch = ecr.getBatch();
        for (int i = 0; i < batch.length; ++i) {
            ChangeRequest request = batch[i];
            context.enterElement("ChangeRequest", context.getOptionalSchemaType("ChangeRequestType"));
            context.writeAttribute("id", request.getCorrelationId());
            context.writeAttribute("updateSequenceNumber", Util.toIntString(request.getUpdateSequenceNumber()));
            context.serializeReference("TargetSpecification", request.getObjectReference());
            PendingAction[] actions = request.getPendingActions();
            for (int j = 0; j < actions.length; ++j) {
                PendingAction action = actions[j];
                context.serializeObject("Action", action.getClass(), (Object)action);
            }
            if (request.hasProperties()) {
                PropertyImpl[] properties = (PropertyImpl[])request.getProperties().toArray();
                context.enterElement("ActionProperties", null);
                PropertySerializerCall call = new PropertySerializerCall(null);
                for (int j = 0; j < properties.length; ++j) {
                    PropertyImpl property;
                    call.property = property = properties[j];
                    context.serializeObject("Property", property.getClass(), (Object)call);
                }
                context.leaveElement();
            }
            context.serializeObject("RefreshFilter", FilterSerialization.INSTANCE, (Object)request.getPropertyFilter());
            context.leaveElement();
        }
        context.leaveElement();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object deserialize(Object object, DeserializerContext context) throws Exception {
        Boolean refresh = Util.parseBoolean(context.getAttribute("refresh"));
        ArrayList<ChangeRequest> requests = new ArrayList<ChangeRequest>();
        ArrayList<ContentHandle> contentHandles = null;
        boolean isNew = false;
        while (Util.isStartToken(context.nextElementToken())) {
            List contentTransfers;
            String correlationId = context.getAttribute("id");
            Integer updateSequenceNumber = Util.minusOneAsNull(Util.parseInteger(context.getAttribute("updateSequenceNumber")));
            context.nextStartToken();
            context.resetContentTransfers();
            ObjectReferenceBase reference = (ObjectReferenceBase)context.deserializeObject("TargetSpecification", ObjectReferenceSerialization.INSTANCE, null);
            PropertyDeserializerCall call = new PropertyDeserializerCall(reference);
            ArrayList<PendingAction> actions = new ArrayList<PendingAction>();
            while (context.isStartToken("Action")) {
                PendingAction action = (PendingAction)context.deserializeObject(context.getXsiType(), (Object)call);
                if (action instanceof Create) {
                    isNew = true;
                }
                actions.add(action);
            }
            PropertiesImpl properties = new PropertiesImpl();
            if (context.isStartToken("ActionProperties")) {
                context.nextElementToken();
                while (Util.isStartToken(context.getTokenType())) {
                    PropertyImpl property = (PropertyImpl)context.deserializeObject(context.getXsiType(), (Object)call);
                    properties.put(property);
                }
                context.checkEndToken();
                context.nextElementToken();
            }
            PropertyFilter refreshFilter = (PropertyFilter)context.deserializeObject("RefreshFilter", FilterSerialization.INSTANCE, null);
            context.checkEndToken();
            ChangeRequest request = new ChangeRequest(actions.toArray(new PendingAction[actions.size()]), call.request, refreshFilter, properties, correlationId, updateSequenceNumber);
            requests.add(request);
            if (correlationId != null) {
                context.putReference(correlationId, call.request);
            }
            if ((contentTransfers = context.getContentTransfers()) == null || contentTransfers.size() <= 0) continue;
            if (contentHandles == null) {
                contentHandles = new ArrayList<ContentHandle>();
            }
            for (EngineObjectImpl ct : contentTransfers) {
                contentHandles.add(new ContentHandle(call.request, properties, ct.getPropertiesImpl(), isNew));
            }
        }
        context.checkEndToken();
        ChangeRequest[] batch = requests.toArray(new ChangeRequest[requests.size()]);
        ExecuteChangesRequest request = new ExecuteChangesRequest(batch);
        if (refresh != null) {
            request.setRefresh(refresh);
        }
        request.setContentHandles(contentHandles);
        request.setXopBinaryProperties(context.getXopBinaryProperties());
        return request;
    }

    private static ReservationType getReservationType(DeserializerContext context) throws Exception {
        ReservationType reservationType = (ReservationType)context.deserializeEnumAttribute("reservationType", false, MAP_RESERVATION_TYPE, null);
        return reservationType;
    }

    private static void writeReservationType(SerializerContext context, ReservationType rt) throws Exception {
        if (rt != null && rt != ReservationType.OBJECT_STORE_DEFAULT) {
            if (rt == ReservationType.COLLABORATIVE) {
                context.writeAttribute("reservationType", "Collaborative");
            } else {
                context.writeAttribute("reservationType", "Exclusive");
            }
        }
    }

    static {
        MAP_RESERVATION_TYPE.put("Exclusive", ReservationType.EXCLUSIVE);
        MAP_RESERVATION_TYPE.put("Collaborative", ReservationType.COLLABORATIVE);
        MAP_LIFECYCLE_CHANGE.put("Reset", LifecycleChangeFlags.RESET);
        MAP_LIFECYCLE_CHANGE.put("Promote", LifecycleChangeFlags.PROMOTE);
        MAP_LIFECYCLE_CHANGE.put("Demote", LifecycleChangeFlags.DEMOTE);
        MAP_LIFECYCLE_CHANGE.put("SetException", LifecycleChangeFlags.SET_EXCEPTION);
        MAP_LIFECYCLE_CHANGE.put("ClearException", LifecycleChangeFlags.CLEAR_EXCEPTION);
        INSTANCE = new ExecuteChangesRequestSerialization();
        CREATE_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("CreateAction");
                Create cr = (Create)object;
                context.writeAttribute("classId", cr.getClassId());
                context.writeAttribute("objectId", cr.getObjectId());
                context.writeAttribute("autoUniqueContainmentName", Util.toBooleanString(cr.getAutoUniqueContainmentName()));
                context.writeAttribute("defineSecurityParentage", Util.toBooleanString(cr.getDefineSecurityParentage()));
                context.writeAttribute("versionSeriesId", cr.getVersionSeriesId());
                ExecuteChangesRequestSerialization.writeReservationType(context, cr.getReservationType());
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                String classId = context.getAttribute("classId");
                String objectId = context.getAttribute("objectId");
                Boolean autoUnique = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("autoUniqueContainmentName")));
                Boolean defineSecurity = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("defineSecurityParentage")));
                String versionSeriesId = context.getAttribute("versionSeriesId");
                ReservationType reservationType = ExecuteChangesRequestSerialization.getReservationType(context);
                context.nextElementToken();
                context.checkEndToken();
                PropertyDeserializerCall call = (PropertyDeserializerCall)object;
                Id cractionId = null;
                if (Id.isId(objectId)) {
                    cractionId = new Id(objectId);
                }
                if (call.request instanceof GlobalIdentity) {
                    GlobalIdentity gi = (GlobalIdentity)call.request;
                    call.request = gi.isObjectStoreReference() ? new RepositoryIdentity(classId, gi, cractionId != null ? cractionId : IdGen.createId()) : new GlobalIdentity(classId, cractionId);
                } else if (call.request instanceof RepositoryIdentity) {
                    RepositoryIdentity ri = (RepositoryIdentity)call.request;
                    if (ri.getObjectId() == null) {
                        ri.setObjectId(cractionId != null ? cractionId : IdGen.createId());
                    }
                    ri.setClassIdentity(classId);
                }
                return new Create(classId, objectId, autoUnique, reservationType, defineSecurity, versionSeriesId);
            }
        };
        UPDATE_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("UpdateAction");
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                context.nextElementToken();
                context.checkEndToken();
                return new Update();
            }
        };
        DELETE_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("DeleteAction");
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                context.nextElementToken();
                context.checkEndToken();
                return new Delete();
            }
        };
        CHECKOUT_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("CheckoutAction");
                Checkout ck = (Checkout)object;
                context.writeAttribute("reservationId", ck.getReservationId());
                context.writeAttribute("reservationClass", ck.getReservationClass());
                ExecuteChangesRequestSerialization.writeReservationType(context, ck.getReservationType());
                Properties props = ck.getReservationProperties();
                if (props != null && props.size() > 0) {
                    PropertyImpl[] properties = (PropertyImpl[])props.toArray();
                    context.enterElement("ReservationProperties", null);
                    PropertySerializerCall call = new PropertySerializerCall(null);
                    for (int j = 0; j < properties.length; ++j) {
                        PropertyImpl property;
                        call.property = property = properties[j];
                        context.serializeObject("Property", property.getClass(), (Object)call);
                    }
                    context.leaveElement();
                }
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                String reservationId = context.getAttribute("reservationId");
                ReservationType reservationType = ExecuteChangesRequestSerialization.getReservationType(context);
                String reservationClass = context.getAttribute("reservationClass");
                PropertiesImpl properties = new PropertiesImpl();
                context.nextElementToken();
                if (context.isStartToken("ReservationProperties")) {
                    context.nextElementToken();
                    while (true) {
                        if (!Util.isStartToken(context.getTokenType())) break;
                        PropertyImpl property = (PropertyImpl)context.deserializeObject(context.getXsiType(), object);
                        properties.put(property);
                    }
                    context.checkEndToken();
                    context.nextElementToken();
                }
                context.checkEndToken();
                return new Checkout(reservationId, reservationType, reservationClass, properties);
            }
        };
        CHECKIN_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("CheckinAction");
                Checkin ck = (Checkin)object;
                context.writeAttribute("autoClassify", Util.toBooleanString(ck.getAutoClassify()));
                context.writeAttribute("checkinMinorVersion", Util.toBooleanString(ck.getCheckinMinorVersion()));
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                Boolean autoClassify = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("autoClassify")));
                Boolean checkinMinor = Util.nullAsFalse(Util.parseBoolean(context.getAttribute("checkinMinorVersion")));
                context.nextElementToken();
                context.checkEndToken();
                return new Checkin(autoClassify, checkinMinor);
            }
        };
        FREEZE_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("FreezeAction");
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                context.nextElementToken();
                context.checkEndToken();
                return new Freeze();
            }
        };
        CHANGE_STATE_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("ChangeStateAction");
                ChangeState cs = (ChangeState)object;
                switch (cs.getLifecycleAction().getValue()) {
                    case 0x500000: {
                        context.writeAttribute("lifecycleAction", "Reset");
                        break;
                    }
                    case 0x100000: {
                        context.writeAttribute("lifecycleAction", "Promote");
                        break;
                    }
                    case 0x200000: {
                        context.writeAttribute("lifecycleAction", "Demote");
                        break;
                    }
                    case 0x300000: {
                        context.writeAttribute("lifecycleAction", "SetException");
                        break;
                    }
                    case 0x400000: {
                        context.writeAttribute("lifecycleAction", "ClearException");
                    }
                }
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                LifecycleChangeFlags action = (LifecycleChangeFlags)context.deserializeEnumAttribute("lifecycleAction", true, MAP_LIFECYCLE_CHANGE, null);
                context.nextElementToken();
                context.checkEndToken();
                return new ChangeState(action);
            }
        };
        CHANGE_CLASS_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("ChangeClassAction");
                context.writeAttribute("newClass", ((ChangeClass)object).getNewClass());
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                String newClass = context.getAttribute("newClass");
                if (newClass == null) {
                    context.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, "newClass");
                }
                context.nextElementToken();
                context.checkEndToken();
                return new ChangeClass(newClass);
            }
        };
        MOVE_CONTENT_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("MoveContentAction");
                MoveContent mv = (MoveContent)object;
                context.writeAttribute("targetPolicyId", mv.getTargetPolicyId());
                context.writeAttribute("moveAllVersions", Util.toBooleanString(mv.getMoveAllVersions()));
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                String target = context.getAttribute("targetPolicyId");
                Boolean allVersions = Util.parseBoolean(context.getAttribute("moveAllVersions"));
                context.nextElementToken();
                context.checkEndToken();
                return new MoveContent(target, allVersions);
            }
        };
        LOCK_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("LockAction");
                Lock lock = (Lock)object;
                context.writeAttribute("timeout", Util.toUnsignedLongString(lock.getTimeout()));
                context.writeAttribute("owner", lock.getOwner());
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                Long timeout = Util.parseLong(context.getAttribute("timeout"));
                String owner = context.getAttribute("owner");
                context.nextElementToken();
                context.checkEndToken();
                return new Lock(timeout, owner);
            }
        };
        UNLOCK_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("UnlockAction");
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                context.nextElementToken();
                context.checkEndToken();
                return new Unlock();
            }
        };
        PROMOTE_VERSION_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("PromoteVersionAction");
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                context.nextElementToken();
                context.checkEndToken();
                return new PromoteVersion();
            }
        };
        DEMOTE_VERSION_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("DemoteVersionAction");
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                context.nextElementToken();
                context.checkEndToken();
                return new DemoteVersion();
            }
        };
        APPLY_SECURITY_TEMPLATE_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("ApplySecurityTemplateAction");
                context.writeAttribute("applyStateId", ((ApplySecurityTemplate)object).getApplyStateId().toString());
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                Id applyId = Util.parseId(context.getAttribute("applyStateId"));
                context.nextElementToken();
                context.checkEndToken();
                return new ApplySecurityTemplate(applyId);
            }
        };
        RAISE_EVENT_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("RaiseEventAction");
                RaiseEvent re = (RaiseEvent)object;
                context.writeAttribute("classId", re.getClassId());
                Properties props = re.getEventProperties();
                if (props != null && props.size() > 0) {
                    PropertyImpl[] properties = (PropertyImpl[])props.toArray();
                    context.enterElement("EventProperties", null);
                    PropertySerializerCall call = new PropertySerializerCall(null);
                    for (int j = 0; j < properties.length; ++j) {
                        PropertyImpl property;
                        call.property = property = properties[j];
                        context.serializeObject("Property", property.getClass(), (Object)call);
                    }
                    context.leaveElement();
                }
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                String classId = context.getAttribute("classId");
                PropertiesImpl properties = new PropertiesImpl();
                context.nextElementToken();
                if (context.isStartToken("EventProperties")) {
                    context.nextElementToken();
                    while (true) {
                        if (!Util.isStartToken(context.getTokenType())) break;
                        PropertyImpl property = (PropertyImpl)context.deserializeObject(context.getXsiType(), object);
                        properties.put(property);
                    }
                    context.checkEndToken();
                    context.nextElementToken();
                }
                context.checkEndToken();
                return new RaiseEvent(properties, classId);
            }
        };
        INSTALL_ADD_ON_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("InstallAddOnAction");
                context.writeAttribute("addOnId", ((InstallAddOn)object).getAddOnId());
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                String addOnId = context.getAttribute("addOnId");
                context.nextElementToken();
                context.checkEndToken();
                return new InstallAddOn(addOnId);
            }
        };
        TAKE_FEDERATED_OWNERSHIP_ACTION = new Serialization(){

            public void serialize(Object object, SerializerContext context) throws Exception {
                context.writeSchemaType("TakeFederatedOwnershipAction");
                context.leaveElement();
            }

            public Object deserialize(Object object, DeserializerContext context) throws Exception {
                context.nextElementToken();
                context.checkEndToken();
                return new TakeFederatedOwnership();
            }
        };
    }
}

