/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.core;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.wsi.ApiContext;
import com.filenet.apiimpl.wsi.Localization;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.ApiContextHeaderSerialization;
import com.filenet.apiimpl.wsi.serialization.core.LocalizationHeaderSerialization;
import com.filenet.apiimpl.wsi.serialization.core.SecurityHeaderSerialization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SoapHeaderSerialization
extends Serialization {
    public static final SoapHeaderSerialization INSTANCE = new SoapHeaderSerialization();

    public void serialize(Object object, SerializerContext context) throws IOException {
        List headers = (List)object;
        if (headers != null && headers.size() > 0) {
            String soapEnvelopeNS = "http://www.w3.org/2003/05/soap-envelope";
            if (context.getAttachmentMode() == 1) {
                soapEnvelopeNS = "http://schemas.xmlsoap.org/soap/envelope/";
            }
            context.enterNamespacedElement(soapEnvelopeNS, "Header");
            for (Object header : headers) {
                if (header instanceof Security) {
                    SecurityHeaderSerialization.INSTANCE.serialize(header, context);
                    continue;
                }
                if (header instanceof Localization) {
                    LocalizationHeaderSerialization.INSTANCE.serialize(header, context);
                    continue;
                }
                if (!(header instanceof ApiContext)) continue;
                ApiContextHeaderSerialization.INSTANCE.serialize(header, context);
            }
            context.leaveElement();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object deserialize(Object object, DeserializerContext context) {
        ArrayList<Object> headers = new ArrayList<Object>();
        while (true) {
            char mu;
            if (!Util.isStartToken(context.nextElementToken())) {
                context.checkEndToken();
                return headers;
            }
            String localName = context.getLocalName();
            if ("Security".equals(localName)) {
                headers.add(SecurityHeaderSerialization.INSTANCE.deserialize(object, context));
                continue;
            }
            if ("Localization".equals(localName)) {
                headers.add(LocalizationHeaderSerialization.INSTANCE.deserialize(object, context));
                continue;
            }
            if ("ApiContext".equals(localName)) {
                headers.add(ApiContextHeaderSerialization.INSTANCE.deserialize(object, context));
                continue;
            }
            String namespace = context.getNamespace();
            String mustU = context.getAttribute("mustUnderstand");
            if (mustU != null && mustU.length() > 0 && ((mu = mustU.charAt(0)) == '1' || mu == 't' || mu == 'T')) {
                String fullName = namespace + ":" + localName;
                throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_SOAP_HEADER_NOT_UNDERSTOOD, fullName);
            }
            context.moveToEndOfEntireElement(namespace, localName);
        }
    }
}

