/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization.core;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.wsi.BinarySecurityToken;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.UsernameToken;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SecurityHeaderSerialization
extends Serialization {
    public static final SecurityHeaderSerialization INSTANCE = new SecurityHeaderSerialization();

    public void serialize(Object object, SerializerContext context) throws IOException {
        Security security = (Security)object;
        if (security != null && security.ImpersonationToken != null) {
            security.UsernameToken = new UsernameToken();
            security.UsernameToken.Username = security.ImpersonationToken.getImpersonationUsername();
            security.UsernameToken.Password = String.valueOf(security.ImpersonationToken.getOneTimePassword());
        }
        if (security != null && (security.UsernameToken != null || security.BinarySecurityToken != null)) {
            String namespace = context.getSchemaNamespace();
            context.enterNamespacedElement(namespace, "Security");
            if (security.UsernameToken != null) {
                context.enterNamespacedElement(namespace, "UsernameToken");
                context.enterNamespacedElement(namespace, "Username");
                context.writeContent(security.UsernameToken.Username);
                context.leaveElement();
                context.enterNamespacedElement(namespace, "Password");
                context.writeContent(security.UsernameToken.Password);
                context.leaveElement();
                context.leaveElement();
            }
            if (security.BinarySecurityToken != null) {
                context.enterNamespacedElement(namespace, "BinarySecurityToken");
                context.writeAttribute("ValueType", security.BinarySecurityToken.ValueType);
                context.writeContent(security.BinarySecurityToken.Value);
                context.leaveElement();
            }
            context.leaveElement();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Object deserialize(Object object, DeserializerContext context) {
        boolean needClone = ConfigValueLookup.getValueAsBoolean("com.filenet.authentication.wsi.needsWSIHeader", false);
        ByteArrayOutputStream cloneToStream = null;
        if (needClone && context.canClone()) {
            cloneToStream = new ByteArrayOutputStream();
            context.startCloning(cloneToStream);
        }
        Security security = new Security();
        context.nextElementToken();
        while (true) {
            block12: {
                if (Util.isStartToken(context.getTokenType())) {
                    String unOrBsToken = context.getLocalName();
                    if ("UsernameToken".equals(unOrBsToken)) {
                        security.UsernameToken = new UsernameToken();
                        context.nextElementToken();
                        break block12;
                    } else {
                        if ("BinarySecurityToken".equals(unOrBsToken)) {
                            security.BinarySecurityToken = new BinarySecurityToken();
                            security.BinarySecurityToken.ValueType = context.getAttribute("ValueType");
                            Object tokenValue = SecurityHeaderSerialization.deserializeBinaryValue(context);
                            if (tokenValue == null || tokenValue instanceof String) {
                                security.BinarySecurityToken.Value = (String)tokenValue;
                                continue;
                            }
                            if (tokenValue instanceof InputStream) {
                                security.BinarySecurityToken.AttachedValue = (InputStream)tokenValue;
                                continue;
                            }
                            security.BinarySecurityToken.Value = tokenValue.toString();
                            continue;
                        }
                        String namespace = context.getNamespace();
                        context.moveToEndOfEntireElement(namespace, unOrBsToken);
                        context.nextElementToken();
                        continue;
                    }
                }
                context.checkEndToken();
                if (cloneToStream != null) {
                    context.stopCloning();
                    security.XmlBlob = cloneToStream.toString();
                }
                return security;
            }
            while (Util.isStartToken(context.getTokenType())) {
                String usrOrPw = context.getLocalName();
                if ("Username".equals(usrOrPw)) {
                    security.UsernameToken.Username = context.readElement();
                    continue;
                }
                if ("Password".equals(usrOrPw)) {
                    security.UsernameToken.Password = context.readElement();
                    continue;
                }
                String namespace = context.getNamespace();
                context.moveToEndOfEntireElement(namespace, usrOrPw);
            }
            context.checkEndToken();
            context.nextElementToken();
        }
    }

    private static final Object deserializeBinaryValue(DeserializerContext context) {
        Object val = null;
        context.nextToken();
        if (context.isStartToken("Include")) {
            String contentId = context.getAttribute("href");
            context.nextEndToken();
            try {
                val = context.referenceAttachment(contentId);
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        } else {
            val = context.isEndToken() ? new String("") : context.readContent();
        }
        context.nextEndToken();
        return val;
    }
}

