/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.constants.GuidConstants;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.collection.AbstractEngineSet;
import com.filenet.apiimpl.collection.BinaryListImpl;
import com.filenet.apiimpl.collection.Paging;
import com.filenet.apiimpl.core.DependentIdentity;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.EngineObjectUtil;
import com.filenet.apiimpl.core.GlobalIdentity;
import com.filenet.apiimpl.core.ObjectFactory;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.SubSetImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.property.PropertyImpl;
import com.filenet.apiimpl.property.PropertySetPaging;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.ejb.ContentPush;
import com.filenet.apiimpl.util.Base64;
import com.filenet.apiimpl.wsi.serialization.TokenReader;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.Context;

public class Util {
    public static final Util INSTANCE = new Util();
    private static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static final String FORCED_Z_DF_OUTPUT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final ThreadLocal dfForcedZoutput = new ThreadLocal(){

        protected Object initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat(Util.FORCED_Z_DF_OUTPUT, Locale.US);
            sdf.setTimeZone(GMT_TIME_ZONE);
            return sdf;
        }
    };
    private static final Pattern ISO_DATE_PATTERN = Pattern.compile("^([+-]?\\d+)-(\\d{2})-(\\d{2})[Tt](\\d{2}):(\\d{2}):(\\d{2})(\\.\\d+)?(.{1,6})?$");

    public static final boolean isStartToken(TokenReader.State tokenType) {
        return tokenType == TokenReader.State.START_TOKEN;
    }

    public static final boolean isEndToken(TokenReader.State tokenType) {
        return tokenType == TokenReader.State.END_TOKEN;
    }

    public static final boolean isContentToken(TokenReader.State tokenType) {
        return tokenType == TokenReader.State.CONTENT;
    }

    public static final Class objectClass(Object object) {
        return object == null ? null : object.getClass();
    }

    public static final String qnamePrefix(String qname) {
        if (qname == null) {
            return null;
        }
        int index = qname.indexOf(58);
        if (index <= 0) {
            return null;
        }
        return qname.substring(0, index);
    }

    public static final String qnameValue(String qname) {
        if (qname == null) {
            return null;
        }
        return qname.substring(qname.indexOf(58) + 1);
    }

    public static final String checkNotEmpty(String name, String value) {
        if (value == null || value.length() == 0) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, name);
        }
        return value;
    }

    public static final String nullAsEmpty(String value) {
        return value == null ? "" : value;
    }

    public static final String emptyAsNull(String value) {
        return value == null || value.length() == 0 ? null : value;
    }

    public static final String trim(String value) {
        return value == null ? null : value.trim();
    }

    public static final Boolean nullAsTrue(Boolean value) {
        return value == null ? Boolean.TRUE : value;
    }

    public static final Boolean nullAsFalse(Boolean value) {
        return value == null ? Boolean.FALSE : value;
    }

    public static final String toString(Object value, Object defaultValue) {
        if (value == null) {
            value = defaultValue;
        }
        return value == null ? null : value.toString();
    }

    public static final String toStringList(String[] values) {
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(32 * values.length);
        buffer.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            buffer.append(' ').append(values[i]);
        }
        return buffer.toString();
    }

    public static final String toIdString(Id value) {
        return value == null ? null : value.toString();
    }

    public static final String toBooleanString(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "1" : "0";
    }

    public static final String toIntString(int value) {
        return Integer.toString(value);
    }

    public static final String toIntString(Integer value) {
        return value == null ? null : value.toString();
    }

    public static final String toUnsignedLongString(Long value) {
        return value == null ? null : value.toString();
    }

    public static final String toUnsignedLongString(int value) {
        return Integer.toString(value);
    }

    public static final String toDoubleString(Double value) {
        return value == null ? null : value.toString();
    }

    public static final String toBase64BinaryString(byte[] value) {
        if (value == null) {
            return null;
        }
        if (value.length == 0) {
            return "";
        }
        return Base64.encode(value);
    }

    public static final String[] parseStringList(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return new String[0];
        }
        return value.split(" ");
    }

    public static final Id parseId(String value) {
        if (value == null || (value = value.trim()).length() == 0) {
            return null;
        }
        try {
            return new Id(value);
        }
        catch (Exception e) {
            Object[] args = new String[]{"Id", value};
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_MALFORMED_VALUE, args);
        }
    }

    public static final Boolean parseBoolean(String value) {
        if (value == null || (value = value.trim()).length() == 0) {
            return null;
        }
        if (value.equals("0") || value.equals("false")) {
            return Boolean.FALSE;
        }
        if (value.equals("1") || value.equals("true")) {
            return Boolean.TRUE;
        }
        Object[] args = new String[]{"Boolean", value};
        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MALFORMED_VALUE, args);
    }

    public static final Integer parseInteger(String value) {
        if (value == null || (value = value.trim()).length() == 0) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (Exception e) {
            Object[] args = new String[]{"Integer", value};
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_MALFORMED_VALUE, args);
        }
    }

    public static final Long parseLong(String value) {
        if (value == null || (value = value.trim()).length() == 0) {
            return null;
        }
        try {
            return new Long(value);
        }
        catch (Exception e) {
            Object[] args = new String[]{"Long", value};
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_MALFORMED_VALUE, args);
        }
    }

    public static final Double parseDouble(String value) {
        if (value == null || (value = value.trim()).length() == 0) {
            return null;
        }
        try {
            return new Double(value);
        }
        catch (Exception e) {
            Object[] args = new String[]{"Double", value};
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_MALFORMED_VALUE, args);
        }
    }

    public static final String toDateTimeString(Date value) {
        return value == null ? null : ((DateFormat)dfForcedZoutput.get()).format(value);
    }

    public static final Date parseDateTime(String value) {
        if (value == null || (value = value.trim()).length() == 0) {
            return null;
        }
        try {
            Matcher matcher = ISO_DATE_PATTERN.matcher(value);
            if (!matcher.matches()) {
                throw new ParseException(value, 0);
            }
            String sYear = matcher.group(1);
            int year = Integer.parseInt(sYear.charAt(0) == '+' ? sYear.substring(1) : sYear);
            int month = Integer.parseInt(matcher.group(2));
            int day = Integer.parseInt(matcher.group(3));
            int hour = Integer.parseInt(matcher.group(4));
            int minute = Integer.parseInt(matcher.group(5));
            int second = Integer.parseInt(matcher.group(6));
            String sFraction = matcher.group(7);
            String sTimezone = matcher.group(8);
            if (month < 1 || day < 1 || hour < 0 || hour > 24 || minute < 0 || minute > 60 || second < 0 || second > 61) {
                throw new ParseException(value, 0);
            }
            GregorianCalendar cal = new GregorianCalendar(Locale.US);
            cal.clear();
            cal.set(year, month - 1, day, hour, minute, second);
            if (sFraction != null && sFraction.length() > 0) {
                double fraction = Double.parseDouble(sFraction);
                int millis = (int)(fraction * 1000.0 + 0.5);
                cal.set(14, millis);
            } else {
                cal.set(14, 0);
            }
            if (sTimezone == null || sTimezone.trim().length() == 0) {
                sTimezone = "Z";
            } else {
                char firstTZchar = sTimezone.charAt(0);
                if (firstTZchar == '-' || firstTZchar == '+') {
                    sTimezone = "GMT" + sTimezone;
                }
            }
            TimeZone tz = TimeZone.getTimeZone(sTimezone);
            cal.setTimeZone(tz);
            return cal.getTime();
        }
        catch (Exception e) {
            Object[] args = new String[]{"DateTime", value};
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_MALFORMED_VALUE, args);
        }
    }

    public static final byte[] parseBase64Binary(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Base64.decode(value);
        }
        catch (Exception e) {
            Object[] args = new String[]{"Base64-encoded Binary", value};
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_MALFORMED_VALUE, args);
        }
    }

    public static final Integer minusOneAsNull(Integer value) {
        return value == null || value == -1 ? null : value;
    }

    public static final Integer nullAsZero(Integer value) {
        return value == null ? new Integer(0) : value;
    }

    public static final ObjectReferenceBase reference(EngineObjectImpl object) {
        return object == null ? null : (ObjectReferenceBase)object.getObjectReference();
    }

    public static final ObjectReference parent(AbstractEngineSet set) {
        Paging paging;
        Paging paging2 = paging = set == null ? null : set.getPaging();
        if (paging instanceof PropertySetPaging) {
            UnevaluatedPropertyValue unevaluated = ((PropertySetPaging)paging).getUnevaluatedValue();
            return unevaluated == null ? null : unevaluated.getParentReference();
        }
        return null;
    }

    public static final Object[] objects(AbstractEngineSet set) {
        return Util.objects(set == null ? null : set.getList());
    }

    public static final Object[] objects(List list) {
        return list == null ? null : list.toArray();
    }

    public static final String continuation(AbstractEngineSet set) {
        Paging paging = set == null ? null : set.getPaging();
        return paging == null ? null : paging.getContinuation();
    }

    public static final String terminator(String continuation) {
        return continuation == null ? "EndOfCollection" : "EndOfPage";
    }

    public static final SubSetImpl createIndependentObjectSet(Connection connection, List objects, String continuation, ObjectReferenceBase parent, String propertyName, PropertyFilter propertyFilter, Integer pageSize) {
        SubSetImpl set = new SubSetImpl(EngineObject.class, (ArrayList)objects);
        if (continuation != null) {
            PropertySetPaging paging = new PropertySetPaging();
            paging.setConnection(connection);
            paging.setContinuation(continuation);
            if (parent != null && propertyName != null) {
                paging.setUnevaluatedValue(new UnevaluatedPropertyValue(parent, propertyName));
            }
            paging.setPropertyFilter(propertyFilter);
            paging.setPageSize(pageSize == null ? new Integer(objects.size()) : pageSize);
            set.setPaging(paging);
        }
        return set;
    }

    public static final EngineObjectImpl createEngineObject(Connection connection, ObjectReferenceBase request, ObjectReferenceBase parent, String propertyName, Integer propertyIndex, String classId, String[] superClasses, String objectId, String objectStore) {
        if (request instanceof DependentIdentity) {
            DependentIdentity identity = (DependentIdentity)request;
            return ObjectFactory.getDependentInstance(connection, classId, superClasses, (ObjectReferenceBase)identity.getParentReference(), identity.getPropertyName(), identity.getIndex());
        }
        if (request instanceof UnevaluatedPropertyValue) {
            parent = (ObjectReferenceBase)((UnevaluatedPropertyValue)request).getParentReference();
        }
        if (EngineObjectUtil.isDependentObject(classId, superClasses)) {
            return ObjectFactory.getDependentInstance(connection, classId, superClasses, parent, propertyName, propertyIndex == null ? new Integer(0) : propertyIndex);
        }
        if (Util.isRepositoryObject(classId, superClasses, objectStore)) {
            GlobalIdentity store = ObjectFactory.getGlobalReference("ObjectStore", objectStore);
            ObjectReferenceBase reference = ObjectFactory.getRepositoryReference(classId, store, objectId);
            return ObjectFactory.getInstance(reference, superClasses, connection);
        }
        return ObjectFactory.getInstance(connection, classId, superClasses, objectId, null);
    }

    private static final boolean isClassDescription(String classId) {
        if ("ClassDescription".equalsIgnoreCase(classId)) {
            return true;
        }
        return Id.isId(classId) && new Id(classId).equals(GuidConstants.Class_ClassDescription);
    }

    private static final boolean isRepositoryObject(String classId, String[] superClasses, String objectStore) {
        if (objectStore == null) {
            return false;
        }
        if (EngineObjectUtil.isRepositoryObject(classId, superClasses)) {
            return true;
        }
        return Util.isClassDescription(classId);
    }

    public static final Long size(InputStream stream) {
        return stream instanceof ClientInputStream ? ((ClientInputStream)stream).getTotalSize() : null;
    }

    public static final void resolveXopBinaryProperties(ArrayList listProps) throws Exception {
        for (int propIdx = 0; propIdx < listProps.size(); ++propIdx) {
            PropertyImpl prop = (PropertyImpl)listProps.get(propIdx);
            Object val = prop.getObjectValue();
            if (val instanceof InputStream) {
                byte[] byteVal = ClientInputStream.gatherStreamToBytes((InputStream)val);
                prop.setObjectValue(byteVal);
                continue;
            }
            if (!(val instanceof BinaryListImpl)) continue;
            ArrayList<Object> newList = new ArrayList<Object>();
            for (Object bin : (List)val) {
                if (bin instanceof InputStream) {
                    byte[] byteVal = ClientInputStream.gatherStreamToBytes((InputStream)bin);
                    newList.add(byteVal);
                    continue;
                }
                newList.add(bin);
            }
            prop.setObjectValue(new BinaryListImpl(newList));
        }
    }

    public static final Throwable containsThrowable(Throwable here, Class sought) {
        while (here != null) {
            if (sought.isAssignableFrom(here.getClass())) {
                return here;
            }
            here = here.getCause();
        }
        return null;
    }

    public static final EngineRuntimeException ereOrIoe_common(Throwable t, ExceptionCode ec, Object[] params, ExceptionContext ecx, Object[] ecxparams) {
        Throwable ioe = Util.containsThrowable(t, IOException.class);
        if (ioe != null) {
            String message = ioe.getMessage();
            return new EngineRuntimeException(t, ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR, null, ExceptionContext.TRANSPORT_WSI_NETWORK_PROBLEMS_DETAILS, new String[]{message});
        }
        return new EngineRuntimeException(t, ec, params, ecx, ecxparams);
    }

    public static final EngineRuntimeException ereOrIoeS(Throwable t, Object[] params) {
        return Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, params, null, null);
    }

    public static final EngineRuntimeException ereOrIoeD(Throwable t, Object[] params) {
        return Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, params, null, null);
    }

    public static final void uploadContent(ArrayList uploadHandles, Context naming, ClientCallContext context) {
        ContentPush cp = new ContentPush(naming, uploadHandles, null, context);
        cp.setMaxThreads(1);
        cp.uploadContent();
    }

    public static EngineRuntimeException prematureEOF() {
        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_MULTIPART_PROBLEM, null, ExceptionContext.TRANSPORT_WSI_UNEXPECTED_EOF, null);
    }
}

