/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.wsi.ServiceSessionNst;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.TokenWriter;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class TokenWriterNst
implements TokenWriter {
    private static XMLOutputFactory sOF;
    private static final String XLXP_FACTORY_IMPL = "com.ibm.xml.xlxp.api.stax.XMLOutputFactoryImpl";
    private final XMLStreamWriter sW;
    private final String operationName;
    private final ServiceSessionNst session;
    private List namespacesToWrite = new ArrayList();
    private boolean justDidContent = false;
    private static String aNL;
    private static String aSP;
    private SerializerContext sCtx = null;

    private static void initFactory() {
        String desiredStax = ConfigValueLookup.getValue("FileNet.WSI.stax.XMLOutputFactory", XLXP_FACTORY_IMPL);
        try {
            Class<?> c = Class.forName(desiredStax);
            sOF = (XMLOutputFactory)c.newInstance();
        }
        catch (Throwable t) {
            throw Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"<init>"}, ExceptionContext.TRANSPORT_WSI_NO_STAX_PARSER, null);
        }
        try {
            sOF.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        }
        catch (IllegalArgumentException e) {
            String sifClassName = sOF.getClass().getName();
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"<init>"}, ExceptionContext.TRANSPORT_WSI_STAX_MUST_REPAIR_NAMESPACES, new Object[]{sifClassName});
        }
    }

    public TokenWriterNst(ServiceSessionNst ssn, OutputStream os, String opName) {
        this.session = ssn;
        this.operationName = opName;
        if (sOF == null) {
            TokenWriterNst.initFactory();
        }
        try {
            this.sW = sOF.createXMLStreamWriter(os);
        }
        catch (EngineRuntimeException ere) {
            throw ere;
        }
        catch (Throwable t) {
            throw Util.ereOrIoe_common(t, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{this.operationName}, ExceptionContext.TRANSPORT_WSI_NO_STAX_PARSER, null);
        }
    }

    public void flush() {
        try {
            this.sW.flush();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
    }

    public void close() {
        try {
            this.sW.close();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
    }

    public String getPrefixForNamespace(String namespace) {
        try {
            return this.sW.getPrefix(namespace);
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
    }

    public void setPrefixForNamespace(String prefix, String namespace) {
        if (namespace == null || namespace.length() == 0) {
            return;
        }
        try {
            if (prefix == null || prefix.length() == 0) {
                this.sW.setDefaultNamespace(namespace);
                this.namespacesToWrite.add(new String[]{null, namespace});
            } else {
                this.sW.setPrefix(prefix, namespace);
                this.namespacesToWrite.add(new String[]{prefix, namespace});
            }
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
    }

    public void enter(String namespace, String eltName) {
        try {
            this.newLineIndent(0);
            if (namespace == null) {
                this.sW.writeStartElement(eltName);
            } else {
                this.sW.writeStartElement(namespace, eltName);
            }
            this.flushNamespaces();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
        this.justDidContent = false;
    }

    private void flushNamespaces() throws XMLStreamException {
        if (this.namespacesToWrite.size() > 0) {
            for (String[] pnPair : this.namespacesToWrite) {
                String prefix = pnPair[0];
                String namespace = pnPair[1];
                if (prefix == null || prefix.length() == 0) {
                    this.sW.writeDefaultNamespace(namespace);
                    continue;
                }
                this.sW.writeNamespace(prefix, namespace);
            }
            this.namespacesToWrite.clear();
        }
    }

    public void leave() {
        try {
            if (!this.justDidContent) {
                this.newLineIndent(-1);
            }
            this.sW.writeEndElement();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
        this.justDidContent = false;
    }

    public String registerAttachment(int attachmentMode, InputStream stream) {
        return this.session.registerAttachment(attachmentMode, stream);
    }

    public void writeAttribute(String namespace, String attrName, String attrValue) {
        try {
            if (namespace == null) {
                this.sW.writeAttribute(attrName, attrValue);
            } else {
                this.sW.writeAttribute(namespace, attrName, attrValue);
            }
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
    }

    public void writeContent(String contentValue) {
        try {
            this.sW.writeCharacters(contentValue);
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
        this.justDidContent = true;
    }

    private void newLineIndent(int adjust) throws XMLStreamException {
        if (this.sCtx != null && this.sCtx.isForTrace()) {
            this.sW.writeCharacters(aNL);
            int indentSize = (this.sCtx.getDepth() + adjust) * 2;
            for (int ii = 0; ii < indentSize; ++ii) {
                this.sW.writeCharacters(aSP);
            }
        }
    }

    public void setSerializerContext(SerializerContext sCtx) {
        this.sCtx = sCtx;
    }

    public void startDocument() {
        try {
            this.sW.writeStartDocument();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
    }

    public void endDocument() {
        try {
            this.sW.writeEndDocument();
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.operationName});
        }
    }

    static {
        try {
            Class<XMLOutputFactory> c = XMLOutputFactory.class;
        }
        catch (NoClassDefFoundError e) {
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_SERIALIZATION_ERROR, new String[]{"<init>"}, ExceptionContext.TRANSPORT_WSI_NO_STAX_PARSER, null);
        }
        sOF = null;
        aNL = "\n";
        aSP = " ";
    }
}

