/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.wsi.ClientConfig;
import com.filenet.apiimpl.wsi.ClientInfo;
import com.filenet.apiimpl.wsi.Namespaces;
import com.filenet.apiimpl.wsi.serialization.Context;
import com.filenet.apiimpl.wsi.serialization.Serializer;
import com.filenet.apiimpl.wsi.serialization.TokenWriter;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.security.auth.Subject;

public class SerializerContext
extends Context {
    private final TokenWriter tokenWriter;
    private final boolean typeAttributeRequired;
    private final String schemaLeading;
    private String wsdlSchemaLeading;
    private String xsdLeading;
    private final int attachmentMode;
    private int depth;
    private final boolean isForTrace;
    private boolean shouldSortProperties = false;
    public static final int ATTACHMENTS_NONE = 0;
    public static final int ATTACHMENTS_DIME = 1;
    public static final int ATTACHMENTS_MTOM = 3;
    private final Locale requestLocale;

    public SerializerContext(boolean clientProcessing, String wsdlNamespace, TokenWriter tokenWriter, boolean isForTrace) throws IOException {
        this(clientProcessing, wsdlNamespace, tokenWriter, isForTrace, true, null);
    }

    public SerializerContext(boolean clientProcessing, String wsdlNamespace, TokenWriter tokenWriter, boolean isForTrace, boolean envelopeDefaultNamespaceDesired, Locale requestLocale) throws IOException {
        super(clientProcessing, wsdlNamespace);
        this.isForTrace = isForTrace;
        this.tokenWriter = tokenWriter;
        this.requestLocale = requestLocale;
        this.typeAttributeRequired = ClientConfig.isTypeAttributeRequired();
        String schemaPrefix = tokenWriter.getPrefixForNamespace(this.schemaNamespace);
        String schLeading = "";
        if (schemaPrefix != null && schemaPrefix.length() > 0) {
            schLeading = schemaPrefix + ':';
        }
        this.wsdlSchemaLeading = "";
        String wsdlSchemaPrefix = tokenWriter.getPrefixForNamespace(this.wsdlSchemaNamespace);
        if (wsdlSchemaPrefix != null && wsdlSchemaPrefix.length() > 0) {
            this.wsdlSchemaLeading = wsdlSchemaPrefix + ':';
        }
        this.xsdLeading = "";
        String xsdPrefix = tokenWriter.getPrefixForNamespace("http://www.w3.org/2001/XMLSchema");
        if (xsdPrefix != null && xsdPrefix.length() > 0) {
            this.xsdLeading = xsdPrefix + ':';
        }
        tokenWriter.setPrefixForNamespace("i", "http://www.w3.org/2001/XMLSchema-instance");
        if (envelopeDefaultNamespaceDesired && ClientConfig.isDefaultNamespacePermitted(this.version)) {
            tokenWriter.setPrefixForNamespace(null, this.schemaNamespace);
            schLeading = "";
        }
        this.schemaLeading = schLeading;
        if (clientProcessing) {
            this.attachmentMode = Namespaces.isDime(wsdlNamespace) ? 1 : (Namespaces.isMtom(wsdlNamespace) ? 3 : 0);
        } else if (Namespaces.isMtom(wsdlNamespace)) {
            this.attachmentMode = 3;
        } else {
            switch (ClientInfo.getBinding()) {
                case 1: {
                    this.attachmentMode = 1;
                    break;
                }
                default: {
                    this.attachmentMode = 0;
                }
            }
        }
        this.depth = 1;
    }

    public boolean getShouldSortProperties() {
        return this.shouldSortProperties;
    }

    public void setShouldSortProperties(boolean shouldSortProperties) {
        this.shouldSortProperties = shouldSortProperties;
    }

    public int getAttachmentMode() {
        return this.attachmentMode;
    }

    public boolean isForTrace() {
        return this.isForTrace;
    }

    public String getSchemaType(String typeName) {
        return this.schemaLeading + typeName;
    }

    public String getOptionalSchemaType(String typeName) {
        return this.typeAttributeRequired ? this.schemaLeading + typeName : null;
    }

    public String getXsdType(String typeName) {
        return this.xsdLeading + typeName;
    }

    public String getOptionalXsdType(String typeName) {
        return this.typeAttributeRequired ? this.xsdLeading + typeName : null;
    }

    public void writeTypeAttribute(String typeValue) throws Exception {
        if (typeValue != null) {
            this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", typeValue);
        }
    }

    public void writeSchemaType(String typeName) throws Exception {
        this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.schemaLeading + typeName);
    }

    public void writeOptionalSchemaType(String typeName) throws IOException {
        if (this.typeAttributeRequired) {
            this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.schemaLeading + typeName);
        }
    }

    public void writeWsdlSchemaType(String typeName) throws IOException {
        this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.wsdlSchemaLeading + typeName);
    }

    public void writeOptionalWsdlSchemaType(String typeName) throws IOException {
        if (this.typeAttributeRequired) {
            this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.wsdlSchemaLeading + typeName);
        }
    }

    public void writeXsdType(String typeName) throws IOException {
        this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.xsdLeading + typeName);
    }

    public void writeOptionalXsdType(String typeName) throws IOException {
        if (this.typeAttributeRequired) {
            this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", this.xsdLeading + typeName);
        }
    }

    public void writeAttribute(String attributeName, String attributeValue) throws IOException {
        if (attributeValue != null) {
            this.tokenWriter.writeAttribute(null, attributeName, attributeValue);
        }
    }

    public void writeAttribute(String namespace, String attributeName, String attributeValue) throws IOException {
        if (attributeValue != null) {
            this.tokenWriter.writeAttribute(namespace, attributeName, attributeValue);
        }
    }

    public void enterElement(String elementName) throws IOException {
        this.tokenEnter(this.schemaNamespace, elementName);
    }

    public void enterElement(String elementName, String typeValue) throws IOException {
        this.tokenEnter(this.schemaNamespace, elementName);
        if (typeValue != null) {
            this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", typeValue);
        }
    }

    public void enterNamespacedElement(String nameSpace, String elementName) throws IOException {
        this.tokenEnter(nameSpace, elementName);
    }

    public void leaveElement() throws IOException {
        this.tokenLeave();
    }

    public void writeElement(String elementName, String typeValue) throws IOException {
        this.tokenEnter(this.schemaNamespace, elementName);
        if (typeValue != null) {
            this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", typeValue);
        }
        this.tokenLeave();
    }

    public void writeElement(String elementName, String typeValue, String contentValue) throws IOException {
        this.tokenEnter(this.schemaNamespace, elementName);
        if (typeValue != null) {
            this.tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", typeValue);
        }
        if (contentValue != null) {
            this.tokenWriter.writeContent(contentValue);
        }
        this.tokenLeave();
    }

    public void writeElementArray(String elementName, String typeValue, String[] contentValues) throws IOException {
        int length = contentValues == null ? 0 : contentValues.length;
        for (int index = 0; index < length; ++index) {
            String contentValue = contentValues[index];
            this.writeElement(elementName, typeValue, contentValue);
        }
    }

    public void writeOptionalElement(String elementName, String typeValue, String contentValue) throws IOException {
        if (contentValue != null) {
            this.writeElement(elementName, typeValue, contentValue);
        }
    }

    public void writeOptionalElementArray(String elementName, String typeValue, String[] contentValues) throws IOException {
        int length = contentValues == null ? 0 : contentValues.length;
        for (int index = 0; index < length; ++index) {
            String contentValue = contentValues[index];
            this.writeOptionalElement(elementName, typeValue, contentValue);
        }
    }

    public void writeContent(String contentValue) throws IOException {
        if (contentValue != null) {
            this.tokenWriter.writeContent(contentValue);
        }
    }

    public void serializeObject(Object key, Object object) throws Exception {
        Serializer serializer = this.registry.getSerializer(key);
        serializer.serialize(object, this);
    }

    public void serializeObject(String elementName, Object key, Object object) throws Exception {
        if (key != null && object != null) {
            Serializer serializer = this.registry.getSerializer(key);
            this.tokenEnter(this.schemaNamespace, elementName);
            serializer.serialize(object, this);
        }
    }

    public void serializeObject(String elementName, Serializer serializer, Object object) throws Exception {
        if (object != null) {
            this.tokenEnter(this.schemaNamespace, elementName);
            serializer.serialize(object, this);
        }
    }

    public void serializeObjectArray(String elementName, Object key, Object[] objects) throws Exception {
        int length = key == null || objects == null ? 0 : objects.length;
        Serializer serializer = length > 0 ? this.registry.getSerializer(key) : null;
        for (int index = 0; index < length; ++index) {
            Object object = objects[index];
            if (object == null) continue;
            this.tokenEnter(this.schemaNamespace, elementName);
            serializer.serialize(object, this);
        }
    }

    public void serializeObjectArray(String elementName, Serializer serializer, Object[] objects) throws Exception {
        int length = objects == null ? 0 : objects.length;
        for (int index = 0; index < length; ++index) {
            Object object = objects[index];
            if (object == null) continue;
            this.tokenEnter(this.schemaNamespace, elementName);
            serializer.serialize(object, this);
        }
    }

    public void serializeReference(ObjectReferenceBase reference) throws Exception {
        ObjectReferenceSerialization.getHandler(reference, this).serialize(reference, this);
    }

    public void serializeReference(String elementName, ObjectReferenceBase reference) throws Exception {
        this.serializeObject(elementName, ObjectReferenceSerialization.getHandler(reference, this), (Object)reference);
    }

    public String registerAttachment(InputStream stream) throws Exception {
        if (this.isForTrace) {
            return "cid:" + stream.getClass().toString() + "@" + stream.hashCode();
        }
        if (stream instanceof ClientInputStream) {
            ClientInputStream cis = (ClientInputStream)stream;
            Subject subject = ClientInfo.getSubject();
            if (subject != null) {
                cis.setOriginalSubject(subject);
            }
        }
        return this.tokenWriter.registerAttachment(this.attachmentMode, stream);
    }

    private void tokenEnter(String nameSpace, String elementName) throws IOException {
        this.tokenWriter.enter(nameSpace, elementName);
        ++this.depth;
    }

    private void tokenLeave() throws IOException {
        this.tokenWriter.leave();
        --this.depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public Locale getRequestLocale() {
        return this.requestLocale;
    }
}

