/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.core.Connection;
import com.filenet.api.core.ObjectReference;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.wsi.serialization.Context;
import com.filenet.apiimpl.wsi.serialization.Deserializer;
import com.filenet.apiimpl.wsi.serialization.TokenReader;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeserializerContext
extends Context {
    private final Connection connection;
    private final Request request;
    private TokenReader tokenReader;
    private Map references;
    private List contentTransfers;
    private ArrayList xopBinaryProps;

    public DeserializerContext(Connection connection, boolean clientProcessing, String wsdlNamespace, Request request) {
        super(clientProcessing, wsdlNamespace);
        this.connection = connection;
        this.request = request;
    }

    public void setTokenReader(TokenReader tokenReader) {
        this.tokenReader = tokenReader;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Request getRequest() {
        return this.request;
    }

    public ObjectReferenceBase getReference(String id) {
        return this.references == null ? null : (ObjectReferenceBase)this.references.get(id);
    }

    public void putReference(String id, ObjectReference reference) {
        if (id == null || reference == null) {
            throw new NullPointerException();
        }
        if (this.references == null) {
            this.references = new HashMap();
        }
        this.references.put(id, reference);
    }

    public List getContentTransfers() {
        return this.contentTransfers;
    }

    public void resetContentTransfers() {
        this.contentTransfers = null;
    }

    public void addContentTransfer(Object obj) {
        if (this.contentTransfers == null) {
            this.contentTransfers = new ArrayList();
        }
        this.contentTransfers.add(obj);
    }

    public ArrayList getXopBinaryProperties() {
        return this.xopBinaryProps;
    }

    public void addXopBinaryProperty(Object obj) {
        if (this.xopBinaryProps == null) {
            this.xopBinaryProps = new ArrayList();
        }
        this.xopBinaryProps.add(obj);
    }

    public TokenReader.State getTokenType() {
        return this.tokenReader.currentState();
    }

    public String getNamespace() {
        return this.tokenReader.getNamespace();
    }

    public String getLocalName() {
        return this.tokenReader.getLocalName();
    }

    public String getAttribute(String name) {
        return this.tokenReader.getAttributeValue(name);
    }

    public String getAttribute(String uri, String name) {
        return this.tokenReader.getAttributeValue(uri, name);
    }

    public String getXsiType() {
        String value = this.getXsiType(null);
        if (value == null) {
            String name = "{http://www.w3.org/2001/XMLSchema-instance}type";
            this.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, name);
        }
        return value;
    }

    public String getXsiType(String defaultValue) {
        if (this.tokenReader.currentState() != TokenReader.State.START_TOKEN) {
            return null;
        }
        String value = this.tokenReader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        return value == null ? defaultValue : Util.qnameValue(value);
    }

    public String getPath() {
        return this.tokenReader.getPath();
    }

    public TokenReader.State nextToken() {
        return this.tokenReader.next();
    }

    public TokenReader.State nextExpectedStartToken(String elementName) {
        TokenReader.State state = null;
        while (!this.isStartToken()) {
            state = this.nextElementToken();
        }
        if (this.isStartToken(elementName)) {
            state = this.nextElementToken();
        } else {
            this.throwException(ExceptionCode.TRANSPORT_WSI_START_TOKEN_EXPECTED);
        }
        return state;
    }

    public void moveToEndOfEntireElement(String masterN, String masterL) {
        if (masterN == null) {
            masterN = "";
        }
        if (masterL == null) {
            masterL = "";
        }
        while (true) {
            TokenReader.State state;
            if ((state = this.nextToken()) != TokenReader.State.START_TOKEN && state != TokenReader.State.END_TOKEN) {
                continue;
            }
            String n = this.getNamespace();
            String l = this.getLocalName();
            if (!masterL.equals(l) || !masterN.equals(n)) continue;
            if (state == TokenReader.State.START_TOKEN) {
                this.moveToEndOfEntireElement(n, l);
                continue;
            }
            if (state == TokenReader.State.END_TOKEN) break;
        }
    }

    public TokenReader.State nextElementToken() {
        TokenReader.State tokenType;
        while ((tokenType = this.tokenReader.next()) == TokenReader.State.CONTENT) {
        }
        return tokenType;
    }

    public void nextStartToken() {
        TokenReader.State tokenType;
        while ((tokenType = this.tokenReader.next()) == TokenReader.State.CONTENT) {
        }
        if (tokenType != TokenReader.State.START_TOKEN) {
            this.throwException(ExceptionCode.TRANSPORT_WSI_START_TOKEN_EXPECTED);
        }
    }

    public void nextEndToken() {
        TokenReader.State tokenType;
        while ((tokenType = this.tokenReader.next()) == TokenReader.State.CONTENT) {
        }
        if (tokenType != TokenReader.State.END_TOKEN) {
            this.throwException(ExceptionCode.TRANSPORT_WSI_END_TOKEN_EXPECTED);
        }
    }

    public boolean isStartToken() {
        return this.tokenReader.currentState() == TokenReader.State.START_TOKEN;
    }

    public boolean isStartToken(String elementName) {
        return this.tokenReader.currentState() == TokenReader.State.START_TOKEN && this.tokenReader.getLocalName().equals(elementName);
    }

    public void checkEndToken() {
        if (this.tokenReader.currentState() != TokenReader.State.END_TOKEN) {
            this.throwException(ExceptionCode.TRANSPORT_WSI_END_TOKEN_EXPECTED);
        }
    }

    public boolean isEndToken() {
        return this.tokenReader.currentState() == TokenReader.State.END_TOKEN;
    }

    public String readElement() {
        if (this.tokenReader.currentState() != TokenReader.State.START_TOKEN) {
            this.throwException(ExceptionCode.TRANSPORT_WSI_START_TOKEN_EXPECTED);
        }
        String elementContent = null;
        TokenReader.State tokenType = this.tokenReader.next();
        if (tokenType == TokenReader.State.CONTENT) {
            elementContent = this.tokenReader.readContent();
            if (elementContent == null) {
                elementContent = "";
            }
            if (this.tokenReader.next() != TokenReader.State.END_TOKEN) {
                this.throwException(ExceptionCode.TRANSPORT_WSI_END_TOKEN_EXPECTED);
            }
        } else if (tokenType == TokenReader.State.END_TOKEN) {
            elementContent = "";
        } else {
            this.throwException(ExceptionCode.TRANSPORT_WSI_END_TOKEN_EXPECTED);
        }
        while (this.tokenReader.next() == TokenReader.State.CONTENT) {
        }
        return elementContent;
    }

    public String readElement(String elementName) {
        if (this.tokenReader.currentState() == TokenReader.State.START_TOKEN && this.tokenReader.getLocalName().equals(elementName)) {
            return this.readElement();
        }
        return null;
    }

    public List readElementList(String elementName) {
        ArrayList<String> list = new ArrayList<String>();
        String value = this.readElement(elementName);
        while (value != null) {
            list.add(value);
            value = this.readElement(elementName);
        }
        return list;
    }

    public String readContent() {
        String elementContent = null;
        if (this.tokenReader.currentState() == TokenReader.State.CONTENT && (elementContent = this.tokenReader.readContent()) == null) {
            elementContent = "";
        }
        return elementContent;
    }

    public Object deserializeObject(Object key, Object object) throws Exception {
        if (!this.targetElement(key)) {
            return null;
        }
        int depth = this.tokenReader.depth();
        String elementName = this.tokenReader.getLocalName();
        Deserializer deserializer = this.registry.getDeserializer(key);
        object = deserializer.deserialize(object, this);
        this.nextElement(depth, elementName);
        return object;
    }

    public Object deserializeObject(Deserializer deserializer, Object object) throws Exception {
        if (this.tokenReader.currentState() != TokenReader.State.START_TOKEN) {
            this.throwException(ExceptionCode.TRANSPORT_WSI_START_TOKEN_EXPECTED);
        }
        int depth = this.tokenReader.depth();
        String elementName = this.tokenReader.getLocalName();
        object = deserializer.deserialize(object, this);
        this.nextElement(depth, elementName);
        return object;
    }

    public Object deserializeObject(String elementName, Deserializer deserializer, Object object) throws Exception {
        if (!this.targetElement(elementName)) {
            return null;
        }
        int depth = this.tokenReader.depth();
        object = deserializer.deserialize(object, this);
        this.nextElement(depth, elementName);
        return object;
    }

    public List deserializeObjectList(String elementName, Deserializer deserializer, Object object) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        int depth = this.tokenReader.depth();
        while (this.targetElement(elementName)) {
            list.add(deserializer.deserialize(object, this));
            this.nextElement(depth, elementName);
        }
        return list;
    }

    public InputStream referenceAttachment(String contentId) throws Exception {
        return this.tokenReader.referenceAttachment(contentId);
    }

    public Object deserializeEnumAttribute(String attrName, boolean required, HashMap mapValues, Object defaultValue) throws Exception {
        String attrVal = this.getAttribute(attrName);
        if (attrVal == null) {
            if (required) {
                this.throwException(ExceptionCode.TRANSPORT_WSI_VALUE_EXPECTED, new Object[]{attrName});
            }
            return defaultValue;
        }
        Object value = mapValues.get(attrVal);
        if (value == null) {
            this.throwException(ExceptionCode.TRANSPORT_WSI_INVALID_ENUM_VALUE, new Object[]{attrVal, attrName});
        }
        return value;
    }

    private void throwException(ExceptionCode code) throws EngineRuntimeException {
        throw new EngineRuntimeException(code, null, ExceptionContext.TRANSPORT_WSI_DESERIALIZATION_PATH, new Object[]{this.getPath()});
    }

    public void throwException(ExceptionCode code, Object codeArg) throws EngineRuntimeException {
        throw new EngineRuntimeException(code, new Object[]{codeArg}, ExceptionContext.TRANSPORT_WSI_DESERIALIZATION_PATH, new Object[]{this.getPath()});
    }

    private void throwException(ExceptionCode code, Object[] codeArgs) throws EngineRuntimeException {
        throw new EngineRuntimeException(code, codeArgs, ExceptionContext.TRANSPORT_WSI_DESERIALIZATION_PATH, new Object[]{this.getPath()});
    }

    private boolean targetElement(Object key) throws Exception {
        if (key == null) {
            return false;
        }
        if (this.tokenReader.currentState() != TokenReader.State.START_TOKEN) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_START_TOKEN_EXPECTED);
        }
        return true;
    }

    private boolean targetElement(String elementName) throws Exception {
        return this.tokenReader.currentState() == TokenReader.State.START_TOKEN && this.tokenReader.getLocalName().equals(elementName);
    }

    private void nextElement(int currentDepth, String currentElement) throws Exception {
        if (this.tokenReader.currentState() == TokenReader.State.END_TOKEN && this.tokenReader.depth() == currentDepth && this.tokenReader.getLocalName().equals(currentElement)) {
            while (this.tokenReader.next() == TokenReader.State.CONTENT) {
            }
        }
    }

    protected int getDepth() {
        return this.tokenReader.depth();
    }

    public boolean canClone() {
        return this.tokenReader.canClone();
    }

    public void startCloning(OutputStream cloneToStream) {
        this.tokenReader.startCloning(cloneToStream);
    }

    public void stopCloning() {
        this.tokenReader.stopCloning();
    }
}

