/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi.serialization;

import com.filenet.api.core.ObjectReference;
import com.filenet.apiimpl.core.EngineObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.smm.Measurement;
import com.filenet.apiimpl.smm.Statistics;
import com.filenet.apiimpl.transport.DuplicateObjectCache;
import com.filenet.apiimpl.wsi.Namespaces;
import com.filenet.apiimpl.wsi.serialization.Deserializer;
import com.filenet.apiimpl.wsi.serialization.Registry;
import com.filenet.apiimpl.wsi.serialization.Serializer;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.reference.ObjectReferenceSerialization;
import com.filenet.apiimpl.wsi.serialization.reference.ReferenceValues;

public abstract class Context {
    protected final boolean clientProcessing;
    protected final String wsdlNamespace;
    protected final String schemaNamespace;
    protected final String wsdlSchemaNamespace;
    protected final int version;
    protected final Registry registry;
    protected DuplicateObjectCache duplicateObjects;
    protected final Util util;

    protected Context(boolean clientProcessing, String wsdlNamespace) {
        this.clientProcessing = clientProcessing;
        this.wsdlNamespace = wsdlNamespace;
        this.schemaNamespace = Namespaces.getSchemaNamespace(wsdlNamespace);
        this.wsdlSchemaNamespace = Namespaces.getWsdlSchemaNamespace(wsdlNamespace);
        this.version = Namespaces.getNamespaceVersion(wsdlNamespace);
        this.registry = Registry.getInstance(wsdlNamespace);
        this.duplicateObjects = new DuplicateObjectCache();
        this.util = Util.INSTANCE;
    }

    public String getWsdlNamespace() {
        return this.wsdlNamespace;
    }

    public String getSchemaNamespace() {
        return this.schemaNamespace;
    }

    public String getWsdlSchemaNamespace() {
        return this.wsdlSchemaNamespace;
    }

    public int getVersion() {
        return this.version;
    }

    public Object getHandler(Object key) {
        return this.registry.getHandler(key);
    }

    public Serializer getSerializer(Object key) {
        return this.registry.getSerializer(key);
    }

    public Deserializer getDeserializer(Object key) {
        return this.registry.getDeserializer(key);
    }

    public void clearObjects() {
        this.duplicateObjects = new DuplicateObjectCache();
    }

    public DuplicateObjectCache getDuplicateObjectCache() {
        return this.duplicateObjects;
    }

    public void setDuplicateObjectCache(DuplicateObjectCache doc) {
        this.duplicateObjects = doc;
    }

    public EngineObjectImpl getObject(ObjectReference reference) {
        EngineObjectImpl object = this.duplicateObjects.getBestChoice((ObjectReferenceBase)reference, this.getDepth());
        if (object == null) {
            return null;
        }
        if (Measurement.Serializer.isEnabled()) {
            Statistics.addMeasurementValue("SERIALIZE_EO_READ_CACHE_HIT", 1.0);
        }
        return object;
    }

    public EngineObjectImpl resolveObject(EngineObjectImpl object) {
        ObjectReferenceBase reference = (ObjectReferenceBase)object.getObjectReference();
        EngineObjectImpl cached = this.duplicateObjects.getBestChoice(reference, this.getDepth());
        if (cached == null) {
            return object;
        }
        return cached;
    }

    public boolean addObject(EngineObjectImpl object) {
        return this.duplicateObjects.putInCache(object, this.getDepth());
    }

    public boolean isClientProcessing() {
        return this.clientProcessing;
    }

    public boolean isServerProcessing() {
        return !this.clientProcessing;
    }

    public ReferenceValues getReferenceValues(ObjectReferenceBase reference) throws Exception {
        return ObjectReferenceSerialization.getHandler(reference, this).getValues(reference, this);
    }

    protected abstract int getDepth();
}

