/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.authentication.util.B64;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.property.ClientInputStream;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.ContentRummager;
import com.filenet.apiimpl.transport.ExecuteChangesRequest;
import com.filenet.apiimpl.transport.ExecuteChangesResponse;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.transport.GetContentResponse;
import com.filenet.apiimpl.transport.GetObjectRequest;
import com.filenet.apiimpl.transport.GetObjectResponse;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.MetadataSearchRequest;
import com.filenet.apiimpl.transport.MetadataSearchResponse;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.transport.SearchRequest;
import com.filenet.apiimpl.transport.SearchResponse;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.transport.ejb.EnginePort;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.JarManifest;
import com.filenet.apiimpl.util.LocaleUtils;
import com.filenet.apiimpl.util.MemoryThenFileSpillStreamFactory;
import com.filenet.apiimpl.util.MultipartInputStreamManager;
import com.filenet.apiimpl.util.SpillStreamFactory;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.wsi.ApiContext;
import com.filenet.apiimpl.wsi.AttachmentHelperNst;
import com.filenet.apiimpl.wsi.BinarySecurityToken;
import com.filenet.apiimpl.wsi.ClientInfo;
import com.filenet.apiimpl.wsi.ClientOperation;
import com.filenet.apiimpl.wsi.DimeInputStreamManager;
import com.filenet.apiimpl.wsi.DimeOutputStream;
import com.filenet.apiimpl.wsi.ExceptionCodeMapper;
import com.filenet.apiimpl.wsi.ImpersonationToken;
import com.filenet.apiimpl.wsi.Localization;
import com.filenet.apiimpl.wsi.MtomInputStreamManager;
import com.filenet.apiimpl.wsi.MtomOutputStream;
import com.filenet.apiimpl.wsi.MultipartOutputStream;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.ServerHelperNst;
import com.filenet.apiimpl.wsi.ServiceSessionWsi;
import com.filenet.apiimpl.wsi.UsernameToken;
import com.filenet.apiimpl.wsi.serialization.DeserializerContext;
import com.filenet.apiimpl.wsi.serialization.Serialization;
import com.filenet.apiimpl.wsi.serialization.SerializerContext;
import com.filenet.apiimpl.wsi.serialization.TokenReader;
import com.filenet.apiimpl.wsi.serialization.TokenReaderNst;
import com.filenet.apiimpl.wsi.serialization.TokenWriterNst;
import com.filenet.apiimpl.wsi.serialization.Util;
import com.filenet.apiimpl.wsi.serialization.core.ExceptionSerialization;
import com.filenet.apiimpl.wsi.serialization.core.SoapHeaderSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.ExecuteChangesRequestSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.ExecuteChangesResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.ExecuteSearchRequestSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.ExecuteSearchResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.GetContentRequestSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.GetContentResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.GetObjectsRequestSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.GetObjectsResponseSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.GetSearchMetadataRequestSerialization;
import com.filenet.apiimpl.wsi.serialization.operation.GetSearchMetadataResponseSerialization;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.Subject;

public class ServiceSessionNst
extends ServiceSessionWsi {
    private static final TransportLogger logger = TransportLogger.getLogger(ServiceSessionNst.class, SubSystem.WSI);
    private String requestName = null;
    private String responseName = null;
    private final AttachmentHelperNst aHelper = new AttachmentHelperNst();
    private boolean requestWasMultipart = false;
    private String noticedSoapEnvelopeNamespace = null;
    private boolean isForTracing = false;
    private MultipartInputStreamManager mism = null;
    private ClientCallContext optionalCCC = null;
    private ImpersonationToken impToken = null;
    private final SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
    private static final String[] MANIFEST_ATTRIBUTE_NAMES = new String[]{"Specification-Version", "Implementation-Version"};
    private static final String userAgentString;
    private static String[] expectedStartersSoap12;
    private static String[] expectedStartersSoap11;
    private static final String fsfP1a = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><e:Envelope xmlns:d=\"http://www.w3.org/2001/XMLSchema\" xmlns=\"http://www.filenet.com/ns/fnce/2006/11/ws/schema\" xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:e=\"";
    private static final String fsfP1b;
    private static final String fsfP3 = "</e:Text></e:Reason><e:Detail><ErrorStack><ErrorName>";
    private static final String fsfP5 = "</ErrorName><ErrorRecord><Source>";
    private static final String fsfP7 = "</Source><Description>";
    private static final String fsfP9 = "</Description><Diagnostic diagnosticType=\"exceptionCode\">";
    private static final String fsfP11 = "</Diagnostic><Diagnostic diagnosticType=\"stackTrace\">\r\n";
    private static final String fsfP13 = "</Diagnostic></ErrorRecord></ErrorStack></e:Detail></e:Fault></e:Body></e:Envelope>\r\n";
    private static boolean USE_OF_DIME_IS_OK;

    public ServiceSessionNst(String uri) {
        super(uri);
        this.httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public final ExecuteChangesResponse executeChanges(ConnectionImpl ceConn, ExecuteChangesRequest request, ArrayList uploadHandles, ClientCallContext optionalClientCallContext) {
        this.optionalCCC = optionalClientCallContext;
        this.requestName = "ExecuteChangesRequest";
        this.responseName = "ExecuteChangesResponse";
        return (ExecuteChangesResponse)this.cReqRespPath(request, ceConn, ExecuteChangesRequestSerialization.INSTANCE, ExecuteChangesResponseSerialization.INSTANCE);
    }

    public final SearchResponse executeSearch(ConnectionImpl ceConn, SearchRequest request, ClientCallContext optionalClientCallContext) {
        this.optionalCCC = optionalClientCallContext;
        this.requestName = "ExecuteSearchRequest";
        this.responseName = "ExecuteSearchResponse";
        return (SearchResponse)this.cReqRespPath(request, ceConn, ExecuteSearchRequestSerialization.INSTANCE, ExecuteSearchResponseSerialization.INSTANCE);
    }

    public final GetContentResponse getContent(ConnectionImpl ceConn, GetContentRequest request, Long contentSize, ClientCallContext optionalClientCallContext) {
        this.optionalCCC = optionalClientCallContext;
        this.requestName = "GetContentRequest";
        this.responseName = "GetContentResponse";
        return (GetContentResponse)this.cReqRespPath(request, ceConn, GetContentRequestSerialization.INSTANCE, GetContentResponseSerialization.INSTANCE);
    }

    public final GetObjectResponse getObjects(ConnectionImpl ceConn, GetObjectRequest request, ClientCallContext optionalClientCallContext) {
        this.optionalCCC = optionalClientCallContext;
        this.requestName = "GetObjectsRequest";
        this.responseName = "GetObjectsResponse";
        return (GetObjectResponse)this.cReqRespPath(request, ceConn, GetObjectsRequestSerialization.INSTANCE, GetObjectsResponseSerialization.INSTANCE);
    }

    public final MetadataSearchResponse getSearchMetadata(ConnectionImpl ceConn, MetadataSearchRequest request, ClientCallContext optionalClientCallContext) {
        this.optionalCCC = optionalClientCallContext;
        this.requestName = "GetSearchMetadataRequest";
        this.responseName = "GetSearchMetadataResponse";
        return (MetadataSearchResponse)this.cReqRespPath(request, ceConn, GetSearchMetadataRequestSerialization.INSTANCE, GetSearchMetadataResponseSerialization.INSTANCE);
    }

    private final Response cReqRespPath(Request request, ConnectionImpl ceConn, Serialization ser, Serialization deser) {
        SerializerContext sCtx;
        HttpURLConnection http;
        int attachmentBindingType = super.getBinding().getType();
        boolean needsMultipartFormat = ContentRummager.requestCarriesContentAttachments(request, attachmentBindingType);
        try {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Serialize " + this.requestName + "/" + this.responseName + " using ServiceSessionNst@" + Integer.toHexString(System.identityHashCode(this)));
            }
            http = this.cOpenHttpConnection();
            MultipartOutputStream moStr = this.cOpenMultipartOutputStream(http, ceConn, needsMultipartFormat, attachmentBindingType);
            moStr.startRootPart();
            TokenWriterNst tokW = new TokenWriterNst(this, moStr, this.requestName);
            String namespaceURI = super.getBinding().getServiceName().getNamespaceURI();
            this.bBigBlobONamespaces(tokW);
            try {
                sCtx = new SerializerContext(true, namespaceURI, tokW, this.isForTracing);
            }
            catch (EngineRuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw Util.ereOrIoeS(t, new String[]{this.requestName});
            }
            tokW.setSerializerContext(sCtx);
            if (!this.isForTracing) {
                this.bStartXmlDocument(this.optionalCCC, tokW, true, sCtx);
            }
            sCtx.enterElement(this.requestName);
            ser.serialize(request, sCtx);
            this.bCloseSoapEnvelopeAndWriteAttachments(moStr, tokW, attachmentBindingType, sCtx, false);
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{this.requestName});
        }
        TokenReaderNst tokR = null;
        try {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Deserialize " + this.requestName + "/" + this.responseName + " using ServiceSessionNst@" + Integer.toHexString(System.identityHashCode(this)));
            }
            InputStream iStr = this.cOpenHttpResponse(http);
            DeserializerContext dCtx = new DeserializerContext(ceConn, true, sCtx.getWsdlNamespace(), request);
            tokR = new TokenReaderNst(this, iStr, this.responseName);
            dCtx.setTokenReader(tokR);
            this.bReadPastSoapEnvelope(dCtx, tokR, false);
            if ("Fault".equals(tokR.getLocalName())) {
                this.cDeserializeSoapFault(dCtx, tokR);
            }
            Response response = (Response)deser.deserialize(null, dCtx);
            return response;
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            String path = tokR == null ? "<initialization>" : tokR.getPath();
            throw Util.ereOrIoeD(t, new String[]{this.responseName, path});
        }
    }

    private void bBigBlobONamespaces(TokenWriterNst tokW) {
        tokW.setPrefixForNamespace("xop", "http://www.w3.org/2004/08/xop/include");
        tokW.setPrefixForNamespace("dime", "http://schemas.xmlsoap.org/ws/2002/04/reference/");
        tokW.setPrefixForNamespace("fn40", "http://www.filenet.com/ns/fnce/2006/11/ws/schema");
        tokW.setPrefixForNamespace("fn40m", "http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/schema");
        tokW.setPrefixForNamespace("fn40d", "http://www.filenet.com/ns/fnce/2006/11/ws/DIME/schema");
        tokW.setPrefixForNamespace("fn35", "http://www.filenet.com/ns/fnce/2005/02/ws/schema");
        tokW.setPrefixForNamespace("fn35d", "http://www.filenet.com/ns/fnce/2005/02/ws/DIME/schema");
    }

    private MultipartOutputStream cOpenMultipartOutputStream(HttpURLConnection http, ConnectionImpl ceConn, boolean needsMultipartFormat, int attachmentBindingType) {
        MultipartOutputStream moStr;
        try {
            moStr = this.cInitHttpConnection(http, ceConn, needsMultipartFormat, attachmentBindingType);
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.API_UNABLE_TO_USE_CONNECTION, (Object[])new String[]{ceConn.getURI()});
        }
        return moStr;
    }

    private final void bCloseSoapEnvelopeAndWriteAttachments(MultipartOutputStream moStr, TokenWriterNst tokW, int attachmentBindingType, SerializerContext sCtx, boolean isFault) throws IOException {
        if (!this.isForTracing) {
            sCtx.leaveElement();
            sCtx.leaveElement();
            tokW.endDocument();
            if (isFault) {
                moStr.flush();
            }
            tokW.close();
            boolean thereAreAttachments = this.aHelper.thereAreAttachments();
            moStr.endRootPart(thereAreAttachments);
            logger.traceDetail("SOAP /Envelope done");
            try {
                if (thereAreAttachments) {
                    this.aHelper.spillAndClearAttachments(moStr, attachmentBindingType);
                }
                if (isFault) {
                    moStr.flush();
                }
                moStr.close();
                logger.traceDetail("HTTP outputStream closed");
            }
            catch (EngineRuntimeException e) {
                throw e;
            }
            catch (IOException e) {
                throw Util.ereOrIoeS(e, new String[]{this.requestName});
            }
        }
    }

    private final MultipartOutputStream cInitHttpConnection(HttpURLConnection http, ConnectionImpl ceConn, boolean needsMultipartFormat, int attachmentBindingType) throws IOException {
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        try {
            int chunkSize = ConfigValueLookup.getValueAsInt("FileNet.WSI.HttpChunkSize", -1);
            http.setChunkedStreamingMode(chunkSize);
            http.setConnectTimeout(ClientOperation.getConnectionTimeout(ceConn));
            http.setReadTimeout(ClientOperation.getConnectionTimeout(ceConn));
        }
        catch (Throwable t) {
            logger.traceDetail("Some methods are only available in Java 5 or later (performance only): " + t);
        }
        String contentIdZero = this.aHelper.computeContentId(0, attachmentBindingType);
        MultipartOutputStream moStr = attachmentBindingType == 1 ? new DimeOutputStream(null, 2000, contentIdZero) : new MtomOutputStream(this.aHelper.getUniquePiece(), contentIdZero, needsMultipartFormat, null);
        http.setRequestProperty("User-Agent", this.bGetUserAgentString());
        http.setRequestProperty("Date", this.httpDateFormat.format(new Date()));
        http.setRequestProperty("Content-Type", moStr.getRequestContentType());
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("HTTP request properties " + http.getRequestProperties());
        }
        OutputStream oStr = null;
        try {
            oStr = ServiceSessionNst.cDoPrivilegedHttpConnectAndGetOutputStream(http);
        }
        catch (IOException e) {
            throw e;
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        moStr.setOutputStream(oStr);
        return moStr;
    }

    private static final OutputStream cDoPrivilegedHttpConnectAndGetOutputStream(final HttpURLConnection http) throws Throwable {
        PrivilegedExceptionAction paProp = new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                http.connect();
                logger.traceDetail("HTTP connect done");
                OutputStream oStr = http.getOutputStream();
                logger.traceDetail("HTTP getOutputStream done");
                return oStr;
            }
        };
        try {
            return (OutputStream)AccessController.doPrivileged(paProp);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    private HttpURLConnection cOpenHttpConnection() throws IOException {
        HttpURLConnection http;
        try {
            URL url = new URL(this.getUri());
            http = (HttpURLConnection)url.openConnection();
            logger.traceDetail("URL openConnection done");
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_INVALID_URI, (Object[])new String[]{this.getUri()});
        }
        catch (ClassCastException e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_UNABLE_TO_USE_CONNECTION, (Object[])new String[]{this.getUri()});
        }
        return http;
    }

    private final String bGetUserAgentString() {
        return userAgentString;
    }

    private final InputStream cOpenHttpResponse(HttpURLConnection http) throws MalformedURLException, IOException, ProtocolException {
        InputStream iStr;
        try {
            iStr = http.getInputStream();
            logger.traceDetail("HTTP getInputStream done");
        }
        catch (Exception e) {
            iStr = http.getErrorStream();
            logger.traceDetail("HTTP getErrorStream done");
        }
        int rc = http.getResponseCode();
        if (rc < 0) {
            String whatsIt = this.bGetLoggableInputStreamBeginning(iStr);
            throw new EngineRuntimeException(ExceptionCode.E_SERVER_ERROR, null, ExceptionContext.TRANSPORT_WSI_RESPONSE_NOT_HTTP, new Object[]{whatsIt});
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("HTTP response properties " + http.getHeaderFields());
        }
        String ct = http.getContentType();
        iStr = this.bInputStreamBasedOnContentType(ct, iStr, true);
        return iStr;
    }

    private final InputStream bInputStreamBasedOnContentType(String ct, InputStream iStr, boolean isResponse) throws IOException {
        ct = ct == null ? "" : ct;
        String ctLower = ct.trim().toLowerCase();
        this.requestWasMultipart = false;
        if (ctLower.startsWith("multipart")) {
            this.requestWasMultipart = true;
            int bufsize = ConfigValueLookup.getValueAsInt("FileNet.WSI.DeserializationBufferSize", 16384);
            this.mism = new MtomInputStreamManager(ct, iStr, bufsize, this.bInstantiateSpill());
            return this.mism.getRootInputStream();
        }
        if (ctLower.indexOf("application/dime") >= 0) {
            this.mism = new DimeInputStreamManager(iStr, (SpillStreamFactory)this.bInstantiateSpill());
            return this.mism.getRootInputStream();
        }
        if (!isResponse || ctLower.indexOf("xml") >= 0) {
            return iStr;
        }
        String whatsIt = this.bGetLoggableInputStreamBeginning(iStr);
        throw new EngineRuntimeException(ExceptionCode.E_SERVER_ERROR, null, ExceptionContext.TRANSPORT_WSI_RESPONSE_NOT_SOAP, new Object[]{ct, whatsIt});
    }

    private final MemoryThenFileSpillStreamFactory bInstantiateSpill() {
        int cutover = ConfigValueLookup.getValueAsInt("FileNet.WSI.SpillCutover", 524288);
        MemoryThenFileSpillStreamFactory spill = new MemoryThenFileSpillStreamFactory(0, cutover, null);
        return spill;
    }

    private final String bGetLoggableInputStreamBeginning(InputStream iStr) throws IOException {
        StringBuffer sb = new StringBuffer();
        String postpend = " ...";
        for (int ii = 0; ii < 5000; ++ii) {
            int theByte = iStr.read();
            if (theByte < 0) {
                postpend = "";
                break;
            }
            sb.append((char)theByte);
        }
        String whatsIt = sb.append(postpend).toString().trim().replaceAll("\r\n", "<CRLF>").replaceAll("\r", "<CR>").replaceAll("\n", "<LF>");
        return whatsIt;
    }

    private final List bReadPastSoapEnvelope(DeserializerContext dCtx, TokenReaderNst tokR, boolean noticeSoapNamespace) {
        List soapHeaders = null;
        while (true) {
            TokenReader.State state;
            if ((state = dCtx.nextToken()) != TokenReader.State.START_TOKEN) {
                continue;
            }
            String localName = tokR.getLocalName();
            if ("Envelope".equals(localName)) {
                if (!noticeSoapNamespace) continue;
                this.noticedSoapEnvelopeNamespace = tokR.getNamespace();
                continue;
            }
            if ("Header".equals(localName)) {
                soapHeaders = (List)SoapHeaderSerialization.INSTANCE.deserialize(null, dCtx);
                continue;
            }
            if ("Body".equals(localName)) break;
        }
        dCtx.nextStartToken();
        return soapHeaders;
    }

    private final void cDeserializeSoapFault(DeserializerContext dCtx, TokenReaderNst tokR) throws Throwable {
        boolean spanishInquisition = false;
        StringBuffer whoLetTheDogsOut = new StringBuffer();
        whoLetTheDogsOut.append("<Fault>");
        String faultPath = tokR.getPath();
        tokR.next();
        TokenReader.State state = tokR.currentState();
        String[] expectedStarters = expectedStartersSoap12;
        if (state == TokenReader.State.START_TOKEN) {
            String localName = tokR.getLocalName();
            whoLetTheDogsOut.append('<').append(localName).append('>');
            if (localName == expectedStartersSoap12[0]) {
                expectedStarters = expectedStartersSoap12;
            } else if (localName == expectedStartersSoap11[0]) {
                expectedStarters = expectedStartersSoap11;
            } else {
                spanishInquisition = true;
            }
        }
        for (int expectdex = 1; expectdex < expectedStarters.length; ++expectdex) {
            while (tokR.next() != TokenReader.State.UNKNOWN) {
                String localName;
                state = tokR.currentState();
                if (state == TokenReader.State.START_TOKEN) {
                    localName = tokR.getLocalName();
                    whoLetTheDogsOut.append('<').append(localName).append('>');
                    if (localName == expectedStarters[expectdex]) break;
                    spanishInquisition = true;
                    break;
                }
                if (state == TokenReader.State.END_TOKEN) {
                    localName = tokR.getLocalName();
                    whoLetTheDogsOut.append("</").append(localName).append(">\n");
                    continue;
                }
                if (state != TokenReader.State.CONTENT) continue;
                whoLetTheDogsOut.append(tokR.readContent());
            }
            if (spanishInquisition) break;
        }
        if (!spanishInquisition) {
            Object response = ExceptionSerialization.INSTANCE.deserialize(null, dCtx);
            if (response instanceof Throwable) {
                throw (Throwable)response;
            }
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, new String[]{this.responseName, tokR.getPath()});
        }
        while (tokR.next() != TokenReader.State.UNKNOWN) {
            state = tokR.currentState();
            if (state == TokenReader.State.START_TOKEN) {
                String localName = tokR.getLocalName();
                whoLetTheDogsOut.append('<').append(localName).append('>');
            } else if (state == TokenReader.State.END_TOKEN) {
                String localName = tokR.getLocalName();
                whoLetTheDogsOut.append("</").append(localName).append(">\n");
                if ("Fault".equals(localName)) {
                    break;
                }
            } else if (state == TokenReader.State.CONTENT) {
                whoLetTheDogsOut.append(tokR.readContent());
            }
            if (whoLetTheDogsOut.length() <= 24576) continue;
        }
        throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR, new String[]{this.responseName, faultPath}, ExceptionContext.TRANSPORT_WSI_UNFAMILIAR_SOAP_FAULT, new String[]{whoLetTheDogsOut.toString()});
    }

    public final void sForceSoapFault(Throwable t, OutputStream oStr, String sNamespace) throws Exception {
        EngineRuntimeException ere = null;
        ere = t instanceof EngineRuntimeException ? (EngineRuntimeException)t : new EngineRuntimeException(t, ExceptionCode.E_SERVER_ERROR, null);
        if (sNamespace == null) {
            sNamespace = "http://www.w3.org/2003/05/soap-envelope";
        }
        String eDescription = XMLHelper.popularEntityEncode(XMLHelper.encodeText(t.getLocalizedMessage()));
        ExceptionCode exceptionCode = ere.getExceptionCode();
        String eCodeMapped = ExceptionCodeMapper.toErrorNameString(exceptionCode, 400);
        PrintStream ps = new PrintStream(oStr);
        ps.print(fsfP1a);
        ps.print(sNamespace);
        ps.print(fsfP1b);
        ps.print(eDescription);
        ps.print(fsfP3);
        ps.print(eCodeMapped);
        ps.print(fsfP5);
        ps.print(t.getClass().getName());
        ps.print(fsfP7);
        ps.print(eDescription);
        ps.print(fsfP9);
        ps.print(exceptionCode.getKey());
        ps.print(fsfP11);
        StackTraceElement[] stack = ere.getStackTrace();
        if (stack != null && stack.length > 0) {
            for (int ii = 0; ii < stack.length; ++ii) {
                StackTraceElement frame = stack[ii];
                ps.print("\tat ");
                ps.print(XMLHelper.popularEntityEncode(XMLHelper.encodeText(frame.toString())));
                ps.print("\r\n");
            }
        } else {
            ps.print("\tat (unknown)\r\n");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream bps = new PrintStream(baos);
        t.printStackTrace(bps);
        bps.close();
        String redundantStack = baos.toString();
        ps.println("Redundant exception report follows");
        ps.println(XMLHelper.popularEntityEncode(XMLHelper.encodeText(redundantStack)));
        ps.print(fsfP13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sSerializeSoapFault(EngineRuntimeException ere, TokenWriterNst tokW, SerializerContext sCtx) throws IOException {
        String localizedMessage;
        String soapNS = this.bSoapEnvelopeNS();
        boolean wantsSoap11 = soapNS != null && soapNS.toLowerCase().indexOf("xmlsoap.org") >= 0;
        Locale requestLocale = sCtx.getRequestLocale();
        if (requestLocale == null) {
            requestLocale = Locale.getDefault();
        }
        Locale oldLocale = UserContext.get().getLocale();
        try {
            UserContext.get().setLocale(requestLocale);
            localizedMessage = ere.getLocalizedMessage();
        }
        finally {
            UserContext.get().setLocale(oldLocale);
        }
        if (wantsSoap11) {
            tokW.enter(null, "faultcode");
            sCtx.writeContent("e:Server");
            sCtx.leaveElement();
            tokW.enter(null, "faultstring");
            sCtx.writeContent(XMLHelper.encodeText(localizedMessage));
            sCtx.leaveElement();
        } else {
            sCtx.enterNamespacedElement(soapNS, "Code");
            sCtx.enterNamespacedElement(soapNS, "Value");
            sCtx.writeContent("e:Receiver");
            sCtx.leaveElement();
            sCtx.leaveElement();
            sCtx.enterNamespacedElement(soapNS, "Reason");
            sCtx.enterNamespacedElement(soapNS, "Text");
            sCtx.writeAttribute("http://www.w3.org/XML/1998/namespace", "lang", LocaleUtils.toXmlLanguageTag(requestLocale));
            sCtx.writeContent(XMLHelper.encodeText(localizedMessage));
            sCtx.leaveElement();
            sCtx.leaveElement();
        }
        if (wantsSoap11) {
            sCtx.enterNamespacedElement(null, "detail");
        } else {
            sCtx.enterNamespacedElement(soapNS, "Detail");
        }
        sCtx.enterElement("ErrorStack");
        ExceptionSerialization.INSTANCE.serialize(ere, sCtx);
        sCtx.leaveElement();
        sCtx.leaveElement();
    }

    private final void bStartXmlDocument(ClientCallContext optionalClientCallContext, TokenWriterNst tokW, boolean isRequest, SerializerContext sCtx) throws IOException {
        tokW.startDocument();
        tokW.setPrefixForNamespace("e", this.bSoapEnvelopeNS());
        tokW.setPrefixForNamespace("d", "http://www.w3.org/2001/XMLSchema");
        sCtx.enterNamespacedElement(this.bSoapEnvelopeNS(), "Envelope");
        if (isRequest) {
            Security sec = ClientOperation.getSoapEnvelopeSecurity();
            Localization loc = ClientOperation.getSoapEnvelopeLocalization(optionalClientCallContext);
            ApiContext ctx = ClientOperation.getSoapEnvelopeApiContext(optionalClientCallContext);
            ArrayList<Object> soapHeaders = new ArrayList<Object>(3);
            soapHeaders.add(loc);
            soapHeaders.add(sec);
            soapHeaders.add(ctx);
            SoapHeaderSerialization.INSTANCE.serialize(soapHeaders, sCtx);
        }
        sCtx.enterNamespacedElement(this.bSoapEnvelopeNS(), "Body");
    }

    public final InputStream getContentInputStream(String contentId) {
        String hackedContentId = contentId;
        if (this.mism instanceof MtomInputStreamManager && contentId.startsWith("cid:")) {
            hackedContentId = "<" + contentId.substring(4) + ">";
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Reference InputStream for attachment " + contentId + "; " + hackedContentId);
        }
        return this.mism.instantiateContentInputStream(hackedContentId);
    }

    public final void sHandleIncomingRequest(String httpPath, String requestContentType, InputStream reqIS, OutputStream respOS, ServerCallbackNotifier callback) {
        if (callback != null) {
            callback.sayUserAgent(this.bGetUserAgentString());
        }
        String namespaceURI = super.getBinding().getServiceName().getNamespaceURI();
        DeserializerContext dCtx = new DeserializerContext(null, false, namespaceURI, null);
        try {
            reqIS = this.bInputStreamBasedOnContentType(requestContentType, reqIS, false);
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (IOException e) {
            throw new EngineRuntimeException(e, ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR, null);
        }
        TokenReaderNst tokR = new TokenReaderNst(this, reqIS, "IncomingServerRequest");
        dCtx.setTokenReader(tokR);
        List soapHeaders = this.bReadPastSoapEnvelope(dCtx, tokR, true);
        if (this.noticedSoapEnvelopeNamespace != null) {
            callback.saySoapNamespace(this.noticedSoapEnvelopeNamespace);
        }
        this.requestName = tokR.getLocalName();
        String requestOperationNamespace = tokR.getNamespace();
        tokR.setOpName(this.requestName);
        Serialization deser = null;
        Serialization ser = null;
        String opName = null;
        if (this.requestName.equalsIgnoreCase("GetObjectsRequest")) {
            this.responseName = "GetObjectsResponse";
            deser = GetObjectsRequestSerialization.INSTANCE;
            ser = GetObjectsResponseSerialization.INSTANCE;
            opName = "GetObjects";
        } else if (this.requestName.equalsIgnoreCase("ExecuteChangesRequest")) {
            this.responseName = "ExecuteChangesResponse";
            deser = ExecuteChangesRequestSerialization.INSTANCE;
            ser = ExecuteChangesResponseSerialization.INSTANCE;
            opName = "ExecuteChanges";
        } else if (this.requestName.equalsIgnoreCase("ExecuteSearchRequest")) {
            this.responseName = "ExecuteSearchResponse";
            deser = ExecuteSearchRequestSerialization.INSTANCE;
            ser = ExecuteSearchResponseSerialization.INSTANCE;
            opName = "ExecuteSearch";
        } else if (this.requestName.equalsIgnoreCase("GetContentRequest")) {
            this.responseName = "GetContentResponse";
            deser = GetContentRequestSerialization.INSTANCE;
            ser = GetContentResponseSerialization.INSTANCE;
            opName = "GetContent";
        } else if (this.requestName.equalsIgnoreCase("GetSearchMetadataRequest")) {
            this.responseName = "GetSearchMetadataResponse";
            deser = GetSearchMetadataRequestSerialization.INSTANCE;
            ser = GetSearchMetadataResponseSerialization.INSTANCE;
            opName = "GetSearchMetadata";
        } else {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_UNEXPECTED_REQUEST, this.requestName);
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Request: " + this.requestName + ", Response " + this.responseName);
        }
        Request request = null;
        ServerHelperNst shn = null;
        boolean needsMultipartResponse = this.requestWasMultipart;
        String uPiece = this.aHelper.getUniquePiece();
        int attachmentBindingType = super.getBinding().getType();
        String cidZero = this.aHelper.computeContentId(0, attachmentBindingType);
        SerializerContext sCtx = null;
        Locale requestLocale = Locale.getDefault();
        try {
            MultipartOutputStream mrespOS;
            request = (Request)deser.deserialize(null, dCtx);
            shn = new ServerHelperNst(opName, namespaceURI);
            String localeString = this.sGetLocaleStringBasedOnSoapHeaders(soapHeaders);
            if (localeString != null) {
                requestLocale = LocaleUtils.fromString(localeString);
            }
            UserContext.get().setLocale(requestLocale);
            Subject subject = this.sGetSubjectBasedOnSoapHeaders(soapHeaders, callback);
            ServerHelperNst.setClientInfo(httpPath, subject);
            this.optionalCCC = this.sCreateCCCBasedOnSoapHeaders(soapHeaders, localeString, ClientInfo.getVersion());
            shn.traceRequest(request, logger);
            PrivilegedExceptionAction pea = this.sGetPEA(request, shn);
            Response response = this.sMakeInternalEJBCall(pea, subject);
            boolean bl = needsMultipartResponse = this.requestWasMultipart || ContentRummager.responseCarriesContentAttachments(response, attachmentBindingType);
            if (requestContentType.indexOf("application/dime") >= 0 || httpPath.indexOf("DIME") >= 0) {
                this.sDimeIsUnsupported();
                mrespOS = new DimeOutputStream(null, 2000, cidZero);
            } else {
                mrespOS = new MtomOutputStream(uPiece, cidZero, needsMultipartResponse, requestContentType);
            }
            mrespOS.setOutputStream(respOS);
            TokenWriterNst tokW = new TokenWriterNst(this, mrespOS, this.responseName);
            sCtx = this.sPrepareToSerializeResponse(this.responseName, requestOperationNamespace, namespaceURI, tokW, mrespOS, callback, requestLocale);
            shn.traceResponse(null, response, logger);
            ser.serialize(response, sCtx);
            this.bCloseSoapEnvelopeAndWriteAttachments(mrespOS, tokW, attachmentBindingType, sCtx, false);
        }
        catch (Throwable t) {
            EngineRuntimeException ere = t instanceof EngineRuntimeException ? (EngineRuntimeException)t : new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            if (shn != null) {
                shn.traceResponse(ere, null, logger);
            }
            if (callback != null) {
                callback.sayFault(true);
            }
            MultipartOutputStream mrespOS = requestContentType.indexOf("application/dime") >= 0 || httpPath.indexOf("DIME") >= 0 ? new DimeOutputStream(null, 2000, cidZero) : new MtomOutputStream(uPiece, cidZero, needsMultipartResponse, requestContentType);
            mrespOS.setOutputStream(respOS);
            TokenWriterNst tokW = new TokenWriterNst(this, mrespOS, this.responseName);
            try {
                sCtx = this.sPrepareToSerializeResponse("Fault", requestOperationNamespace, namespaceURI, tokW, mrespOS, callback, requestLocale);
                this.sSerializeSoapFault(ere, tokW, sCtx);
                this.bCloseSoapEnvelopeAndWriteAttachments(mrespOS, tokW, attachmentBindingType, sCtx, true);
            }
            catch (EngineRuntimeException ee) {
                throw ee;
            }
            catch (Throwable tt) {
                throw new EngineRuntimeException(tt, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        }
    }

    private void sDimeIsUnsupported() {
        if (USE_OF_DIME_IS_OK) {
            return;
        }
        USE_OF_DIME_IS_OK = ConfigValueLookup.getValueAsBoolean("FileNet.WSI.EnableDIME", false);
        if (!USE_OF_DIME_IS_OK) {
            throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_DIME_UNSUPPORTED);
        }
    }

    private final Response sMakeInternalEJBCall(PrivilegedExceptionAction pea, Subject subject) {
        try {
            Response response = (Response)J2EEUtil.getInstance().doAs(subject, pea);
            return response;
        }
        catch (Throwable t) {
            EngineRuntimeException ere = ServerHelperNst.distillInterestingException(t, ServiceSessionNst.sGetPrincipalName(subject), logger);
            throw ere;
        }
    }

    private final Subject sGetSubjectBasedOnSoapHeaders(List soapHeaders, ServerCallbackNotifier callback) {
        String username = null;
        String password = null;
        String binarySecurityToken = null;
        String binarySecurityTokenValueType = null;
        String securityHeaderXml = null;
        Subject subject = null;
        if (soapHeaders != null) {
            for (Object header : soapHeaders) {
                Object sc1;
                Object[] sc;
                BinarySecurityToken bst;
                if (!(header instanceof Security)) continue;
                Security security = (Security)header;
                UsernameToken usernameToken = security.UsernameToken;
                if (usernameToken != null) {
                    username = usernameToken.Username;
                    password = usernameToken.Password;
                }
                if ((bst = security.BinarySecurityToken) != null) {
                    if (bst.Value == null && bst.AttachedValue != null) {
                        byte[] valueBytes;
                        try {
                            valueBytes = ClientInputStream.gatherStreamToBytes(bst.AttachedValue);
                        }
                        catch (IOException e) {
                            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
                        }
                        bst.Value = B64.encodeToString(valueBytes);
                    }
                    binarySecurityToken = bst.Value;
                    binarySecurityTokenValueType = bst.ValueType;
                }
                if ((sc = callback.wsiAuthenticator(username, password, binarySecurityToken, binarySecurityTokenValueType, securityHeaderXml = security.XmlBlob)) != null && sc.length > 0) {
                    subject = (Subject)sc[0];
                    if (subject == null) {
                        throw new EngineRuntimeException(ExceptionCode.E_NOT_AUTHENTICATED);
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Subject from request: " + subject);
                        logger.traceDetail("Principal name: " + ServiceSessionNst.sGetPrincipalName(subject));
                    }
                }
                if (sc == null || sc.length <= 1 || (sc1 = sc[1]) == null || !(sc1 instanceof ImpersonationToken)) break;
                this.impToken = (ImpersonationToken)sc1;
                if (!logger.isDetailTraceEnabled()) break;
                logger.traceDetail("Flagged username: " + this.impToken.getImpersonationUsername());
                break;
            }
        }
        return subject;
    }

    private final String sGetLocaleStringBasedOnSoapHeaders(List soapHeaders) {
        String localeString = null;
        if (soapHeaders != null) {
            for (Object header : soapHeaders) {
                if (!(header instanceof Localization)) continue;
                Localization localization = (Localization)header;
                localeString = localization.Locale;
                break;
            }
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Locale string from request: " + localeString);
        }
        return localeString;
    }

    private final PrivilegedExceptionAction sGetPEA(final Request request, final ServerHelperNst shn) {
        PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                Message response;
                EnginePort enginePort = shn.getEnginePort();
                if (ServiceSessionNst.this.responseName == "GetObjectsResponse") {
                    response = enginePort.getObjects(ServiceSessionNst.this.optionalCCC, (GetObjectRequest)request);
                } else if (ServiceSessionNst.this.responseName == "ExecuteChangesResponse") {
                    ArrayList contentHandles;
                    ExecuteChangesRequest ecRequest = (ExecuteChangesRequest)request;
                    ArrayList xopBinaryProps = ecRequest.getXopBinaryProperties();
                    if (xopBinaryProps != null && xopBinaryProps.size() > 0) {
                        Util.resolveXopBinaryProperties(xopBinaryProps);
                    }
                    if ((contentHandles = ecRequest.getContentHandles()) != null && contentHandles.size() > 0) {
                        if (ServiceSessionNst.this.impToken != null) {
                            ServiceSessionNst.this.sSetCCCForImpersonation(ServiceSessionNst.this.optionalCCC, null);
                        }
                        Util.uploadContent(contentHandles, shn.getNamingContext(), ServiceSessionNst.this.optionalCCC);
                        if (ServiceSessionNst.this.impToken != null) {
                            ServiceSessionNst.this.sSetCCCForImpersonation(ServiceSessionNst.this.optionalCCC, ServiceSessionNst.this.impToken);
                        }
                    }
                    response = enginePort.executeChanges(ServiceSessionNst.this.optionalCCC, (ExecuteChangesRequest)request);
                } else if (ServiceSessionNst.this.responseName == "ExecuteSearchResponse") {
                    response = enginePort.executeSearch(ServiceSessionNst.this.optionalCCC, (SearchRequest)request);
                } else if (ServiceSessionNst.this.responseName == "GetContentResponse") {
                    response = enginePort.getContent(ServiceSessionNst.this.optionalCCC, (GetContentRequest)request);
                } else if (ServiceSessionNst.this.responseName == "GetSearchMetadataResponse") {
                    response = enginePort.getSearchMetadata(ServiceSessionNst.this.optionalCCC, (MetadataSearchRequest)request);
                } else {
                    throw new EngineRuntimeException(ExceptionCode.TRANSPORT_WSI_UNEXPECTED_RESPONSE, ServiceSessionNst.this.responseName);
                }
                return response;
            }
        };
        return pea;
    }

    private final String bSoapEnvelopeNS() {
        if (this.noticedSoapEnvelopeNamespace != null) {
            return this.noticedSoapEnvelopeNamespace;
        }
        if (super.getBinding().getType() == 1) {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }
        return "http://www.w3.org/2003/05/soap-envelope";
    }

    private final SerializerContext sPrepareToSerializeResponse(String respName, String requestOperationNamespace, String namespaceURI, TokenWriterNst tokW, MultipartOutputStream moStr, ServerCallbackNotifier fn, Locale requestLocale) throws IOException {
        SerializerContext sCtx;
        String contentType = moStr.getResponseContentType();
        if (fn != null) {
            fn.sayContentType(contentType);
            fn.sayFaultStream(moStr);
        }
        this.bBigBlobONamespaces(tokW);
        try {
            sCtx = new SerializerContext(false, namespaceURI, tokW, this.isForTracing, false, requestLocale);
        }
        catch (EngineRuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Util.ereOrIoeS(t, new String[]{respName});
        }
        tokW.setSerializerContext(sCtx);
        moStr.startRootPart();
        this.bStartXmlDocument(this.optionalCCC, tokW, false, sCtx);
        if (respName == "Fault") {
            sCtx.enterNamespacedElement(this.bSoapEnvelopeNS(), respName);
        } else {
            if (requestOperationNamespace == null) {
                requestOperationNamespace = "http://www.filenet.com/ns/fnce/2006/11/ws/schema";
            }
            tokW.setPrefixForNamespace(null, requestOperationNamespace);
            sCtx.enterElement(respName);
        }
        return sCtx;
    }

    private static final void sPutCCCParam(ClientCallContext context, String name, Serializable value) {
        if (value != null) {
            context.putParam(name, value);
        }
    }

    private void sSetCCCForImpersonation(ClientCallContext context, ImpersonationToken impToken) {
        if (impToken != null) {
            ServiceSessionNst.sPutCCCParam(context, "impusr", (Serializable)((Object)impToken.getImpersonationUsername()));
            ServiceSessionNst.sPutCCCParam(context, "imptok", (Serializable)((Object)impToken.getRawToken()));
        } else {
            context.putParam("impusr", null);
            context.putParam("imptok", null);
        }
    }

    private ClientCallContext sCreateCCCBasedOnSoapHeaders(List soapHeaders, String localeString, int endpointWsdlVersion) {
        ClientCallContext context = new ClientCallContext();
        ServiceSessionNst.sPutCCCParam(context, "loc", (Serializable)((Object)localeString));
        ServiceSessionNst.sPutCCCParam(context, "cliver", new Integer(endpointWsdlVersion));
        ServiceSessionNst.sPutCCCParam(context, "wsi", Boolean.TRUE);
        if (this.impToken != null) {
            this.sSetCCCForImpersonation(context, this.impToken);
        }
        if (soapHeaders != null) {
            for (Object header : soapHeaders) {
                if (!(header instanceof ApiContext)) continue;
                ApiContext ctx = (ApiContext)header;
                ServiceSessionNst.sPutCCCParam(context, "clitype", (Serializable)((Object)ctx.type));
                ServiceSessionNst.sPutCCCParam(context, "cliver", ctx.version);
                ServiceSessionNst.sPutCCCParam(context, "clibuild", (Serializable)((Object)ctx.build));
                ServiceSessionNst.sPutCCCParam(context, "ctid", (Serializable)((Object)ctx.threadId));
                break;
            }
        }
        return context;
    }

    private static final String sGetPrincipalName(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<Principal> principals = subject.getPrincipals();
        if (principals == null) {
            return null;
        }
        Iterator<Principal> iterator = principals.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        Principal principal = iterator.next();
        return principal == null ? null : principal.getName();
    }

    public final String registerAttachment(int attachmentMode, InputStream stream) {
        return this.aHelper.registerAttachment(attachmentMode, stream);
    }

    static {
        String productRelease = null;
        String buildNumber = null;
        List attributeValues = JarManifest.getManifestAttributes(null, "Jace.jar", MANIFEST_ATTRIBUTE_NAMES);
        if (attributeValues == null) {
            attributeValues = JarManifest.getManifestAttributes(null, "jace.jar", MANIFEST_ATTRIBUTE_NAMES);
        }
        if (attributeValues == null) {
            attributeValues = JarManifest.getManifestAttributes(null, "api-java/classes/dbg/", MANIFEST_ATTRIBUTE_NAMES);
        }
        if (attributeValues != null) {
            productRelease = (String)attributeValues.get(0);
            buildNumber = (String)attributeValues.get(1);
        }
        if (productRelease == null) {
            productRelease = "X.Y.Z";
        }
        if (buildNumber == null) {
            buildNumber = "dapNNN.MMM";
        }
        userAgentString = "IBM FileNet P8 CE Java API (" + productRelease + " / " + buildNumber + ")";
        logger.traceDetail(userAgentString);
        expectedStartersSoap12 = new String[]{"Code", "Value", "Reason", "Text", "Detail", "ErrorStack"};
        expectedStartersSoap11 = new String[]{"faultcode", "faultstring", "detail", "ErrorStack"};
        fsfP1b = "\"><e:Body><e:Fault><e:Code><e:Value>e:Receiver</e:Value></e:Code><e:Reason><e:Text xml:lang=\"" + LocaleUtils.toXmlLanguageTag(Locale.getDefault()) + "\">";
        USE_OF_DIME_IS_OK = false;
    }

    public static interface ServerCallbackNotifier {
        public void sayContentType(String var1);

        public void sayFaultStream(OutputStream var1);

        public void sayFault(boolean var1);

        public void sayUserAgent(String var1);

        public void saySoapNamespace(String var1);

        public Object[] wsiAuthenticator(String var1, String var2, String var3, String var4, String var5);
    }
}

