/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

public final class Namespaces {
    public static final String XML = "http://www.w3.org/XML/1998/namespace";
    public static final String XML_SCHEMA_2001 = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_SCHEMA_INSTANCE_2001 = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SOAP_REFERENCE_2002 = "http://schemas.xmlsoap.org/ws/2002/04/reference/";
    public static final String XML_SOAP_REFERENCE = "http://schemas.xmlsoap.org/ws/2002/04/reference/";
    public static final String W3C_XOP = "http://www.w3.org/2004/08/xop/include";
    public static final String W3C_SOAP_ENVELOPE = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP11_ENVELOPE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final int FNCEWS10_VERSION = 300;
    private static final String FNCEWS10_DATE = "2004/06";
    public static final String FNCEWS10_SCHEMA = "http://www.filenet.com/ns/fnce/2004/06/ws/schema";
    public static final String FNCEWS10_DIME_SCHEMA = "http://www.filenet.com/ns/fnce/2004/06/ws/DIME/schema";
    public static final String FNCEWS10_WSDL = "http://www.filenet.com/ns/fnce/2004/06/ws/wsdl";
    public static final String FNCEWS10_SOAP_WSDL = "http://www.filenet.com/ns/fnce/2004/06/ws/SOAP/wsdl";
    public static final String FNCEWS10_DIME_WSDL = "http://www.filenet.com/ns/fnce/2004/06/ws/DIME/wsdl";
    public static final int FNCEWS35_VERSION = 350;
    private static final String FNCEWS35_DATE = "2005/02";
    public static final String FNCEWS35_SCHEMA = "http://www.filenet.com/ns/fnce/2005/02/ws/schema";
    public static final String FNCEWS35_DIME_SCHEMA = "http://www.filenet.com/ns/fnce/2005/02/ws/DIME/schema";
    public static final String FNCEWS35_WSDL = "http://www.filenet.com/ns/fnce/2005/02/ws/wsdl";
    public static final String FNCEWS35_SOAP_WSDL = "http://www.filenet.com/ns/fnce/2005/02/ws/SOAP/wsdl";
    public static final String FNCEWS35_DIME_WSDL = "http://www.filenet.com/ns/fnce/2005/02/ws/DIME/wsdl";
    public static final int FNCEWS40_VERSION = 400;
    private static final String FNCEWS40_DATE = "2006/11";
    public static final String FNCEWS40_SCHEMA = "http://www.filenet.com/ns/fnce/2006/11/ws/schema";
    public static final String FNCEWS40_DIME_SCHEMA = "http://www.filenet.com/ns/fnce/2006/11/ws/DIME/schema";
    public static final String FNCEWS40_MTOM_SCHEMA = "http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/schema";
    public static final String FNCEWS40_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/wsdl";
    public static final String FNCEWS40_SOAP_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/SOAP/wsdl";
    public static final String FNCEWS40_DIME_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/DIME/wsdl";
    public static final String FNCEWS40_MTOM_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/wsdl";
    public static final int FNCEWS_VERSION = 400;
    public static final String FNCEWS_SCHEMA = "http://www.filenet.com/ns/fnce/2006/11/ws/schema";
    public static final String FNCEWS_DIME_SCHEMA = "http://www.filenet.com/ns/fnce/2006/11/ws/DIME/schema";
    public static final String FNCEWS_MTOM_SCHEMA = "http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/schema";
    public static final String FNCEWS_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/wsdl";
    public static final String FNCEWS_SOAP_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/SOAP/wsdl";
    public static final String FNCEWS_DIME_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/DIME/wsdl";
    public static final String FNCEWS_MTOM_WSDL = "http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/wsdl";
    private static final int SCHEMA_LENGTH = "http://www.filenet.com/ns/fnce/xxxx/xx/ws/schema".length();
    private static final int SCHEMA_SUFFIX_INDEX = "http://www.filenet.com/ns/fnce/xxxx/xx/ws/".length();
    private static final int MAX_WSDL_SCHEMA_LENGTH = "http://www.filenet.com/ns/fnce/xxxx/xx/ws/xxxx/wsdl".length();
    private static final int ATTACHMENT_INDEX = SCHEMA_SUFFIX_INDEX;
    private static final int DATE_INDEX = "http://www.filenet.com/ns/fnce/".length();

    private Namespaces() {
    }

    public static boolean isDime(String namespace) {
        return namespace.startsWith("DIME", ATTACHMENT_INDEX);
    }

    public static boolean isMtom(String namespace) {
        return namespace.startsWith("MTOM", ATTACHMENT_INDEX);
    }

    public static String getSchemaNamespace(String namespace) {
        StringBuffer buffer = new StringBuffer(Math.max(SCHEMA_LENGTH, namespace.length()));
        buffer.append(namespace);
        buffer.setLength(SCHEMA_SUFFIX_INDEX);
        buffer.append("schema");
        return buffer.toString();
    }

    public static String getWsdlSchemaNamespace(String namespace) {
        StringBuffer buffer = new StringBuffer(Math.max(MAX_WSDL_SCHEMA_LENGTH, namespace.length()));
        buffer.append(namespace);
        buffer.setLength(ATTACHMENT_INDEX);
        if (namespace.startsWith("DIME", ATTACHMENT_INDEX)) {
            buffer.append("DIME/");
        } else if (namespace.startsWith("MTOM", ATTACHMENT_INDEX)) {
            buffer.append("MTOM/");
        }
        buffer.append("schema");
        return buffer.toString();
    }

    public static String getSoapWsdlNamespace(String namespace) {
        StringBuffer buffer = new StringBuffer(Math.max(MAX_WSDL_SCHEMA_LENGTH, namespace.length()));
        buffer.append(namespace);
        buffer.setLength(ATTACHMENT_INDEX);
        buffer.append("SOAP/wsdl");
        return buffer.toString();
    }

    public static int getNamespaceVersion(String namespace) {
        if (namespace.startsWith(FNCEWS40_DATE, DATE_INDEX)) {
            return 400;
        }
        if (namespace.startsWith(FNCEWS35_DATE, DATE_INDEX)) {
            return 350;
        }
        if (namespace.startsWith(FNCEWS10_DATE, DATE_INDEX)) {
            return 300;
        }
        throw new IllegalArgumentException(namespace);
    }
}

