/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.wsi.MultipartOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MtomOutputStream
extends MultipartOutputStream {
    private final boolean needsMultipartFormat;
    private final String requestContentType;
    private String rootContentId = null;
    private byte[] mimeBoundary = null;
    private String contentType = "application/soap+xml";
    private static final byte[] CONTENT_TYPE_OCTET_STREAM_CRLF = "Content-Type: application/octet-stream\r\n".getBytes();
    private static final byte[] DASH_DASH = "--".getBytes();
    private static final byte[] CONTENT_TYPE_XOP_XML_CRLF = "Content-Type: application/xop+xml; type=\"application/soap+xml\"; charset=UTF-8\r\n".getBytes();
    private static final byte[] CONTENT_TRANSFER_ENCODING_BINARY_CRLF = "Content-Transfer-Encoding: binary\r\n".getBytes();
    private static final byte[] CRLF = "\r\n".getBytes();

    public MtomOutputStream(String uniquePiece, String contentIdZero, boolean needsMultipartFormat, String requestContentType) {
        super(null);
        this.needsMultipartFormat = needsMultipartFormat;
        this.requestContentType = requestContentType;
        if (needsMultipartFormat) {
            this.computeMimeRelatedItems(uniquePiece, contentIdZero);
        }
    }

    public void close() throws IOException {
        if (this.needsMultipartFormat) {
            this.out.write(DASH_DASH);
            this.out.write(this.mimeBoundary);
            this.out.write(DASH_DASH);
            this.out.write(CRLF);
            this.out.write(CRLF);
        }
        this.out.close();
    }

    public void flush() {
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(int b) throws IOException {
        this.out.write(b);
    }

    private void computeMimeRelatedItems(String uniquePiece, String contentIdZero) {
        this.rootContentId = "<" + contentIdZero + ">";
        String mimeBoundaryStr = "A-B--MIME-BOUNDARY--" + uniquePiece + "--Y-Z";
        try {
            this.mimeBoundary = mimeBoundaryStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        this.contentType = "multipart/related; boundary=" + mimeBoundaryStr + "; type=\"application/xop+xml\"; start-info=\"application/soap+xml\"; " + "start=\"" + this.rootContentId + "\"";
    }

    public void startRootPart() throws IOException {
        if (this.needsMultipartFormat) {
            this.out.write(DASH_DASH);
            this.out.write(this.mimeBoundary);
            this.out.write(CRLF);
            this.out.write(CONTENT_TRANSFER_ENCODING_BINARY_CRLF);
            this.out.write(CONTENT_TYPE_XOP_XML_CRLF);
            String cidHeader = "Content-ID: " + this.rootContentId;
            this.out.write(cidHeader.getBytes("UTF-8"));
            this.out.write(CRLF);
            this.out.write(CRLF);
        }
    }

    public void endRootPart(boolean attachmentsFollow) throws IOException {
        this.endAttachment(attachmentsFollow);
    }

    public void startAttachment(String contentId) throws IOException {
        this.out.write(DASH_DASH);
        this.out.write(this.mimeBoundary);
        this.out.write(CRLF);
        this.out.write(CONTENT_TRANSFER_ENCODING_BINARY_CRLF);
        this.out.write(CONTENT_TYPE_OCTET_STREAM_CRLF);
        String partCidHeader = "Content-Id: <" + contentId + ">";
        this.out.write(partCidHeader.getBytes("UTF-8"));
        this.out.write(CRLF);
        this.out.write(CRLF);
    }

    public void endAttachment(boolean attachmentsFollow) throws IOException {
        this.out.write(CRLF);
    }

    public String getRequestContentType() {
        return this.contentType;
    }

    public String getResponseContentType() {
        if (this.needsMultipartFormat) {
            return this.contentType;
        }
        if (this.requestContentType == null || this.requestContentType.length() == 0) {
            return "application/soap+xml";
        }
        return this.requestContentType;
    }
}

