/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.BinaryImpersonation;
import java.util.Arrays;

public class ImpersonationToken {
    private byte[] regionKey;
    private char[] rawToken;
    private String flagUsername;
    private BinaryImpersonation binToken;
    private static final String IMP_PREFIX = "#IMPERSONATION(";
    private static final String IMP_SUFFIX = ")";
    private static final String CLASS_NAME = ImpersonationToken.class.getName();
    private static final int LEN_CLASS_NAME = CLASS_NAME.length();

    public ImpersonationToken(Id regionId, byte[] regionKey, String username) {
        this.regionKey = ImpersonationToken.regenName(regionKey);
        this.binToken = new BinaryImpersonation(username);
        this.flagUsername = IMP_PREFIX + regionId.toString() + IMP_SUFFIX;
    }

    public ImpersonationToken(String flagUsername, char[] rawToken) {
        if (!ImpersonationToken.isImpersonationUsername(flagUsername) || rawToken == null || rawToken.length < 52) {
            throw new IllegalArgumentException();
        }
        this.flagUsername = flagUsername;
        this.rawToken = rawToken;
    }

    public char[] getOneTimePassword() {
        byte[] key = ImpersonationToken.regenName(this.regionKey);
        char[] ctok = this.binToken.generateToken(key);
        Arrays.fill(key, (byte)0);
        return ctok;
    }

    public void destroy() {
        if (this.regionKey != null) {
            Arrays.fill(this.regionKey, (byte)0);
        }
        this.regionKey = null;
        this.rawToken = null;
        this.binToken = null;
        this.flagUsername = null;
    }

    public String getImpersonationUsername() {
        return this.flagUsername;
    }

    public static boolean isImpersonationUsername(String username) {
        return username != null && username.startsWith(IMP_PREFIX) && username.endsWith(IMP_SUFFIX) && username.length() > IMP_PREFIX.length() + IMP_SUFFIX.length();
    }

    public static Id getRegionId(String username) {
        if (ImpersonationToken.isImpersonationUsername(username)) {
            String idStr = username.substring(IMP_PREFIX.length(), username.length() - IMP_SUFFIX.length());
            return new Id(idStr);
        }
        return null;
    }

    private static byte[] regenName(byte[] key) {
        int len = key.length;
        byte[] retn = new byte[len];
        for (int i = 0; i < len; ++i) {
            retn[i] = (byte)(key[i] ^ 37 * i + CLASS_NAME.charAt(i % LEN_CLASS_NAME));
        }
        return retn;
    }

    public String getRawToken() {
        if (this.rawToken == null) {
            return null;
        }
        return new String(this.rawToken);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImpersonationToken)) {
            return false;
        }
        ImpersonationToken that = (ImpersonationToken)obj;
        if (!Arrays.equals(this.rawToken, that.rawToken)) {
            return false;
        }
        if (this.binToken == null) {
            return that.binToken == null;
        }
        if (!this.binToken.equals(that.binToken)) {
            return false;
        }
        return Arrays.equals(this.regionKey, that.regionKey);
    }

    public int hashCode() {
        int result = this.flagUsername.hashCode() + 23 * this.binToken.getUsername().hashCode();
        for (int i = 0; i < this.regionKey.length; ++i) {
            result = 7 * result + this.regionKey[i];
        }
        return result;
    }
}

