/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.wsi.ClientOperation;
import com.filenet.apiimpl.wsi.ImpersonationToken;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.WSICredential;

public class Impersonation {
    private Impersonation() {
    }

    public static void begin(Id regionId, byte[] key, String username) {
        Impersonation.end();
        ImpersonationToken token = new ImpersonationToken(regionId, key, username);
        WSICredential cred = new WSICredential(token);
        ClientOperation.setThreadCredential(cred);
    }

    public static void end() {
        block3: {
            try {
                Security sec;
                WSICredential old = ClientOperation.getCredential();
                if (old != null && (sec = old.getSecurityToken()) != null && sec.ImpersonationToken != null) {
                    sec.ImpersonationToken.destroy();
                }
            }
            catch (EngineRuntimeException ere) {
                if (ere.getExceptionCode() == ExceptionCode.SECURITY_INVALID_CREDENTIALS) break block3;
                throw ere;
            }
        }
        ClientOperation.setThreadCredential(null);
    }
}

