/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.MultipartOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class DimeOutputStream
extends MultipartOutputStream {
    private static final TransportLogger logger = TransportLogger.getLogger(DimeOutputStream.class, SubSystem.API);
    private static final String APPLICATION_DIME = "application/dime";
    public static final byte TYPE_T_UNCHANGED = 0;
    public static final byte TYPE_T_MEDIA_TYPE = 1;
    public static final byte TYPE_T_URI = 2;
    public static final byte TYPE_T_UNKNOWN = 3;
    public static final byte TYPE_T_NONE = 4;
    private final int fuzzyChunkSize;
    private final ByteArrayOutputStream baos;
    private final String contentIdZero;
    private int chunkCount = -1;
    private boolean didMessageEnd = false;
    private boolean messageBegin = true;
    private boolean messageEnd = false;
    private boolean recordBegin = true;
    private boolean recordEnd = false;
    private byte recordTypeType = 0;
    private String recordType = null;
    private String recordId = null;
    private static final byte[] PAD = new byte[]{0, 0, 0};

    public DimeOutputStream(OutputStream out, int fuzzyChunkSize, String contentIdZero) {
        super(out);
        this.fuzzyChunkSize = fuzzyChunkSize;
        this.baos = new ByteArrayOutputStream(this.fuzzyChunkSize);
        this.contentIdZero = contentIdZero;
    }

    public void close() throws IOException {
        this.messageEnd = true;
        if (!this.didMessageEnd && this.baos.size() > 0) {
            this.doChunk(null, 0, 0);
        }
        this.out.close();
    }

    public void flush() {
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.timeToChunk(len)) {
            this.doChunk(b, off, len);
        } else {
            this.baos.write(b, off, len);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        if (this.timeToChunk(1)) {
            this.doChunk(b);
        } else {
            this.baos.write(b);
        }
    }

    public void startRecord(String recId, byte recTypeType, String recType) {
        this.recordBegin = true;
        this.recordEnd = false;
        this.recordId = recId;
        this.recordTypeType = recTypeType;
        this.recordType = recType;
    }

    public void endRecord(boolean endMessage) throws IOException {
        this.recordEnd = true;
        this.messageEnd = endMessage;
        this.doChunk(null, 0, 0);
    }

    public void startRootPart() {
        this.startRecord(this.contentIdZero, (byte)2, "http://schemas.xmlsoap.org/soap/envelope/");
    }

    public void endRootPart(boolean attachmentsFollow) throws IOException {
        this.endRecord(!attachmentsFollow);
    }

    public void startAttachment(String contentId) {
        this.startRecord("cid:" + contentId, (byte)1, "application/octet-stream");
    }

    public void endAttachment(boolean attachmentsFollow) throws IOException {
        this.endRecord(!attachmentsFollow);
    }

    public String getRequestContentType() {
        return APPLICATION_DIME;
    }

    public String getResponseContentType() {
        return APPLICATION_DIME;
    }

    private boolean timeToChunk(int howMuchMore) {
        return this.baos.size() + howMuchMore >= this.fuzzyChunkSize;
    }

    private void doChunk(byte[] b, int off, int len) throws IOException {
        byte[] already = this.baos.toByteArray();
        this.baos.reset();
        int howMany = already.length + len;
        this.sayDimeChunkHeader(howMany);
        this.out.write(already, 0, already.length);
        if (b != null) {
            this.out.write(b, off, len);
        }
        int dataPad = 4 - howMany % 4;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "A dataPad " + dataPad);
        }
        if (dataPad > 0 && dataPad < 4) {
            this.out.write(PAD, 0, dataPad);
        }
    }

    private void doChunk(int b) throws IOException {
        byte[] already = this.baos.toByteArray();
        this.baos.reset();
        int howMany = already.length + 1;
        this.sayDimeChunkHeader(howMany);
        this.out.write(already, 0, already.length);
        this.out.write(b & 0xFF);
        int dataPad = 4 - howMany % 4;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "B dataPad " + dataPad);
        }
        if (dataPad > 0 && dataPad < 4) {
            this.out.write(PAD, 0, dataPad);
        }
    }

    private void sayDimeChunkHeader(int dataLength) throws IOException {
        boolean cf;
        boolean mb = this.messageBegin;
        boolean me = this.messageEnd;
        boolean bl = cf = !this.recordEnd;
        if (!this.recordBegin) {
            this.recordTypeType = 0;
        }
        byte[] idBytes = this.recordId == null ? null : this.recordId.getBytes();
        byte[] typeBytes = this.recordType == null ? null : this.recordType.getBytes();
        this.sayRawDimeChunkHeader(dataLength, mb, me, cf, idBytes, this.recordTypeType, typeBytes);
        this.messageBegin = false;
        this.recordBegin = false;
        this.recordEnd = false;
        this.recordId = null;
        this.recordType = null;
        if (me) {
            this.didMessageEnd = true;
        }
    }

    private void sayRawDimeChunkHeader(int dataLength, boolean mb, boolean me, boolean cf, byte[] idBytes, byte typeType, byte[] typeBytes) throws IOException {
        ++this.chunkCount;
        int byteFlagsHI = 8;
        if (mb) {
            byteFlagsHI = (byte)(byteFlagsHI | 4);
        }
        if (me) {
            byteFlagsHI = (byte)(byteFlagsHI | 2);
        }
        if (cf) {
            byteFlagsHI = (byte)(byteFlagsHI | 1);
        }
        byte byteFlagsLO = (byte)(typeType << 4);
        this.out.write(byteFlagsHI);
        this.out.write(byteFlagsLO);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "chunk flags 0x" + Integer.toHexString(byteFlagsHI) + " 0x" + Integer.toHexString(byteFlagsLO));
        }
        int byteOptLenHI = 0;
        int byteOptLenLO = 0;
        this.out.write(byteOptLenHI);
        this.out.write(byteOptLenLO);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "0 optionsLength 0x" + Integer.toHexString(byteOptLenHI) + " 0x" + Integer.toHexString(byteOptLenLO));
        }
        int byteIdLenHI = 0;
        int byteIdLenLO = 0;
        if (idBytes != null) {
            int idLen = idBytes.length;
            byteIdLenHI = (byte)(idLen >> 8 & 0xFF);
            byteIdLenLO = (byte)(idLen & 0xFF);
        }
        this.out.write(byteIdLenHI);
        this.out.write(byteIdLenLO);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + (idBytes == null ? 0 : idBytes.length) + " idLength 0x" + Integer.toHexString(byteIdLenHI) + " 0x" + Integer.toHexString(byteIdLenLO));
        }
        int byteTypeLenHI = 0;
        int byteTypeLenLO = 0;
        if (typeBytes != null) {
            int typeLen = typeBytes.length;
            byteTypeLenHI = (byte)(typeLen >> 8 & 0xFF);
            byteTypeLenLO = (byte)(typeLen & 0xFF);
        }
        this.out.write(byteTypeLenHI);
        this.out.write(byteTypeLenLO);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + (typeBytes == null ? 0 : typeBytes.length) + " typeLength 0x" + Integer.toHexString(byteTypeLenHI) + " 0x" + Integer.toHexString(byteTypeLenLO));
        }
        byte byteDataLenHI = (byte)(dataLength >> 24 & 0xFF);
        byte byteDataLenHM = (byte)(dataLength >> 16 & 0xFF);
        byte byteDataLenML = (byte)(dataLength >> 8 & 0xFF);
        byte byteDataLenLO = (byte)(dataLength & 0xFF);
        this.out.write(byteDataLenHI);
        this.out.write(byteDataLenHM);
        this.out.write(byteDataLenML);
        this.out.write(byteDataLenLO);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + dataLength + " dataLength 0x" + Integer.toHexString(byteDataLenHI) + " 0x" + Integer.toHexString(byteDataLenHM) + " 0x" + Integer.toHexString(byteDataLenML) + " 0x" + Integer.toHexString(byteDataLenLO));
        }
        if (idBytes != null && idBytes.length > 0) {
            this.out.write(idBytes);
            int idPad = 4 - idBytes.length % 4;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail(this.logTag() + "idPad " + idPad);
            }
            if (idPad > 0 && idPad < 4) {
                this.out.write(PAD, 0, idPad);
            }
        }
        if (typeBytes != null && typeBytes.length > 0) {
            this.out.write(typeBytes);
            int typePad = 4 - typeBytes.length % 4;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail(this.logTag() + "typePad " + typePad);
            }
            if (typePad > 0 && typePad < 4) {
                this.out.write(PAD, 0, typePad);
            }
        }
    }

    private String logTag() {
        String thread = Thread.currentThread().getName();
        String hash = Integer.toHexString(System.identityHashCode(this));
        return "@oDime@0x" + hash + "@" + thread + "@" + this.chunkCount + "@ ";
    }
}

