/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.MultipartInputStreamManager;
import com.filenet.apiimpl.util.SpillStreamFactory;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.serialization.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

class DimeInputStreamManager
extends MultipartInputStreamManager {
    private static final TransportLogger logger = TransportLogger.getLogger(DimeInputStreamManager.class, SubSystem.API);
    private final PushbackInputStream masterInputStream;
    private int currentChunkFlags = 0;
    private int chunkDataBytesRemaining = 0;
    private int dataPadBytes = 0;
    private String contentId = null;
    private boolean masterEOF = false;
    private int chunkCount = -1;

    public DimeInputStreamManager(InputStream masterInputStream, SpillStreamFactory ssF) {
        super(null, ssF);
        this.masterInputStream = new PushbackInputStream(masterInputStream);
    }

    private final void readNextDimeChunkHeader() throws IOException {
        ++this.chunkCount;
        byte[] dimeChunkHeader = new byte[12];
        this.currentChunkFlags = 0;
        this.chunkDataBytesRemaining = 0;
        for (int ii = 0; ii < dimeChunkHeader.length; ++ii) {
            int b = this.masterInputStream.read();
            if (b < 0) {
                this.masterEOF = true;
                if (ii == 0) {
                    return;
                }
                throw Util.prematureEOF();
            }
            dimeChunkHeader[ii] = (byte)(b & 0xFF);
        }
        String dimeChunkHeaderSt = "";
        for (int ii = 0; ii < dimeChunkHeader.length; ++ii) {
            byte b = dimeChunkHeader[ii];
            dimeChunkHeaderSt = dimeChunkHeaderSt + b + " ";
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "chunk header bytes " + dimeChunkHeaderSt);
        }
        this.currentChunkFlags = 0xFF & dimeChunkHeader[0];
        int optL1 = 0xFF & dimeChunkHeader[2];
        int optL2 = 0xFF & dimeChunkHeader[3];
        int optionsLength = optL1 << 8 | optL2;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "optionsLength " + optionsLength);
        }
        for (int ii = 0; ii < optionsLength; ++ii) {
            int b = this.masterInputStream.read();
            if (b >= 0) continue;
            this.masterEOF = true;
            throw Util.prematureEOF();
        }
        int optionsPad = DimeInputStreamManager.padNeeded(optionsLength);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "optionsPad " + optionsPad);
        }
        for (int ii = 0; ii < optionsPad; ++ii) {
            int b = this.masterInputStream.read();
            if (b >= 0) continue;
            this.masterEOF = true;
            throw Util.prematureEOF();
        }
        int idL1 = 0xFF & dimeChunkHeader[4];
        int idL2 = 0xFF & dimeChunkHeader[5];
        int idLength = idL1 << 8 | idL2;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "idLength " + idLength);
        }
        byte[] idBytes = new byte[idLength];
        for (int ii = 0; ii < idLength; ++ii) {
            int b = this.masterInputStream.read();
            if (b < 0) {
                this.masterEOF = true;
                throw Util.prematureEOF();
            }
            idBytes[ii] = (byte)(b & 0xFF);
        }
        this.contentId = new String(idBytes);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "contentId " + this.contentId);
        }
        int idPad = DimeInputStreamManager.padNeeded(idLength);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "idPad " + idPad);
        }
        for (int ii = 0; ii < idPad; ++ii) {
            int b = this.masterInputStream.read();
            if (b >= 0) continue;
            this.masterEOF = true;
            throw Util.prematureEOF();
        }
        int typeL1 = 0xFF & dimeChunkHeader[6];
        int typeL2 = 0xFF & dimeChunkHeader[7];
        int typeLength = typeL1 << 8 | typeL2;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "typeLength " + typeLength);
        }
        for (int ii = 0; ii < typeLength; ++ii) {
            int b = this.masterInputStream.read();
            if (b >= 0) continue;
            this.masterEOF = true;
            throw Util.prematureEOF();
        }
        int typePad = DimeInputStreamManager.padNeeded(typeLength);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "typePad " + typePad);
        }
        for (int ii = 0; ii < typePad; ++ii) {
            int b = this.masterInputStream.read();
            if (b >= 0) continue;
            this.masterEOF = true;
            throw Util.prematureEOF();
        }
        int dataL1 = 0xFF & dimeChunkHeader[8];
        int dataL2 = 0xFF & dimeChunkHeader[9];
        int dataL3 = 0xFF & dimeChunkHeader[10];
        int dataL4 = 0xFF & dimeChunkHeader[11];
        this.chunkDataBytesRemaining = dataL1 << 24 | dataL2 << 16 | dataL3 << 8 | dataL4;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "dataLength " + this.chunkDataBytesRemaining);
        }
        this.dataPadBytes = DimeInputStreamManager.padNeeded(this.chunkDataBytesRemaining);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "dataPad " + this.dataPadBytes);
        }
    }

    private void consumeDataPadBytes() throws IOException {
        while (this.dataPadBytes > 0) {
            int b = this.masterInputStream.read();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail(this.logTag() + "dataPad byte value " + b);
            }
            if (b < 0) {
                this.masterEOF = true;
                throw Util.prematureEOF();
            }
            --this.dataPadBytes;
        }
    }

    private boolean isFinalChunkOfRecord() {
        int chunkFlag = this.currentChunkFlags & 1;
        return chunkFlag == 0;
    }

    private static int padNeeded(int count) {
        int remainder = count % 4;
        int pad = 4 - remainder;
        if (pad == 4) {
            pad = 0;
        }
        return pad;
    }

    protected int availableRightNow() {
        int masterAvail;
        try {
            masterAvail = this.masterInputStream.available();
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail(this.logTag() + "Master avail " + masterAvail);
            }
            if (masterAvail < 0) {
                if (!this.isManagedInputStreamAtLogicalEOF()) {
                    this.masterEOF = true;
                    throw Util.prematureEOF();
                }
                this.masterEOF = true;
                return 0;
            }
            if (masterAvail == 0) {
                int oneByte;
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail(this.logTag() + "Master avail blocked;  chunk avail " + this.chunkDataBytesRemaining);
                }
                if ((oneByte = this.masterInputStream.read()) == -1) {
                    if (!this.isManagedInputStreamAtLogicalEOF()) {
                        this.masterEOF = true;
                        throw Util.prematureEOF();
                    }
                    this.masterEOF = true;
                    return 0;
                }
                this.masterInputStream.unread(oneByte);
                masterAvail = this.masterInputStream.available();
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail(this.logTag() + "Master pushback avail " + masterAvail);
                }
                if (masterAvail <= 0) {
                    masterAvail = 1;
                }
            }
        }
        catch (IOException e) {
            masterAvail = 0;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "Master avail " + masterAvail + ";  chunk avail " + this.chunkDataBytesRemaining);
        }
        return Math.min(masterAvail, this.chunkDataBytesRemaining);
    }

    protected int eatBytesFromBuffer(byte[] bucket, int destOffset, int howManyToEat) throws IOException {
        int count = this.masterInputStream.read(bucket, destOffset, howManyToEat);
        if (count < 0) {
            throw Util.prematureEOF();
        }
        this.chunkDataBytesRemaining -= count;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail(this.logTag() + "eat " + count + ";  leaving " + this.chunkDataBytesRemaining);
        }
        if (this.chunkDataBytesRemaining <= 0) {
            this.consumeDataPadBytes();
        }
        return count;
    }

    protected MultipartInputStreamManager.ManagedInputStream getNextContentInputStream() throws IOException {
        this.readNextDimeChunkHeader();
        if (this.masterEOF) {
            return null;
        }
        return (MultipartInputStreamManager.ManagedInputStream)this.instantiateContentInputStream(this.contentId);
    }

    protected boolean isManagedInputStreamAtLogicalEOF() {
        if (this.chunkDataBytesRemaining > 0) {
            return false;
        }
        if (this.masterEOF) {
            return true;
        }
        return this.isFinalChunkOfRecord();
    }

    protected void makeSomethingAvailable() throws IOException {
        if (this.chunkDataBytesRemaining > 0) {
            return;
        }
        if (this.isFinalChunkOfRecord()) {
            return;
        }
        this.readNextDimeChunkHeader();
    }

    private String logTag() {
        String thread = Thread.currentThread().getName();
        String hash = Integer.toHexString(System.identityHashCode(this));
        return "@iDime@0x" + hash + "@" + thread + "@" + this.chunkCount + "@ ";
    }
}

