/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.Message;
import com.filenet.apiimpl.transport.Request;
import com.filenet.apiimpl.transport.Response;
import com.filenet.apiimpl.transport.TransportLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SessionContext;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.ApiContext;
import com.filenet.apiimpl.wsi.ClientBinding;
import com.filenet.apiimpl.wsi.ClientInfo;
import com.filenet.apiimpl.wsi.Localization;
import com.filenet.apiimpl.wsi.Security;
import com.filenet.apiimpl.wsi.ServiceSessionWsi;
import com.filenet.apiimpl.wsi.WSICredential;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.security.auth.Subject;

public abstract class ClientOperation {
    private final ServiceSessionWsi session;
    private final String operation;
    private final ConnectionImpl connection;
    private final ClientCallContext context;
    private final Request request;
    private Response response;
    private Throwable exception;
    private SessionContext savedSessionContext;
    private static ThreadLocal overrideCredential = new ThreadLocal();
    private static final TransportLogger logger = TransportLogger.getLogger(ClientOperation.class, SubSystem.WSI);
    private static String DEFAULT_BUILD = ConfigValueLookup.getValue("BuildVersion", "unknown").trim();

    protected ClientOperation(ServiceSessionWsi session, String operation, ConnectionImpl connection, Request request, ClientCallContext context) {
        this.session = session;
        this.operation = operation;
        this.connection = connection;
        this.request = request;
        this.context = context;
    }

    protected abstract Response execute() throws Exception;

    public static void setThreadCredential(WSICredential credential) {
        overrideCredential.set(credential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response run() {
        EngineRuntimeException excep;
        this.init();
        try {
            this.start();
            this.response = this.execute();
        }
        catch (Throwable e) {
            this.error(e);
        }
        finally {
            excep = this.finish();
        }
        if (excep == null) {
            return this.response;
        }
        throw excep;
    }

    private void init() {
        this.savedSessionContext = SessionContext.getSessionContext();
        this.exception = null;
    }

    private void start() throws Exception {
        this.traceRequest();
        ClientOperation.setSessionContext(this.session, this.connection, this.request);
        this.setCallContext(this.session, this.connection, this.context);
    }

    private EngineRuntimeException finish() {
        SessionContext.setSessionContext(this.savedSessionContext);
        EngineRuntimeException excep = ClientOperation.evaluate(this.exception);
        this.traceResponse(excep);
        return excep;
    }

    protected void error(Throwable excep) {
        if (excep == null || this.exception == null) {
            this.exception = excep;
        }
    }

    private static EngineRuntimeException evaluate(Throwable e) {
        if (e == null) {
            return null;
        }
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof EngineRuntimeException)) continue;
            e = cause;
        }
        if (e instanceof EngineRuntimeException) {
            return (EngineRuntimeException)e;
        }
        if (e instanceof Error) {
            return new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return new EngineRuntimeException(e, ExceptionCode.E_EXCEPTION_RETRY, null);
    }

    private void traceRequest() throws Exception {
        if (!logger.isCallTraceEnabled()) {
            return;
        }
        if (this.request instanceof Message) {
            logger.traceRequest(this.context, this.operation, (Message)((Object)this.request));
        }
    }

    private void traceResponse(EngineRuntimeException excep) {
        if (excep != null) {
            logger.traceException(this.context, this.operation, excep, System.currentTimeMillis());
        } else if (this.response instanceof Message) {
            logger.traceResponse(this.context, this.operation, (Message)((Object)this.response), System.currentTimeMillis());
        }
    }

    private static void setSessionContext(ServiceSessionWsi session, Connection connection, Request request) {
        SessionContext.setSessionContext(new SessionContext(connection));
        ClientBinding binding = session.getBinding();
        ClientInfo.setBinding(binding.getType());
        ClientInfo.setVersion(binding.getVersion());
        ClientInfo.setRequest(request);
    }

    protected abstract void setCallContext(ServiceSessionWsi var1, ConnectionImpl var2, ClientCallContext var3);

    protected static void setCallContextHelper(Map contextData, ClientCallContext optionalCCC) {
        Security sec = ClientOperation.getSoapEnvelopeSecurity();
        Localization loc = ClientOperation.getSoapEnvelopeLocalization(optionalCCC);
        ApiContext ctx = ClientOperation.getSoapEnvelopeApiContext(optionalCCC);
        contextData.put("Security", sec);
        contextData.put("Localization", loc);
        contextData.put("ApiContext", ctx);
        contextData.put("WSDL_VERSION", SessionContext.getRuntimeValues().get("WSDL_VERSION"));
    }

    public static Localization getSoapEnvelopeLocalization(ClientCallContext optionalCCC) {
        Localization loc = new Localization();
        if (optionalCCC != null && optionalCCC.getParam("loc") instanceof String) {
            loc.Locale = (String)((Object)optionalCCC.getParam("loc"));
        } else {
            UserContext uc = UserContext.get();
            loc.Locale = uc.getLocale().getLanguage() + "-" + uc.getLocale().getCountry();
        }
        int tzOffset = TimeZone.getDefault().getOffset(System.currentTimeMillis());
        String sign = "+";
        if (tzOffset < 0) {
            sign = "-";
            tzOffset = -tzOffset;
        }
        DecimalFormat twoDigits = new DecimalFormat("00");
        loc.Timezone = sign + twoDigits.format(tzOffset / 3600000) + ":" + twoDigits.format(tzOffset % 3600000);
        return loc;
    }

    public static ApiContext getSoapEnvelopeApiContext(ClientCallContext optionalCCC) {
        ApiContext ctx = new ApiContext();
        ctx.type = "Java";
        if (optionalCCC != null) {
            ctx.version = optionalCCC.getClientVersion();
            ctx.build = (String)((Object)optionalCCC.getParam("clibuild"));
            ctx.threadId = (String)((Object)optionalCCC.getParam("ctid"));
        }
        if (ctx.version == null) {
            ctx.version = 500;
        }
        if (ctx.threadId == null) {
            ctx.threadId = String.valueOf(System.identityHashCode(Thread.currentThread()));
        }
        if (ctx.build == null) {
            ctx.build = DEFAULT_BUILD;
        }
        return ctx;
    }

    public static Security getSoapEnvelopeSecurity() {
        WSICredential credential = ClientOperation.getCredential();
        Security sec = credential.getSecurityToken();
        return sec;
    }

    protected static WSICredential getCredential() {
        WSICredential cred = (WSICredential)overrideCredential.get();
        if (cred != null) {
            return cred;
        }
        boolean isFromUserContext = false;
        Subject sub = UserContext.get().getSubject();
        if (sub == null) {
            sub = J2EEUtil.getInstance().getCurrentSubject();
        } else {
            isFromUserContext = true;
        }
        if (sub == null) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, (Object[])null, ExceptionContext.SECURITY_NO_SECURITY_CONTEXT, null);
        }
        Set creds = null;
        try {
            creds = ClientOperation.cDoPrivilegedGetPrivateCredentials(sub);
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.SECURITY_INVALID_CREDENTIALS, null, ExceptionContext.SECURITY_CANNOT_RETRIEVE_CREDENTIALS, null);
        }
        if (creds == null) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, (Object[])null, ExceptionContext.SECURITY_MISSING_CREDENTIALS, null);
        }
        Iterator iter = creds.iterator();
        if (iter == null || !iter.hasNext()) {
            throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, (Object[])null, ExceptionContext.SECURITY_MISSING_CREDENTIALS, null);
        }
        WSICredential ret = (WSICredential)iter.next();
        if (logger.isDetailTraceEnabled()) {
            if (isFromUserContext) {
                logger.traceDetail("Using Principal<" + ClientOperation.getPrincipal(ret) + "> from UserContext");
            } else {
                logger.traceDetail("Using Principal<" + ClientOperation.getPrincipal(ret) + "> from ambient context");
            }
        }
        return ret;
    }

    private static final Set cDoPrivilegedGetPrivateCredentials(final Subject sub) throws Throwable {
        PrivilegedExceptionAction paProp = new PrivilegedExceptionAction(){

            public Object run() throws ClassNotFoundException {
                return sub.getPrivateCredentials(Class.forName("com.filenet.apiimpl.wsi.WSICredential"));
            }
        };
        try {
            return (Set)AccessController.doPrivileged(paProp);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    private static String getPrincipal(WSICredential cred) {
        if (cred == null || cred.getSecurityToken() == null || cred.getSecurityToken().UsernameToken == null || cred.getSecurityToken().UsernameToken.Username == null) {
            return "";
        }
        return cred.getSecurityToken().UsernameToken.Username;
    }

    protected static int getConnectionTimeout(Connection conn) {
        Object rawValue = conn.getParameter(ConfigurationParameter.WSI_TRANSPORT_CONNECTION_TIMEOUT);
        if (rawValue == null) {
            rawValue = ConfigValueLookup.getValue("FileNet.WSI.TransportConnectionTimeout", null);
        }
        if (rawValue == null) {
            return ConfigValueLookup.getInt(ConfigurationParameter.WSI_TRANSPORT_CONNECTION_TIMEOUT, Integer.MAX_VALUE);
        }
        if (rawValue instanceof String) {
            return Integer.parseInt((String)rawValue);
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        return Integer.MAX_VALUE;
    }
}

