/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.wsi;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.wsi.ClientInfo;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

final class ClientBinding {
    private int type;
    private int version;
    private String wsdlPath;
    private String portName;
    private QName serviceName;
    private QName[] understoodHeaders;
    private static final String SERVICE_NAME40 = "FNCEWS40Service";
    private static final QName[] UNDERSTOOD_HEADERS40 = new QName[]{new QName("http://www.filenet.com/ns/fnce/2006/11/ws/schema", "Security"), new QName("http://www.filenet.com/ns/fnce/2006/11/ws/schema", "Localization")};
    private static final Map bindings = new HashMap();

    ClientBinding() {
    }

    public int getType() {
        return this.type;
    }

    public int getVersion() {
        return this.version;
    }

    public String getWsdlPath() {
        return this.wsdlPath;
    }

    public String getPortName() {
        return this.portName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public QName[] getUnderstoodHeaders() {
        return this.understoodHeaders;
    }

    public static ClientBinding getBinding(String uri) {
        Integer version;
        Integer type = ClientInfo.determineBinding(uri);
        ClientBinding binding = (ClientBinding)bindings.get(new Key(type, version = ClientInfo.determineWsdlVersion(uri)));
        if (binding == null) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_URI, new Object[]{uri});
        }
        return binding;
    }

    static {
        ClientBinding binding = new ClientBinding();
        binding.type = 1;
        binding.version = 400;
        binding.wsdlPath = "wsdl/FNCEWS40DIME.wsdl";
        binding.portName = "FNCEWS40DimePort";
        binding.serviceName = new QName("http://www.filenet.com/ns/fnce/2006/11/ws/DIME/wsdl", SERVICE_NAME40);
        binding.understoodHeaders = UNDERSTOOD_HEADERS40;
        bindings.put(new Key(binding.type, binding.version), binding);
        binding = new ClientBinding();
        binding.type = 3;
        binding.version = 400;
        binding.wsdlPath = "wsdl/FNCEWS40SOAP.wsdl";
        binding.portName = "FNCEWS40InlinePort";
        binding.serviceName = new QName("http://www.filenet.com/ns/fnce/2006/11/ws/SOAP/wsdl", SERVICE_NAME40);
        binding.understoodHeaders = UNDERSTOOD_HEADERS40;
        bindings.put(new Key(binding.type, binding.version), binding);
        binding = new ClientBinding();
        binding.type = 4;
        binding.version = 400;
        binding.wsdlPath = "wsdl/FNCEWS40MTOM.wsdl";
        binding.portName = "FNCEWS40MTOMPort";
        binding.serviceName = new QName("http://www.filenet.com/ns/fnce/2006/11/ws/MTOM/wsdl", SERVICE_NAME40);
        binding.understoodHeaders = UNDERSTOOD_HEADERS40;
        bindings.put(new Key(binding.type, binding.version), binding);
        binding = new ClientBinding();
        binding.type = 1;
        binding.version = 350;
        binding.wsdlPath = "FNCEWS35DIME.wsdl";
        binding.portName = "FNCEWS35DimePort";
        binding.serviceName = new QName("http://www.filenet.com/ns/fnce/2005/02/ws/DIME/wsdl", "FNCEWS35Service");
        binding.understoodHeaders = UNDERSTOOD_HEADERS40;
        bindings.put(new Key(binding.type, binding.version), binding);
        binding = new ClientBinding();
        binding.type = 3;
        binding.version = 350;
        binding.wsdlPath = "FNCEWS35SOAP.wsdl";
        binding.portName = "FNCEWS35InlinePort";
        binding.serviceName = new QName("http://www.filenet.com/ns/fnce/2005/02/ws/SOAP/wsdl", "FNCEWS35Service");
        binding.understoodHeaders = UNDERSTOOD_HEADERS40;
        bindings.put(new Key(binding.type, binding.version), binding);
    }

    private static final class Key {
        private final int type;
        private final int version;

        public Key(int type, int version) {
            this.type = type;
            this.version = version;
        }

        public Key(Integer type, Integer version) {
            this.type = type == null ? -1 : type;
            this.version = version == null ? -1 : version;
        }

        public boolean equals(Object o) {
            Key other = (Key)o;
            return other.type == this.type && other.version == this.version;
        }

        public int hashCode() {
            return this.type + this.version;
        }
    }
}

