/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.core.ListImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.property.UnevaluatedPropertyValue;
import com.filenet.apiimpl.util.XMLTraceReader;
import java.lang.reflect.Field;
import java.util.HashMap;

public class XMLTraceReaderBasic
extends XMLTraceReader {
    private HashMap attributeExclusion = new HashMap();
    private static HashMap attributeValueExclusion = new HashMap();
    private static HashMap fieldInclusions = new HashMap();
    private static String[] listImplInclusionList = new String[]{"currentList"};
    private static String LISTIMPL = "com.filenet.apiimpl.core.ListImpl";

    public XMLTraceReaderBasic() {
        this.attributeExclusion.put("rid", "rid");
        this.attributeExclusion.put("dirty", "dirty");
        this.attributeExclusion.put("access", "access");
        this.attributeExclusion.put("stale", "stale");
        this.attributeExclusion.put("classType", "classType");
    }

    public void visitValue(String element, Object object) throws Exception {
        super.visitValue(element, object);
    }

    public void visitObject(String element, Object object) throws Exception {
        if (object instanceof Connection) {
            return;
        }
        if (this.isRIDObject(object)) {
            this.attributeExclusion.remove("rid");
        }
        super.visitObject(element, object);
        if (this.isRIDObject(object)) {
            this.attributeExclusion.put("rid", "rid");
        }
    }

    public void addAttribute(String name, String value) throws Exception {
        if (this.isAttributeIncluded(name, value)) {
            super.addAttribute(name, value);
        }
    }

    public void visitField(Object object, Field field) throws Exception {
        if (this.isFieldIncluded(object, field)) {
            super.visitField(object, field);
        }
    }

    private boolean isRIDObject(Object o) {
        if (o instanceof UnevaluatedPropertyValue) {
            return false;
        }
        return o instanceof ObjectReferenceBase;
    }

    private boolean isAttributeIncluded(String name, String value) {
        String valueExclusion;
        if (value != null && (valueExclusion = (String)attributeValueExclusion.get(name + "." + value)) != null) {
            return false;
        }
        return this.attributeExclusion.get(name) == null;
    }

    private boolean isFieldIncluded(Object object, Field field) {
        String objectName = this.getObjectName(object);
        String fieldName = field.getName();
        String[] includeList = (String[])fieldInclusions.get(objectName);
        if (includeList == null) {
            return true;
        }
        for (int lp = 0; lp < includeList.length; ++lp) {
            if (!includeList[lp].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    private String getObjectName(Object obj) {
        if (obj instanceof ListImpl) {
            return LISTIMPL;
        }
        return obj.getClass().getName();
    }

    static {
        attributeValueExclusion.put("type.Id", "type.Id");
        attributeValueExclusion.put("type.IdList", "type.IdList");
        attributeValueExclusion.put("type.PropertyId", "type.PropertyId");
        attributeValueExclusion.put("type.PropertyIdList", "type.PropertyIdList");
        attributeValueExclusion.put("type.PropertyInteger32", "type.PropertyInteger32");
        attributeValueExclusion.put("type.PropertyInteger32List", "type.PropertyInteger32List");
        attributeValueExclusion.put("type.PropertyString", "type.PropertyString");
        attributeValueExclusion.put("type.PropertyStringList", "type.PropertyStringList");
        attributeValueExclusion.put("type.PropertyEngineObject", "type.PropertyEngineObject");
        attributeValueExclusion.put("type.PropertyEngineObjectSet", "type.PropertyEngineObjectSet");
        attributeValueExclusion.put("type.PropertyEngineObjectList", "type.PropertyEngineObjectList");
        attributeValueExclusion.put("type.PropertyDateTime", "type.PropertyDateTime");
        attributeValueExclusion.put("type.PropertyDateTimeList", "type.PropertyDateTimeList");
        attributeValueExclusion.put("type.PropertyBoolean", "type.PropertyBoolean");
        attributeValueExclusion.put("type.PropertyBooleanList", "type.PropertyBooleanList");
        attributeValueExclusion.put("type.PropertyBinary", "type.PropertyBinary");
        attributeValueExclusion.put("type.PropertyBinaryList", "type.PropertyBinaryList");
        attributeValueExclusion.put("type.PropertyFloat64", "type.PropertyFloat64");
        attributeValueExclusion.put("type.PropertyFloat64List", "type.PropertyFloat64List");
        fieldInclusions.put(LISTIMPL, listImplInclusionList);
    }
}

