/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.Base64;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.XMLHelper;
import com.filenet.apiimpl.util.XMLObjectReader;
import com.filenet.apiimpl.util.XMLTraceable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class XMLTraceReader
extends XMLObjectReader {
    protected int maxChars;
    protected int maxBytes;
    protected int byteRadix;
    protected boolean visitAttributeFields;
    protected Map traceMethods = new IdentityHashMap();
    protected static final int DEFAULT_MAX_CHARS = 128;
    protected static final int DEFAULT_MAX_BYTES = 8;
    protected static final int DEFAULT_BYTE_RADIX = 16;
    protected static final char[] digits = "0123456789abcdef".toCharArray();
    protected static final String TRACE_METHOD_NAME = "trace";
    protected static final Class[] TRACE_PARAMETER_TYPES = new Class[]{XMLTraceReader.class, String.class};
    protected static final String TRANSPORT_CLASS_NAME_PREFIX = "com.filenet.apiimpl.transport.";
    protected static final Set attributeTypes = new HashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Class.class, Date.class, Id.class, URI.class));

    protected void init() {
        super.init();
        this.maxChars = ConfigValueLookup.getValueAsInt("TraceMaxChars", 128);
        this.maxBytes = ConfigValueLookup.getValueAsInt("TraceMaxBytes", 8);
        this.byteRadix = ConfigValueLookup.getValueAsInt("TraceByteRadix", 16);
        if (this.maxChars < 0) {
            this.maxChars = Integer.MAX_VALUE;
        }
        if (this.maxBytes < 0) {
            this.maxBytes = Integer.MAX_VALUE;
        }
    }

    public void visitValue(String element, Object object) throws Exception {
        if (object == null) {
            this.visitNull(element);
        } else if (object instanceof XMLTraceable) {
            ((XMLTraceable)object).trace(this, element);
        } else if (this.isInternalObject(object)) {
            Method method = this.getTraceMethod(object);
            if (method == null) {
                this.visitInternalValue(element, object);
            } else {
                method.invoke(object, this, element);
            }
        } else {
            this.visitExternalValue(element, object);
        }
    }

    protected Method getTraceMethod(Object object) throws Exception {
        Class<?> type = object.getClass();
        Object value = this.traceMethods.get(type);
        if (value == Boolean.FALSE) {
            return null;
        }
        if (value != null) {
            return (Method)value;
        }
        while (type != null && type != Object.class) {
            try {
                Method method = type.getDeclaredMethod(TRACE_METHOD_NAME, TRACE_PARAMETER_TYPES);
                method.setAccessible(true);
                this.traceMethods.put(type, method);
                return method;
            }
            catch (NoSuchMethodException e) {
                type = type.getSuperclass();
            }
        }
        this.traceMethods.put(type, Boolean.FALSE);
        return null;
    }

    public void visitNull(String element) throws Exception {
    }

    public void visitFields(String element, Object object) throws Exception {
        this.visitAttributeFields = true;
        this.visitFields(object, object.getClass());
        this.visitAttributeFields = false;
        super.visitFields(element, object);
    }

    public void visitField(Object object, Field field) throws Exception {
        String name = field.getName();
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            boolean attributeField = this.isAttributeName(name);
            if (this.visitAttributeFields && attributeField) {
                this.addAttribute(name, this.stringValue(field.get(object)));
            } else if (!this.visitAttributeFields && !attributeField) {
                this.visitPrimitiveField(object, field);
            }
        } else {
            Object value = field.get(object);
            boolean attributeField = this.isAttributeValue(name, value);
            if (this.visitAttributeFields && attributeField) {
                this.addAttribute(name, this.stringValue(value));
            } else if (!this.visitAttributeFields && !attributeField) {
                this.visitObject(name, value);
            }
        }
    }

    public Map filterValues(Map values, Map aliases) throws Exception {
        if (values == null || values.size() == 0) {
            return null;
        }
        HashMap result = new HashMap();
        for (Map.Entry entry : values.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            Object alias = aliases.get(key);
            if (alias != null) {
                key = alias;
            }
            result.put(key, value);
        }
        return result.size() == 0 ? null : result;
    }

    public void addAttributes(Map values) throws Exception {
        if (values == null || values.size() == 0) {
            return;
        }
        for (Map.Entry entry : values.entrySet()) {
            Object value;
            Object key = entry.getKey();
            if (!this.isAttributeValue(key, value = entry.getValue())) continue;
            this.addAttribute((String)key, this.stringValue(value));
        }
    }

    public void visitElements(Map values) throws Exception {
        if (values == null || values.size() == 0) {
            return;
        }
        for (Map.Entry entry : values.entrySet()) {
            boolean attributeName;
            Object key = entry.getKey();
            Object value = entry.getValue();
            String name = key instanceof String ? (String)key : null;
            boolean bl = attributeName = name != null && this.isAttributeName(name);
            if (attributeName && value != null && this.isAttributeType(value.getClass())) continue;
            if (attributeName) {
                this.visitObject(name, value);
                continue;
            }
            this.startElement("entry");
            this.visitObject("key", key);
            this.visitObject("value", value);
            this.endElement("entry");
        }
    }

    public boolean isAttributeName(String name) throws Exception {
        return XMLHelper.isUnicodeIdentifier(name);
    }

    public boolean isAttributeType(Class type) throws Exception {
        return attributeTypes.contains(type);
    }

    public boolean isAttributeType(String name, Class type) throws Exception {
        return this.isAttributeName(name) && this.isAttributeType(type);
    }

    public boolean isAttributeValue(Object name, Object value) throws Exception {
        if (!(name instanceof String) || value == null) {
            return false;
        }
        return this.isAttributeName((String)name) && this.isAttributeType(value.getClass());
    }

    public void visitByteArray(String element, byte[] array) throws Exception {
        boolean truncated;
        String content = "";
        int count = Math.min(array.length, this.maxBytes);
        boolean bl = truncated = count < array.length;
        if (count > 0) {
            StringBuffer buffer;
            if (this.byteRadix == 8) {
                buffer = new StringBuffer(this.size(count, 4L, 3L));
                for (int i = 0; i < count; ++i) {
                    byte value = array[i];
                    buffer.append(digits[value >> 6 & 3]);
                    buffer.append(digits[value >> 3 & 7]);
                    buffer.append(digits[value & 7]);
                    buffer.append(' ');
                }
            } else if (this.byteRadix == 10) {
                buffer = new StringBuffer(this.size(count, 2L, 3L));
                for (int i = 0; i < count; ++i) {
                    buffer.append(array[i]).append(' ');
                }
            } else if (this.byteRadix == 16) {
                buffer = new StringBuffer(this.size(count, 3L, 3L));
                for (int i = 0; i < count; ++i) {
                    byte value = array[i];
                    buffer.append(digits[value >> 4 & 0xF]);
                    buffer.append(digits[value & 0xF]);
                    buffer.append(' ');
                }
            } else if (this.byteRadix == 64) {
                String encoded = Base64.encode(array, 0, count);
                buffer = new StringBuffer(this.size(encoded.length(), 1L, 4L));
                buffer.append(encoded).append(' ');
            } else {
                buffer = new StringBuffer(this.size(count, 2L, 3L));
                for (int i = 0; i < count; ++i) {
                    buffer.append(Integer.toString(array[i], this.byteRadix)).append(' ');
                }
            }
            if (truncated) {
                buffer.append("...");
            } else {
                buffer.setLength(buffer.length() - 1);
            }
            content = buffer.toString();
        }
        this.startArray(element, array, array.length, truncated);
        this.characters(content);
        this.endArray(element);
    }

    public void visitCharArray(String element, char[] array) throws Exception {
        boolean truncated;
        int count = Math.min(array.length, this.maxChars);
        boolean bl = truncated = count < array.length;
        if (truncated) {
            char[] subset = new char[this.size(count, 1L, 3L)];
            System.arraycopy(array, 0, subset, 0, count);
            subset[count + 2] = 46;
            subset[count + 1] = 46;
            subset[count] = 46;
            array = subset;
        }
        this.startArray(element, array, array.length, truncated);
        this.characters(array);
        this.endArray(element);
    }

    public void visitString(String element, String object) throws Exception {
        boolean truncated;
        int length = object.length();
        boolean bl = truncated = length > this.maxChars;
        if (truncated) {
            StringBuffer buffer = new StringBuffer(this.size(this.maxChars, 1L, 3L));
            object = buffer.append(object.substring(0, this.maxChars)).append("...").toString();
        }
        if (truncated) {
            this.addAttribute("length", String.valueOf(length));
        }
        this.element(element, object);
    }

    public void startElement(String name, String type) throws Exception {
        if (type != null) {
            type = type.startsWith(TRANSPORT_CLASS_NAME_PREFIX) ? null : (type.startsWith("com.filenet.") ? this.typeName(type) : null);
        }
        super.startElement(name, type);
    }

    public String stringValue(Object value) throws Exception {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.formatDate((Date)value);
        }
        if (value instanceof Class) {
            return ((Class)value).getName();
        }
        if (value instanceof Object[]) {
            return this.stringArray((Object[])value);
        }
        return String.valueOf(value);
    }

    public String stringArray(Object[] values) throws Exception {
        if (values == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(32 * (values.length + 1));
        for (int i = 0; i < values.length; ++i) {
            buffer.append(this.stringValue(values[i])).append(' ');
        }
        buffer.setLength(Math.max(0, buffer.length() - 1));
        return buffer.toString();
    }

    public String objectType(Object value) throws Exception {
        return value == null ? null : this.typeName(value.getClass().getName());
    }

    public String typeName(String type) throws Exception {
        if (type == null) {
            return null;
        }
        int index = type.lastIndexOf(46);
        if (index != -1) {
            type = type.substring(index + 1);
        }
        if (type.endsWith("Impl")) {
            type = type.substring(0, type.length() - 4);
        }
        return type;
    }

    public Object[] emptyAsNull(Object[] values) {
        return values == null || values.length == 0 ? null : values;
    }

    public Collection emptyAsNull(Collection values) {
        return values == null || values.size() == 0 ? null : values;
    }

    public Map emptyAsNull(Map values) {
        return values == null || values.size() == 0 ? null : values;
    }

    public static Map getConstantAliases(final Class[] types, BaseLogger logger) {
        try {
            return (Map)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    HashMap aliases = new HashMap();
                    for (int i = 0; i < types.length; ++i) {
                        this.add(aliases, types[i]);
                    }
                    return aliases;
                }

                void add(Map aliases, Class type) throws Exception {
                    Field[] fields = type.getDeclaredFields();
                    for (int i = fields.length - 1; i >= 0; --i) {
                        String name;
                        Field field = fields[i];
                        field.setAccessible(true);
                        if (!Modifier.isStatic(field.getModifiers()) || field.getType() != String.class || !XMLHelper.isUnicodeIdentifier(name = field.getName())) continue;
                        StringBuffer buffer = new StringBuffer(name);
                        for (int pos = 0; pos < buffer.length(); ++pos) {
                            char ch = buffer.charAt(pos);
                            if (ch == '_') {
                                do {
                                    ch = '\u0000';
                                    buffer.deleteCharAt(pos);
                                    if (pos >= buffer.length()) continue;
                                    ch = buffer.charAt(pos);
                                    buffer.setCharAt(pos, Character.toUpperCase(ch));
                                } while (ch == '_');
                                continue;
                            }
                            buffer.setCharAt(pos, Character.toLowerCase(ch));
                        }
                        name = buffer.toString();
                        String value = (String)field.get(null);
                        aliases.put(value, name);
                    }
                }
            });
        }
        catch (Throwable e) {
            if (logger != null) {
                logger.error("Unexpected error initializing aliases", e);
            }
            return Collections.EMPTY_MAP;
        }
    }
}

