/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class UtilityMap {
    private int numBuckets;
    private int hashMask;
    private Entry[] buckets;
    private int entryCount = 0;
    private int expandThreshold;
    private int updateEpoch = 0;
    private float loadFactor;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;

    public UtilityMap() {
        this.numBuckets = 16;
        this.loadFactor = 0.75f;
        this.hashMask = this.numBuckets - 1;
        this.buckets = new Entry[this.numBuckets];
        this.expandThreshold = (int)((float)this.numBuckets * this.loadFactor);
    }

    public UtilityMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public UtilityMap(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.numBuckets = 1;
        while (this.numBuckets < initialCapacity) {
            this.numBuckets <<= 1;
        }
        this.hashMask = this.numBuckets - 1;
        this.buckets = new Entry[this.numBuckets];
        this.expandThreshold = (int)((float)this.numBuckets * loadFactor);
    }

    public Object putMember(SelfKeyedMember memb) {
        Object newKey = memb.getKey();
        int bucketIndex = this.getKeyHashCode(newKey) & this.hashMask;
        if (this.buckets[bucketIndex] == null) {
            this.buckets[bucketIndex] = memb;
        } else {
            Entry previous = null;
            for (Entry existing = this.buckets[bucketIndex]; existing != null; existing = existing.next()) {
                if (this.keysEqual(newKey, existing.getKey())) {
                    if (existing instanceof ChainedMember) {
                        ((ChainedMember)existing).member = memb;
                    } else {
                        if (existing instanceof ChainedKeyValue) {
                            throw new UnsupportedOperationException();
                        }
                        if (previous == null) {
                            this.buckets[bucketIndex] = memb;
                        } else {
                            ((ChainedEntry)((Object)previous)).nextInBucket = memb;
                        }
                    }
                    return existing.getValue();
                }
                previous = existing;
            }
            ChainedMember newMemb = new ChainedMember(memb);
            newMemb.nextInBucket = this.buckets[bucketIndex];
            this.buckets[bucketIndex] = newMemb;
        }
        ++this.entryCount;
        ++this.updateEpoch;
        if (this.entryCount > this.expandThreshold) {
            this.expandCapacity();
        }
        return null;
    }

    public Object put(Object key, Object value) {
        int bucketIndex = this.getKeyHashCode(key) & this.hashMask;
        if (this.buckets[bucketIndex] == null) {
            this.buckets[bucketIndex] = new ChainedKeyValue(key, value);
        } else {
            for (Entry existing = this.buckets[bucketIndex]; existing != null; existing = existing.next()) {
                if (!this.keysEqual(key, existing.getKey())) continue;
                if (existing instanceof ChainedKeyValue) {
                    Object prevValue = existing.getValue();
                    ((ChainedKeyValue)existing).value = value;
                    return prevValue;
                }
                throw new UnsupportedOperationException();
            }
            ChainedKeyValue newEntry = new ChainedKeyValue(key, value);
            newEntry.nextInBucket = this.buckets[bucketIndex];
            this.buckets[bucketIndex] = newEntry;
        }
        ++this.entryCount;
        ++this.updateEpoch;
        if (this.entryCount > this.expandThreshold) {
            this.expandCapacity();
        }
        return null;
    }

    public Object get(Object key) {
        for (Entry existing = this.buckets[this.getKeyHashCode(key) & this.hashMask]; existing != null; existing = existing.next()) {
            if (!this.keysEqual(existing.getKey(), key)) continue;
            return existing.getValue();
        }
        return null;
    }

    public Object removeMember(SelfKeyedMember memb) {
        return this.removeByKey(memb.getMembershipKey());
    }

    public Object remove(Object key) {
        return this.removeByKey(key);
    }

    public boolean containsMember(SelfKeyedMember memb) {
        return this.containsKey(memb.getMembershipKey());
    }

    public boolean containsKey(Object key) {
        int bucketIndex = this.getKeyHashCode(key) & this.hashMask;
        for (Entry existing = this.buckets[bucketIndex]; existing != null; existing = existing.next()) {
            if (!this.keysEqual(existing.getKey(), key)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.buckets = new Entry[this.numBuckets];
        this.entryCount = 0;
        ++this.updateEpoch;
    }

    public int size() {
        return this.entryCount;
    }

    public Iterator getEntries() {
        return new MapIterator();
    }

    protected int getKeyHashCode(Object key) {
        return key.hashCode();
    }

    protected boolean keysEqual(Object key1, Object key2) {
        return key1.equals(key2);
    }

    private Object removeByKey(Object key) {
        int bucketIndex = this.getKeyHashCode(key) & this.hashMask;
        Entry previous = null;
        for (Entry existing = this.buckets[bucketIndex]; existing != null; existing = existing.next()) {
            if (this.keysEqual(existing.getKey(), key)) {
                if (existing instanceof ChainedEntry) {
                    if (previous == null) {
                        this.buckets[bucketIndex] = ((ChainedEntry)((Object)existing)).nextInBucket;
                    } else {
                        ((ChainedEntry)((Object)previous)).nextInBucket = ((ChainedEntry)((Object)existing)).nextInBucket;
                    }
                } else if (previous == null) {
                    this.buckets[bucketIndex] = null;
                } else {
                    ((ChainedEntry)((Object)previous)).nextInBucket = null;
                }
                ++this.updateEpoch;
                --this.entryCount;
                return existing.getValue();
            }
            previous = existing;
        }
        return null;
    }

    private void expandCapacity() {
        int newNumBuckets = this.numBuckets << 1;
        int newHashMask = newNumBuckets - 1;
        Entry[] newBuckets = new Entry[newNumBuckets];
        block0: for (int bucketIndex = 0; bucketIndex < this.numBuckets; ++bucketIndex) {
            Entry existing = this.buckets[bucketIndex];
            while (existing != null) {
                Entry next;
                ChainedMember cm;
                int newBucketIndex = this.getKeyHashCode(existing.getKey()) & newHashMask;
                if (newBuckets[newBucketIndex] == null) {
                    if (existing instanceof SelfKeyedMember) {
                        newBuckets[newBucketIndex] = existing;
                        continue block0;
                    }
                    if (existing instanceof ChainedMember) {
                        newBuckets[newBucketIndex] = (Entry)existing.getValue();
                        existing = ((ChainedMember)existing).nextInBucket;
                        continue;
                    }
                    Entry next2 = ((ChainedKeyValue)existing).nextInBucket;
                    ((ChainedKeyValue)existing).nextInBucket = null;
                    newBuckets[newBucketIndex] = existing;
                    existing = next2;
                    continue;
                }
                if (existing instanceof SelfKeyedMember) {
                    cm = new ChainedMember((SelfKeyedMember)existing);
                    cm.nextInBucket = newBuckets[newBucketIndex];
                    newBuckets[newBucketIndex] = cm;
                    continue block0;
                }
                if (existing instanceof ChainedMember) {
                    cm = (ChainedMember)existing;
                    next = cm.nextInBucket;
                    cm.nextInBucket = newBuckets[newBucketIndex];
                    newBuckets[newBucketIndex] = cm;
                    existing = next;
                    continue;
                }
                ChainedKeyValue ckv = (ChainedKeyValue)existing;
                next = ckv.nextInBucket;
                ckv.nextInBucket = newBuckets[newBucketIndex];
                newBuckets[newBucketIndex] = ckv;
                existing = next;
            }
        }
        this.numBuckets = newNumBuckets;
        this.expandThreshold = (int)((float)this.numBuckets * this.loadFactor);
        this.hashMask = newHashMask;
        this.buckets = newBuckets;
        ++this.updateEpoch;
    }

    private class MapIterator
    implements Iterator {
        private int bucket = 0;
        private Entry current = null;
        private Entry next;
        private int iterationEpoch;

        public MapIterator() {
            this.iterationEpoch = UtilityMap.this.updateEpoch;
            while (this.bucket < UtilityMap.this.numBuckets) {
                if (UtilityMap.this.buckets[this.bucket] != null) {
                    this.next = UtilityMap.this.buckets[this.bucket];
                    break;
                }
                ++this.bucket;
            }
        }

        public boolean hasNext() {
            if (this.iterationEpoch != UtilityMap.this.updateEpoch) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        public Object next() {
            if (this.iterationEpoch != UtilityMap.this.updateEpoch) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.next = null;
            if (this.current instanceof ChainedEntry && ((ChainedEntry)((Object)this.current)).nextInBucket != null) {
                this.next = ((ChainedEntry)((Object)this.current)).nextInBucket;
            } else {
                ++this.bucket;
                while (this.bucket < UtilityMap.this.numBuckets) {
                    if (UtilityMap.this.buckets[this.bucket] != null) {
                        this.next = UtilityMap.this.buckets[this.bucket];
                        break;
                    }
                    ++this.bucket;
                }
            }
            if (this.current instanceof ChainedMember) {
                return ((ChainedMember)this.current).getValue();
            }
            return this.current;
        }

        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (this.iterationEpoch != UtilityMap.this.updateEpoch) {
                throw new ConcurrentModificationException();
            }
            UtilityMap.this.removeByKey(this.current.getKey());
            this.current = null;
            this.iterationEpoch = UtilityMap.this.updateEpoch;
        }
    }

    private static class ChainedKeyValue
    extends ChainedEntry
    implements Entry {
        private final Object key;
        private Object value;

        private ChainedKeyValue(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public final Object getKey() {
            return this.key;
        }

        public final Object getValue() {
            return this.value;
        }
    }

    private static class ChainedMember
    extends ChainedEntry
    implements Entry {
        private SelfKeyedMember member;

        private ChainedMember(SelfKeyedMember memb) {
            this.member = memb;
        }

        public final Object getKey() {
            return this.member.getMembershipKey();
        }

        public final Object getValue() {
            return this.member;
        }
    }

    private static abstract class ChainedEntry {
        protected Entry nextInBucket;

        private ChainedEntry() {
        }

        public final Entry next() {
            return this.nextInBucket;
        }
    }

    public static abstract class SelfKeyedMember
    implements Entry {
        protected abstract Object getMembershipKey();

        public final Object getKey() {
            return this.getMembershipKey();
        }

        public final Object getValue() {
            return this;
        }

        public final Entry next() {
            return null;
        }
    }

    public static interface Entry {
        public Object getKey();

        public Object getValue();

        public Entry next();
    }
}

