/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.J2EEUtil;
import javax.security.auth.Subject;

public class Subjects {
    public static Subject getCurrent() {
        return Subjects.getCurrent(true);
    }

    public static Subject getCurrent(boolean required) {
        Subject subject = UserContext.get().getSubject();
        if (subject == null) {
            subject = J2EEUtil.getInstance().getCurrentSubject();
            if (required && subject == null) {
                throw new EngineRuntimeException(ExceptionCode.SECURITY_INVALID_CREDENTIALS, (Object[])null, ExceptionContext.SECURITY_NO_SECURITY_CONTEXT, null);
            }
        }
        return subject;
    }

    public static Subject clone(Subject subject) {
        return Subjects.clone(subject, subject.isReadOnly());
    }

    public static Subject clone(Subject subject, boolean readOnly) {
        return new Subject(readOnly, subject.getPrincipals(), subject.getPublicCredentials(), subject.getPrivateCredentials());
    }
}

