/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.util.Collection;
import java.util.Hashtable;

public class SubSystem {
    private static final Hashtable gSubSystems = new Hashtable();
    public static final SubSystem WSI = new SubSystem("wsi", "WSI");
    public static final SubSystem EJB = new SubSystem("ejb", "EJB");
    public static final SubSystem API = new SubSystem("api", "API");
    public static final SubSystem Engine = new SubSystem("engine", "ENG");
    public static final SubSystem ContentStorage = new SubSystem("content_storage", "CSTG");
    public static final SubSystem Security = new SubSystem("security", "SEC");
    public static final SubSystem Events = new SubSystem("events", "EVNT");
    public static final SubSystem ContentCache = new SubSystem("content_cache", "CCHE");
    public static final SubSystem FixedContentProvider = new SubSystem("fixed_content_provider", "FCPV");
    public static final SubSystem AsynchronousProcessing = new SubSystem("asynchronous_processing", "ASYN");
    public static final SubSystem CFSDaemon = new SubSystem("cfs_daemon", "CFSD");
    public static final SubSystem SSI = new SubSystem("ssi", "SSI");
    public static final SubSystem CBR = new SubSystem("cbr", "CBR");
    public static final SubSystem MetaDataCache = new SubSystem("metadata_cache", "MCHE");
    public static final SubSystem Search = new SubSystem("search", "SRCH");
    public static final SubSystem Database = new SubSystem("database", "DB");
    public static final SubSystem GCD = new SubSystem("gcd", "GCD");
    public static final SubSystem Publish = new SubSystem("publish", "PUBL");
    public static final SubSystem CodeModule = new SubSystem("code_module", "CMOD");
    public static final SubSystem Error = new SubSystem("error", "ERR");
    public static final SubSystem CFSImportAgent = new SubSystem("cfs_import_agent", "CFSI");
    public static final SubSystem Replication = new SubSystem("replication", "REPL");
    public static final SubSystem AuditDisposition = new SubSystem("audit_disposition", "AUDT");
    private String mName;
    private String mAbbrev;

    protected SubSystem(String name, String abbrev) {
        this.mName = name;
        this.mAbbrev = abbrev;
        gSubSystems.put(name, this);
    }

    public String toString() {
        return this.mName;
    }

    public String getAbbreviation() {
        return this.mAbbrev;
    }

    public static SubSystem getSubSystem(String subSystemName) {
        return (SubSystem)gSubSystems.get(subSystemName);
    }

    public static SubSystem[] getAllSubSystems() {
        Collection values = gSubSystems.values();
        return values.toArray(new SubSystem[values.size()]);
    }
}

