/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.core.Connection;
import com.filenet.apiimpl.util.BinaryInputStream;
import com.filenet.apiimpl.util.BinaryOutputStream;
import com.filenet.apiimpl.util.DelegateInputStream;
import com.filenet.apiimpl.util.DelegateOutputStream;
import com.filenet.apiimpl.util.SessionContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Streams {
    private static final Streams CURRENT = new Streams(5);
    private final short version;

    protected Streams(short version) {
        this.version = version;
    }

    public static Streams getInstance() {
        return CURRENT;
    }

    public static Streams getInstance(short version) {
        return version == 5 ? CURRENT : new Streams(version);
    }

    public int getVerion() {
        return this.version;
    }

    public DelegateInputStream getDelegate(ObjectInputStream s, Connection connection) throws IOException {
        if (s instanceof DelegateInputStream) {
            return (DelegateInputStream)s;
        }
        return BinaryInputStream.getInstance(this.version, s, connection);
    }

    public Connection readConnection(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Connection connection = (Connection)s.readObject();
        Connection current = SessionContext.getCurrentConnection();
        return current == null ? connection : current;
    }

    public DelegateOutputStream getDelegate(ObjectOutputStream s) throws IOException {
        if (s instanceof DelegateOutputStream) {
            return (DelegateOutputStream)s;
        }
        return BinaryOutputStream.getInstance(this.version, s);
    }
}

