/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.core.Connection;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.transport.ejb.ContentEJBHome;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.J2EEUtilWL;
import com.filenet.apiimpl.util.SessionHandle;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.apiimpl.wsi.ServiceSessionNst;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class SessionLocator {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(SessionLocator.class, SubSystem.API);
    private static boolean useSessionCache = true;
    private static ThreadLocal cache = new ThreadLocal();
    private static String splat = " {|} ";
    private static ThreadLocal ejbHomeCache = new ThreadLocal();
    private static HashMap<String, SoftReference<ContentEJBHome>> cacheEntriesContentEjb = new HashMap();
    static HashMap ejbHomeCacheMap = new HashMap();
    private static Constructor serverSessionConstructor;
    private static Constructor EJBSessionConstructor;
    private static Throwable EJBSessionConstructorError;
    private static ThreadLocal enableServerSession;
    private static ClassLoader cl;
    private static final String SERVER_SESSION_CLASS_NAME = "com.filenet.engine.context.ServerSession";
    private static final String EJB_SESSION_CLASS_NAME = "com.filenet.apiimpl.transport.ejb.EJBSession";
    private static ThreadLocal serverSessionOverRide;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear(Connection conn) {
        HashMap<String, SoftReference<ContentEJBHome>> hashMap = cacheEntriesContentEjb;
        synchronized (hashMap) {
            cacheEntriesContentEjb.clear();
        }
        if (!useSessionCache) {
            return;
        }
        ConnectionImpl connToUse = SessionLocator.getConnectionToUse((ConnectionImpl)conn);
        if (connToUse == null) {
            return;
        }
        HashMap cacheEntryes = (HashMap)cache.get();
        if (cacheEntryes == null) {
            return;
        }
        SoftReference sr = (SoftReference)cacheEntryes.remove(SessionLocator.getConnectionKey(connToUse));
        if (sr != null) {
            Session session = (Session)sr.get();
            session.remove();
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Clearing Session cache for:" + connToUse.toString());
        }
    }

    private static String getConnectionKey(Connection conn) {
        if (conn == null) {
            return "";
        }
        String connURI = conn.getURI();
        if (connURI == null) {
            return "";
        }
        String key = connURI.toLowerCase();
        if (SessionLocator.usesWsiTransport(connURI) || SessionLocator.isExecutingInServer()) {
            return key;
        }
        Properties props = J2EEUtil.getEJBJndiEnvironment((ConnectionImpl)conn);
        if (props == null || props.size() < 2) {
            return key + splat;
        }
        key = key + splat + props.toString();
        return key;
    }

    private static String getContentConnectionKey(Connection conn, boolean useAffinity) {
        String baseKey = SessionLocator.getConnectionKey(conn);
        if (useAffinity) {
            return baseKey + "-stateful";
        }
        return baseKey + "-stateless";
    }

    public static Session getSession(Connection conn) {
        SoftReference sr;
        HashMap<String, SoftReference<Session>> cacheEntryes = (HashMap<String, SoftReference<Session>>)cache.get();
        if (cacheEntryes == null) {
            cacheEntryes = new HashMap<String, SoftReference<Session>>();
            cache.set(cacheEntryes);
        }
        ConnectionImpl connToUse = SessionLocator.getConnectionToUse((ConnectionImpl)conn);
        if (!(SessionLocator.isExecutingInServer() || connToUse != null && connToUse.getURI() != null && connToUse.getURI().length() >= 3)) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "Connection");
        }
        Session session = null;
        String conKey = SessionLocator.getConnectionKey(connToUse);
        if (SessionLocator.shouldCacheSession(connToUse) && (sr = (SoftReference)cacheEntryes.get(conKey)) != null) {
            session = (Session)sr.get();
        }
        if (logger.isDetailTraceEnabled() && session != null) {
            logger.traceDetail("A session instance for " + conKey + " was found in the cache and will be returned");
        }
        if (session == null) {
            block19: {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("No session entry found in the cache for " + conKey);
                }
                session = SessionLocator.createNewSession(connToUse);
                J2EEUtil j2eeUtil = J2EEUtil.getInstance();
                if (session == null && j2eeUtil.canInstantiateInitialContext()) {
                    try {
                        if (connToUse == null) {
                            connToUse = new ConnectionImpl();
                        }
                        InitialContext ic = J2EEUtil.getInitialContextWithParameters(connToUse);
                        if (session == null) {
                            session = SessionLocator.findEJBSessionByPath(connToUse, ic, j2eeUtil.getRemoteEnginePath());
                            if (logger.isDetailTraceEnabled()) {
                                if (session == null) {
                                    logger.traceDetail("Remote EJB Interface " + j2eeUtil.getRemoteEnginePath() + " NOT found " + SessionLocator.getJNDIDebugText(ic));
                                } else {
                                    logger.traceDetail("Remote EJB Interface " + j2eeUtil.getRemoteEnginePath() + " found " + SessionLocator.getJNDIDebugText(ic));
                                }
                            }
                        }
                    }
                    catch (NamingException ne) {
                        if (!logger.isDetailTraceEnabled()) break block19;
                        logger.traceDetail(" Naming exception occured that is being ignored " + ne.toString());
                    }
                }
            }
            if (session != null && connToUse != null && SessionLocator.shouldCacheSession(connToUse)) {
                cacheEntryes.put(conKey, new SoftReference<Session>(session));
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Session was cached for " + conKey);
                }
            }
        }
        if (session != null) {
            if (SessionLocator.isExecutingInServer()) {
                return session;
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Remote session is returned and will be wrapped in a session handle for retry conditions");
            }
            return new SessionHandle(session, connToUse);
        }
        throw new EngineRuntimeException(ExceptionCode.API_UNABLE_TO_USE_CONNECTION, connToUse != null ? connToUse.toString() : "null");
    }

    private static boolean shouldCacheSession(ConnectionImpl conn) {
        return conn != null && useSessionCache && !SessionLocator.usesWsiTransport(conn.getURI()) && !SessionLocator.isExecutingInServer();
    }

    private static ConnectionImpl getConnectionToUse(ConnectionImpl conn) {
        if (!SessionLocator.isExecutingInServer() && conn != null && conn.getURI() == null) {
            return SessionLocator.getDefaultConnectionFromExisting(conn);
        }
        if (conn == null) {
            return new ConnectionImpl();
        }
        return conn;
    }

    public static Object getEJB(Context cntx) {
        J2EEUtil j2eeUtil;
        SoftReference sr;
        if (cntx == null) {
            return null;
        }
        HashMap<String, SoftReference<Object>> cacheEntryes = (HashMap<String, SoftReference<Object>>)ejbHomeCache.get();
        if (cacheEntryes == null) {
            cacheEntryes = new HashMap<String, SoftReference<Object>>();
            ejbHomeCache.set(cacheEntryes);
        }
        if ((sr = (SoftReference)cacheEntryes.get((j2eeUtil = J2EEUtil.getInstance()).getLocalEnginePath())) != null && sr.get() != null) {
            return sr.get();
        }
        Object h = SessionLocator.locateEJBByPath(cntx, j2eeUtil.getLocalEnginePath());
        if (h != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Local EJB Interface " + j2eeUtil.getLocalEnginePath() + " found " + SessionLocator.getJNDIDebugText(cntx));
            }
            cacheEntryes.put(j2eeUtil.getLocalEnginePath(), new SoftReference<Object>(h));
            return h;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Local EJB Interface " + j2eeUtil.getLocalEnginePath() + " NOT found " + SessionLocator.getJNDIDebugText(cntx));
        }
        if ((sr = (SoftReference)cacheEntryes.get(j2eeUtil.getRemoteEnginePath())) != null && sr.get() != null) {
            return sr.get();
        }
        Object ret = SessionLocator.locateEJBByPath(cntx, j2eeUtil.getRemoteEnginePath());
        if (ret != null) {
            cacheEntryes.put(j2eeUtil.getRemoteEnginePath(), new SoftReference<Object>(ret));
        }
        if (logger.isDetailTraceEnabled()) {
            if (ret == null) {
                logger.traceDetail("Remote EJB Interface " + j2eeUtil.getRemoteEnginePath() + " found " + SessionLocator.getJNDIDebugText(cntx));
            } else {
                logger.traceDetail("Remote EJB Interface " + j2eeUtil.getRemoteEnginePath() + " NOT found " + SessionLocator.getJNDIDebugText(cntx));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentEJBHome getContentEJB(ConnectionImpl conn, boolean useAffinityEjb) {
        Object ejbHome = null;
        ContentEJBHome contentEjbHome = null;
        boolean isStateful = useAffinityEjb;
        boolean isLocal = false;
        HashMap<String, SoftReference<ContentEJBHome>> hashMap = cacheEntriesContentEjb;
        synchronized (hashMap) {
            String conKey = SessionLocator.getContentConnectionKey(conn, useAffinityEjb);
            SoftReference<ContentEJBHome> sr = cacheEntriesContentEjb.get(conKey);
            ContentEJBHome contentEJBHome = contentEjbHome = sr != null ? sr.get() : null;
            if (contentEjbHome != null) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.getContentEJB called and a cached value is being returned for " + conKey);
                }
                return contentEjbHome;
            }
            Context cntx = SessionLocator.getNewContext(conn);
            J2EEUtil j2eeUtil = J2EEUtil.getInstance();
            String localEngineContentPath = j2eeUtil.getLocalEngineContentPath();
            String remoteEngineContentPath = useAffinityEjb ? j2eeUtil.getRemoteEngineContentAffinityPath() : j2eeUtil.getRemoteEngineContentPath();
            if (ejbHome == null && (ejbHome = SessionLocator.locateEJBByPath(cntx, remoteEngineContentPath)) != null && logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.getContentEJB: Remote content EJB path '" + remoteEngineContentPath + "' lookup found " + ejbHome);
            }
            if (ejbHome == null) {
                String remoteEnginePath = j2eeUtil.getRemoteEnginePath();
                String connPath = conn.getPath();
                if (connPath != null && connPath.endsWith(remoteEnginePath)) {
                    if ((connPath = connPath.substring(0, connPath.length() - remoteEnginePath.length()) + remoteEngineContentPath).startsWith("/")) {
                        connPath = connPath.substring(1);
                    }
                    if ((ejbHome = SessionLocator.locateEJBByPath(cntx, connPath)) != null && logger.isDetailTraceEnabled()) {
                        logger.traceDetail("SessionLocator.getContentEJB: Connection content EJB path '" + connPath + "' lookup found " + ejbHome);
                    }
                }
            }
            if (ejbHome != null) {
                contentEjbHome = new ContentEJBHome(ejbHome, isLocal, isStateful, conKey);
                cacheEntriesContentEjb.put(conKey, new SoftReference<ContentEJBHome>(contentEjbHome));
            }
        }
        return contentEjbHome;
    }

    public static ContentEJBHome getContentEJB(Context cntx) {
        J2EEUtil j2eeUtil;
        Object h;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.getContentEJB: Getting ContentEJB from Context: " + SessionLocator.getJNDIDebugText(cntx));
        }
        if ((h = SessionLocator.locateEJBByPath(cntx, (j2eeUtil = J2EEUtil.getInstance()).getLocalEngineContentPath())) != null) {
            ContentEJBHome contentEjbHome = new ContentEJBHome(h, true, false, null);
            return contentEjbHome;
        }
        h = SessionLocator.locateEJBByPath(cntx, j2eeUtil.getRemoteEngineContentPath());
        if (h != null) {
            ContentEJBHome contentEjbHome = new ContentEJBHome(h, false, false, null);
            return contentEjbHome;
        }
        return null;
    }

    public static void setUseSessionCache(boolean val) {
        useSessionCache = val;
    }

    private static Session createNewSession(ConnectionImpl conn) {
        if (SessionLocator.isExecutingInServer()) {
            try {
                return (Session)SessionLocator.getServerSessionConstructor().newInstance(null);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.createNewSession called and it attempted to create a server session " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.createNewSession called and it attempted to create a server session " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{SERVER_SESSION_CLASS_NAME});
            }
        }
        if (conn != null && conn.getAsURI() != null) {
            Session session = null;
            String providerURL = conn.getProviderURL();
            String path = conn.getPath();
            URI uri = conn.getAsURI();
            if (path != null && !uri.isAbsolute()) {
                InitialContext nContext;
                try {
                    nContext = J2EEUtil.getInitialContextWithParameters(conn);
                }
                catch (NamingException ne) {
                    throw new EngineRuntimeException(ne, ExceptionCode.API_UNEXPECTED_JNDI_ERROR, null);
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                session = SessionLocator.findEJBSessionByPath(conn, nContext, path);
            } else if (SessionLocator.usesWsiTransport(providerURL)) {
                session = SessionLocator.createNewSoapSession(conn, providerURL, path);
            } else if (path == null || path.length() < 1 || path.equals("/")) {
                Context nContext = SessionLocator.getNewContext(conn);
                session = SessionLocator.findEJBSession(conn, nContext);
            } else {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (J2EEUtil.getInstance() instanceof J2EEUtilWL) {
                    session = SessionLocator.findEJBSessionByPath(conn, path);
                } else {
                    Context nContext = SessionLocator.getNewContext(conn);
                    session = SessionLocator.findEJBSessionByPath(conn, nContext, path);
                }
            }
            if (session != null) {
                return session;
            }
        }
        return null;
    }

    private static Context getNewContext(ConnectionImpl conn) {
        try {
            return J2EEUtil.getInitialContextWithParameters(conn);
        }
        catch (NamingException ne) {
            throw new EngineRuntimeException(ne, ExceptionCode.API_UNEXPECTED_JNDI_ERROR, null);
        }
    }

    private static boolean usesWsiTransport(String providerURL) {
        if (providerURL == null) {
            return false;
        }
        return providerURL.substring(0, 4).equalsIgnoreCase("http");
    }

    public static boolean isExecutingInServer() {
        boolean ret = SessionLocator.getServerSessionConstructor() != null && SessionLocator.isServerSessionEnabled();
        return ret;
    }

    private static StringBuffer getJNDIDebugText(Context cntx) {
        StringBuffer txt = new StringBuffer();
        try {
            Hashtable<?, ?> env = cntx.getEnvironment();
            Set<Map.Entry<?, ?>> entries = env.entrySet();
            Iterator<Map.Entry<?, ?>> iter = entries.iterator();
            txt.append("JNDI InitialContext environment");
            while (iter.hasNext()) {
                Map.Entry<?, ?> ent = iter.next();
                txt.append("\n key=");
                txt.append(ent.getKey());
                txt.append(" Value=");
                txt.append(ent.getValue());
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return txt;
    }

    private static Session createNewSoapSession(ConnectionImpl conn, String providerURL, String path) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.createNewSoapSession called with providerURL " + (providerURL != null ? providerURL : "null") + " path " + (path != null ? path : "null"));
        }
        if (path == null || path.length() < 1 || path.equals("/")) {
            throw new EngineRuntimeException(ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        String soapURI = providerURL + path;
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Instantiating a SoapSession instance using uri " + soapURI);
        }
        return new ServiceSessionNst(soapURI);
    }

    private static ConnectionImpl getDefaultConnectionFromExisting(ConnectionImpl conn) {
        String uri = ConfigValueLookup.getValue("Engine", null);
        if (uri != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.getDefaultConnectionFromExisting called a URI was found " + uri);
            }
            return new ConnectionImpl(uri);
        }
        return conn;
    }

    private static Session findEJBSession(Connection conn, Context cntx) {
        if (EJBSessionConstructor == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.findEJBSession is resulting in an exception becuase the EJB Session constructor can not be found");
            }
            throw new EngineRuntimeException(EJBSessionConstructorError, ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        Object ejb = SessionLocator.getEJB(cntx);
        if (ejb != null) {
            try {
                return (Session)EJBSessionConstructor.newInstance(ejb, cntx);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSession called and a new instance of the EJBSession could not be instantiated " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSession called and a new instance of the EJBSession could not be instantiated " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Session findEJBSessionByPath(ConnectionImpl conn, String path) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.findEJBSessionByPath called path=" + path);
        }
        if (EJBSessionConstructor == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.findEJBSessionByPath is resulting in an exception becuase the EJB Session constructor can not be found");
            }
            throw new EngineRuntimeException(EJBSessionConstructorError, ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        String conKey = SessionLocator.getConnectionKey(conn);
        Object ejb = null;
        Context cntx = null;
        HashMap hashMap = ejbHomeCacheMap;
        synchronized (hashMap) {
            ejb = ejbHomeCacheMap.get(conKey);
            if (ejb == null && (ejb = SessionLocator.locateEJBByPath(cntx = SessionLocator.getNewContext(conn), path)) != null) {
                ejbHomeCacheMap.put(conKey, ejb);
            }
        }
        if (ejb != null) {
            try {
                return (Session)EJBSessionConstructor.newInstance(ejb, cntx);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
            }
        }
        return null;
    }

    private static Session findEJBSessionByPath(Connection conn, Context cntx, String path) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.findEJBSessionByPath called path=" + path);
        }
        if (EJBSessionConstructor == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.findEJBSessionByPath is resulting in an exception becuase the EJB Session constructor can not be found");
            }
            throw new EngineRuntimeException(EJBSessionConstructorError, ExceptionCode.API_INVALID_URI, new Object[]{conn.getURI()});
        }
        Object ejb = SessionLocator.locateEJBByPath(cntx, path);
        if (ejb != null) {
            try {
                return (Session)EJBSessionConstructor.newInstance(ejb, cntx);
            }
            catch (EngineRuntimeException ert) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + ert.toString());
                }
                throw ert;
            }
            catch (Throwable t) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("SessionLocator.findEJBSessionByPath called and a new instance of the EJBSession could not be instantiated " + t.toString());
                }
                if (t.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)t.getCause();
                }
                throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
            }
        }
        return null;
    }

    private static Object locateEJBByPath(Context cntx, String path) {
        if (cntx == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.locateEJBByPath called with a null context and path of " + path);
            }
            return null;
        }
        try {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.locateEJBBypath called with:" + path);
            }
            return cntx.lookup(path);
        }
        catch (NamingException ne) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.locateEJBByPath was called with a path of " + path + " and resulted in an exception " + ne.toString());
            }
            if (!SessionLocator.isNamingExceptionTolerated(ne)) {
                throw new EngineRuntimeException(ne, ExceptionCode.API_UNEXPECTED_JNDI_ERROR, null);
            }
            return null;
        }
    }

    private static boolean isNamingExceptionTolerated(NamingException ne) {
        return ne instanceof NameNotFoundException || ne.getRootCause() instanceof NameNotFoundException || ne instanceof LinkException || ne instanceof ConfigurationException;
    }

    public static void setEnableServerSession(boolean enable) {
        if (enable) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.setEnableServerSession(true) called");
            }
            enableServerSession.set(Boolean.TRUE);
        } else {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("SessionLocator.setEnableServerSession(false) called");
            }
            enableServerSession.set(null);
        }
    }

    public static boolean isServerSessionEnabled() {
        if (enableServerSession.get() == null) {
            return false;
        }
        return (Boolean)enableServerSession.get();
    }

    public static void setClassLoader(ClassLoader ncl) {
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("SessionLocator.setClassLoader called " + ncl.toString());
        }
        cl = ncl;
        SessionLocator.loadSessionConstructors();
    }

    public static void setServerSessionConstructor(Constructor ssc) {
        if (logger.isDetailTraceEnabled() && ssc != null) {
            logger.traceDetail("SessionLocator.setServerSessionConstructor called " + ssc.getName());
        }
        serverSessionOverRide.set(ssc);
    }

    public static Constructor getServerSessionConstructor() {
        if (serverSessionOverRide.get() != null) {
            return (Constructor)serverSessionOverRide.get();
        }
        return serverSessionConstructor;
    }

    public static Constructor findServerSessionConstructor() {
        Constructor<?> ret = null;
        try {
            Class<?> serverSessionClass = cl.loadClass(SERVER_SESSION_CLASS_NAME);
            ret = serverSessionClass.getConstructor(null);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor com.filenet.engine.context.ServerSession found");
            }
        }
        catch (NoClassDefFoundError ncd) {
            ret = null;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + ncd.toString());
            }
        }
        catch (ClassNotFoundException cnf) {
            ret = null;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + cnf.toString());
            }
        }
        catch (EngineRuntimeException ert) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + ert.toString());
            }
            throw ert;
        }
        catch (Throwable t) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Server Session constructor will not be used:" + t.toString());
            }
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{SERVER_SESSION_CLASS_NAME});
        }
        return ret;
    }

    private static void loadSessionConstructors() {
        serverSessionConstructor = SessionLocator.findServerSessionConstructor();
        try {
            Class<?> EJBSessionClass = cl.loadClass(EJB_SESSION_CLASS_NAME);
            EJBSessionConstructor = EJBSessionClass.getConstructor(Object.class, Context.class);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor com.filenet.apiimpl.transport.ejb.EJBSession found");
            }
        }
        catch (NoClassDefFoundError ncd) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = ncd;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + ncd.toString());
            }
        }
        catch (ClassNotFoundException cnf) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = cnf;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + cnf.toString());
            }
        }
        catch (EngineRuntimeException ert) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = ert;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + ert.toString());
            }
            throw ert;
        }
        catch (Throwable t) {
            EJBSessionConstructor = null;
            EJBSessionConstructorError = t;
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("EJB Session constructor will not be used:" + t.toString());
            }
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            throw new EngineRuntimeException(t, ExceptionCode.API_SESSION_NOT_IMPL_CORRECTLY, new Object[]{EJB_SESSION_CLASS_NAME});
        }
    }

    static {
        enableServerSession = new ThreadLocal();
        serverSessionOverRide = new ThreadLocal();
        cl = SessionLocator.class.getClassLoader();
        SessionLocator.loadSessionConstructors();
    }
}

