/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.action.PendingAction;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.property.PropertyFilter;
import com.filenet.apiimpl.core.BatchItemHandleImpl;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.core.ObjectReferenceBase;
import com.filenet.apiimpl.core.Session;
import com.filenet.apiimpl.exception.Exceptions;
import com.filenet.apiimpl.transport.ChangeRequest;
import com.filenet.apiimpl.transport.ClientCallContext;
import com.filenet.apiimpl.transport.ExecuteChangesRequest;
import com.filenet.apiimpl.transport.ExecuteChangesResponse;
import com.filenet.apiimpl.transport.GetContentRequest;
import com.filenet.apiimpl.transport.GetContentResponse;
import com.filenet.apiimpl.transport.GetObjectRequest;
import com.filenet.apiimpl.transport.GetObjectResponse;
import com.filenet.apiimpl.transport.MetadataSearchRequest;
import com.filenet.apiimpl.transport.MetadataSearchResponse;
import com.filenet.apiimpl.transport.SearchRequest;
import com.filenet.apiimpl.transport.SearchResponse;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SessionLocator;
import com.filenet.apiimpl.util.SubSystem;
import java.util.ArrayList;
import java.util.HashMap;

public class SessionHandle
extends Session {
    public static final int MAXIMUM_RETRY = ConfigValueLookup.getValueAsInt("MaximumRetry", 1);
    private static final int EXPIRE_SESSION_INTERVAL = ConfigValueLookup.getValueAsInt("ExpireSessionInterval", 0);
    private static final BaseLogger logger = BaseLogger.getBaseLogger(SessionHandle.class, SubSystem.API);
    private int usedInterval = 0;
    private short retried = 0;
    private Session session;
    private ConnectionImpl connection;

    SessionHandle(Session sess, ConnectionImpl conn) {
        this.session = sess;
        this.connection = conn;
    }

    Session getSession() {
        if (EXPIRE_SESSION_INTERVAL > 0 && this.usedInterval >= EXPIRE_SESSION_INTERVAL && this.session != null) {
            this.clear();
            this.usedInterval = 0;
        } else {
            ++this.usedInterval;
        }
        if (this.session == null) {
            this.usedInterval = 0;
            this.getNewSession();
        }
        return this.session;
    }

    private void getNewSession() {
        this.session = SessionLocator.getSession(this.connection);
        if (this.session instanceof SessionHandle) {
            this.session = ((SessionHandle)this.session).getSession();
        }
    }

    public static void applyWait() {
        int interval = ConfigValueLookup.getValueAsInt("RetryInterval", 5000);
        if (interval > 0) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void clear() {
        SessionLocator.clear(this.connection);
        if (this.session != null) {
            this.session.remove();
        }
        this.session = null;
    }

    public ExecuteChangesResponse executeChanges(ConnectionImpl conn, ExecuteChangesRequest request, ArrayList uploadHandles, ClientCallContext optionalClientCallContext) {
        try {
            ExecuteChangesResponse executeChangesResponse = this.getSession().executeChanges(conn, request, uploadHandles, optionalClientCallContext);
            return executeChangesResponse;
        }
        catch (EngineRuntimeException ert) {
            if (this.isRetryException(ert)) {
                this.clear();
                this.retried = (short)(this.retried + 1);
                if (this.retried <= MAXIMUM_RETRY) {
                    if (logger.isInfoEnabled()) {
                        logger.info("An exception has occurred while processing an executeChanges request. The executeChanges request is being retried(" + this.retried + ") of (" + MAXIMUM_RETRY + ") times.", ert.getCause());
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail(Exceptions.printStackTrace(ert));
                    }
                    SessionHandle.applyWait();
                    ExecuteChangesResponse executeChangesResponse = this.executeChanges(conn, request, uploadHandles, optionalClientCallContext);
                    return executeChangesResponse;
                }
                this.throwFirstERECause(ert);
                throw new EngineRuntimeException(ert.getCause(), ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            throw ert;
        }
        finally {
            this.retried = 0;
        }
    }

    public SearchResponse executeSearch(ConnectionImpl conn, SearchRequest search, ClientCallContext optionalClientCallContext) {
        try {
            SearchResponse searchResponse = this.getSession().executeSearch(conn, search, optionalClientCallContext);
            return searchResponse;
        }
        catch (EngineRuntimeException ert) {
            if (this.isRetryException(ert)) {
                this.clear();
                this.retried = (short)(this.retried + 1);
                if (this.retried <= MAXIMUM_RETRY) {
                    if (logger.isInfoEnabled()) {
                        logger.info("An exception has occurred while processing an executeSearch request. The search request is being retried(" + this.retried + ") of (" + MAXIMUM_RETRY + ") times.", ert.getCause());
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail(Exceptions.printStackTrace(ert));
                    }
                    SessionHandle.applyWait();
                    SearchResponse searchResponse = this.executeSearch(conn, search, optionalClientCallContext);
                    return searchResponse;
                }
                this.throwFirstERECause(ert);
                throw new EngineRuntimeException(ert.getCause(), ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            throw ert;
        }
        finally {
            this.retried = 0;
        }
    }

    public MetadataSearchResponse getSearchMetadata(ConnectionImpl conn, MetadataSearchRequest search, ClientCallContext optionalClientCallContext) {
        try {
            MetadataSearchResponse metadataSearchResponse = this.getSession().getSearchMetadata(conn, search, optionalClientCallContext);
            return metadataSearchResponse;
        }
        catch (EngineRuntimeException ert) {
            if (this.isRetryException(ert)) {
                this.clear();
                this.retried = (short)(this.retried + 1);
                if (this.retried <= MAXIMUM_RETRY) {
                    if (logger.isInfoEnabled()) {
                        logger.info("An exception has occurred while processing a getSearchMetadata request. The getSearchMetadata request is being retried(" + this.retried + ") of (" + MAXIMUM_RETRY + ") times.", ert.getCause());
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail(Exceptions.printStackTrace(ert));
                    }
                    SessionHandle.applyWait();
                    MetadataSearchResponse metadataSearchResponse = this.getSearchMetadata(conn, search, optionalClientCallContext);
                    return metadataSearchResponse;
                }
                this.throwFirstERECause(ert);
                throw new EngineRuntimeException(ert.getCause(), ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            throw ert;
        }
        finally {
            this.retried = 0;
        }
    }

    public GetContentResponse getContent(ConnectionImpl conn, GetContentRequest request, Long contentSize, ClientCallContext optionalClientCallContext) {
        try {
            GetContentResponse getContentResponse = this.getSession().getContent(conn, request, contentSize, optionalClientCallContext);
            return getContentResponse;
        }
        catch (EngineRuntimeException ert) {
            if (this.isRetryException(ert)) {
                this.clear();
                this.retried = (short)(this.retried + 1);
                if (this.retried <= MAXIMUM_RETRY) {
                    if (logger.isInfoEnabled()) {
                        logger.info("An exception has occurred while processing a getContent request. The getContent request is being retried(" + this.retried + ") of (" + MAXIMUM_RETRY + ") times.", ert.getCause());
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail(Exceptions.printStackTrace(ert));
                    }
                    SessionHandle.applyWait();
                    GetContentResponse getContentResponse = this.getContent(conn, request, contentSize, optionalClientCallContext);
                    return getContentResponse;
                }
                this.throwFirstERECause(ert);
                throw new EngineRuntimeException(ert.getCause(), ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            throw ert;
        }
        finally {
            this.retried = 0;
        }
    }

    public GetObjectResponse getObjects(ConnectionImpl conn, GetObjectRequest request, ClientCallContext optionalClientCallContext) {
        try {
            GetObjectResponse getObjectResponse = this.getSession().getObjects(conn, request, optionalClientCallContext);
            return getObjectResponse;
        }
        catch (EngineRuntimeException ert) {
            if (this.isRetryException(ert)) {
                this.clear();
                this.retried = (short)(this.retried + 1);
                if (this.retried <= MAXIMUM_RETRY) {
                    if (logger.isInfoEnabled()) {
                        logger.info("An exception has occurred while processing a getObjects request. The getObjects request is being retried(" + this.retried + ") of (" + MAXIMUM_RETRY + ") times.", ert.getCause());
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail(Exceptions.printStackTrace(ert));
                    }
                    SessionHandle.applyWait();
                    GetObjectResponse getObjectResponse = this.getObjects(conn, request, optionalClientCallContext);
                    return getObjectResponse;
                }
                this.throwFirstERECause(ert);
                throw new EngineRuntimeException(ert.getCause(), ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            throw ert;
        }
        finally {
            this.retried = 0;
        }
    }

    private void throwFirstERECause(EngineRuntimeException ere) {
        if (ere.getExceptionCode() != ExceptionCode.E_EXCEPTION_RETRY) {
            throw ere;
        }
        for (Throwable t = ere.getCause(); t != null; t = t.getCause()) {
            if (!(t instanceof EngineRuntimeException)) continue;
            throw (EngineRuntimeException)t;
        }
    }

    public void getContentToUpload(IndependentlyPersistableObjectImpl obj, ChangeRequest cr, ArrayList uploadHandles) {
        this.getSession().getContentToUpload(obj, cr, uploadHandles);
    }

    public ObjectReferenceBase getExecuteChangesTargetSpecification(PendingAction[] actions, IndependentlyPersistableObjectImpl objToUpdate) {
        return this.getSession().getExecuteChangesTargetSpecification(actions, objToUpdate);
    }

    public void getChangeRequests(BatchItemHandleImpl[] batchItems, ArrayList changeRequestTypes, HashMap correlationMap, ArrayList uploadHandles) {
        this.getSession().getChangeRequests(batchItems, changeRequestTypes, correlationMap, uploadHandles);
    }

    public ChangeRequest getChangeRequest(IndependentlyPersistableObjectImpl objToUpdate, PendingAction[] actions, PropertyFilter refreshFilter, String correlationId) {
        return this.getSession().getChangeRequest(objToUpdate, actions, refreshFilter, correlationId);
    }

    public ClientCallContext getClientCallContext(ConnectionImpl conn) {
        return this.getSession().getClientCallContext(conn);
    }

    private boolean isRetryException(EngineRuntimeException ere) {
        if (ere.getExceptionCode() == ExceptionCode.E_EXCEPTION_RETRY) {
            return true;
        }
        if (ere.getExceptionCode() == ExceptionCode.TRANSPORT_WSI_END_TOKEN_EXPECTED) {
            return true;
        }
        if (ere.getExceptionCode() == ExceptionCode.TRANSPORT_WSI_DESERIALIZATION_ERROR) {
            return true;
        }
        if (ere.getExceptionCode() == ExceptionCode.TRANSPORT_WSI_NETWORK_ERROR) {
            return true;
        }
        if (ere.getCause() != null) {
            Throwable t = ere.getCause();
            do {
                String cn;
                if (!(cn = t.getClass().getName()).equals("weblogic.rjvm.PeerGoneException") && !cn.equals("weblogic.utils.net.SocketResetException")) continue;
                return true;
            } while ((t = t.getCause()) != null);
        }
        return false;
    }

    public void remove() {
        if (this.session != null) {
            this.session.remove();
        }
    }

    public void beginGetContentSession(ConnectionImpl conn) {
        if (this.session != null) {
            this.session.beginGetContentSession(conn);
        }
    }

    public void finishGetContentSession(ConnectionImpl conn) {
        if (this.session != null) {
            this.session.finishGetContentSession(conn);
        }
    }
}

