/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.SubSystem;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class NonceCache
extends LinkedHashMap {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(NonceCache.class, SubSystem.Security);
    private long timeToLiveMillisecs;
    private int maxCapacity = 0;
    private static final boolean INSERTION_ORDER_MODE = false;

    protected NonceCache() {
    }

    NonceCache(int initialCapacity, long timeToLiveSeconds) {
        super(initialCapacity, 0.75f, false);
        if (logger.isInfoEnabled()) {
            logger.info("NonceCache initialized: initial capacity = " + Integer.toString(initialCapacity) + ", max capacity = not limited" + ", time to live(seconds) = " + Long.toString(timeToLiveSeconds));
        }
        this.timeToLiveMillisecs = timeToLiveSeconds * 1000L;
    }

    NonceCache(int initialCapacity, int maxCapacity, long timeToLiveSeconds) {
        super(initialCapacity, 0.75f, false);
        if (logger.isInfoEnabled()) {
            logger.info("NonceCache initialized: initial capacity = " + Integer.toString(initialCapacity) + ", max capacity = " + Integer.toString(maxCapacity) + ", time to live(seconds) = " + Long.toString(timeToLiveSeconds));
        }
        this.timeToLiveMillisecs = timeToLiveSeconds * 1000L;
        this.maxCapacity = maxCapacity;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        Object val = null;
        if (eldest != null) {
            val = eldest.getValue();
        }
        if (val == null || !(val instanceof Long)) {
            return true;
        }
        long now = System.currentTimeMillis();
        boolean isAtCapacity = false;
        if (this.maxCapacity > 0 && this.size() >= this.maxCapacity) {
            isAtCapacity = true;
        } else if (now - (Long)val < this.timeToLiveMillisecs) {
            return false;
        }
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            Long key = (Long)it.next();
            Long startInCache = (Long)this.get(key);
            if (isAtCapacity) {
                it.remove();
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Nonce removed from cache(max capacity exceeded): " + eldest.getKey());
                }
                isAtCapacity = false;
                continue;
            }
            if (now - startInCache < this.timeToLiveMillisecs) break;
            it.remove();
            if (!logger.isDetailTraceEnabled()) continue;
            logger.traceDetail("Nonce removed from cache(aged out): " + key);
        }
        return false;
    }
}

