/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.core.Scope;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

final class MetadataCacheIE {
    private static final long MAX_CD_TTL = 14400000L;
    private static final Map cdCache = Collections.synchronizedMap(new HashMap());
    private static final PropertyFilter cdPf;
    private static Hashtable domainClasses;
    private static Hashtable objectTypeMap;
    private static Domain localDomain;

    private MetadataCacheIE() {
    }

    public static ClassDescription getClassDescription(String className, ObjectStore objStore) {
        ClassDescription classDesc = MetadataCacheIE.locateCD(objStore, className, null);
        return classDesc;
    }

    public static ClassDescription getClassDescription(EngineObject engineObj, ObjectStore objStore) {
        String className = engineObj.getClassName();
        if (engineObj instanceof Domain) {
            return MetadataCacheIE.getDomainClassDesc((Domain)engineObj, className);
        }
        if (engineObj instanceof ObjectStore) {
            return MetadataCacheIE.getClassDescription(className, (ObjectStore)engineObj);
        }
        return MetadataCacheIE.getClassDescription(className, objStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EngineObject createObject(String className, ObjectStore objStore, Id objectId) {
        ClassDescription cd = MetadataCacheIE.locateCD(objStore, className, null);
        EngineObject engineObj = null;
        try {
            if (!cd.get_AllowsInstances().booleanValue()) {
                throw new EngineRuntimeException(ExceptionCode.E_NOT_CREATABLE);
            }
            Class<?> factoryClass = null;
            String createName = className;
            do {
                try {
                    factoryClass = Class.forName("com.filenet.api.core.Factory$" + createName);
                    break;
                }
                catch (ClassNotFoundException e) {
                    cd = cd.get_SuperclassDescription();
                    createName = cd.get_SymbolicName();
                }
                catch (Exception e) {
                    throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
                }
            } while (cd != null);
            Method createMethod = null;
            if (objectId != null) {
                try {
                    createMethod = factoryClass.getMethod("createInstance", ObjectStore.class, String.class, Id.class);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (createMethod != null) {
                    return (EngineObject)createMethod.invoke(null, objStore, className, objectId);
                }
                createMethod = factoryClass.getMethod("createInstance", ObjectStore.class, Id.class);
                if (createMethod == null) throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED);
                return (EngineObject)createMethod.invoke(null, objStore, objectId);
            }
            try {
                createMethod = factoryClass.getMethod("createInstance", ObjectStore.class, String.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (createMethod != null) {
                return (EngineObject)createMethod.invoke(null, objStore, className);
            }
            try {
                createMethod = factoryClass.getMethod("createInstance", ObjectStore.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (createMethod != null) {
                return (EngineObject)createMethod.invoke(null, objStore);
            }
            try {
                createMethod = factoryClass.getMethod("createInstance", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (createMethod == null) throw new EngineRuntimeException(ExceptionCode.E_NOT_CREATABLE);
            return (EngineObject)createMethod.invoke(null, null);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public static Integer getObjectType(EngineObject eo) {
        if (objectTypeMap.isEmpty()) {
            MetadataCacheIE.addSystemObjectTypes();
        }
        ObjectStore objStore = null;
        if (eo instanceof RepositoryObject) {
            objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
        }
        String className = eo.getClassName();
        for (int i = 0; i < 100; ++i) {
            Object objType = objectTypeMap.get(className);
            if (objType != null && (Integer)objType >= 0) {
                return (Integer)objType;
            }
            ClassDescription cd = MetadataCacheIE.locateCD(objStore, className, null);
            objType = objectTypeMap.get(className = cd.get_SymbolicName());
            if (objType != null && (Integer)objType >= 0) {
                return (Integer)objType;
            }
            if ((cd = cd.get_SuperclassDescription()) == null) {
                return null;
            }
            className = cd.get_SymbolicName();
        }
        throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED_EXCEPTION);
    }

    public static void setLocalDomain(Domain domain) {
        localDomain = domain;
    }

    public static Domain getLocalDomain() {
        return localDomain;
    }

    private static final ClassDescription getDomainClassDesc(Domain dom, String className) {
        ClassDescription classDesc = (ClassDescription)domainClasses.get(className.toLowerCase());
        if (classDesc == null) {
            try {
                classDesc = Factory.ClassDescription.fetchInstance((Scope)dom, className, cdPf);
                domainClasses.put(classDesc.get_SymbolicName().toLowerCase(), classDesc);
                domainClasses.put(classDesc.get_Id().toString().toLowerCase(), classDesc);
            }
            catch (EngineRuntimeException rexc) {
                if (rexc.getExceptionCode() == ExceptionCode.E_OBJECT_NOT_FOUND) {
                    throw new EngineRuntimeException((Throwable)rexc, ExceptionCode.E_BAD_CLASSID, null);
                }
                throw rexc;
            }
        }
        return classDesc;
    }

    private static final ClassDescription locateCD(EngineObject eo, String cdSymNameOrId, Locale locale) {
        long now;
        ClassKey lookFor = new ClassKey(eo, cdSymNameOrId, locale);
        ClassInfo entry = (ClassInfo)cdCache.get(lookFor);
        if (entry == null) {
            entry = MetadataCacheIE.populateNewCd(lookFor);
        }
        if ((now = System.currentTimeMillis()) - entry.getTimeStamp() > 14400000L) {
            entry = MetadataCacheIE.refreshCd(lookFor, entry);
        }
        ClassDescription cd = entry.getClassDescription();
        return cd;
    }

    private static ClassInfo populateNewCd(ClassKey lookFor) {
        ClassDescription cd = Factory.ClassDescription.getInstance((Scope)((ObjectStore)lookFor.eo), lookFor.cdSymNameOrId);
        cd.refresh(cdPf);
        ClassInfo entry = new ClassInfo(cd);
        cdCache.put(lookFor, entry);
        return entry;
    }

    private static ClassInfo refreshCd(ClassKey lookFor, ClassInfo entry) {
        ClassDescription cd = entry.getClassDescription();
        cd.refresh(cdPf);
        entry = new ClassInfo(cd);
        cdCache.put(lookFor, entry);
        return entry;
    }

    private static void addSystemObjectTypes() {
        MetadataCacheIE.addObjectTypeMapping("Any", 0);
        MetadataCacheIE.addObjectTypeMapping("AccessPermission", 2012);
        MetadataCacheIE.addObjectTypeMapping("ActiveMarking", 1210);
        MetadataCacheIE.addObjectTypeMapping("AddOn", 1202);
        MetadataCacheIE.addObjectTypeMapping("Annotation", 3);
        MetadataCacheIE.addObjectTypeMapping("AuditDefinition", 1181);
        MetadataCacheIE.addObjectTypeMapping("Choice", 1025);
        MetadataCacheIE.addObjectTypeMapping("ChoiceList", 1026);
        MetadataCacheIE.addObjectTypeMapping("ClassDefinition", 1027);
        MetadataCacheIE.addObjectTypeMapping("ClassDescription", 25);
        MetadataCacheIE.addObjectTypeMapping("ClassSubscription", 1166);
        MetadataCacheIE.addObjectTypeMapping("ColumnDefinition", 1028);
        MetadataCacheIE.addObjectTypeMapping("ContentReference", 1035);
        MetadataCacheIE.addObjectTypeMapping("ContentTransfer", 1038);
        MetadataCacheIE.addObjectTypeMapping("CustomObject", 15);
        MetadataCacheIE.addObjectTypeMapping("Document", 1);
        MetadataCacheIE.addObjectTypeMapping("DocumentClassificationAction", 1161);
        MetadataCacheIE.addObjectTypeMapping("DocumentLifecycleAction", 1154);
        MetadataCacheIE.addObjectTypeMapping("DocumentLifecyclePolicy", 1148);
        MetadataCacheIE.addObjectTypeMapping("DocumentState", 1152);
        MetadataCacheIE.addObjectTypeMapping("Domain", 2005);
        MetadataCacheIE.addObjectTypeMapping("DynamicReferentialContainmentRelationship", 1050);
        MetadataCacheIE.addObjectTypeMapping("EntireNetwork", 2004);
        MetadataCacheIE.addObjectTypeMapping("Event", 1180);
        MetadataCacheIE.addObjectTypeMapping("EventAction", 1143);
        MetadataCacheIE.addObjectTypeMapping("Folder", 2);
        MetadataCacheIE.addObjectTypeMapping("Group", 2001);
        MetadataCacheIE.addObjectTypeMapping("InstanceSubscription", 1165);
        MetadataCacheIE.addObjectTypeMapping("Link", 1156);
        MetadataCacheIE.addObjectTypeMapping("LocalizedString", 1075);
        MetadataCacheIE.addObjectTypeMapping("Marking", 1201);
        MetadataCacheIE.addObjectTypeMapping("MarkingSet", 1200);
        MetadataCacheIE.addObjectTypeMapping("ObjectStore", 4);
        MetadataCacheIE.addObjectTypeMapping("Permission", 2012);
        MetadataCacheIE.addObjectTypeMapping("PermissionDescription", 1177);
        MetadataCacheIE.addObjectTypeMapping("PropertyDefinition", 1077);
        MetadataCacheIE.addObjectTypeMapping("PropertyDescription", 24);
        MetadataCacheIE.addObjectTypeMapping("PropertyTemplate", 1055);
        MetadataCacheIE.addObjectTypeMapping("Realm", 2006);
        MetadataCacheIE.addObjectTypeMapping("ReferentialContainmentRelationship", 1124);
        MetadataCacheIE.addObjectTypeMapping("SecurityPolicy", 1170);
        MetadataCacheIE.addObjectTypeMapping("SecurityTemplate", 1175);
        MetadataCacheIE.addObjectTypeMapping("StoragePolicy", 1037);
        MetadataCacheIE.addObjectTypeMapping("Subscription", 1144);
        MetadataCacheIE.addObjectTypeMapping("TableDefinition", 1135);
        MetadataCacheIE.addObjectTypeMapping("User", 2000);
        MetadataCacheIE.addObjectTypeMapping("VersionSeries", 1140);
        MetadataCacheIE.addObjectTypeMapping("WorkflowDefinition", 1160);
        MetadataCacheIE.addObjectTypeMapping("XMLPropertyMappingScript", 1162);
    }

    private static void addObjectTypeMapping(String className, int objType) {
        objectTypeMap.put(className, new Integer(objType));
    }

    static {
        domainClasses = new Hashtable();
        objectTypeMap = new Hashtable();
        localDomain = null;
        cdPf = new PropertyFilter();
        cdPf.setLevelDependents(true);
        cdPf.addExcludeProperty("ClassDescription DescriptiveText Ids SuperclassPropertyCount ImmediateSubclassDescriptions NamePropertyIndex HasPropertSubclassProperties Name InstanceType IsHidden IsSecurable PermissionDescriptions DefaultInstancePermissions ProperSubclassPropertyDescriptions DefaultInstanceOwner IsSelectable IsSearchable IsOrderable IsReadOnly ChoiceList RequiresUniqueElements PropertySelectionBinary MaximumLengthBinary PropertySelectionsBoolean PropertySelectionsDateTime PropertyMinimumDateTime PropertyMaximumDateTime PropertySelectionsFloat64 PropertyMinimumFloat64 PropertyMaximumFloat64 PropertySelectionsId PropertySelectionsInteger32 PropertyMinimumInteger32 PropertyMaximumInteger32 PropertySelectionsObject RequiredClass ReflectivePropertyId DeletionAction AllowsForeignObject SecurityProxyType PropertySelectionsString MaximumLengthString UsesLongColumn QueryOperatorDescriptions");
    }

    private static class ClassInfo {
        private ClassDescription classDesc;
        private final long timeStamp = System.currentTimeMillis();

        private ClassInfo(ClassDescription cd) {
            this.classDesc = cd;
        }

        private ClassDescription getClassDescription() {
            return this.classDesc;
        }

        private long getTimeStamp() {
            return this.timeStamp;
        }
    }

    private static final class ClassKey {
        private EngineObject eo;
        private String cdSymNameOrId;
        private Locale locale;

        public boolean equals(Object o) {
            Locale thatLO;
            String thatCD;
            EngineObject thatEO;
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassKey)) {
                return false;
            }
            ClassKey k = (ClassKey)o;
            EngineObject thisEO = this.eo;
            if (thisEO == null != ((thatEO = k.eo) == null)) {
                return false;
            }
            if (thatEO != null && thisEO != null && !thatEO.equals(thisEO)) {
                return false;
            }
            String thisCD = this.cdSymNameOrId;
            if (thisCD == null != ((thatCD = k.cdSymNameOrId) == null)) {
                return false;
            }
            if (thatCD != null && thisCD != null && !thatCD.equals(thisCD)) {
                return false;
            }
            Locale thisLO = this.locale;
            if (thisLO == null != ((thatLO = k.locale) == null)) {
                return false;
            }
            return thatLO == null || thisLO == null || thatLO.equals(thisLO);
        }

        public int hashCode() {
            int result = 17;
            EngineObject thisOS = this.eo;
            String thisCD = this.cdSymNameOrId;
            Locale thisLO = this.locale;
            result = 37 * result + (thisOS != null ? thisOS.hashCode() : 0);
            result = 37 * result + (thisCD != null ? thisCD.hashCode() : 0);
            result = 37 * result + (thisLO != null ? thisLO.hashCode() : 0);
            return result;
        }

        private ClassKey(EngineObject eo, String cdSymNameOrId, Locale locale) {
            this.eo = eo;
            this.cdSymNameOrId = cdSymNameOrId.toLowerCase();
            this.locale = locale;
        }
    }
}

