/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.SpillStreamFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class MemoryThenFileSpillStreamFactory
implements SpillStreamFactory {
    private SwitchableOutputStream sos = null;
    private final int estimatedCapacity;
    private final int cutoverCapacity;
    private final File directory;

    private static InputStream openPrivilegedFileInputStream(final File theFile) throws Throwable {
        PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return new FileInputStream(theFile);
            }
        };
        try {
            return (InputStream)AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    private static OutputStream openPrivilegedFileOutputStream(final File theFile) throws Throwable {
        PrivilegedExceptionAction pea = new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return new FileOutputStream(theFile);
            }
        };
        try {
            return (OutputStream)AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    public MemoryThenFileSpillStreamFactory(int estimatedCapacity, int cutoverCapacity, File directory) {
        this.estimatedCapacity = estimatedCapacity;
        this.cutoverCapacity = cutoverCapacity;
        this.directory = directory;
    }

    public SpillStreamFactory getInstance() {
        return new MemoryThenFileSpillStreamFactory(this.estimatedCapacity, this.cutoverCapacity, this.directory);
    }

    public OutputStream getOutputStream() {
        ByteArrayOutputStream baos = null;
        baos = this.estimatedCapacity > 0 ? new ByteArrayOutputStream(this.estimatedCapacity) : new ByteArrayOutputStream();
        this.sos = new SwitchableOutputStream(baos, this.cutoverCapacity, this.directory);
        return this.sos;
    }

    public InputStream getInputStream() throws IOException {
        if (this.sos == null) {
            IllegalStateException ise = new IllegalStateException("Must call getOutputStream before getInputStream");
            IOException ioe = new IOException();
            ioe.initCause(ise);
            throw ioe;
        }
        OutputStream out = this.sos.getStream();
        this.sos.close();
        out.close();
        if (out instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)out;
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            return bais;
        }
        if (out instanceof FileOutputStream) {
            InputStream fis;
            File theFile = this.sos.getFile();
            try {
                fis = MemoryThenFileSpillStreamFactory.openPrivilegedFileInputStream(theFile);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
            return new DeleteMeFileInputStream(fis, theFile);
        }
        IllegalStateException ise = new IllegalStateException(out.getClass().getName());
        IOException ioe = new IOException();
        ioe.initCause(ise);
        throw ioe;
    }

    public static final class SwitchableOutputStream
    extends FilterOutputStream {
        int count = 0;
        private final int maxCapacity;
        private final File directory;
        private File theFile = null;

        public SwitchableOutputStream(OutputStream out, int maxCapacity, File directory) {
            super(out);
            this.maxCapacity = maxCapacity;
            this.directory = directory;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.count += len;
            this.checkCapacity();
            super.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.count += b.length;
            this.checkCapacity();
            super.write(b);
        }

        public void write(int b) throws IOException {
            ++this.count;
            this.checkCapacity();
            super.write(b);
        }

        private OutputStream getStream() {
            return this.out;
        }

        private File getFile() {
            return this.theFile;
        }

        private void checkCapacity() throws IOException {
            if (this.out instanceof ByteArrayOutputStream && this.count > this.maxCapacity) {
                OutputStream theFos;
                this.theFile = this.directory != null ? File.createTempFile("spil", null, this.directory) : File.createTempFile("spil", null);
                this.theFile.deleteOnExit();
                try {
                    theFos = MemoryThenFileSpillStreamFactory.openPrivilegedFileOutputStream(this.theFile);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Throwable e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                ByteArrayOutputStream baos = (ByteArrayOutputStream)this.out;
                baos.writeTo(theFos);
                this.out = theFos;
            }
        }
    }

    public class DeleteMeFileInputStream
    extends FilterInputStream {
        private final File theFile;

        public DeleteMeFileInputStream(InputStream in, File theFile) {
            super(in);
            this.theFile = theFile;
        }

        public void close() throws IOException {
            this.deleteMeInTheEnd(-1);
            super.close();
        }

        public int read() throws IOException {
            return this.deleteMeInTheEnd(super.read());
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.deleteMeInTheEnd(super.read(b, off, len));
        }

        public int read(byte[] b) throws IOException {
            return this.deleteMeInTheEnd(super.read(b));
        }

        private int deleteMeInTheEnd(int count) throws IOException {
            if (count < 0) {
                super.close();
                this.theFile.delete();
            }
            return count;
        }
    }
}

