/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.util.ConfigValueLookup;
import java.io.IOException;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class MemoryAppender
extends RollingFileAppender {
    private int circularBufferSize = ConfigValueLookup.getValueAsInt("MaxMemoryAppenderBufferSize", 10000);
    private LoggingEvent[] buffer;
    private int start = 0;
    private int count = 0;

    public MemoryAppender() {
        this.buffer = new LoggingEvent[this.circularBufferSize];
    }

    public MemoryAppender(Layout layout, String filename, boolean append, int maxMemBuf) throws IOException {
        super(layout, filename, append);
        this.circularBufferSize = maxMemBuf;
        this.buffer = new LoggingEvent[maxMemBuf];
    }

    public MemoryAppender(Layout layout, String filename, boolean append) throws IOException {
        this(layout, filename, append, 10000);
    }

    public MemoryAppender(Layout layout, String filename) throws IOException {
        this(layout, filename, true, 10000);
    }

    public int getMemoryBufferSize() {
        return this.circularBufferSize;
    }

    public void setMemoryBufferSize(int bufferSize) {
        this.circularBufferSize = bufferSize;
    }

    public void initBuffer() {
        this.buffer = new LoggingEvent[this.circularBufferSize];
    }

    protected void subAppend(LoggingEvent event) {
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = event;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
        }
        if (this.containsThrowable(event)) {
            for (int i = 0; i < this.count; ++i) {
                int j = (this.start + i) % this.buffer.length;
                LoggingEvent logEvent = this.buffer[j];
                super.subAppend(logEvent);
            }
            this.start = 0;
            this.count = 0;
        }
    }

    private boolean containsThrowable(LoggingEvent event) {
        ThrowableInformation ti = event.getThrowableInformation();
        return ti != null;
    }
}

