/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LoggerMessageMap {
    public static final String ID_AUTOMATIC_UPGRADE_DOMAIN = "AU_DOMAIN";
    public static final String ID_AUTOMATIC_UPGRADE_OBJECTSTORE = "AU_OBJECTSTORE";
    public static final String ID_ASYNC_UPGRADE_OBJECTSTORE = "ASYNCUPGRADE_OBJECTSTORE";
    public static final int STATUS_IN_PROGRESS = 0;
    public static final int STATUS_COMPLETED = 1;
    public static final int STATUS_NOTAVAILABLE = 2;
    public static final int STATUS_ASYNC_UPGRADE_IN_PROGRESS = 3;
    public static final int STATUS_FAILED = 4;
    private static final int MESSAGETYPE_SCHEMA_REVISION = 0;
    public static final String PATH_DELIMITER = "\\";
    private static final boolean isTestMode = true;
    private static HashMap topLevelMap = new HashMap();
    private static HashMap statusMap = new HashMap();

    public static HashMap getDomainMassageMap() {
        return LoggerMessageMap.getMapFromPath(ID_AUTOMATIC_UPGRADE_DOMAIN);
    }

    public static HashMap getObjectStoreMassageMap() {
        return LoggerMessageMap.getMapFromPath(ID_AUTOMATIC_UPGRADE_OBJECTSTORE);
    }

    public static List getAllObjectStores() {
        ArrayList<String> osList = new ArrayList<String>();
        Object[] keyArray = statusMap.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            String key = (String)keyArray[i];
            if (key.indexOf(ID_AUTOMATIC_UPGRADE_OBJECTSTORE) < 0) continue;
            osList.add(key.substring(key.lastIndexOf(PATH_DELIMITER) + 1));
        }
        return osList;
    }

    public static List getAllDomains() {
        ArrayList<String> osList = new ArrayList<String>();
        Object[] keyArray = statusMap.keySet().toArray();
        for (int i = 0; i < keyArray.length; ++i) {
            String key = (String)keyArray[i];
            if (key.indexOf(ID_AUTOMATIC_UPGRADE_DOMAIN) < 0) continue;
            osList.add(key.substring(key.lastIndexOf(PATH_DELIMITER) + 1));
        }
        return osList;
    }

    protected static HashMap getDomainMassageMap(String domainName) {
        return LoggerMessageMap.getMapFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_DOMAIN, domainName}));
    }

    protected static HashMap getObjectStoreMassageMap(String domainName, String objectStoreName) {
        return LoggerMessageMap.getMapFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, domainName, objectStoreName}));
    }

    public static int getDomainUpgradeStatus(String domainName) {
        return LoggerMessageMap.getStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_DOMAIN, domainName}));
    }

    public static void setDomainUpgradeStatus(String domainName, int status) {
        LoggerMessageMap.updateStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_DOMAIN, domainName}), status);
    }

    public static int getObjectStoreUpgradeStatus(String osName) {
        return LoggerMessageMap.getStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osName}));
    }

    public static void setObjectStoreUpgradeStatus(String osName, int status) {
        LoggerMessageMap.updateStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osName}), status);
    }

    public static int getObjectStoreAsyncUpgradeStatus(String osName) {
        return LoggerMessageMap.getStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_ASYNC_UPGRADE_OBJECTSTORE, osName}));
    }

    public static void setObjectStoreAsyncUpgradeStatus(String osName, int status) {
        LoggerMessageMap.updateStatusFromPath(LoggerMessageMap.buildPath(new String[]{ID_ASYNC_UPGRADE_OBJECTSTORE, osName}), status);
    }

    public static String getObjectStoreSchemaRevision(String osName) {
        return LoggerMessageMap.getMessageStringFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osName}), 0);
    }

    public static void setObjectStoreSchemaRevision(String osName, String schemaRevision) {
        LoggerMessageMap.updateMessageStringFromPath(LoggerMessageMap.buildPath(new String[]{ID_AUTOMATIC_UPGRADE_OBJECTSTORE, osName}), 0, schemaRevision);
    }

    public static String buildPath(String[] orderedElementNameArray) {
        String result = "";
        if (orderedElementNameArray == null || orderedElementNameArray.length == 0) {
            return null;
        }
        if (orderedElementNameArray.length == 1) {
            return orderedElementNameArray[0];
        }
        for (int i = 0; i < orderedElementNameArray.length - 1; ++i) {
            result = result + orderedElementNameArray[i] + PATH_DELIMITER;
        }
        return result + orderedElementNameArray[orderedElementNameArray.length - 1];
    }

    public static HashMap getMapFromPath(String path) {
        HashMap currentMap = topLevelMap;
        StringTokenizer st = new StringTokenizer(path, PATH_DELIMITER);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (!currentMap.containsKey(key)) {
                HashMap newMap = new HashMap();
                currentMap.put(key, newMap);
                currentMap = newMap;
                continue;
            }
            currentMap = (HashMap)currentMap.get(key);
        }
        return currentMap;
    }

    public static int getStatusFromPath(String path) {
        if (!statusMap.containsKey(path)) {
            throw new NoSuchElementException("Failed to find status from path: " + path);
        }
        return ((NodeStatus)statusMap.get(path)).getStatus();
    }

    public static void updateStatusFromPath(String path, int newStatus) {
        NodeStatus ns = (NodeStatus)statusMap.get(path);
        if (ns == null) {
            ns = new NodeStatus();
            statusMap.put(path, ns);
        }
        ns.setStatus(newStatus);
    }

    public static String getMessageStringFromPath(String path, int messageType) {
        if (!statusMap.containsKey(path)) {
            throw new NoSuchElementException("Failed to find message from path: " + path);
        }
        return ((NodeStatus)statusMap.get(path)).getMessageString(messageType);
    }

    public static void updateMessageStringFromPath(String path, int messageType, String newMessage) {
        NodeStatus ns = (NodeStatus)statusMap.get(path);
        if (ns == null) {
            ns = new NodeStatus();
            statusMap.put(path, ns);
        }
        ns.setMessageString(messageType, newMessage);
    }

    private LoggerMessageMap() {
    }

    public static void runTest(int mode) {
        topLevelMap.clear();
        statusMap.clear();
        switch (mode) {
            case 0: {
                LoggerMessageMap.setDomainUpgradeStatus("Domain1", 0);
                break;
            }
            case 1: {
                String domainName = "Domain1";
                LoggerMessageMap.setDomainUpgradeStatus(domainName, 0);
                LoggerMessageMap.addTestMessage(domainName, LoggerMessageMap.getDomainMassageMap());
                break;
            }
            case 2: {
                LoggerMessageMap.setDomainUpgradeStatus("Domain1", 1);
                LoggerMessageMap.setObjectStoreUpgradeStatus("os111", 0);
                LoggerMessageMap.setObjectStoreUpgradeStatus("os222", 1);
                LoggerMessageMap.setObjectStoreUpgradeStatus("reallyreallyreallyreallylongnameOS", 0);
                break;
            }
            case 3: {
                LoggerMessageMap.setDomainUpgradeStatus("Domain1", 1);
                LoggerMessageMap.setObjectStoreUpgradeStatus("os111", 0);
                LoggerMessageMap.setObjectStoreUpgradeStatus("os222", 1);
                LoggerMessageMap.setObjectStoreUpgradeStatus("reallyreallyreallyreallylongnameOS", 0);
                LoggerMessageMap.addTestMessage("os111", LoggerMessageMap.getObjectStoreMassageMap());
                break;
            }
            case 4: {
                LoggerMessageMap.setDomainUpgradeStatus("Domain1", 1);
                LoggerMessageMap.setObjectStoreUpgradeStatus("os111", 0);
                LoggerMessageMap.setObjectStoreUpgradeStatus("os222", 1);
                LoggerMessageMap.setObjectStoreUpgradeStatus("os333", 0);
                LoggerMessageMap.setObjectStoreUpgradeStatus("reallyreallyreallyreallylongnameOS", 0);
                LoggerMessageMap.setObjectStoreAsyncUpgradeStatus("os222", 2);
                LoggerMessageMap.addTestMessage("os111", LoggerMessageMap.getObjectStoreMassageMap());
            }
        }
    }

    private static void addTestMessage(String name, HashMap map) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("2009-03-10T00:58:59.937Z 802284C6 ENG  FNRCE0000D - DEBUG Calling loadClass(): FolderManager.");
        messages.add("2009-03-10T00:59:00.390Z 802284C6 ENG  FNRCE0000E - ERROR E_OBJECT_NOT_FOUND: Requested item not found. object identity classId=Document&objectId={001231BE-C469-56DA-9156-889703BDA6A0}&objectStore={F2B43EE3-2AE5-4DF1-8075-2D0CB951918B} class name Document.");
        messages.add("2009-03-10T00:59:00.578Z 802284C6 ENG  FNRCE0000W - WARN Missing locale-specific string for locale 'hr' and key 'PROP_DatabaseUserName_DESC'.  Using 'en-us' locale instead.");
        messages.add("2009-03-10T01:01:03.984Z 000352EC ENG  FNRCE0000I - INFO ObjectStoreUpgrade(null) releasing memory used by auto-upgrade.");
        map.put(name, messages);
    }

    private static class NodeStatus {
        private int status;
        private HashMap messageMap = new HashMap();

        public NodeStatus() {
            this.status = 0;
        }

        public NodeStatus(int initStatus) {
            this.status = initStatus;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int newStatus) {
            this.status = newStatus;
        }

        public String getMessageString(int messageType) {
            return (String)this.messageMap.get(new Integer(messageType));
        }

        public void setMessageString(int messageType, String value) {
            this.messageMap.put(new Integer(messageType), value);
        }
    }
}

