/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class LocaleUtils {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(LocaleUtils.class, SubSystem.API);
    private static Pattern primaryTag = Pattern.compile("[ix]|[a-zA-Z]{2,3}");
    private static Pattern subTag = Pattern.compile("[a-zA-Z0-9]{2,8}");
    private static Pattern separator = Pattern.compile("[_-]");
    private static Map locales = new HashMap();
    private static final String FALLBACK_LOCALE = "en-us";
    private static String defaultLocaleName = ConfigValueLookup.getValue("com.filenet.engine.init.DefaultLocale", "en-us");

    private LocaleUtils() {
    }

    public static String[] validateLocaleName(String localeName, boolean forPersistence) {
        if (localeName == null) {
            return null;
        }
        String[] localeParts = new String[]{null, null};
        String[] s = separator.split(localeName);
        boolean matches = true;
        for (int i = 0; i < s.length && matches; ++i) {
            if (i == 0) {
                if (s[0].length() > 0) {
                    matches = primaryTag.matcher(s[0]).matches();
                    if (!matches) continue;
                    localeParts[0] = s[0].toLowerCase();
                    continue;
                }
                if (forPersistence) {
                    matches = false;
                    continue;
                }
                if (defaultLocaleName == null) continue;
                localeParts = separator.split(defaultLocaleName);
                continue;
            }
            if (s[i].length() <= 0 || !(matches = subTag.matcher(s[i]).matches()) || i != 1) continue;
            localeParts[1] = s[1].toLowerCase();
        }
        if (localeParts[0] != null && localeParts[0].length() == 1 && localeParts[1] == null) {
            matches = false;
        }
        if (!matches) {
            if (localeName.equals("C")) {
                localeParts[0] = Locale.getDefault().getLanguage().toLowerCase();
                localeParts[1] = Locale.getDefault().getCountry().toLowerCase();
                matches = true;
            } else {
                localeParts = null;
            }
        }
        return localeParts;
    }

    public static String[] validateLocaleName(String localeName) {
        if (locales.containsKey(localeName)) {
            return (String[])locales.get(localeName);
        }
        String[] localeParts = LocaleUtils.validateLocaleName(localeName, false);
        locales.put(localeName, localeParts);
        return localeParts;
    }

    public static Locale fromString(String localeString) {
        String[] localeParts = LocaleUtils.validateLocaleName(localeString);
        if (localeParts == null) {
            throw new EngineRuntimeException(ExceptionCode.E_INVALID_LOCALE_FORMAT, new Object[]{localeString});
        }
        Locale loc = localeParts[1] != null ? new Locale(localeParts[0], localeParts[1]) : new Locale(localeParts[0]);
        return loc;
    }

    public static String getDefaultLocaleName() {
        return defaultLocaleName;
    }

    public static String toXmlLanguageTag(Locale locale) {
        if (locale == null) {
            return null;
        }
        String language = locale.getLanguage();
        String region = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer out = new StringBuffer(language);
        if (region != null && region.length() > 0) {
            out.append('-').append(region);
        }
        if (variant != null && variant.length() > 0) {
            out.append('-').append(variant);
        }
        return out.toString();
    }

    static {
        String[] localeParts = LocaleUtils.validateLocaleName(defaultLocaleName, true);
        if (!defaultLocaleName.equalsIgnoreCase(FALLBACK_LOCALE)) {
            if (localeParts == null || localeParts[0] == null || localeParts[0].length() == 0) {
                logger.warn("DefaultLocale value of '" + defaultLocaleName + "' is not valid.  Using '" + FALLBACK_LOCALE + "'.");
                defaultLocaleName = FALLBACK_LOCALE;
                localeParts = LocaleUtils.validateLocaleName(defaultLocaleName, true);
            } else {
                defaultLocaleName = localeParts[1] != null && localeParts[1].length() > 0 ? localeParts[0] + "-" + localeParts[1] : localeParts[0];
                logger.info("Using default locale value of '" + defaultLocaleName + "'.");
            }
        }
    }
}

