/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.SubSystem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class J2EEUtilWS
extends J2EEUtil {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(J2EEUtilWS.class, SubSystem.API);
    private static final String[] WS_J2CCF_JNDI_LIST = new String[]{"eis/com.filenet.apiimpl.transport.ConnectionFactory"};
    private static String WS_J2CCF_JNDI = null;
    private static Class doAsClass;
    private static Method doAsMethod;
    private static Method getSubjectMethod;

    private static void handleException(Throwable e) {
        Throwable cause = e.getCause();
        if (cause instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)cause;
        }
        if (e instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)e;
        }
        if (e instanceof InvocationTargetException && cause instanceof RuntimeException && cause.getCause() instanceof EngineRuntimeException) {
            throw (EngineRuntimeException)cause.getCause();
        }
        throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
    }

    protected J2EEUtilWS() {
    }

    public String getTransactionManagerPath() {
        return null;
    }

    public UserTransaction getUserTransaction(Context cntx) {
        try {
            Context comp = (Context)cntx.lookup("jta");
            Object userTrans = comp.lookup("usertransaction");
            return (UserTransaction)userTrans;
        }
        catch (Throwable e) {
            J2EEUtilWS.handleException(e);
            return null;
        }
    }

    public synchronized TransactionManager getTransactionManager(Context cntx) {
        try {
            Class cl = TransactionManagerFactorySelector.tmfClass;
            Method method = cl.getMethod("getTransactionManager", null);
            Object tm = method.invoke(null, null);
            return (TransactionManager)tm;
        }
        catch (Throwable e) {
            J2EEUtilWS.handleException(e);
            return null;
        }
    }

    public String getLocalEnginePath() {
        return ConfigValueLookup.getValue("LocalEnginePath", "local:ejb/FileNet/Engine");
    }

    public String getLocalEngineCorePath() {
        return "java:comp/env/EngineCoreLocal";
    }

    public String getLocalEngineContentPath() {
        return ConfigValueLookup.getValue("LocalContentPath", "local:ejb/FileNet/EngineContent");
    }

    public String getLocalEngineContentCorePath() {
        return "java:comp/env/EngineContentCoreLocal";
    }

    public Object doAs(Subject sub, PrivilegedExceptionAction pa) {
        try {
            return doAsMethod.invoke(null, sub, pa);
        }
        catch (Exception e) {
            J2EEUtilWS.handleException(e);
            return null;
        }
    }

    public Subject getCurrentSubject() {
        Subject sub = super.getCurrentSubject();
        if (sub == null) {
            try {
                sub = (Subject)getSubjectMethod.invoke(null, null);
            }
            catch (Exception e) {
                J2EEUtilWS.handleException(e);
            }
        }
        return sub;
    }

    public String getJaasContextFile() {
        return "jaas.conf.WebSphere";
    }

    public String getLocalJ2CConnectionFactoryPath() {
        if (WS_J2CCF_JNDI == null) {
            for (int i = 0; i < WS_J2CCF_JNDI_LIST.length; ++i) {
                try {
                    Object context = new InitialContext().lookup(WS_J2CCF_JNDI_LIST[i]);
                    WS_J2CCF_JNDI = WS_J2CCF_JNDI_LIST[i];
                    break;
                }
                catch (Throwable t) {
                    WS_J2CCF_JNDI = null;
                    continue;
                }
            }
            if (WS_J2CCF_JNDI == null) {
                WS_J2CCF_JNDI = super.getLocalJ2CConnectionFactoryPath();
            }
        }
        return WS_J2CCF_JNDI;
    }

    public void initializeORB() {
        J2EEUtilWS.initializeORBInternal();
    }

    private static void initializeORBInternal() {
        try {
            InitialContext ic = J2EEUtil.getInitialContextWithParameters(null);
            ic.lookup("");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Class[] args = new Class[]{Subject.class, PrivilegedExceptionAction.class};
        try {
            doAsClass = Class.forName("com.ibm.websphere.security.auth.WSSubject");
            doAsMethod = doAsClass.getDeclaredMethod("doAs", args);
            getSubjectMethod = doAsClass.getDeclaredMethod("getCallerSubject", null);
            J2EEUtilWS.initializeORBInternal();
        }
        catch (Throwable e) {
            J2EEUtilWS.handleException(e);
        }
    }

    private static class TransactionManagerFactorySelector {
        private static final String WSTMF_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
        private static final String WSTMF_CLASS_5_0 = "com.ibm.ejs.jts.jta.TransactionManagerFactory";
        private static final String WSTMF_CLASS_4 = "com.ibm.ejs.jts.jta.JTSXA";
        private static Class tmfClass = null;
        private static Exception savedEx = null;

        private TransactionManagerFactorySelector() {
        }

        private static Class getTransactionManagerFactoryClass(String factoryClass, String versionNumber) {
            try {
                return Class.forName(factoryClass);
            }
            catch (Exception ex) {
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("Could not find WebSphere " + versionNumber + " TransactionManagerFactory class " + factoryClass + ".");
                }
                if (savedEx == null) {
                    savedEx = ex;
                }
                return null;
            }
        }

        static {
            tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_5_1, "5.1");
            if (tmfClass == null) {
                tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_5_0, "5.0");
            }
            if (tmfClass == null) {
                tmfClass = TransactionManagerFactorySelector.getTransactionManagerFactoryClass(WSTMF_CLASS_4, "4");
            }
            if (tmfClass == null) {
                throw new EngineRuntimeException(savedEx, ExceptionCode.E_CLASS_LOADING_ERROR, new Object[]{"com.ibm.ws.Transaction.TransactionManagerFactory, com.ibm.ejs.jts.jta.TransactionManagerFactory, com.ibm.ejs.jts.jta.JTSXA"});
            }
        }
    }
}

