/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.J2EEUtil;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import javax.naming.InitialContext;
import javax.security.auth.Subject;

public class J2EEUtilWL
extends J2EEUtil {
    private static Class runAsClass;
    private static Method getSubjectMethod;
    private static Method runAsMethod;

    protected J2EEUtilWL() {
    }

    public String getTransactionManagerPath() {
        return "javax/transaction/TransactionManager";
    }

    public String getUserTransactionPath() {
        return "javax/transaction/UserTransaction";
    }

    public Object doAs(Subject sub, PrivilegedExceptionAction pa) {
        try {
            return runAsMethod.invoke(null, sub, pa);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public Subject getCurrentSubject() {
        Subject sub = super.getCurrentSubject();
        if (sub == null) {
            try {
                sub = (Subject)getSubjectMethod.invoke(null, null);
            }
            catch (Exception e) {
                if (e.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)e.getCause();
                }
                if (e instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)e;
                }
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        }
        return sub;
    }

    public Object getMBeanServer() {
        try {
            Class<?> mbhomeCls = Class.forName("weblogic.management.MBeanHome");
            String mbhomeName = (String)mbhomeCls.getField("LOCAL_JNDI_NAME").get(null);
            Method getMBeanServerMethod = mbhomeCls.getDeclaredMethod("getMBeanServer", null);
            InitialContext ctx = J2EEUtil.getInitialContextWithParameters(null);
            Object mbhome = ctx.lookup(mbhomeName);
            return getMBeanServerMethod.invoke(mbhome, null);
        }
        catch (Exception ex) {
            throw new EngineRuntimeException(ex, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public String getJaasContextFile() {
        return "jaas.conf.WebLogic";
    }

    static {
        Class[] args = new Class[]{Subject.class, PrivilegedExceptionAction.class};
        try {
            runAsClass = Class.forName("weblogic.security.Security");
            runAsMethod = runAsClass.getDeclaredMethod("runAs", args);
            getSubjectMethod = runAsClass.getDeclaredMethod("getCurrentSubject", null);
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }
}

