/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.authentication.util.J2EEAuthnUtil;
import com.filenet.apiimpl.util.J2EEUtil;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public class J2EEUtilJB
extends J2EEUtil {
    private static Class getSubjectClass;
    private static Method getSubjectMethod;
    private static Method getPrincipalMethod;

    protected J2EEUtilJB() {
    }

    public Principal getCurrentPrincipalFromSecurityAssociation() {
        Principal prin = null;
        try {
            prin = (Principal)getPrincipalMethod.invoke(null, null);
        }
        catch (Exception e) {
            prin = null;
        }
        return prin;
    }

    public Subject getCurrentSubject() {
        Subject sub = super.getCurrentSubject();
        if (sub == null) {
            try {
                sub = (Subject)getSubjectMethod.invoke(null, null);
            }
            catch (Exception e) {
                if (e.getCause() instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)e.getCause();
                }
                if (e instanceof EngineRuntimeException) {
                    throw (EngineRuntimeException)e;
                }
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        }
        return sub;
    }

    public String getJaasContextFile() {
        return "jaas.conf.JBoss";
    }

    public Object doAs(Subject sub, PrivilegedExceptionAction pa) {
        try {
            return J2EEAuthnUtil.getInstance().runAs(sub, pa);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            if (t instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t;
            }
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    static {
        try {
            getSubjectClass = Class.forName("org.jboss.security.SecurityAssociation");
            getSubjectMethod = getSubjectClass.getDeclaredMethod("getSubject", null);
            getPrincipalMethod = getSubjectClass.getDeclaredMethod("getPrincipal", null);
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }
}

