/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.core.ConnectionImpl;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.J2EEUtilJB;
import com.filenet.apiimpl.util.J2EEUtilWL;
import com.filenet.apiimpl.util.J2EEUtilWS;
import com.filenet.apiimpl.util.SubSystem;
import com.filenet.ecm.wcm.utils.uAudit.UsageAuditor;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class J2EEUtil {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(J2EEUtil.class, SubSystem.API);
    static final String APPSERVER_WEBLOGIC = "WebLogic";
    static final String APPSERVER_WEBSPHERE = "WebSphere";
    static final String APPSERVER_JBOSS = "JBoss";
    static boolean canInstantiateInitialContext = false;
    private static J2EEUtil appServerUtilRef;
    private static String propFactory;

    protected J2EEUtil() {
    }

    public static final J2EEUtil getInstance() {
        return appServerUtilRef;
    }

    public void initializeORB() {
    }

    public Object doAs(Subject sub, PrivilegedExceptionAction pa) {
        try {
            return Subject.doAs(sub, pa);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t.getCause();
            }
            if (t instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t;
            }
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public Subject getCurrentSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    public String getTransactionManagerPath() {
        return "java:/TransactionManager";
    }

    public String getUserTransactionPath() {
        return "UserTransaction";
    }

    public UserTransaction getUserTransaction(Context cntx) {
        try {
            return (UserTransaction)cntx.lookup(this.getUserTransactionPath());
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public TransactionManager getTransactionManager(Context cntx) {
        try {
            return (TransactionManager)cntx.lookup(this.getTransactionManagerPath());
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public boolean isInGlobalTrans(Context cntx) {
        long t1 = System.currentTimeMillis();
        UserTransaction ut = this.getUserTransaction(cntx);
        try {
            boolean bl = ut.getStatus() != 6;
            return bl;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e.getCause();
            }
            if (e instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)e;
            }
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        finally {
            UsageAuditor.Instance().countIn("isInGlobalTransaction", System.currentTimeMillis() - t1, true);
        }
    }

    public Object getMBeanServer() {
        try {
            Class[] params = new Class[]{String.class};
            Object[] args = new Object[]{null};
            Class<?> MBeanServerFactoryClass = Class.forName("javax.management.MBeanServerFactory");
            Method findMBeanServerMethod = MBeanServerFactoryClass.getDeclaredMethod("findMBeanServer", params);
            ArrayList mbeanServers = (ArrayList)findMBeanServerMethod.invoke(null, args);
            return mbeanServers.get(0);
        }
        catch (Exception ex) {
            throw new EngineRuntimeException(ex, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public String getRemoteEnginePath() {
        return ConfigValueLookup.getValue("RemoteEnginePath", "FileNet/Engine");
    }

    public String getLocalEnginePath() {
        return ConfigValueLookup.getValue("LocalEnginePath", "FileNet/Local/Engine");
    }

    public String getLocalEngineCorePath() {
        return "FileNet/Local/EngineCore";
    }

    public String getLocalEngineContentPath() {
        return ConfigValueLookup.getValue("LocalContentPath", "FileNet/Local/EngineContent");
    }

    public String getRemoteEngineContentPath() {
        return ConfigValueLookup.getValue("RemoteContentPath", "FileNet/EngineContent");
    }

    public String getLocalEngineContentCorePath() {
        return "FileNet/Local/EngineContentCore";
    }

    public String getLocalEngineContentAffinityPath() {
        return ConfigValueLookup.getValue("LocalContentAffinityPath", "FileNet/Local/EngineContentAffinity");
    }

    public String getRemoteEngineContentAffinityPath() {
        return ConfigValueLookup.getValue("RemoteContentAffinityPath", "FileNet/EngineContentAffinity");
    }

    public String getLocalJ2CConnectionFactoryPath() {
        return "FileNet/Local/ConnectionFactory";
    }

    public Principal getCurrentPrincipal() {
        Subject sub = this.getCurrentSubject();
        if (sub == null || sub.getPrincipals() == null || sub.getPrincipals().isEmpty()) {
            return null;
        }
        Object[] principals = sub.getPrincipals().toArray();
        return (Principal)principals[0];
    }

    public boolean canInstantiateInitialContext() {
        return canInstantiateInitialContext;
    }

    public String getJaasContextFile() {
        return "jaas.conf.WSI";
    }

    private static void detectAllAppserversByInitialContextFactoryName(String initCntxFactory) {
        String J2EEUtilClass = null;
        try {
            J2EEUtilClass = "com.filenet.apiimpl.util.J2EEUtilWL";
            if (!J2EEUtil.detectAppserverByInitialContextFactoryName(APPSERVER_WEBLOGIC, J2EEUtilClass, initCntxFactory) && !J2EEUtil.detectAppserverByInitialContextFactoryName(APPSERVER_WEBSPHERE, J2EEUtilClass = "com.filenet.apiimpl.util.J2EEUtilWS", initCntxFactory)) {
                J2EEUtilClass = "com.filenet.apiimpl.util.J2EEUtilJB";
                J2EEUtil.detectAppserverByInitialContextFactoryName(APPSERVER_JBOSS, J2EEUtilClass, initCntxFactory);
            }
        }
        catch (Exception ex) {
            throw new EngineRuntimeException(ex, ExceptionCode.API_J2EE_UTIL_INIT_FAILED, new Object[]{J2EEUtilClass});
        }
    }

    private static boolean detectAppserverByInitialContextFactoryName(String appServerName, String J2EEUtilClass, String initCntxFactory) throws Exception {
        String appServer = appServerName.toLowerCase();
        if (initCntxFactory.indexOf(appServer) != -1 || appServer.equals("jboss") && initCntxFactory.indexOf("jnp") != -1) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Detected that the application server is " + appServerName + ": " + initCntxFactory);
            }
            Class<?> cl = Class.forName(J2EEUtilClass);
            appServerUtilRef = (J2EEUtil)cl.newInstance();
            return true;
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("Detected that the application server is NOT " + appServerName + ": " + initCntxFactory);
        }
        return false;
    }

    private static void detectAllAppServersByFixedClassNames() {
        String J2EEUtilClass = "com.filenet.apiimpl.util.J2EEUtilWS";
        String initCtxClass = "com.ibm.websphere.naming.WsnInitialContextFactory";
        if (J2EEUtil.detectAppServerByFixedClassName(APPSERVER_WEBSPHERE, J2EEUtilClass, initCtxClass)) {
            return;
        }
        J2EEUtilClass = "com.filenet.apiimpl.util.J2EEUtilWL";
        initCtxClass = "weblogic.jndi.WLInitialContextFactory";
        if (J2EEUtil.detectAppServerByFixedClassName(APPSERVER_WEBLOGIC, J2EEUtilClass, initCtxClass)) {
            return;
        }
        J2EEUtilClass = "com.filenet.apiimpl.util.J2EEUtilJB";
        initCtxClass = "org.jnp.interfaces.NamingContextFactory";
        if (J2EEUtil.detectAppServerByFixedClassName(APPSERVER_JBOSS, J2EEUtilClass, initCtxClass)) {
            return;
        }
    }

    private static boolean detectAppServerByFixedClassName(String appServer, String J2EEUtilClass, String initCntxFactory) {
        block6: {
            String initialContextParam = "java.naming.factory.initial";
            try {
                if (Class.forName(initCntxFactory) != null) {
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Detected that the application server is " + appServer + ".");
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail(appServer + " class " + initCntxFactory + " found defaulting the configuration to this application server");
                    }
                    if (logger.isDetailTraceEnabled()) {
                        logger.traceDetail("Defaulting " + initialContextParam + " to " + initCntxFactory);
                    }
                    canInstantiateInitialContext = true;
                    Class<?> cl = Class.forName(J2EEUtilClass);
                    appServerUtilRef = (J2EEUtil)cl.newInstance();
                    return true;
                }
            }
            catch (Throwable t) {
                if (!logger.isDetailTraceEnabled()) break block6;
                logger.traceDetail(appServer + " class " + initCntxFactory + " not used because of the following error: " + t.toString());
            }
        }
        return false;
    }

    private static String getInitialContextFactory() {
        String initCntxFactory;
        block3: {
            initCntxFactory = null;
            try {
                InitialContext context = J2EEUtil.getInitialContextWithParameters(null);
                initCntxFactory = (String)context.getEnvironment().get("java.naming.factory.initial");
                if (initCntxFactory != null) {
                    canInstantiateInitialContext = true;
                }
            }
            catch (Throwable ex) {
                if (!logger.isDetailTraceEnabled()) break block3;
                logger.traceDetail("getInitialContextFactory() failed because of the following error: " + ex.toString());
            }
        }
        return initCntxFactory;
    }

    public static InitialContext getInitialContextWithParameters(ConnectionImpl conn) throws NamingException {
        Properties jndiEnvironment = J2EEUtil.getEJBJndiEnvironment(conn);
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("J2EEUtil.getInitialContextWithParameters JNDI Environment (a): " + jndiEnvironment);
        }
        if (jndiEnvironment == null) {
            jndiEnvironment = new Properties();
        }
        if (jndiEnvironment.size() == 0) {
            block16: {
                if (propFactory == null) {
                    try {
                        InitialContext ic = new InitialContext();
                        propFactory = (String)ic.getEnvironment().get("java.naming.factory.initial");
                    }
                    catch (NoInitialContextException noic) {
                        if (!logger.isDetailTraceEnabled()) break block16;
                        logger.traceDetail("J2EEUtil.getInitialContextWithParameters caught and ignored (harmless): " + noic);
                    }
                }
            }
            if (propFactory == null && appServerUtilRef != null) {
                if (appServerUtilRef instanceof J2EEUtilWS) {
                    propFactory = "com.ibm.websphere.naming.WsnInitialContextFactory";
                } else if (appServerUtilRef instanceof J2EEUtilWL) {
                    propFactory = "weblogic.jndi.WLInitialContextFactory";
                } else if (appServerUtilRef instanceof J2EEUtilJB) {
                    propFactory = "org.jnp.interfaces.NamingContextFactory";
                }
                if (logger.isDetailTraceEnabled()) {
                    logger.traceDetail("J2EEUtil.getInitialContextWithParameters forced java.naming.factory.initial: " + propFactory);
                }
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("J2EEUtil.getInitialContextWithParameters computed java.naming.factory.initial: " + propFactory);
            }
            if (propFactory != null) {
                jndiEnvironment.put("java.naming.factory.initial", propFactory);
            }
        }
        if (logger.isDetailTraceEnabled()) {
            logger.traceDetail("J2EEUtil.getInitialContextWithParameters JNDI Environment (b): " + jndiEnvironment);
        }
        InitialContext initialContext = new InitialContext(jndiEnvironment);
        return initialContext;
    }

    public static Properties getEJBJndiEnvironment(ConnectionImpl conn) {
        URI connURI;
        String providerPropertyValue;
        String propsAsString;
        Object propsAsParameter = null;
        if (conn != null) {
            propsAsParameter = conn.getParameter(ConfigurationParameter.EJB_CONTEXT_PROPERTIES);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Connection-specific FileNet.EJB.ContextProperties: " + propsAsParameter);
            }
        }
        if (propsAsParameter == null) {
            propsAsParameter = ConfigValueLookup.getValue("FileNet.EJB.ContextProperties", null);
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("JVM global FileNet.EJB.ContextProperties: " + propsAsParameter);
            }
        }
        try {
            propsAsString = (String)propsAsParameter;
        }
        catch (ClassCastException e) {
            throw new EngineRuntimeException(e, ExceptionCode.API_INVALID_CONFIGURATION_PARAMETER, new Object[]{"FileNet.EJB.ContextProperties"});
        }
        Properties env = new Properties();
        if (propsAsString != null) {
            try {
                env.load(new ByteArrayInputStream(propsAsString.getBytes("ISO-8859-1")));
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.API_INVALID_CONFIGURATION_PARAMETER, new Object[]{"FileNet.EJB.ContextProperties"}, ExceptionContext.API_INVALID_CONFIGURATION_PARAMETER_STRING_VALUE, new Object[]{"java.util.Properties", propsAsString});
            }
        }
        if ((providerPropertyValue = (String)env.get("java.naming.provider.url")) != null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("FileNet.EJB.ContextProperties has java.naming.provider.url=" + providerPropertyValue);
            }
            if (providerPropertyValue.equals("!")) {
                env.remove("java.naming.provider.url");
            }
        } else if (conn != null && (connURI = conn.getAsURI()) != null && connURI.isAbsolute()) {
            String origURI = conn.getURI();
            String authority = connURI.getAuthority();
            if (authority != null) {
                String scheme = connURI.getScheme();
                providerPropertyValue = scheme + "://" + authority;
            } else {
                int firstSlash = origURI.indexOf(47);
                providerPropertyValue = origURI;
                if (firstSlash > 0) {
                    providerPropertyValue = origURI.substring(0, firstSlash);
                }
            }
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("Reducing " + origURI + " to " + "java.naming.provider.url" + "=" + providerPropertyValue);
            }
            env.setProperty("java.naming.provider.url", providerPropertyValue);
        }
        return env;
    }

    static {
        if (appServerUtilRef == null) {
            String initCntxFactory = J2EEUtil.getInitialContextFactory();
            if (appServerUtilRef == null && initCntxFactory != null) {
                J2EEUtil.detectAllAppserversByInitialContextFactoryName(initCntxFactory);
            }
        }
        if (appServerUtilRef == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("JNDI did not reveal an appserver, so looking for known classes on the classpath");
            }
            J2EEUtil.detectAllAppServersByFixedClassNames();
        }
        if (appServerUtilRef == null) {
            if (logger.isDetailTraceEnabled()) {
                logger.traceDetail("The code has NOT detected a need to introduce specific application server logic and is defaulting to using standard J2EE calls");
            }
            appServerUtilRef = new J2EEUtil();
        }
        propFactory = null;
    }
}

