/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.authentication.util.AuthnUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class J2EEType {
    public static final int APP_SERVER_UNDETERMINED = 0;
    public static final int APP_SERVER_UNKNOWN = 1;
    public static final int APP_SERVER_JBOSS = 2;
    public static final int APP_SERVER_WEBLOGIC = 3;
    public static final int APP_SERVER_WEBSPHERE = 4;
    public static final int APP_SERVER_ORACLE = 5;
    public static final String APP_SERVER_PROP_NAME = "com.filenet.AppServer";
    public static final String APP_SERVER_TYPE_PROP = "FileNet.properties";
    private static int appServerType;
    private static String providerURL;
    public static final String[] APP_SERVER_NAMES;
    private static final String FNAME = "[J2EEType] ";
    private static final AppInfo[] appInfo;

    private J2EEType() {
    }

    public static int getAppServerType() {
        if (appServerType == 0) {
            appServerType = AppTypeFinder.innerAppServerType;
        }
        return appServerType;
    }

    public static void setAppServerType(int type) {
        if (type < 0 || type >= APP_SERVER_NAMES.length) {
            throw new IllegalArgumentException();
        }
        appServerType = type;
    }

    public static String getAppServer() {
        return APP_SERVER_NAMES[appServerType];
    }

    public static void setAppServer(String str) {
        int type = J2EEType.findType(str);
        if (type == 0 && str != null) {
            throw new IllegalArgumentException();
        }
        appServerType = type;
    }

    public static String getProviderURL() {
        if (providerURL == null) {
            providerURL = URLFinder.innerProviderURL;
        }
        return providerURL;
    }

    public static void setProviderURL(String url) {
        providerURL = url;
    }

    public static boolean isInitialContextOk() {
        return InitialContextFinder.innerAppServerType != 0;
    }

    private static int findType(String str) {
        int type = 0;
        if (str != null) {
            str = str.toLowerCase(Locale.US);
            for (int i = 0; i < appInfo.length; ++i) {
                if (str.indexOf(J2EEType.appInfo[i].matchString) < 0) continue;
                type = J2EEType.appInfo[i].appType;
                break;
            }
        }
        return type;
    }

    public static InitialContext reflective_J2EEUtil_getInitialContextWithParameters() throws NamingException {
        return J2EEType.reflective_J2EEUtil_getInitialContextWithParameters(null);
    }

    public static InitialContext reflective_J2EEUtil_getInitialContextWithParameters(String factory) throws NamingException {
        try {
            Class<?> j2eeUtilClass = Class.forName("com.filenet.apiimpl.util.J2EEUtil");
            Class<?> connClass = Class.forName("com.filenet.apiimpl.core.ConnectionImpl");
            Method gICWP = j2eeUtilClass.getDeclaredMethod("getEJBJndiEnvironment", connClass);
            Properties env = (Properties)gICWP.invoke(null, new Object[]{null});
            if (factory != null) {
                if (env == null) {
                    env = new Properties();
                }
                env.put("java.naming.factory.initial", factory);
            }
            return new InitialContext(env);
        }
        catch (Throwable t) {
            return new InitialContext();
        }
    }

    private static final String getPrivilegedProperty(final String propertyName) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        };
        try {
            return (String)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    static {
        APP_SERVER_NAMES = new String[]{"undetermined", "unknown", "JBoss", "WebLogic", "WebSphere", "Oracle"};
        appInfo = new AppInfo[]{new AppInfo("weblogic", 3, "weblogic.jndi.WLInitialContextFactory"), new AppInfo("websphere", 4, "com.ibm.websphere.naming.WsnInitialContextFactory"), new AppInfo(".jnp.", 2, "org.jnp.interfaces.NamingContextFactory"), new AppInfo("jboss", 2, null), new AppInfo("oracle", 5, "oracle.j2ee.rmi.RMIInitialContextFactory")};
    }

    private static class InitialContextFinder {
        static int innerAppServerType;
        static String innerProviderURL;

        private InitialContextFinder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void tryInitialContext(String factory) {
            InitialContext context = null;
            try {
                context = J2EEType.reflective_J2EEUtil_getInitialContextWithParameters(factory);
                Hashtable<?, ?> env = context.getEnvironment();
                innerProviderURL = (String)env.get("java.naming.provider.url");
                String initCntxFactory = (String)env.get("java.naming.factory.initial");
                innerAppServerType = J2EEType.findType(initCntxFactory);
                if (innerAppServerType == 4) {
                    context.lookup("");
                }
            }
            catch (Exception e) {
                AuthnUtil.warn("[J2EEType] InitialContext failed: " + e.getLocalizedMessage());
            }
            finally {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        static {
            InitialContextFinder.tryInitialContext(null);
            if (innerAppServerType == 0) {
                for (int i = 0; i < appInfo.length; ++i) {
                    if (appInfo[i].defaultClass == null) continue;
                    try {
                        Class<?> c = Class.forName(appInfo[i].defaultClass);
                        if (c == null) continue;
                        innerAppServerType = appInfo[i].appType;
                        InitialContextFinder.tryInitialContext(appInfo[i].defaultClass);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (innerAppServerType == 0) {
                innerAppServerType = 1;
                AuthnUtil.error("app server not known");
            }
        }
    }

    private static class URLFinder {
        static String innerProviderURL = J2EEType.access$000("java.naming.provider.url");

        private URLFinder() {
        }

        static {
            if (innerProviderURL == null) {
                innerProviderURL = InitialContextFinder.innerProviderURL;
            }
        }
    }

    private static class AppTypeFinder {
        static int innerAppServerType = 0;

        private AppTypeFinder() {
        }

        static {
            innerAppServerType = J2EEType.findType(J2EEType.getPrivilegedProperty(J2EEType.APP_SERVER_PROP_NAME));
            if (innerAppServerType == 0) {
                innerAppServerType = J2EEType.findType(J2EEType.getPrivilegedProperty("java.naming.factory.initial"));
            }
            if (innerAppServerType == 0) {
                try {
                    Properties props = new Properties();
                    URL url = ClassLoader.getSystemResource(J2EEType.APP_SERVER_TYPE_PROP);
                    props.load(url.openStream());
                    innerAppServerType = J2EEType.findType(props.getProperty(J2EEType.APP_SERVER_PROP_NAME));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (innerAppServerType == 0) {
                innerAppServerType = InitialContextFinder.innerAppServerType;
            }
        }
    }

    private static class AppInfo {
        String matchString;
        int appType;
        String defaultClass;

        AppInfo(String matchString, int appType, String defaultClass) {
            this.matchString = matchString;
            this.appType = appType;
            this.defaultClass = defaultClass;
        }
    }
}

