/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.action.Create;
import com.filenet.api.action.PendingAction;
import com.filenet.api.admin.AuditDefinition;
import com.filenet.api.admin.Choice;
import com.filenet.api.admin.ClassDefinition;
import com.filenet.api.admin.LocalizedString;
import com.filenet.api.admin.PropertyDefinition;
import com.filenet.api.admin.PropertyTemplate;
import com.filenet.api.collection.AuditDefinitionList;
import com.filenet.api.collection.LocalizedStringList;
import com.filenet.api.collection.MarkingSetSet;
import com.filenet.api.collection.PermissionList;
import com.filenet.api.collection.PropertyDefinitionList;
import com.filenet.api.collection.PropertyTemplateSet;
import com.filenet.api.constants.AccessType;
import com.filenet.api.constants.AutoClassify;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.CheckinType;
import com.filenet.api.constants.PermissionSource;
import com.filenet.api.constants.RefreshMode;
import com.filenet.api.constants.ReservationType;
import com.filenet.api.constants.SecurityPrincipalType;
import com.filenet.api.constants.SpecialPrincipal;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.ContentTransfer;
import com.filenet.api.core.Document;
import com.filenet.api.core.Domain;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentObject;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.core.Scope;
import com.filenet.api.events.DocumentState;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.ClassDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.security.AccessPermission;
import com.filenet.api.security.MarkingSet;
import com.filenet.api.security.SecurityTemplate;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.core.IndependentlyPersistableObjectImpl;
import com.filenet.apiimpl.exception.CompatibilityException;
import com.filenet.apiimpl.exception.ExceptionContext;
import com.filenet.apiimpl.util.Base64;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.CachePropIE;
import com.filenet.apiimpl.util.CachePropertiesIE;
import com.filenet.apiimpl.util.ImportExportUtil;
import com.filenet.apiimpl.util.MetadataCacheIE;
import com.filenet.apiimpl.util.SubSystem;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class ImportXML {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ImportXML.class, SubSystem.API);
    private static boolean existingObject = false;

    public static Object importObject(Domain domain, ObjectStore objectStore, Object importSource, Object optFlags) {
        if (importSource == null || !(importSource instanceof Element)) {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
        }
        int flags = 0;
        if (ImportExportUtil.isOptionalParamPresent(optFlags)) {
            flags = (Integer)optFlags;
        }
        MetadataCacheIE.setLocalDomain(domain);
        Object importedObject = null;
        if (importSource instanceof String) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = null;
            org.w3c.dom.Document importDOMDoc = null;
            try {
                parser = factory.newDocumentBuilder();
                InputSource inputStream = new InputSource(ImportExportUtil.loadXMLFile((String)importSource));
                importDOMDoc = parser.parse(inputStream);
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
            Element docElem = importDOMDoc.getDocumentElement();
            importedObject = ImportXML.importObject(objectStore, docElem, flags);
        } else if (importSource instanceof Element) {
            importedObject = ImportXML.importObject(objectStore, (Element)importSource, flags);
        } else {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_OR_INVALID_PARAM_VALUE, "importSource");
        }
        return importedObject;
    }

    public static void importManifest(Domain domain, ObjectStore objectStore, Object importManifest, Object errReport, Object optFlags) {
        int flags = 0;
        if (ImportExportUtil.isOptionalParamPresent(optFlags)) {
            flags = (Integer)optFlags;
        }
        MetadataCacheIE.setLocalDomain(domain);
        Element domNode = null;
        if (importManifest instanceof org.w3c.dom.Document) {
            domNode = ((org.w3c.dom.Document)importManifest).getDocumentElement();
        } else if (importManifest instanceof Element) {
            domNode = (Element)importManifest;
        } else {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
        }
        ImportXML.importManifest(objectStore, domNode, errReport, flags);
    }

    private static void importManifest(ObjectStore objectStore, Element domNode, Object errReport, int flags) {
        if (domNode == null) {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
        }
        NodeList importManifest = domNode.getChildNodes();
        int length = importManifest.getLength();
        for (int i = 0; i < length; ++i) {
            if (importManifest.item(i).getNodeType() == 3) continue;
            Node objectManifest = importManifest.item(i);
            String manifestName = objectManifest.getNodeName();
            boolean isClassDef = false;
            if (manifestName.equalsIgnoreCase("ClassDefinitions")) {
                isClassDef = true;
            }
            if (manifestName.equalsIgnoreCase("Documents")) {
                ImportXML.importDocuments(objectStore, objectManifest, flags, errReport);
                continue;
            }
            NodeList importObjects = objectManifest.getChildNodes();
            int size = importObjects.getLength();
            for (int j = 0; j < size; ++j) {
                if (importObjects.item(j).getNodeType() == 3) continue;
                Node importObject = importObjects.item(j);
                try {
                    Object newObj = ImportXML.importObject(objectStore, (Element)importObject, flags);
                    if (newObj == null) {
                        if ((flags & 0x200) != 0) {
                            throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null, ExceptionContext.E_IMPORT_RETURNED_NULL, new Object[]{((Element)importObject).getNodeName()});
                        }
                        ImportXML.createXMLErrorNode((Element)importObject, manifestName, errReport, null);
                        continue;
                    }
                    ((IndependentlyPersistableObject)newObj).save(RefreshMode.NO_REFRESH);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof EngineRuntimeException && ExceptionCode.DB_NOT_UNIQUE.equals(((EngineRuntimeException)e).getExceptionCode()) && !isClassDef || e instanceof EngineRuntimeException && ExceptionCode.E_NOT_UNIQUE.equals(((EngineRuntimeException)e).getExceptionCode()) && !isClassDef) continue;
                    ImportXML.createXMLErrorNode((Element)importObject, manifestName, errReport, e);
                    if ((flags & 0x200) == 0) continue;
                    if (e instanceof EngineRuntimeException) {
                        throw (EngineRuntimeException)e;
                    }
                    throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED, null);
                }
            }
            if (!manifestName.equalsIgnoreCase("ClassDefinitions")) continue;
            objectStore.refresh();
        }
    }

    public static boolean manifestHasErrors(Object errReport) {
        boolean hasErrors = false;
        org.w3c.dom.Document errDoc = (org.w3c.dom.Document)errReport;
        Node rootErrNode = errDoc.getFirstChild();
        if (rootErrNode != null && rootErrNode.hasChildNodes()) {
            hasErrors = true;
        }
        return hasErrors;
    }

    public static String getErrorReportString(Object errReport, boolean formatted) {
        String errReportString = null;
        org.w3c.dom.Document errDoc = (org.w3c.dom.Document)errReport;
        Node rootErrNode = errDoc.getFirstChild();
        if (rootErrNode != null && rootErrNode.hasChildNodes()) {
            StringBuffer sb = new StringBuffer();
            ImportExportUtil.nodeToBuffer(rootErrNode, sb, 0, formatted);
            errReportString = sb.toString();
        }
        return errReportString;
    }

    private static void importDocuments(ObjectStore objectStore, Node objectManifest, int flags, Object errReport) {
        NodeList importObjects = objectManifest.getChildNodes();
        int objCount = importObjects.getLength();
        if (objCount > 0) {
            LinkedList<VersionSeriesList> setVersionSeries = new LinkedList<VersionSeriesList>();
            for (int i = 0; i < objCount; ++i) {
                Node objRefNode;
                Node verNode;
                Node docNode;
                Node propsNode;
                if (importObjects.item(i).getNodeType() == 3 || !ImportXML.isValidParentNode(propsNode = ImportExportUtil.selectSingleNode(docNode = importObjects.item(i), docNode.getNodeName() + "Properties"))) continue;
                String docId = "";
                String verSerId = "";
                Node idNode = ImportExportUtil.selectSingleNode(propsNode, "Id");
                if (ImportXML.isValidParentNode(idNode)) {
                    docId = ImportExportUtil.getNodeValue(idNode);
                }
                if (ImportXML.isValidParentNode(verNode = ImportExportUtil.selectSingleNode(propsNode, "VersionSeries")) && ImportXML.isValidParentNode(objRefNode = ImportExportUtil.selectSingleNode(verNode, "ObjectRef"))) {
                    verSerId = ImportXML.getObjRefValue(objRefNode, "ObjectId");
                }
                if (docId == null || docId.length() <= 0 || verSerId == null || verSerId.length() <= 0) continue;
                Node node = ImportExportUtil.selectSingleNode(propsNode, "MajorVersionNumber");
                long majorVersion = Integer.valueOf(ImportExportUtil.getNodeValue(node)).intValue();
                node = ImportExportUtil.selectSingleNode(propsNode, "MinorVersionNumber");
                long minorVersion = Integer.valueOf(ImportExportUtil.getNodeValue(node)).intValue();
                long verNumber = majorVersion * 10000L + minorVersion;
                VersionInfo verInfo = new VersionInfo();
                verInfo.docVersionId = docId;
                verInfo.docNode = docNode;
                verInfo.version = verNumber;
                VersionSeriesList verSeries = null;
                verSeries = ImportXML.findVersionSeries(setVersionSeries, verSerId);
                if (verSeries != null) {
                    boolean versionAdded = false;
                    int size = verSeries.listVersions.size();
                    for (int j = 0; j < size; ++j) {
                        VersionInfo temp = (VersionInfo)verSeries.listVersions.get(j);
                        if (temp.version <= verNumber) continue;
                        verSeries.listVersions.add(j, verInfo);
                        versionAdded = true;
                        break;
                    }
                    if (versionAdded) continue;
                    verSeries.listVersions.add(size, verInfo);
                    continue;
                }
                verSeries = new VersionSeriesList();
                verSeries.versionSeriesId = verSerId;
                verSeries.listVersions = new LinkedList();
                verSeries.listVersions.add(verInfo);
                setVersionSeries.add(verSeries);
            }
            for (VersionSeriesList verSeries : setVersionSeries) {
                ImportXML.importVersionSeries(objectStore, verSeries.listVersions, flags, errReport);
            }
        }
    }

    private static void importVersionSeries(ObjectStore objectStore, LinkedList listVersions, int flags, Object errReport) {
        EngineObject eo = null;
        String className = null;
        VersionInfo verInfo = (VersionInfo)listVersions.getFirst();
        Node docNode = verInfo.docNode;
        Node classNode = ImportXML.getClassNode(docNode);
        Node propsNode = ImportExportUtil.selectSingleNode(docNode, docNode.getNodeName() + "Properties");
        if (ImportXML.isValidParentNode(classNode) && ImportXML.isValidParentNode(propsNode)) {
            className = classNode.getNodeName();
            Id docId = null;
            if ((flags & 1) == 1) {
                Node idNode = ImportExportUtil.selectSingleNode(propsNode, "Id");
                docId = new Id(ImportExportUtil.formatId(ImportExportUtil.getNodeValue(idNode)));
            }
            eo = MetadataCacheIE.createObject(className, objectStore, docId);
            if ((flags & 1) == 1) {
                eo = ImportXML.importVersionSeriesId(eo, propsNode);
            }
        }
        if (eo != null) {
            try {
                Node securityNode;
                eo = ImportXML.persistableImport(eo, propsNode, flags);
                if (((flags & 8) != 0 || (flags & 2) != 0) && ImportXML.isValidParentNode(securityNode = ImportExportUtil.selectSingleNode(classNode, className + "Security"))) {
                    eo = ImportXML.securityImport(eo, securityNode, flags);
                }
            }
            catch (Exception e) {
                ImportXML.createXMLErrorNode((Element)docNode, "Documents", errReport, e);
            }
        }
        Document doc = (Document)eo;
        long minorVersion = verInfo.version % 10000L;
        CheckinType type = minorVersion > 0L ? CheckinType.MINOR_VERSION : CheckinType.MAJOR_VERSION;
        try {
            doc.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, type);
            doc.save(RefreshMode.REFRESH);
        }
        catch (Exception e) {
            ImportXML.createXMLErrorNode((Element)docNode, "Documents", errReport, e);
            doc = null;
        }
        if (doc != null) {
            int size = listVersions.size();
            for (int i = 1; i < size; ++i) {
                String temp;
                Id resId = null;
                docNode = ((VersionInfo)listVersions.get(i)).docNode;
                if ((flags & 1) == 1 && (temp = ((VersionInfo)listVersions.get((int)i)).docVersionId) != null && temp.length() > 0) {
                    resId = new Id(ImportExportUtil.formatId(temp));
                }
                doc.checkout(ReservationType.OBJECT_STORE_DEFAULT, resId, null, null);
                doc.save(RefreshMode.REFRESH);
                Document res = (Document)doc.get_Reservation();
                propsNode = ImportExportUtil.selectSingleNode(docNode, docNode.getNodeName() + "Properties");
                try {
                    Node securityNode;
                    eo = ImportXML.persistableImport(res, propsNode, flags);
                    if (((flags & 8) != 0 || (flags & 2) != 0) && ImportXML.isValidParentNode(securityNode = ImportExportUtil.selectSingleNode(classNode, className + "Security"))) {
                        eo = ImportXML.securityImport(eo, securityNode, flags);
                    }
                    doc = (Document)eo;
                    minorVersion = ((VersionInfo)listVersions.get((int)i)).version % 10000L;
                    type = minorVersion > 0L ? CheckinType.MINOR_VERSION : CheckinType.MAJOR_VERSION;
                    doc.checkin(AutoClassify.DO_NOT_AUTO_CLASSIFY, type);
                    doc.save(RefreshMode.REFRESH);
                    continue;
                }
                catch (Exception e) {
                    doc.cancelCheckout();
                    doc.save(RefreshMode.REFRESH);
                    ImportXML.createXMLErrorNode((Element)docNode, "Documents", errReport, e);
                }
            }
        }
    }

    private static VersionSeriesList findVersionSeries(LinkedList verList, String verSerId) {
        VersionSeriesList verSerList = null;
        for (VersionSeriesList tempList : verList) {
            if (!tempList.versionSeriesId.equalsIgnoreCase(verSerId)) continue;
            verSerList = tempList;
            break;
        }
        return verSerList;
    }

    private static void createXMLErrorNode(Element importObject, String manifestName, Object errReport, Exception importEx) {
        try {
            String nodeName;
            Element entryElem;
            Node manifestNode;
            if (importEx != null && importEx instanceof EngineRuntimeException) {
                logger.logError((EngineRuntimeException)importEx);
            }
            org.w3c.dom.Document docErrLog = null;
            docErrLog = errReport instanceof org.w3c.dom.Document ? (org.w3c.dom.Document)errReport : ((Node)errReport).getOwnerDocument();
            Element domElement = docErrLog.getDocumentElement();
            if (domElement == null) {
                domElement = docErrLog.createElement("ImportErrors");
                docErrLog.appendChild(domElement);
            }
            if ((manifestNode = ImportExportUtil.selectSingleNode(domElement, manifestName)) == null) {
                manifestNode = docErrLog.createElement(manifestName);
                domElement.appendChild(manifestNode);
            }
            if ((entryElem = docErrLog.createElement(nodeName = importObject.getNodeName())) != null) {
                manifestNode.appendChild(entryElem);
                Node propsNode = ImportExportUtil.selectSingleNode(importObject, nodeName + "Properties");
                if (ImportXML.isValidParentNode(propsNode)) {
                    String text;
                    Node nameNode;
                    Text textNode;
                    String text2;
                    Node idNode = ImportExportUtil.selectSingleNode(propsNode, "Id");
                    if (idNode == null) {
                        idNode = ImportExportUtil.selectSingleNode(propsNode, "PrimaryId");
                    }
                    if (ImportXML.isValidParentNode(idNode) && (text2 = ImportExportUtil.getNodeValue(idNode)) != null && text2.length() > 0) {
                        Element errIdElem = docErrLog.createElement("Id");
                        textNode = docErrLog.createTextNode(text2);
                        errIdElem.appendChild(textNode);
                        entryElem.appendChild(errIdElem);
                    }
                    if ((nameNode = ImportExportUtil.selectSingleNode(propsNode, "Name")) == null) {
                        nameNode = ImportExportUtil.selectSingleNode(propsNode, "SymbolicName");
                    }
                    if (ImportXML.isValidParentNode(nameNode) && (text = ImportExportUtil.getNodeValue(nameNode)) != null && text.length() > 0) {
                        Element errNameElem = docErrLog.createElement("Name");
                        Text textNode2 = docErrLog.createTextNode(text);
                        errNameElem.appendChild(textNode2);
                        entryElem.appendChild(errNameElem);
                    }
                    if (importEx != null) {
                        Element elem = docErrLog.createElement("ExceptionMessage");
                        textNode = docErrLog.createTextNode(importEx.getLocalizedMessage());
                        elem.appendChild(textNode);
                        entryElem.appendChild(elem);
                        ExceptionCode ec = ((EngineRuntimeException)importEx).getExceptionCode();
                        elem = docErrLog.createElement("ExceptionCode");
                        textNode = docErrLog.createTextNode(ec.getKey());
                        elem.appendChild(textNode);
                        entryElem.appendChild(elem);
                        CompatibilityException ce = new CompatibilityException(ec);
                        elem = docErrLog.createElement("HRESULT");
                        textNode = docErrLog.createTextNode(ce.getHResult());
                        elem.appendChild(textNode);
                        entryElem.appendChild(elem);
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static Object importObject(ObjectStore objStore, Element domNode, int flags) {
        IndependentlyPersistableObjectImpl ipoi;
        if (domNode == null) {
            throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
        }
        Node classNode = ImportXML.getClassNode(domNode);
        String className = classNode.getNodeName();
        Node propsNode = ImportExportUtil.selectSingleNode(classNode, className + "Properties");
        Node securityNode = ImportExportUtil.selectSingleNode(classNode, className + "Security");
        EngineObject eo = null;
        ClassDescription classDesc = Factory.ClassDescription.getInstance((Scope)objStore, className);
        if (classDesc.describedIsOfClass("ClassDefinition").booleanValue()) {
            Node propNode;
            if (((flags & 1) == 0 || (eo = ImportXML.findExistingEngineObject(objStore, className, propsNode)) == null) && ImportXML.isValidParentNode(propNode = ImportExportUtil.selectSingleNode(propsNode, "SuperclassDefinition"))) {
                String id;
                Node objRefNode = ImportExportUtil.selectSingleNode(propNode, "ObjectRef");
                String objId = null;
                if (ImportXML.isValidParentNode(objRefNode)) {
                    objId = ImportXML.getObjRefValue(objRefNode, "ObjectId");
                }
                ClassDefinition classDef = Factory.ClassDefinition.fetchInstance(objStore, new Id(objId), ImportExportUtil.propFilter());
                eo = (flags & 1) == 1 ? ((id = ImportXML.getNodeText(propsNode, "Id")) == null || id.length() == 0 ? classDef.createSubclass() : classDef.createSubclass(new Id(ImportExportUtil.formatId(id)))) : classDef.createSubclass();
            }
            if (eo == null) {
                String name = ImportXML.getNodeText(propsNode, "SymbolicName");
                if (name == null) {
                    name = ImportXML.getNodeText(propsNode, "Id");
                }
                if ((flags & 0x800) == 2048) {
                    throw new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_FOUND, null, ExceptionContext.E_UAO_MISSING_METADATA, new Object[]{"ClassDefinition", name});
                }
                throw new EngineRuntimeException(ExceptionCode.E_REQUIRED_VALUE_ABSENT, null, ExceptionContext.E_MISSING_SUPERCLASS_DEFINITION, new Object[]{name});
            }
        } else if (!classDesc.describedIsOfClass("PropertyTemplate").booleanValue() || (flags & 1) == 0 || (eo = ImportXML.findExistingEngineObject(objStore, className, propsNode)) == null) {
            if ((flags & 1) == 1) {
                String id = ImportXML.getNodeText(propsNode, "Id");
                if (classDesc.describedIsOfClass("ChoiceList").booleanValue()) {
                    eo = ImportXML.findExistingEngineObject(objStore, "ChoiceList", propsNode);
                }
                if (eo == null) {
                    eo = id == null || id.length() == 0 ? MetadataCacheIE.createObject(className, objStore, null) : MetadataCacheIE.createObject(className, objStore, new Id(ImportExportUtil.formatId(id)));
                    eo = ImportXML.importVersionSeriesId(eo, propsNode);
                }
            } else {
                eo = MetadataCacheIE.createObject(className, objStore, null);
            }
        }
        if (ImportExportUtil.isDeleted((IndependentlyPersistableObject)eo)) {
            throw new EngineRuntimeException(ExceptionCode.E_OBJECT_DELETED, null);
        }
        eo = ImportXML.persistableImport(eo, propsNode, flags);
        if (classDesc.describedIsOfClass("PropertyTemplate").booleanValue() && (flags & 0x800) == 2048 && (ipoi = (IndependentlyPersistableObjectImpl)eo).isNew() && !ipoi.getProperties().isPropertyPresent("Cardinality")) {
            String name = ImportXML.getNodeText(propsNode, "SymbolicName");
            if (name == null) {
                name = ImportXML.getNodeText(propsNode, "Id");
            }
            throw new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_FOUND, null, ExceptionContext.E_UAO_MISSING_METADATA, new Object[]{"PropertyTemplate", name});
        }
        if (((flags & 8) != 0 || (flags & 2) != 0) && ImportXML.isValidParentNode(securityNode)) {
            eo = ImportXML.securityImport(eo, securityNode, flags);
        }
        return eo;
    }

    private static EngineObject importVersionSeriesId(EngineObject eo, Node propsNode) {
        Node vsNode;
        if (eo != null && eo instanceof Document && ImportXML.isValidParentNode(vsNode = ImportExportUtil.selectSingleNode(propsNode, "VersionSeries"))) {
            Node objRefNode = ImportExportUtil.selectSingleNode(vsNode, "ObjectRef");
            String objId = null;
            if (ImportXML.isValidParentNode(objRefNode)) {
                objId = ImportXML.getObjRefValue(objRefNode, "ObjectId");
            }
            if (ImportXML.isNewEO(eo)) {
                if (objId != null && objId.length() > 0) {
                    IndependentlyPersistableObject ipo = (IndependentlyPersistableObject)eo;
                    PendingAction[] pa = ipo.getPendingActions();
                    if (pa.length == 1 && pa[0] instanceof Create) {
                        Create createAction = (Create)pa[0];
                        Boolean paAutoUnique = createAction.getAutoUniqueContainmentName();
                        String paClassId = createAction.getClassId();
                        Boolean paSecParent = createAction.getDefineSecurityParentage();
                        String paObjectId = createAction.getObjectId();
                        ReservationType paResType = createAction.getReservationType();
                        String paVerSerId = new Id(objId).toString();
                        ipo.clearPendingActions();
                        ipo.addPendingAction(new Create(paClassId, paObjectId, paAutoUnique, paResType, paSecParent, paVerSerId));
                    } else if (pa.length != 0) {
                        throw new EngineRuntimeException(ExceptionCode.E_CONFLICTING_OPERATION, null);
                    }
                }
            } else {
                throw new EngineRuntimeException(ExceptionCode.E_NOT_SUPPORTED, null);
            }
        }
        return eo;
    }

    private static EngineObject persistableImport(EngineObject eo, Node classProps, int flags) {
        ObjectStore objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
        if (ImportXML.isValidParentNode(classProps)) {
            if (eo instanceof SecurityTemplate) {
                eo = ImportXML.securityTemplateImport(eo, objStore, classProps, flags);
            } else if (eo instanceof DocumentState) {
                eo = ImportXML.documentStateImport(eo, objStore, classProps, flags);
            } else if (eo instanceof Choice) {
                eo = ImportXML.cvlElementImport(eo, objStore, classProps, flags);
            } else {
                CachePropertiesIE cacheProps = new CachePropertiesIE(eo);
                eo = ImportXML.genericPersistableImport(eo, objStore, cacheProps, classProps, flags);
            }
        }
        return eo;
    }

    private static EngineObject securityTemplateImport(EngineObject eo, ObjectStore objStore, Node classProps, int flags) {
        Node permsNode;
        CachePropertiesIE cacheProps = new CachePropertiesIE(eo);
        eo = ImportXML.genericPersistableImport(eo, objStore, cacheProps, classProps, flags);
        if (classProps.hasChildNodes() && (permsNode = ImportExportUtil.selectSingleNode(classProps, "TemplatePermissions")) != null) {
            PermissionList perms = null;
            if (eo.getProperties().isPropertyPresent("TemplatePermissions")) {
                perms = (PermissionList)eo.getProperties().get("TemplatePermissions").getObjectValue();
            } else {
                perms = Factory.Permission.createList();
                eo.getProperties().putValue("TemplatePermissions", perms);
            }
            perms = ImportXML.permissionsImport(perms, permsNode);
        }
        return eo;
    }

    private static EngineObject documentStateImport(EngineObject eo, ObjectStore objStore, Node classProps, int flags) {
        Node permsNode;
        CachePropertiesIE cacheProps = new CachePropertiesIE(eo);
        eo = ImportXML.genericPersistableImport(eo, objStore, cacheProps, classProps, flags);
        if (classProps.hasChildNodes() && (permsNode = ImportExportUtil.selectSingleNode(classProps, "TemplatePermissions")) != null) {
            PermissionList perms = null;
            if (eo.getProperties().isPropertyPresent("TemplatePermissions")) {
                perms = (PermissionList)eo.getProperties().get("TemplatePermissions").getObjectValue();
            } else {
                perms = Factory.Permission.createList();
                eo.getProperties().putValue("TemplatePermissions", perms);
            }
            perms = ImportXML.permissionsImport(perms, permsNode);
        }
        return eo;
    }

    private static EngineObject contentTransferImport(EngineObject eo, ObjectStore objStore, Node classProps, int flags) {
        CachePropertiesIE cacheProps = new CachePropertiesIE(eo);
        eo = ImportXML.genericPersistableImport(eo, objStore, cacheProps, classProps, flags);
        Node node = ImportExportUtil.selectSingleNode(classProps, "ExternalRef");
        if (ImportXML.isValidParentNode(node)) {
            eo = ImportXML.refContentImport(eo, node);
        } else {
            node = ImportExportUtil.selectSingleNode(classProps, "EncodedContent");
            if (node != null) {
                eo = ImportXML.encodedImport(eo, node);
            }
        }
        return eo;
    }

    private static EngineObject refContentImport(EngineObject eo, Node extRefNode) {
        ContentTransfer contTrans = (ContentTransfer)eo;
        String filePath = null;
        if (ImportXML.isValidNode(extRefNode)) {
            filePath = ImportExportUtil.getNodeValue(extRefNode);
        }
        if (filePath != null && filePath.length() > 0) {
            try {
                File file = new File(filePath);
                if (!file.exists()) {
                    throw new EngineRuntimeException(ExceptionCode.E_URL_PROTOCOL_NOT_SUPPORTED, null);
                }
                FileInputStream inputStream = new FileInputStream(file);
                if (inputStream != null && file.length() > 0L) {
                    contTrans.setCaptureSource(inputStream);
                }
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_VALUE_NOT_SET, null);
            }
        }
        return eo;
    }

    private static EngineObject encodedImport(EngineObject eo, Node encodedNode) {
        byte[] content;
        ByteArrayInputStream inputStream;
        ContentTransfer contTrans = (ContentTransfer)eo;
        String nodeValue = ImportExportUtil.getNodeValue(encodedNode);
        if (nodeValue == null) {
            nodeValue = "";
        }
        if ((inputStream = new ByteArrayInputStream(content = Base64.decode(nodeValue))) != null) {
            contTrans.setCaptureSource(inputStream);
        }
        return eo;
    }

    private static EngineObject cvlElementImport(EngineObject eo, ObjectStore objStore, Node classProps, int flags) {
        CachePropertiesIE cacheProps = new CachePropertiesIE(eo);
        eo = ImportXML.genericPersistableImport(eo, objStore, cacheProps, classProps, flags);
        CachePropIE cacheProp = cacheProps.Item("DisplayName");
        if (cacheProp != null) {
            Node node = ImportExportUtil.selectSingleNode(classProps, cacheProp.getPropertyDescription().get_SymbolicName());
            TElement elemValue = new TElement(cacheProp.getPropertyDescription().get_DataType());
            if ((elemValue = ImportXML.elementValueImport(node, elemValue)).isValueSet()) {
                Properties updateProps = eo.getProperties();
                updateProps = ImportXML.setProperty(updateProps, cacheProp, elemValue, flags);
            }
        }
        return eo;
    }

    private static EngineObject genericPersistableImport(EngineObject eo, ObjectStore objStore, CachePropertiesIE cacheProps, Node classProps, int flags) {
        if (classProps.hasChildNodes()) {
            Properties updateProps = eo.getProperties();
            Node propNode = null;
            CachePropIE cacheProp = null;
            int count = cacheProps.size();
            for (int i = 0; i < count; ++i) {
                cacheProp = cacheProps.Item(i);
                boolean isPersistent = ImportExportUtil.isPersistentProperty(cacheProp.getPropertyDescription());
                propNode = ImportExportUtil.selectSingleNode(classProps, cacheProp.getName());
                if (!ImportXML.isPrivilegedSettabilityProperty(cacheProp.getName(), flags) && (!isPersistent || !ImportXML.isPropState(cacheProp, (byte)2) || !ImportXML.isPropertyImported(cacheProp.getName()) || propNode == null) || ImportXML.isSettableOnlyByTrusted(cacheProp.getName(), flags) && !ImportXML.canSetTrustedOnlyProps()) continue;
                Cardinality card = cacheProp.getPropertyDescription().get_Cardinality();
                if (card == Cardinality.SINGLE) {
                    TElement elemValue = new TElement(cacheProp.getPropertyDescription().get_DataType());
                    if (cacheProp.getTypeID() == TypeID.OBJECT) {
                        Node objRefNode;
                        if (cacheProp.getName().equalsIgnoreCase("ChoiceList") && !propNode.hasChildNodes()) {
                            updateProps = ImportXML.clearPropertyValue(updateProps, cacheProp);
                        }
                        if ((objRefNode = ImportExportUtil.selectSingleNode(propNode, "ObjectRef")) != null) {
                            elemValue = ImportXML.objectRefImport(objRefNode, elemValue, eo, objStore);
                        } else if (cacheProp.getName().equalsIgnoreCase("SecurityPolicy") && (flags & 0x10) != 0) {
                            updateProps = ImportXML.setProperty(updateProps, cacheProp, elemValue, flags);
                        }
                    } else {
                        elemValue = ImportXML.elementValueImport(propNode, elemValue);
                    }
                    boolean ignoreLocalName = false;
                    if (existingObject && cacheProp.getName().equalsIgnoreCase("LocaleName")) {
                        ignoreLocalName = true;
                    }
                    if (elemValue.isValueSet() && !ignoreLocalName) {
                        updateProps = ImportXML.setProperty(updateProps, cacheProp, elemValue, flags);
                    }
                    elemValue = null;
                    continue;
                }
                updateProps = ImportXML.propertyListImport(updateProps, cacheProp, propNode, eo, flags);
            }
        }
        return eo;
    }

    private static boolean isPropState(CachePropIE cacheProp, byte propAccess) {
        byte Access = propAccess;
        return (cacheProp.getAccess() & Access) == Access;
    }

    private static boolean isPropertyImported(String propName) {
        return !propName.equalsIgnoreCase("TemplatePermissions") && !propName.equalsIgnoreCase("PrimaryId");
    }

    private static boolean isSettableOnlyByTrusted(String propName, int flags) {
        if (propName.equalsIgnoreCase("Creator") || propName.equalsIgnoreCase("DateCreated") || propName.equalsIgnoreCase("LastModifier") || propName.equalsIgnoreCase("DateLastModified")) {
            return (flags & 0x100) == 0;
        }
        return false;
    }

    private static boolean isPrivilegedSettabilityProperty(String propName, int Flags) {
        return (Flags & 0x100) != 0 && (propName.equals("Creator") || propName.equals("DateCreated") || propName.equals("LastModifier") || propName.equals("DateLastModified"));
    }

    private static boolean canSetTrustedOnlyProps() {
        return false;
    }

    private static TElement objectRefImport(Node objRefNode, TElement elemValue, EngineObject eo, ObjectStore objStore) {
        String objectId = null;
        String classId = null;
        String objectStoreId = null;
        boolean isMarkingSet = false;
        if (objRefNode.hasChildNodes()) {
            Node objectNode = ImportExportUtil.selectSingleNode(objRefNode, "ObjectId");
            if (objectNode == null) {
                isMarkingSet = true;
                objectNode = ImportExportUtil.selectSingleNode(objRefNode, "Name");
            }
            Node classNode = ImportExportUtil.selectSingleNode(objRefNode, "ClassId");
            if (objectNode != null && classNode != null) {
                objectId = isMarkingSet ? ImportExportUtil.getNodeValue(objectNode) : ImportExportUtil.formatId(ImportExportUtil.getNodeValue(objectNode));
                classId = ImportExportUtil.formatId(ImportExportUtil.getNodeValue(classNode));
                Node objStoreNode = ImportExportUtil.selectSingleNode(objRefNode, "StoreId");
                if (objStoreNode != null) {
                    objectStoreId = ImportExportUtil.formatId(ImportExportUtil.getNodeValue(objStoreNode));
                }
            } else {
                throw new EngineRuntimeException(ExceptionCode.E_BAD_VALUE, null);
            }
        }
        IndependentObject obj = null;
        if (isMarkingSet) {
            Domain dom = MetadataCacheIE.getLocalDomain();
            if (!dom.getProperties().isPropertyPresent("MarkingSets")) {
                dom.fetchProperty("MarkingSets", null);
            }
            MarkingSetSet mss = dom.get_MarkingSets();
            Iterator it = mss.iterator();
            while (it.hasNext()) {
                String name;
                MarkingSet ms = (MarkingSet)it.next();
                if (ms.get_DisplayName().length() <= 0 || !(name = ms.get_DisplayName()).equalsIgnoreCase(ImportExportUtil.unFormatId(objectId))) continue;
                obj = ms;
                break;
            }
        } else {
            if (objStore == null) {
                objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
            }
            if (objectStoreId != null && objectStoreId.length() > 0) {
                objStore = Factory.ObjectStore.getInstance(MetadataCacheIE.getLocalDomain(), objectStoreId);
            }
            try {
                obj = objStore.fetchObject(classId, objectId, null);
            }
            catch (Exception e) {
                throw new EngineRuntimeException(e, ExceptionCode.E_BAD_OBJECT, null);
            }
        }
        if (obj == null) {
            throw new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_FOUND, null);
        }
        elemValue.setValue(obj);
        return elemValue;
    }

    private static TElement elementValueImport(Node propNode, TElement elemValue) {
        if (propNode != null && ImportExportUtil.getNodeValue(propNode) != null && ImportExportUtil.getNodeValue(propNode).length() > 0) {
            switch (elemValue.getDataType().getValue()) {
                case 1: {
                    byte[] BinaryVal = Base64.decode(ImportExportUtil.getNodeValue(propNode));
                    elemValue.setValue(BinaryVal);
                    break;
                }
                case 2: {
                    if (ImportExportUtil.getNodeValue(propNode).equals("1")) {
                        elemValue.setValue(Boolean.TRUE);
                        break;
                    }
                    elemValue.setValue(Boolean.FALSE);
                    break;
                }
                case 3: {
                    elemValue.setValue(ImportExportUtil.fromXmlDateTime(ImportExportUtil.getNodeValue(propNode)));
                    break;
                }
                case 4: {
                    elemValue.setValue(Double.valueOf(ImportExportUtil.getNodeValue(propNode)));
                    break;
                }
                case 5: {
                    elemValue.setValue(new Id(ImportExportUtil.formatId(ImportExportUtil.getNodeValue(propNode))));
                    break;
                }
                case 6: {
                    elemValue.setValue(Integer.valueOf(ImportExportUtil.getNodeValue(propNode)));
                    break;
                }
                case 8: {
                    elemValue.setValue(ImportExportUtil.getNodeValue(propNode));
                    break;
                }
                default: {
                    throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
                }
            }
        }
        return elemValue;
    }

    private static Properties propertyListImport(Properties updateProps, CachePropIE cacheProp, Node propNode, EngineObject eo, int flags) {
        if (!ImportXML.isValidParentNode(propNode)) {
            return updateProps;
        }
        List propList = null;
        boolean isNew = false;
        if (!updateProps.isPropertyPresent(cacheProp.getName())) {
            isNew = true;
            TypeID type = cacheProp.getPropertyDescription().get_DataType();
            if (type == TypeID.STRING) {
                propList = Factory.StringList.createList();
            } else if (type == TypeID.LONG) {
                propList = Factory.Integer32List.createList();
            } else if (type == TypeID.DATE) {
                propList = Factory.DateTimeList.createList();
            } else if (type == TypeID.BINARY) {
                propList = Factory.BinaryList.createList();
            } else if (type == TypeID.DOUBLE) {
                propList = Factory.Float64List.createList();
            } else if (type == TypeID.BOOLEAN) {
                propList = Factory.BooleanList.createList();
            } else if (type == TypeID.GUID) {
                propList = Factory.IdList.createList();
            } else if (type == TypeID.OBJECT) {
                String className = ImportXML.getFirstChildNode(propNode).getNodeName();
                try {
                    Class<?> factoryClass = Class.forName("com.filenet.api.core.Factory$" + className);
                    Method method = factoryClass.getMethod("createList", new Class[0]);
                    propList = (List)method.invoke((Object)eo, new Object[0]);
                }
                catch (Exception e) {
                    throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
                }
            }
            updateProps.putObjectValue(cacheProp.getName(), propList);
        }
        if ((propList = (List)updateProps.getObjectValue(cacheProp.getName())) != null && ImportXML.isValidParentNode(propNode)) {
            if (cacheProp.getTypeID() != TypeID.OBJECT || cacheProp.getName().equalsIgnoreCase("SecurityTemplates") || cacheProp.getName().equalsIgnoreCase("DocumentStates") || cacheProp.getName().equalsIgnoreCase("ChoiceValues")) {
                propList.clear();
            }
            ObjectStore objStore = ((RepositoryObject)((Object)eo)).getObjectStore();
            NodeList propNodes = (NodeList)((Object)propNode);
            int length = propNodes.getLength();
            for (int i = 0; i < length; ++i) {
                if (propNodes.item(i).getNodeType() == 3) continue;
                Node node = propNodes.item(i);
                TypeID type = cacheProp.getPropertyDescription().get_DataType();
                if (type == TypeID.OBJECT) {
                    existingObject = false;
                    EngineObject newEO = null;
                    newEO = eo instanceof ClassDefinition ? ImportXML.classDefPrepareDependentImport(node, cacheProp, propList, objStore, isNew) : (propList instanceof LocalizedStringList ? ImportXML.metadataPrepareDependentImport(node, cacheProp, propList, objStore, isNew) : ImportXML.prepareDependentImport(node, objStore));
                    if (newEO instanceof SecurityTemplate) {
                        newEO = ImportXML.securityTemplateImport(newEO, objStore, node, flags);
                    } else if (newEO instanceof DocumentState) {
                        newEO = ImportXML.documentStateImport(newEO, objStore, node, flags);
                    } else if (newEO instanceof Choice) {
                        newEO = ImportXML.cvlElementImport(newEO, objStore, node, flags);
                    } else if (newEO instanceof ContentTransfer) {
                        newEO = ImportXML.contentTransferImport(newEO, objStore, node, flags);
                    } else {
                        CachePropertiesIE cacheProps = new CachePropertiesIE(newEO, ((RepositoryObject)((Object)eo)).getObjectStore());
                        newEO = ImportXML.genericPersistableImport(newEO, objStore, cacheProps, node, flags);
                    }
                    if (existingObject) continue;
                    propList.add(propList.size(), newEO);
                    continue;
                }
                if (!ImportXML.isSimpleNode(node, type)) continue;
                TElement elemValue = new TElement(type);
                if ((elemValue = ImportXML.elementValueImport(node, elemValue)).isValueSet()) {
                    if (type == TypeID.OBJECT) {
                        throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
                    }
                    propList.add(elemValue.getValue());
                    continue;
                }
                if (type != TypeID.STRING) continue;
                String blank = " ";
                propList.add(blank);
            }
        }
        return updateProps;
    }

    private static Properties setProperty(Properties updateProps, CachePropIE cacheProp, TElement elemValue, int flags) {
        if (cacheProp.getPropertyDescription().get_Cardinality() != Cardinality.SINGLE) {
            throw new EngineRuntimeException(ExceptionCode.E_ILLEGAL_OPERATION, null);
        }
        if (!ImportXML.isPropState(cacheProp, (byte)2)) {
            if (!ImportXML.isPrivilegedSettabilityProperty(cacheProp.getName(), flags)) {
                throw new EngineRuntimeException(ExceptionCode.E_READ_ONLY, null);
            }
        } else {
            if (elemValue == null) {
                throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
            }
            if (elemValue.getDataType() != cacheProp.getPropertyDescription().get_DataType()) {
                throw new EngineRuntimeException(ExceptionCode.E_DATATYPE_MISMATCH, null);
            }
        }
        if (elemValue.isValueSet()) {
            updateProps.putObjectValue(cacheProp.getName(), elemValue.getValue());
        } else {
            updateProps = ImportXML.clearPropertyValue(updateProps, cacheProp);
        }
        return updateProps;
    }

    private static Properties clearPropertyValue(Properties updateProps, CachePropIE cacheProp) {
        if (cacheProp.isValueSet()) {
            TypeID type = cacheProp.getTypeID();
            switch (type.getValue()) {
                case 1: {
                    updateProps.putValue(cacheProp.getName(), (byte[])null);
                    break;
                }
                case 2: {
                    updateProps.putValue(cacheProp.getName(), (Boolean)null);
                    break;
                }
                case 3: {
                    updateProps.putValue(cacheProp.getName(), (Date)null);
                    break;
                }
                case 4: {
                    updateProps.putValue(cacheProp.getName(), (Double)null);
                    break;
                }
                case 5: {
                    updateProps.putValue(cacheProp.getName(), (Id)null);
                    break;
                }
                case 6: {
                    updateProps.putValue(cacheProp.getName(), (Integer)null);
                    break;
                }
                case 7: {
                    updateProps.putValue(cacheProp.getName(), (EngineObject)null);
                    break;
                }
                case 8: {
                    updateProps.putValue(cacheProp.getName(), (String)null);
                    break;
                }
                default: {
                    throw new EngineRuntimeException(ExceptionCode.API_UNSUPPORTED_PROPERTY_TYPE, type);
                }
            }
        }
        return updateProps;
    }

    private static EngineObject prepareDependentImport(Node node, ObjectStore objStore) {
        EngineObject eo = null;
        existingObject = false;
        eo = MetadataCacheIE.createObject(node.getNodeName(), objStore, null);
        return eo;
    }

    private static EngineObject classDefPrepareDependentImport(Node node, CachePropIE cacheProp, List propList, ObjectStore objStore, boolean isNew) {
        EngineObject eo = null;
        existingObject = false;
        if (cacheProp.getName().equalsIgnoreCase("PropertyDefinitions")) {
            String nodePrimaryId = "";
            Node idNode = ImportExportUtil.selectSingleNode(node, "PrimaryId");
            if (idNode != null && ImportExportUtil.getNodeValue(idNode).length() > 0) {
                nodePrimaryId = ImportExportUtil.formatId(ImportExportUtil.getNodeValue(idNode));
                PropertyDefinitionList propDefs = (PropertyDefinitionList)propList;
                for (PropertyDefinition propDef : propDefs) {
                    String pdPrimaryId;
                    if (!propDef.getProperties().isPropertyPresent("PrimaryId") || !(pdPrimaryId = propDef.get_PrimaryId().toString()).equalsIgnoreCase(nodePrimaryId)) continue;
                    existingObject = true;
                    eo = propDef;
                    break;
                }
            }
            if (!existingObject && nodePrimaryId.length() > 0) {
                String ptId;
                PropertyTemplateSet propTemplates = null;
                if (!objStore.getProperties().isPropertyPresent("PropertyTemplates")) {
                    Property pts = objStore.fetchProperty("PropertyTemplates", ImportExportUtil.propFilter());
                    propTemplates = (PropertyTemplateSet)pts.getIndependentObjectSetValue();
                } else {
                    propTemplates = objStore.get_PropertyTemplates();
                }
                Iterator it = propTemplates.iterator();
                PropertyTemplate propTemp = null;
                while (it.hasNext() && !(ptId = (propTemp = (PropertyTemplate)it.next()).get_Id().toString()).equalsIgnoreCase(nodePrimaryId)) {
                    propTemp = null;
                }
                if (propTemp == null) {
                    Node tempNode = ImportExportUtil.selectSingleNode(node, "Name");
                    String temp = ImportExportUtil.getNodeValue(tempNode);
                    throw new EngineRuntimeException(ExceptionCode.API_PROPERTY_TEMPLATE_NOT_FOUND, temp);
                }
                eo = propTemp.createClassProperty();
            }
        } else if (cacheProp.getName().equalsIgnoreCase("AuditDefinitions")) {
            String nodeId = "";
            Node idNode = ImportExportUtil.selectSingleNode(node, "Id");
            if (idNode != null && ImportExportUtil.getNodeValue(idNode).length() > 0) {
                nodeId = ImportExportUtil.formatId(ImportExportUtil.getNodeValue(idNode));
                AuditDefinitionList auditDefs = (AuditDefinitionList)propList;
                for (AuditDefinition auditDef : auditDefs) {
                    String pdPrimaryId;
                    if (!auditDef.getProperties().isPropertyPresent("Id") || !(pdPrimaryId = auditDef.get_Id().toString()).equalsIgnoreCase(nodeId)) continue;
                    existingObject = true;
                    eo = auditDef;
                    break;
                }
            }
            if (!existingObject && nodeId.length() > 0) {
                eo = ImportXML.prepareDependentImport(node, objStore);
            }
        }
        if (eo == null) {
            eo = ImportXML.metadataPrepareDependentImport(node, cacheProp, propList, objStore, isNew);
        }
        return eo;
    }

    private static EngineObject metadataPrepareDependentImport(Node node, CachePropIE cacheProp, List propList, ObjectStore objStore, boolean isNew) {
        EngineObject eo = null;
        existingObject = false;
        if (!isNew && (cacheProp.getName().equalsIgnoreCase("DisplayNames") || cacheProp.getName().equalsIgnoreCase("DescriptiveTexts"))) {
            Node locNameNode = ImportExportUtil.selectSingleNode(node, "LocaleName");
            if (locNameNode != null && ImportExportUtil.getNodeValue(locNameNode).length() > 0) {
                String localeName = ImportExportUtil.getNodeValue(locNameNode);
                for (LocalizedString ls : propList) {
                    if (!localeName.equalsIgnoreCase(ls.get_LocaleName())) continue;
                    eo = ls;
                    existingObject = true;
                    break;
                }
            } else {
                throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED, null);
            }
        }
        if (!existingObject) {
            eo = ImportXML.prepareDependentImport(node, objStore);
        }
        return eo;
    }

    private static EngineObject securityImport(EngineObject eo, Node securityNode, int flags) {
        Node permissionsNode;
        Node ownerNode;
        if ((flags & 8) != 0 && ImportXML.isValidParentNode(ownerNode = ImportExportUtil.selectSingleNode(securityNode, "Owner"))) {
            ImportExportUtil.Principal principal = new ImportExportUtil.Principal();
            principal.sid = ImportXML.getNodeText(ownerNode, "SID");
            principal.name = ImportXML.getNodeText(ownerNode, "Name");
            principal.principalType = SecurityPrincipalType.USER;
            ImportExportUtil.lookupPrincipal(principal);
            if (principal.name.length() > 0) {
                eo.getProperties().putValue("Owner", principal.name);
            }
        }
        if ((flags & 2) != 0 && (permissionsNode = ImportExportUtil.selectSingleNode(securityNode, "Permissions")) != null) {
            PermissionList perms = null;
            if (eo.getProperties().isPropertyPresent("Permissions")) {
                perms = (PermissionList)eo.getProperties().get("Permissions").getObjectValue();
                perms = ImportXML.removeDirectAces(perms);
            } else {
                perms = Factory.Permission.createList();
                eo.getProperties().putValue("Permissions", perms);
            }
            perms = ImportXML.permissionsImport(perms, permissionsNode);
        }
        if (eo instanceof ClassDefinition) {
            eo = ImportXML.cdImportDefInstanceSecurity(eo, securityNode, flags);
        }
        return eo;
    }

    private static PermissionList permissionsImport(PermissionList perms, Node permissionsNode) {
        if (ImportXML.isValidParentNode(permissionsNode)) {
            NodeList nodes = permissionsNode.getChildNodes();
            int length = nodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node accessNode;
                if (nodes.item(i).getNodeType() == 3 || (accessNode = nodes.item(i)).getNodeName() != "AccessPermission") continue;
                perms = ImportXML.aceImport(perms, accessNode);
            }
        }
        return perms;
    }

    private static EngineObject cdImportDefInstanceSecurity(EngineObject eo, Node securityNode, int flags) {
        Node sidNode;
        Node ownerNode;
        PermissionList accessPerms = null;
        Node permsNode = ImportExportUtil.selectSingleNode(securityNode, "DefaultInstancePermissions");
        if (ImportXML.isValidParentNode(permsNode)) {
            if (eo.getProperties().isPropertyPresent("DefaultInstancePermissions")) {
                accessPerms = (PermissionList)eo.getProperties().get("DefaultInstancePermissions").getObjectValue();
                accessPerms = ImportXML.removeDirectAces(accessPerms);
            } else {
                accessPerms = Factory.AccessPermission.createList();
                eo.getProperties().putValue("DefaultInstancePermissions", accessPerms);
            }
            accessPerms = ImportXML.permissionsImport(accessPerms, permsNode);
        }
        if (ImportXML.isValidParentNode(ownerNode = ImportExportUtil.selectSingleNode(securityNode, "DefaultInstanceOwner")) && (sidNode = ImportExportUtil.selectSingleNode(ownerNode, "SID")) != null) {
            CachePropertiesIE cacheProps = new CachePropertiesIE(eo);
            CachePropIE cacheProp = cacheProps.Item("DefaultInstanceOwner");
            Properties updateProps = eo.getProperties();
            if (ImportExportUtil.getNodeValue(sidNode).length() > 0) {
                String owner = ImportExportUtil.getNodeValue(sidNode);
                TElement elemValue = new TElement(TypeID.STRING);
                if (owner.equalsIgnoreCase("S-1-3-0")) {
                    elemValue.setValue(SpecialPrincipal.CREATOR_OWNER.toString());
                } else if (owner.equalsIgnoreCase("S-1-5-11")) {
                    elemValue.setValue(SpecialPrincipal.AUTHENTICATED_USERS.toString());
                } else {
                    ImportExportUtil.Principal principal = new ImportExportUtil.Principal();
                    principal.sid = owner;
                    principal.principalType = SecurityPrincipalType.USER;
                    ImportExportUtil.lookupPrincipal(principal);
                    elemValue.setValue(principal.name);
                }
                if (elemValue.isValueSet()) {
                    updateProps = ImportXML.setProperty(updateProps, cacheProp, elemValue, flags);
                }
            } else {
                updateProps = ImportXML.clearPropertyValue(updateProps, cacheProp);
            }
        }
        return eo;
    }

    private static boolean isSimpleNode(Node node, TypeID type) {
        return node.getNodeName() != null && node.getNodeName().length() > 0 && node.getNodeName().equals(ImportExportUtil.TypeToString[type.getValue()]);
    }

    private static PermissionList aceImport(PermissionList perms, Node accessNode) {
        Node sourceNode = ImportExportUtil.selectSingleNode(accessNode, "PermissionSource");
        int inheritDepth = 0;
        AccessType type = AccessType.DENY;
        int accessMask = 0;
        String ownerSID = "";
        PermissionSource source = null;
        String name = "";
        if (ImportXML.isValidNode(sourceNode)) {
            int sourceVal = Integer.valueOf(ImportExportUtil.getNodeValue(sourceNode));
            switch (sourceVal) {
                case 4: {
                    source = PermissionSource.MARKING;
                    break;
                }
                case 255: {
                    source = PermissionSource.MARKING;
                    break;
                }
                case 1: {
                    source = PermissionSource.SOURCE_DEFAULT;
                    break;
                }
                case 0: {
                    source = PermissionSource.SOURCE_DIRECT;
                    break;
                }
                case 3: {
                    source = PermissionSource.SOURCE_PARENT;
                    break;
                }
                case 2: {
                    source = PermissionSource.SOURCE_TEMPLATE;
                }
            }
            if (source == PermissionSource.SOURCE_DEFAULT || source == PermissionSource.SOURCE_DIRECT) {
                Node accessMaskNode;
                Node accessTypeNode;
                Node depthNode;
                Node granteeNode = ImportExportUtil.selectSingleNode(accessNode, "Grantee");
                if (ImportXML.isValidParentNode(granteeNode)) {
                    Node sidNode = ImportExportUtil.selectSingleNode(granteeNode, "SID");
                    if (ImportXML.isValidNode(sidNode)) {
                        ownerSID = ImportExportUtil.getNodeValue(sidNode);
                    } else {
                        Node nameNode = ImportExportUtil.selectSingleNode(granteeNode, "Name");
                        if (ImportXML.isValidNode(nameNode)) {
                            name = ImportExportUtil.getNodeValue(nameNode);
                        }
                    }
                }
                if (ImportXML.isValidNode(depthNode = ImportExportUtil.selectSingleNode(accessNode, "InheritableDepth"))) {
                    inheritDepth = Integer.parseInt(ImportExportUtil.getNodeValue(depthNode));
                }
                if (ImportXML.isValidNode(accessTypeNode = ImportExportUtil.selectSingleNode(accessNode, "AccessType"))) {
                    int accessType = Integer.parseInt(ImportExportUtil.getNodeValue(accessTypeNode));
                    if (accessType == 1) {
                        type = AccessType.ALLOW;
                    } else if (accessType == 2) {
                        type = AccessType.DENY;
                    }
                }
                if (ImportXML.isValidNode(accessMaskNode = ImportExportUtil.selectSingleNode(accessNode, "AccessMask"))) {
                    accessMask = Integer.parseInt(ImportExportUtil.getNodeValue(accessMaskNode));
                }
                SecurityPrincipalType principalType = SecurityPrincipalType.USER;
                if (ownerSID.equalsIgnoreCase("S-1-3-0")) {
                    name = SpecialPrincipal.CREATOR_OWNER.toString();
                    principalType = SecurityPrincipalType.USER;
                } else if (ownerSID.equalsIgnoreCase("S-1-5-11")) {
                    name = SpecialPrincipal.AUTHENTICATED_USERS.toString();
                    principalType = SecurityPrincipalType.GROUP;
                } else {
                    ImportExportUtil.Principal principal = new ImportExportUtil.Principal();
                    principal.sid = ownerSID;
                    principal.name = name;
                    principal.principalType = principalType;
                    ImportExportUtil.lookupPrincipal(principal);
                    name = principal.name;
                    principalType = principal.principalType;
                }
                boolean duplicate = false;
                AccessPermission perm = null;
                Iterator it = perms.iterator();
                while (it.hasNext() && !duplicate) {
                    perm = (AccessPermission)it.next();
                    if (perm.get_PermissionSource() != source || perm.get_InheritableDepth() != inheritDepth || perm.get_AccessType() != type || !perm.get_GranteeName().equalsIgnoreCase(name) || perm.get_GranteeType() != principalType) continue;
                    duplicate = true;
                    int permAccessMask = perm.get_AccessMask() | accessMask;
                    perm.set_AccessMask(new Integer(permAccessMask));
                }
                if (!duplicate) {
                    perm = Factory.AccessPermission.createInstance();
                    perm.getProperties().putValue("PermissionSource", source.getValue());
                    perm.getProperties().putValue("GranteeType", principalType.getValue());
                    perm.set_GranteeName(name);
                    perm.set_InheritableDepth(new Integer(inheritDepth));
                    perm.set_AccessMask(new Integer(accessMask));
                    perm.set_AccessType(type);
                    perms.add(perm);
                }
            }
        }
        return perms;
    }

    private static PermissionList removeDirectAces(PermissionList perms) {
        if (perms != null && perms.size() > 0) {
            for (int i = perms.size() - 1; i >= 0; --i) {
                AccessPermission perm = (AccessPermission)perms.get(i);
                if (perm.get_PermissionSource() != PermissionSource.SOURCE_DEFAULT && perm.get_PermissionSource() != PermissionSource.SOURCE_DIRECT) continue;
                perms.remove(i);
            }
        }
        return perms;
    }

    private static String getNodeText(Node parentNode, String name) {
        Node node = null;
        if (ImportXML.isValidParentNode(parentNode) && (node = ImportExportUtil.selectSingleNode(parentNode, name)) != null) {
            if (node.getNodeType() != 3) {
                node = node.getFirstChild();
            }
            return ImportExportUtil.getNodeValue(node);
        }
        return null;
    }

    private static boolean isValidNode(Node node) {
        return node != null && ImportExportUtil.getNodeValue(node).length() > 0;
    }

    private static Node getFirstChildNode(Node parentNode) {
        Node firstChild = null;
        if (ImportXML.isValidParentNode(parentNode)) {
            NodeList nodes = parentNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i).getNodeType() == 3) continue;
                firstChild = nodes.item(i);
                break;
            }
        }
        return firstChild;
    }

    private static boolean isValidParentNode(Node node) {
        return node != null && node.hasChildNodes();
    }

    private static boolean isNewEO(EngineObject eo) {
        if (eo instanceof IndependentlyPersistableObject) {
            IndependentlyPersistableObject ipo = (IndependentlyPersistableObject)eo;
            PendingAction[] acts = ipo.getPendingActions();
            return acts.length > 0 && acts[0] instanceof Create;
        }
        return false;
    }

    private static EngineObject findExistingEngineObject(ObjectStore objStore, String className, Node propsNode) {
        IndependentObject eo = null;
        String id = ImportXML.getNodeText(propsNode, "Id");
        try {
            eo = objStore.fetchObject(className, ImportExportUtil.formatId(id), null);
        }
        catch (EngineRuntimeException ere) {
            if (!ere.getExceptionCode().equals(ExceptionCode.E_OBJECT_NOT_FOUND)) {
                throw new EngineRuntimeException((Throwable)ere, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
            }
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return eo;
    }

    private static String getObjRefValue(Node objRefNode, String nodeName) {
        Node node = ImportExportUtil.selectSingleNode(objRefNode, nodeName);
        if (ImportXML.isValidNode(node)) {
            return ImportExportUtil.formatId(ImportExportUtil.getNodeValue(node));
        }
        return null;
    }

    private static Node getClassNode(Node domNode) {
        Node classNode = domNode;
        String name = classNode.getNodeName() + "Properties";
        Node propsNode = ImportExportUtil.selectSingleNode(classNode, name);
        if (propsNode == null) {
            NodeList classNodes = domNode.getChildNodes();
            for (int i = 0; i < classNodes.getLength() && (propsNode = ImportExportUtil.selectSingleNode(classNode = classNodes.item(i), name = classNode.getNodeName() + "Properties")) == null; ++i) {
                classNode = null;
            }
        }
        return classNode;
    }

    private static String unformatXMLString(String inString) {
        if (inString == null) {
            return inString;
        }
        if (inString.indexOf("&amp;") > -1) {
            inString = inString.replaceAll("&amp;", "&");
        }
        if (inString.indexOf("&lt;") > -1) {
            inString = inString.replaceAll("&lt;", "<");
        }
        if (inString.indexOf("&gt;") > -1) {
            inString = inString.replaceAll("&gt;", ">");
        }
        if (inString.indexOf("&quot;") > -1) {
            inString = inString.replaceAll("&quot;", "\"");
        }
        return inString;
    }

    private static class VersionSeriesList {
        String versionSeriesId;
        LinkedList listVersions;

        private VersionSeriesList() {
        }
    }

    private static class VersionInfo {
        String docVersionId;
        long version;
        private Node docNode;

        private VersionInfo() {
        }
    }

    public static class TElement {
        private Object value;
        private boolean valueSet;
        private TypeID type;

        public void setValue(Object Val) {
            this.value = Val instanceof String ? ImportXML.unformatXMLString((String)Val) : Val;
            this.valueSet = true;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isValueSet() {
            return this.valueSet;
        }

        public TypeID getDataType() {
            return this.type;
        }

        public TElement(TypeID typeId) {
            this.type = typeId;
            this.valueSet = false;
        }
    }
}

