/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.action.Delete;
import com.filenet.api.action.PendingAction;
import com.filenet.api.constants.SecurityPrincipalType;
import com.filenet.api.core.Domain;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.Group;
import com.filenet.api.security.User;
import com.filenet.apiimpl.util.MetadataCacheIE;
import java.io.BufferedReader;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportExportUtil {
    public static final String XML_TAG_EXPORT_OBJECTS = "ExportObjects";
    public static final String XML_TAG_PROPERTIES = "Properties";
    public static final String XML_TAG_SECURITY = "Security";
    public static final String XML_TAG_OWNER = "Owner";
    public static final String XML_TAG_PERMISSIONS = "Permissions";
    public static final String XML_TAG_ACCESSPERM = "AccessPermission";
    public static final String XML_TAG_GRANTEE = "Grantee";
    public static final String XML_TAG_ACCESS_TYPE = "AccessType";
    public static final String XML_TAG_INHERIT_DEPTH = "InheritableDepth";
    public static final String XML_TAG_ACCESS_MASK = "AccessMask";
    public static final String XML_TAG_PERM_SOURCE = "PermissionSource";
    public static final String XML_TAG_OBJECT_TYPE = "ObjectType";
    public static final String XML_TAG_OBJECT_REF = "ObjectRef";
    public static final String XML_TAG_OBJECT_ID = "ObjectId";
    public static final String XML_TAG_OBJECT_NAME = "Name";
    public static final String XML_TAG_SID = "SID";
    public static final String XML_TAG_SHORT_NAME = "ShortName";
    public static final String XML_TAG_DISPLAY_NAME = "DisplayName";
    public static final String XML_TAG_PRINCIPAL_TYPE = "PrincipalType";
    public static final String XML_TAG_CLASS_ID = "ClassId";
    public static final String XML_TAG_EXTERNAL = "ExternalRef";
    public static final String XML_TAG_ENCODED = "EncodedContent";
    public static final String XML_TAG_DEF_INST_PERMS = "DefaultInstancePermissions";
    public static final String XML_TAG_DEF_INST_OWNER = "DefaultInstanceOwner";
    public static final String XML_TAG_OBJECTSTORE_ID = "StoreId";
    public static final String XML_TAG_TEMPLATE_PERMS = "TemplatePermissions";
    public static final String XML_TAG_PRIMARY_ID = "PrimaryId";
    public static final String XML_TAG_LOCALE_NAME = "LocaleName";
    public static final String XML_TAG_DOCUMENTS = "Documents";
    public static final String XML_TAG_CLASSDEFINITIONS = "ClassDefinitions";
    public static final String XML_TAG_IMPORT_ERRORS = "ImportErrors";
    public static final String XML_TAG_SYMBOLIC_NAME = "SymbolicName";
    public static final String XML_TAG_MAJOR_VER_NUMBER = "MajorVersionNumber";
    public static final String XML_TAG_MINOR_VER_NUMBER = "MinorVersionNumber";
    public static final String XML_TAG_EXCEPTION_CODE = "ExceptionCode";
    public static final String XML_TAG_EXCEPTION_MSG = "ExceptionMessage";
    public static final String XML_TAG_HRESULT = "HRESULT";
    public static final String XML_TAG_EXPORT_OPTIONS = "ExportOptions";
    public static final String XML_TAG_STRING = "String";
    public static final String XML_TAG_INTEGER = "Integer32";
    public static final String XML_TAG_DATETIME = "DateTime";
    public static final String XML_TAG_BOOLEAN = "Boolean";
    public static final String XML_TAG_FLOAT = "Float64";
    public static final String XML_TAG_BINARY = "Binary";
    public static final String XML_TAG_ID = "Id";
    public static final String XML_TAG_OBJECT = "Object";
    public static final String XML_TAG_EXPORTFILTER = "ExportFilter";
    public static final String XML_TAG_OBJECTFILTER = "ObjectFilter";
    public static final String XML_TAG_INCLUDEPROPS = "IncludeProperties";
    public static final String XML_TAG_EXCLUDEPROPS = "ExcludeProperties";
    public static final String XML_TAG_OBJECT_MANIFEST = "ObjectManifest";
    public static final String XML_ATTR_OVPRECURSION = "OVPRecursion";
    public static final String XML_ATTR_SYMBOLIC_NAME = "SymbolicName";
    public static final String XML_ATTR_ID = "Id";
    public static final String XML_ATTR_CREATED_BY = "ExportObjectsCreatedBy";
    public static final String XML_ATTR_MODIFIED_SINCE = "ExportObjectsModifiedSince";
    public static final String XML_ATTR_SUBS_ON_OBJECT = "ExportSubscriptionsOnObject";
    public static final String XML_ATTR_OBJECT_METADATA = "ExportObjectMetadata";
    public static final String XML_MT_DOC_LC_ACTIONS = "DocumentLifecycleActions";
    public static final String XML_MT_DOC_LC_POLICIES = "DocumentLifecyclePolicies";
    public static final String XML_MT_CHOICE_LISTS = "ChoiceLists";
    public static final String XML_MT_PROP_TEMPLATES = "PropertyTemplates";
    public static final String XML_MT_CLASS_DEFS = "ClassDefinitions";
    public static final String XML_MT_CUSTOM_OBJECTS = "CustomObjects";
    public static final String XML_MT_FOLDERS = "Folders";
    public static final String XML_MT_DOCUMENTS = "Documents";
    public static final String XML_MT_ANNOTATIONS = "Annotations";
    public static final String XML_MT_EVENT_ACTIONS = "EventActions";
    public static final String XML_MT_SUBSCRIPTIONS = "Subscriptions";
    public static final String XML_MT_OTHERS = "Others";
    public static final String XML_MT_RCRS = "ReferentialContainmentRelationships";
    public static final String XML_MT_DRCRS = "DynamicReferentialContainmentRelationships";
    public static final int MAX_PATH = 260;
    public static final int BUFFER_SIZE = 6144;
    public static final String SID_CREATOR_OWNER = "S-1-3-0";
    public static final String SID_AUTHENTICATED_USERS = "S-1-5-11";
    public static final String THIS_PROPERTY = "This";
    public static final String[] TypeToString = new String[]{" ", "Binary", "Boolean", "DateTime", "Float64", "Id", "Integer32", "Object", "String"};

    public static Node selectSingleNode(Node parent, String nodeName) {
        Node node = null;
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength() && !nodeName.equalsIgnoreCase((node = nodes.item(i)).getNodeName()); ++i) {
            node = null;
        }
        return node;
    }

    public static String getNodeValue(Node node) {
        String value = null;
        if (node != null) {
            if (node.getNodeType() != 3) {
                node = node.getFirstChild();
            }
            if (node != null) {
                value = node.getNodeValue();
            }
        }
        return value;
    }

    public static boolean isOptionalParamPresent(Object optParam) {
        return optParam != null;
    }

    public static String loadXMLFile(String fileName) {
        StringBuffer sbuf = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            String line = "";
            while ((line = in.readLine()) != null) {
                sbuf.append(line);
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sbuf.toString();
    }

    public static void lookupPrincipal(Principal principal) {
        block13: {
            String Index = "";
            if (principal.sid != null && principal.sid.length() > 0) {
                Index = principal.sid;
            } else if (principal.name != null && principal.name.length() > 0) {
                Index = principal.name;
            } else {
                throw new EngineRuntimeException(ExceptionCode.E_BAD_PARAMETER, null);
            }
            Domain domain = MetadataCacheIE.getLocalDomain();
            try {
                Group group = null;
                try {
                    group = Factory.Group.fetchInstance(domain.getConnection(), Index, new PropertyFilter());
                }
                catch (EngineRuntimeException e) {
                    ExceptionCode ec = e.getExceptionCode();
                    if (ec.equals(ExceptionCode.E_OBJECT_NOT_FOUND) || ec.equals(ExceptionCode.E_INVALID_REQUEST)) {
                        throw new EngineRuntimeException(ExceptionCode.E_OBJECT_NOT_FOUND);
                    }
                    throw new EngineRuntimeException((Throwable)e, ExceptionCode.E_UNEXPECTED, null);
                }
                if (group != null) {
                    principal.sid = group.get_Id();
                    principal.name = group.get_Name();
                    principal.shortName = group.get_ShortName();
                    principal.displayName = group.get_DisplayName();
                    principal.principalType = SecurityPrincipalType.GROUP;
                }
            }
            catch (EngineRuntimeException e) {
                ExceptionCode ec = e.getExceptionCode();
                if (!ec.equals(ExceptionCode.E_OBJECT_NOT_FOUND) && !ec.equals(ExceptionCode.E_INVALID_REQUEST)) break block13;
                try {
                    User user = Factory.User.fetchInstance(domain.getConnection(), Index, new PropertyFilter());
                    if (user != null) {
                        principal.sid = user.get_Id();
                        principal.name = user.get_Name();
                        principal.shortName = user.get_ShortName();
                        principal.displayName = user.get_DisplayName();
                        principal.principalType = SecurityPrincipalType.USER;
                    }
                }
                catch (Exception e2) {
                    throw new EngineRuntimeException(e2, ExceptionCode.E_VALUE_NOT_SET, null);
                }
            }
        }
    }

    public static boolean isPersistentProperty(PropertyDescription propDesc) {
        if (propDesc.getProperties().isPropertyPresent("IsPersistent")) {
            return propDesc.getProperties().getBooleanValue("IsPersistent");
        }
        return propDesc.getProperties().getInteger32Value("PersistenceType") != 0;
    }

    public static String toXmlDateTime(Date dateTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        String xmlDateTime = dateFormat.format(dateTime);
        return xmlDateTime;
    }

    public static Date fromXmlDateTime(String xmlDateTime) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS'Z'");
        Date date = null;
        try {
            date = dateFormat.parse(xmlDateTime);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return date;
    }

    public static String formatId(String id) {
        if (id != null && id.length() > 0) {
            if (!id.startsWith("{")) {
                id = "{" + id;
            }
            if (!id.endsWith("}")) {
                id = id + "}";
            }
        }
        return id;
    }

    public static String unFormatId(String id) {
        if (id != null && id.length() > 0) {
            if (id.startsWith("{")) {
                id = id.substring(1);
            }
            if (id.endsWith("}")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        return id.toLowerCase();
    }

    public static boolean isDeleted(IndependentlyPersistableObject ipo) {
        PendingAction[] pas = ipo.getPendingActions();
        if (pas.length > 0) {
            for (int i = 0; i < pas.length; ++i) {
                if (!(pas[i] instanceof Delete)) continue;
                return true;
            }
        }
        return false;
    }

    public static PropertyFilter propFilter() {
        PropertyFilter propFilter = new PropertyFilter();
        propFilter.setLevelDependents(true);
        propFilter.addExcludeProperty("QueryOperatorDescriptions");
        return propFilter;
    }

    public static void nodeToBuffer(Node node, StringBuffer sb, int level, boolean formatted) {
        StringBuffer sbIndent = new StringBuffer();
        if (formatted) {
            for (int i = 0; i < level * 4; ++i) {
                sbIndent.append(" ");
            }
            sb.append("\n");
            sb.append(sbIndent);
        }
        if (node.hasChildNodes()) {
            Node firstChild = node.getFirstChild();
            if (firstChild.getNodeType() == 3) {
                if (firstChild.getNodeValue() != null && firstChild.getNodeValue() != "") {
                    sb.append("<" + node.getNodeName() + ">" + firstChild.getNodeValue() + "</" + node.getNodeName() + ">");
                } else {
                    sb.append("<" + node.getNodeName() + "/>");
                }
            } else {
                sb.append("<" + node.getNodeName() + ">");
                NodeList nodes = node.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    ImportExportUtil.nodeToBuffer(nodes.item(i), sb, level + 1, formatted);
                }
                if (formatted) {
                    sb.append("\n");
                    sb.append(sbIndent);
                }
                sb.append("</" + node.getNodeName() + ">");
            }
        } else {
            sb.append("<" + node.getNodeName() + "/>");
        }
    }

    public static class Principal {
        public String sid = "";
        public String name = "";
        public String shortName = "";
        public String displayName = "";
        public SecurityPrincipalType principalType = SecurityPrincipalType.USER;
    }

    public static class ExportOptions {
        public static final int EXPORT_OBJECT_ID = 1;
        public static final int EXPORT_SECURITY = 2;
        public static final int EXPORT_ENCODED_CONTENT = 16;
        public static final int EXPORT_CONTENT_REF = 32;
        public static final int EXPORT_SCHEMA_REF = 64;
        public static final int EXPORT_FULL = 128;
    }

    public static class ImportOptions {
        public static final int IMPORT_OBJECT_ID = 1;
        public static final int IMPORT_PERMISSIONS = 2;
        public static final int IMPORT_OWNER = 8;
        public static final int IMPORT_NULL_VALUES = 16;
        public static final int IMPORT_PRIVILEGED_SETTABILITY_PROPERTIES = 256;
        public static final int IMPORT_THROW_EXCEPTION = 512;
        public static final int IMPORT_ADDON = 1024;
        public static final int IMPORT_UPGRADE_ADDON = 2048;
    }
}

