/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.ConfigValueLookup;
import com.filenet.apiimpl.util.SubSystem;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class ErrorLayout
extends Layout {
    private static final String productID = "FNRCE";
    private static final Pattern ERE_TOSTRING_ERRORID_PULLER = Pattern.compile(EngineRuntimeException.class.getName() + ": (" + "FNRCE" + "[0-9]{4})");
    private static final int BUF_SIZE = 1024;
    private static final int MAX_CAPACITY = 2048;
    private static final boolean USE_MDC = false;
    private static final String[] SPACE_PADDING = new String[]{" ", "  ", "   ", "    "};
    private static final String[] ZERO_PADDING = new String[]{"0", "00", "000", "0000", "00000", "000000", "0000000", "00000000"};
    private static final String PREAMBLE_SEP = " - ";
    private static final String FILENET_LOGGER_NAME_BEGIN = "filenet_";
    private static final int FILENET_LOGGER_NAME_BEGIN_LEN = "filenet_".length();
    private static final int DOT = 46;
    private static final String NEWLINE = "\n";
    private static final Hashtable loggerNamesToSubSysAbbrev = new Hashtable();
    private StringBuffer sbuf = new StringBuffer(1024);
    static final TimeZone utcTz = TimeZone.getTimeZone("GMT+00");
    protected static final String LOGFILE_DATE_SDF_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private final Date date = new Date(0L);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String NEWLINE_ESCAPE = "\\n";
    private static final String ESCAPE_ESCAPE = "\\\\";

    public ErrorLayout() {
        this.sdf.setTimeZone(utcTz);
    }

    public void activateOptions() {
        ErrorLayout.activateOptionsCommon();
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public String getHeader() {
        return ErrorLayout.getHeaderCommon();
    }

    public String format(LoggingEvent event) {
        return ErrorLayout.formatCommon(event, this.sbuf, this.date, this.sdf, "ErrorLayout", false);
    }

    static final String formatCommon(LoggingEvent event, StringBuffer sbuf, Date date, SimpleDateFormat sdf, String whichLayout, boolean singleLine) {
        String tidTxt;
        if (sbuf == null || sbuf.capacity() > 2048) {
            sbuf = new StringBuffer(1024);
        } else {
            sbuf.setLength(0);
        }
        date.setTime(event.timeStamp);
        sbuf.append(sdf.format(date));
        sbuf.append(SPACE_PADDING[0]);
        int thdid = 0;
        if (thdid == 0) {
            Thread thd = Thread.currentThread();
            thdid = thd.hashCode();
        }
        if ((tidTxt = Integer.toHexString(thdid).toUpperCase()).length() < 8) {
            sbuf.append(ZERO_PADDING[7 - tidTxt.length()]);
        }
        sbuf.append(tidTxt);
        sbuf.append(SPACE_PADDING[0]);
        String subSysAbbrev = null;
        if (subSysAbbrev == null) {
            String logName = event.getLoggerName();
            if (!loggerNamesToSubSysAbbrev.containsKey(logName)) {
                if (logName.startsWith(FILENET_LOGGER_NAME_BEGIN)) {
                    int dotIdx = logName.indexOf(46, FILENET_LOGGER_NAME_BEGIN_LEN);
                    if (dotIdx > 0) {
                        int subSysBeginIdx = dotIdx + 1;
                        String subSysName = (dotIdx = logName.indexOf(46, subSysBeginIdx)) > 0 ? logName.substring(subSysBeginIdx, dotIdx) : logName.substring(subSysBeginIdx);
                        SubSystem subSys = SubSystem.getSubSystem(subSysName);
                        if (subSys != null) {
                            subSysAbbrev = subSys.getAbbreviation();
                        } else {
                            LogLog.error((String)("Invalid subsystem portion of logger name: " + logName));
                        }
                    } else {
                        LogLog.error((String)("Invalid logger name being used, no part follows special filenet_ part: " + logName));
                    }
                } else {
                    LogLog.debug((String)("FileNet " + whichLayout + "used with a non-FileNet logger: " + logName));
                }
                loggerNamesToSubSysAbbrev.put(logName, subSysAbbrev);
            } else {
                subSysAbbrev = (String)loggerNamesToSubSysAbbrev.get(logName);
            }
        }
        if (subSysAbbrev != null) {
            sbuf.append(subSysAbbrev);
            int len = subSysAbbrev.length();
            if (len < 4) {
                sbuf.append(SPACE_PADDING[3 - len]);
            }
        } else {
            sbuf.append(SPACE_PADDING[3]);
        }
        sbuf.append(SPACE_PADDING[0]);
        String renderedMessage = event.getRenderedMessage();
        String errorId = "FNRCE0000";
        ThrowableInformation ti = event.getThrowableInformation();
        if (ti != null) {
            Throwable t = ti.getThrowable();
            if (t instanceof EngineRuntimeException) {
                EngineRuntimeException ere = (EngineRuntimeException)t;
                ExceptionCode ec = ere.getExceptionCode();
                errorId = ec.getErrorId();
            }
        } else {
            Matcher m;
            String s = renderedMessage;
            if (s != null && (m = ERE_TOSTRING_ERRORID_PULLER.matcher(s)).find()) {
                errorId = m.group(1);
            }
        }
        sbuf.append(errorId);
        Level level = event.getLevel();
        if (level.equals((Object)Level.INFO)) {
            sbuf.append("I");
        } else if (level.equals((Object)Level.WARN)) {
            sbuf.append("W");
        } else if (level.equals((Object)Level.ERROR)) {
            sbuf.append("E");
        } else if (level.equals((Object)Level.DEBUG)) {
            sbuf.append("D");
        } else {
            sbuf.append("-");
        }
        sbuf.append(PREAMBLE_SEP);
        if (!Level.ALL.isGreaterOrEqual((Priority)level)) {
            sbuf.append(level.toString());
            sbuf.append(SPACE_PADDING[0]);
        }
        ErrorLayout.appendRenderedMessage(sbuf, renderedMessage, singleLine);
        String[] tstrrep = event.getThrowableStrRep();
        if (tstrrep != null) {
            for (int i = 0; i < tstrrep.length; ++i) {
                sbuf.append(singleLine ? NEWLINE_ESCAPE : NEWLINE);
                sbuf.append(tstrrep[i]);
            }
        }
        sbuf.append(Layout.LINE_SEP);
        return sbuf.toString();
    }

    static final String getHeaderCommon() {
        StringBuffer sbHeader = new StringBuffer(100);
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "unknown host";
        }
        String productName = ConfigValueLookup.getValue("ProductName", null);
        String productVersion = ConfigValueLookup.getValue("ProductVersion", null);
        String buildVersion = ConfigValueLookup.getValue("BuildVersion", null);
        sbHeader.append(productName + " Version: " + productVersion + " Build: " + buildVersion + " on " + hostName + '\n');
        sbHeader.append("All times are GMT; local time zone is " + TimeZone.getDefault().getDisplayName() + '\n');
        String virtualServerName = ConfigValueLookup.getValue("com.filenet.gcd.VirtualServerName", null);
        String serverInstanceName = ConfigValueLookup.getValue("com.filenet.gcd.ServerInstanceName", null);
        sbHeader.append("VirtualServer: " + virtualServerName + " " + "ServerInstance: " + serverInstanceName + '\n');
        sbHeader.append("Date (GMT)               Thread   Sub  Category     Sev  Message\n");
        return sbHeader.toString();
    }

    private static void appendRenderedMessage(StringBuffer sbuf, String msg, boolean singleLine) {
        if (!singleLine) {
            sbuf.append(msg);
        } else {
            int current = 0;
            int len = msg.length();
            for (int i = 0; i < len; ++i) {
                char c = msg.charAt(i);
                if (c == '\n' || c == '\f') {
                    sbuf.append(msg.substring(current, i));
                    sbuf.append(NEWLINE_ESCAPE);
                    current = i + 1;
                    continue;
                }
                if (c == '\r') {
                    sbuf.append(msg.substring(current, i));
                    sbuf.append(NEWLINE_ESCAPE);
                    if (i + 1 < len && msg.charAt(i + 1) == '\n') {
                        ++i;
                    }
                    current = i + 1;
                    continue;
                }
                if (c != '\\') continue;
                sbuf.append(msg.substring(current, i));
                sbuf.append(ESCAPE_ESCAPE);
                current = i + 1;
            }
            if (current < len) {
                sbuf.append(msg.substring(current));
            }
        }
    }

    static void activateOptionsCommon() {
    }
}

