/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public class EnumValues {
    public static final ConfigurationParameter[] CONFIGURATION_PARAMETERS = (ConfigurationParameter[])EnumValues.getValues(ConfigurationParameter.class);

    private static Object[] getValues(final Class enumClass) {
        return (Object[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    ArrayList<Object> values = new ArrayList<Object>();
                    Field[] fields = enumClass.getFields();
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        if (!field.getType().equals(enumClass)) continue;
                        values.add(field.get(null));
                    }
                    return values.toArray((Object[])Array.newInstance(enumClass, values.size()));
                }
                catch (IllegalAccessException e) {
                    throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, new Object[0]);
                }
            }
        });
    }
}

