/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Digest {
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA1";

    public static byte[] getDigest(String fileName) {
        return Digest.getDigest(fileName, DEFAULT_DIGEST_ALGORITHM);
    }

    public static byte[] getDigest(String fileName, String digestAlgorithm) {
        byte[] result = null;
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
            result = Digest.getDigest(in, digestAlgorithm);
            in.close();
        }
        catch (IOException ioe) {
            throw new EngineRuntimeException(ioe, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return result;
    }

    public static byte[] getDigest(InputStream inputStream) {
        return Digest.getDigest(inputStream, DEFAULT_DIGEST_ALGORITHM);
    }

    public static byte[] getDigest(InputStream inputStream, String digestAlgorithm) {
        byte[] result = null;
        try {
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            int MY_BUF_SIZE = 4096;
            byte[] myBuf = new byte[4096];
            while (0 < (bytesRead = inputStream.read(myBuf))) {
                md.update(myBuf, 0, bytesRead);
            }
            result = md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new EngineRuntimeException(nsae, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        catch (IOException ioe) {
            throw new EngineRuntimeException(ioe, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return result;
    }

    public static byte[] getDigest(char[] input) {
        return Digest.getDigest(input, DEFAULT_DIGEST_ALGORITHM);
    }

    public static byte[] getDigest(char[] input, String digestAlgorithm) {
        ByteBuffer bb = ByteBuffer.allocate(input.length * 2);
        CharBuffer cb = bb.asCharBuffer();
        cb.put(input);
        byte[] result = Digest.getDigest(bb.array(), digestAlgorithm);
        return result;
    }

    public static byte[] getDigest(byte[] input) {
        return Digest.getDigest(input, DEFAULT_DIGEST_ALGORITHM);
    }

    public static byte[] getDigest(byte[] input, String digestAlgorithm) {
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(input);
            result = md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new EngineRuntimeException(nsae, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return result;
    }
}

