/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.apiimpl.util.Digest;
import com.filenet.apiimpl.util.UTF8Helper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    protected static final int ITER_COUNT = 1019;
    private static final String SALT_DIGEST_ALG = "SHA-256";
    private static final String IV_DIGEST_ALG = "SHA-256";
    private static final String HMAC_ALG = "HMACSHA256";
    protected String cipherParam = null;
    protected String algorithm = null;
    protected String mode = null;
    protected String padding = null;
    protected int keySize = -1;
    protected Key key = null;
    protected KeyPair keyPair = null;
    protected AlgorithmParameterSpec aps = null;
    protected int cipherBlockSize = 0;

    public static byte[] encryptBytes(String cipherParams, Key key, byte[] plainText) {
        Crypto c = new Crypto();
        c.init(cipherParams, key);
        return c.cryptoBytes(1, plainText);
    }

    public static byte[] decryptBytes(String cipherParams, Key key, byte[] cipherText) {
        Crypto c = new Crypto();
        c.init(cipherParams, key);
        return c.cryptoBytes(2, cipherText);
    }

    public static byte[] encryptBytes(String cipherParams, byte[] encodedKey, byte[] plainText) {
        Crypto c = new Crypto();
        c.init(cipherParams, encodedKey);
        return c.cryptoBytes(1, plainText);
    }

    public static byte[] decryptBytes(String cipherParams, byte[] encodedKey, byte[] cipherText) {
        Crypto c = new Crypto();
        c.init(cipherParams, encodedKey);
        return c.cryptoBytes(2, cipherText);
    }

    private void initCipherParam(String cipherParam) {
        this.cipherParam = cipherParam;
        String[] parts = cipherParam.split("/");
        if (1 <= parts.length) {
            this.algorithm = parts[0];
        }
        if (1 < parts.length) {
            this.mode = parts[1];
        }
        if (2 < parts.length) {
            this.padding = parts[2];
        }
    }

    public void init(String cipherParam) {
        this.initCipherParam(cipherParam);
    }

    public void init(String cipherParam, int keySize) {
        this.initCipherParam(cipherParam);
        this.keySize = keySize;
    }

    public void init(String cipherParam, Key key) {
        this.initCipherParam(cipherParam);
        this.key = key;
    }

    public void init(String cipherParam, byte[] encodedKey) {
        this.initCipherParam(cipherParam);
        this.key = this.decodeKey(encodedKey);
    }

    public void init(String cipherParam, char[] password) {
        this.initCipherParam(cipherParam);
        this.generatePBEKey(password);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getMode() {
        return this.mode;
    }

    public String getPadding() {
        return this.padding;
    }

    public void setKey(Key key) {
        this.key = key;
    }

    public Key getKey() {
        return this.key;
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public PublicKey getPublicKey() {
        return this.keyPair.getPublic();
    }

    public void generateSymmetricKey() {
        this.key = null;
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(this.algorithm);
            if (-1 != this.keySize) {
                keygen.init(this.keySize);
            }
            this.key = keygen.generateKey();
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public SecretKeySpec decodeKey(byte[] encodedKey) {
        SecretKeySpec ks = null;
        try {
            ks = new SecretKeySpec(encodedKey, this.algorithm);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return ks;
    }

    public void generatePBEKey(char[] password) {
        this.key = null;
        byte[] utf8Password = UTF8Helper.encode(password);
        byte[] utf8PwdRev = new byte[utf8Password.length];
        for (int i = 0; i < utf8Password.length; ++i) {
            utf8PwdRev[i] = utf8Password[utf8Password.length - 1 - i];
        }
        byte[] salt2 = Digest.getDigest(utf8PwdRev, "SHA-256");
        Arrays.fill(utf8PwdRev, (byte)0);
        byte[] salt1 = new byte[8];
        System.arraycopy(salt2, 0, salt1, 0, 8);
        this.aps = new PBEParameterSpec(salt1, 1019);
        try {
            PBEKeySpec keySpec = new PBEKeySpec(password, salt2, 1019);
            SecretKeyFactory skf = SecretKeyFactory.getInstance(this.cipherParam);
            this.key = skf.generateSecret(keySpec);
            keySpec.clearPassword();
            Arrays.fill(password, '\u0000');
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    private static void xor(byte[] a, byte[] b) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = (byte)(a[n] ^ b[i]);
        }
    }

    private static byte[] getPkcs5Pbkdf2Block(String hmacAlgorithm, byte[] password, byte[] salt, int iterationCount, int blockNum) {
        int i;
        byte[] result = null;
        byte[] blkSalt = new byte[salt.length + 4];
        for (i = 0; i < salt.length; ++i) {
            blkSalt[i] = salt[i];
        }
        blkSalt[i + 3] = (byte)(blockNum & 0xFF);
        blkSalt[i + 2] = (byte)((blockNum >>= 8) & 0xFF);
        blkSalt[i + 1] = (byte)((blockNum >>= 8) & 0xFF);
        blkSalt[i] = (byte)((blockNum >>= 8) & 0xFF);
        try {
            SecretKeySpec ks = new SecretKeySpec(password, hmacAlgorithm);
            Mac m = Mac.getInstance(hmacAlgorithm);
            m.init(ks);
            result = m.doFinal(blkSalt);
            byte[] tmp = new byte[result.length];
            System.arraycopy(result, 0, tmp, 0, tmp.length);
            for (i = 2; i <= iterationCount; ++i) {
                tmp = m.doFinal(tmp);
                Crypto.xor(result, tmp);
            }
        }
        catch (Exception e) {
            System.out.println("got exception: " + e);
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] pkcs5Pbkdf2(String hmacAlgorithm, byte[] password, byte[] salt, int iterationCount, int numBytes) {
        int len;
        byte[] result = new byte[numBytes];
        int blkNum = 1;
        for (int pos = 0; pos < numBytes; pos += len) {
            byte[] block;
            len = pos + (block = Crypto.getPkcs5Pbkdf2Block(hmacAlgorithm, password, salt, iterationCount, blkNum++)).length < numBytes ? block.length : numBytes - pos;
            System.arraycopy(block, 0, result, pos, len);
        }
        Arrays.fill(password, (byte)0);
        return result;
    }

    public static byte[] pkcs5Pbkdf2(char[] password, int numBytes) {
        byte[] utf8Password = UTF8Helper.encode(password);
        Arrays.fill(password, '\u0000');
        byte[] utf8PwdRev = new byte[utf8Password.length];
        for (int i = 0; i < utf8Password.length; ++i) {
            utf8PwdRev[i] = utf8Password[utf8Password.length - 1 - i];
        }
        byte[] salt2 = Digest.getDigest(utf8PwdRev, "SHA-256");
        Arrays.fill(utf8PwdRev, (byte)0);
        return Crypto.pkcs5Pbkdf2(HMAC_ALG, utf8Password, salt2, 1019, numBytes);
    }

    public void genPKIKeys(int keySize) {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.algorithm);
            kpg.initialize(keySize);
            this.keyPair = kpg.generateKeyPair();
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    protected static String hexEncode(byte[] input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            String oneByte = Integer.toHexString(input[i] & 0xFF);
            if (1 == oneByte.length()) {
                sb.append('0');
            }
            sb.append(oneByte);
        }
        return sb.toString();
    }

    protected void dumpState(Cipher cipher) {
        System.out.println("Crypto dump state: " + new Date());
        System.out.println("transform=" + (null != this.cipherParam ? this.cipherParam : "<null>"));
        if (null != cipher) {
            System.out.println("blockSize=" + cipher.getBlockSize());
        } else {
            System.out.println("cipher=<null>");
        }
        if (null != this.key) {
            System.out.println("key=" + Crypto.hexEncode(this.key.getEncoded()));
        } else {
            System.out.println("key=<null>");
        }
        if (null != this.aps) {
            if (this.aps instanceof IvParameterSpec) {
                IvParameterSpec ips = (IvParameterSpec)this.aps;
                System.out.println("iv=" + Crypto.hexEncode(ips.getIV()));
            } else {
                System.out.println("aps (not handled)");
            }
        } else {
            System.out.println("aps=<null>");
        }
        Provider[] providers = Security.getProviders();
        if (0 < providers.length) {
            System.out.println("Providers:");
            for (int i = 0; i < providers.length; ++i) {
                System.out.println(i + ": " + providers[i]);
            }
        }
    }

    protected Cipher getCipher(int opMode) {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.cipherParam);
            if (null != this.mode && this.mode.equalsIgnoreCase("CBC") && null == this.aps) {
                byte[] encodedKey = this.key.getEncoded();
                this.aps = new IvParameterSpec(Digest.getDigest(encodedKey, "SHA-256"), 0, cipher.getBlockSize());
            }
            cipher.init(opMode, this.key, this.aps);
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return cipher;
    }

    protected void copyStream(InputStream in, OutputStream out) {
        int byteRead = 0;
        try {
            while (-1 != (byteRead = in.read())) {
                out.write(byteRead);
            }
            out.flush();
        }
        catch (IOException ioe) {
            throw new EngineRuntimeException(ioe, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public InputStream getCryptoInputStream(int opMode, InputStream inputStream) {
        return new CipherInputStream(inputStream, this.getCipher(opMode));
    }

    public OutputStream getCryptoOutputStream(int opMode, OutputStream outputStream) {
        return new CipherOutputStream(outputStream, this.getCipher(opMode));
    }

    public void copyCryptoStream(int opMode, InputStream inputStream, OutputStream outputStream) {
        this.copyStream(inputStream, new CipherOutputStream(outputStream, this.getCipher(opMode)));
    }

    public byte[] cryptoBytes(int opMode, byte[] input) {
        byte[] result = null;
        Cipher cipher = this.getCipher(opMode);
        int inBlkSize = cipher.getBlockSize();
        int outBlkSize = cipher.getOutputSize(inBlkSize);
        try {
            if (!this.algorithm.equalsIgnoreCase("RSA")) {
                result = cipher.doFinal(input);
            } else {
                int resultSize = (input.length / inBlkSize + 1) * outBlkSize + 32;
                ByteBuffer bb = ByteBuffer.allocate(resultSize);
                int outPos = 0;
                int inPos = 0;
                while (inPos < input.length) {
                    int bytesToRead = inPos + inBlkSize > input.length ? input.length - inPos : inBlkSize;
                    byte[] temp = new byte[bytesToRead];
                    System.arraycopy(input, inPos, temp, 0, bytesToRead);
                    byte[] cipherText = cipher.doFinal(temp);
                    bb.put(cipherText);
                    inPos += bytesToRead;
                    outPos += cipherText.length;
                }
                result = new byte[bb.position()];
                System.arraycopy(bb.array(), 0, result, 0, bb.position());
            }
        }
        catch (Exception e) {
            throw new EngineRuntimeException(e, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
        return result;
    }

    public void cryptoFile(int opMode, String inFileName, String outFileName) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(inFileName));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFileName));
            this.copyCryptoStream(opMode, in, out);
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException ioe) {
            throw new EngineRuntimeException(ioe, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public byte[] encryptBytes(byte[] input) {
        return this.cryptoBytes(1, input);
    }

    public InputStream getEncryptedInputStream(InputStream inputStream) {
        return this.getCryptoInputStream(1, inputStream);
    }

    public OutputStream getEncryptedOutputStream(OutputStream outputStream) {
        return this.getCryptoOutputStream(1, outputStream);
    }

    public void encryptStream(InputStream inputStream, OutputStream outputStream) {
        this.copyCryptoStream(1, inputStream, outputStream);
    }

    public void encryptFile(String inFileName, String outFileName) {
        this.cryptoFile(1, inFileName, outFileName);
    }

    public byte[] decryptBytes(byte[] input) {
        return this.cryptoBytes(2, input);
    }

    public InputStream getDecryptedInputStream(InputStream inputStream) {
        return this.getCryptoInputStream(2, inputStream);
    }

    public OutputStream getDecryptedOutputStream(OutputStream outputStream) {
        return this.getCryptoOutputStream(2, outputStream);
    }

    public void decryptStream(InputStream inputStream, OutputStream outputStream) {
        this.copyCryptoStream(2, inputStream, outputStream);
    }

    public void decryptFile(String inFileName, String outFileName) {
        this.cryptoFile(2, inFileName, outFileName);
    }
}

