/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.Id;
import com.filenet.apiimpl.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class ContentSignature {
    public static final int SIGNATURE_LENGTH = 32;
    private static final int[] k = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int[] hv = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private byte[] wb = new byte[64];
    private int wOffset = 0;
    private long totalSize = 0L;
    private int[] w = new int[64];
    private Id uploadId;

    public ContentSignature(Id _uploadId) {
        this.uploadId = _uploadId;
    }

    public ContentSignature(Id _uploadId, String checkpoint) {
        try {
            byte[] serial = Base64.decode(checkpoint);
            ByteArrayInputStream bis = new ByteArrayInputStream(serial);
            ObjectInputStream ois = new ObjectInputStream(bis);
            byte[] idBytes = new byte[16];
            ois.read(idBytes, 0, idBytes.length);
            this.uploadId = new Id(idBytes);
            if (!this.uploadId.equals(_uploadId)) {
                throw new EngineRuntimeException(ExceptionCode.E_ACCESS_DENIED);
            }
            for (int i = 0; i < this.hv.length; ++i) {
                this.hv[i] = ois.readInt();
            }
            this.wOffset = ois.readInt();
            if (this.wOffset != 0) {
                ois.read(this.wb, 0, this.wOffset);
            }
            this.totalSize = ois.readLong();
            byte[] sig = new byte[32];
            System.arraycopy(serial, serial.length - 32, sig, 0, 32);
            ContentSignature cs = new ContentSignature(this.uploadId);
            cs.addChunk(serial, 0, serial.length - 32);
            cs.finalize();
            byte[] newSig = cs.getSignature();
            if (!Arrays.equals(sig, newSig)) {
                throw new EngineRuntimeException(ExceptionCode.E_ACCESS_DENIED);
            }
        }
        catch (Throwable t) {
            if (t instanceof EngineRuntimeException) {
                throw (EngineRuntimeException)t;
            }
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    public void addChunk(byte[] chunk) {
        this.addChunk(chunk, 0, chunk.length);
    }

    public void addChunk(byte[] chunk, int offset, int length) {
        this.totalSize += (long)length;
        for (int i = 0; i < length; ++i) {
            this.wb[this.wOffset] = chunk[i + offset];
            if (++this.wOffset != 64) continue;
            this.process64Bytes();
        }
    }

    public void finish() {
        this.wb[this.wOffset] = -128;
        if (++this.wOffset == 64) {
            this.process64Bytes();
        }
        if (this.wOffset >= 56) {
            while (this.wOffset < 64) {
                this.wb[this.wOffset++] = 0;
            }
            this.process64Bytes();
        }
        while (this.wOffset < 56) {
            this.wb[this.wOffset++] = 0;
        }
        long bitCount = this.totalSize << 3;
        this.wb[56] = (byte)(bitCount >>> 56 & 0xFFL);
        this.wb[57] = (byte)(bitCount >>> 48 & 0xFFL);
        this.wb[58] = (byte)(bitCount >>> 40 & 0xFFL);
        this.wb[59] = (byte)(bitCount >>> 32 & 0xFFL);
        this.wb[60] = (byte)(bitCount >>> 24 & 0xFFL);
        this.wb[61] = (byte)(bitCount >>> 16 & 0xFFL);
        this.wb[62] = (byte)(bitCount >>> 8 & 0xFFL);
        this.wb[63] = (byte)(bitCount & 0xFFL);
        this.process64Bytes();
    }

    public byte[] getSignature() {
        byte[] result = new byte[32];
        int i4 = 0;
        for (int i = 0; i < 8; ++i) {
            result[i4++] = (byte)(this.hv[i] >>> 24 & 0xFF);
            result[i4++] = (byte)(this.hv[i] >>> 16 & 0xFF);
            result[i4++] = (byte)(this.hv[i] >>> 8 & 0xFF);
            result[i4++] = (byte)(this.hv[i] & 0xFF);
        }
        return result;
    }

    public String getBase64Signature() {
        return Base64.encode(this.getSignature());
    }

    public String checkpoint() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.write(this.uploadId.getBytes());
            for (int i = 0; i < this.hv.length; ++i) {
                oos.writeInt(this.hv[i]);
            }
            oos.writeInt(this.wOffset);
            if (this.wOffset != 0) {
                oos.write(this.wb, 0, this.wOffset);
            }
            oos.writeLong(this.totalSize);
            oos.flush();
            byte[] serial = bos.toByteArray();
            ContentSignature cs = new ContentSignature(this.uploadId);
            cs.addChunk(serial);
            cs.finalize();
            byte[] sig = cs.getSignature();
            byte[] checkpoint = ContentSignature.concat(serial, sig);
            return Base64.encode(checkpoint);
        }
        catch (Throwable t) {
            throw new EngineRuntimeException(t, ExceptionCode.E_UNEXPECTED_EXCEPTION, null);
        }
    }

    private void process64Bytes() {
        int i = 0;
        int i4 = 0;
        while (i < 16) {
            this.w[i++] = (this.wb[i4++] & 0xFF) << 24 | (this.wb[i4++] & 0xFF) << 16 | (this.wb[i4++] & 0xFF) << 8 | this.wb[i4++] & 0xFF;
        }
        while (i < 64) {
            int w15 = this.w[i - 15];
            int w2 = this.w[i - 2];
            this.w[i] = this.w[i - 16] + ((w15 >>> 7 | w15 << 25) ^ (w15 >>> 18 | w15 << 14) ^ w15 >>> 3) + this.w[i - 7] + ((w2 >>> 17 | w2 << 15) ^ (w2 >>> 19 | w2 << 13) ^ w2 >>> 10);
            ++i;
        }
        int a = this.hv[0];
        int b = this.hv[1];
        int c = this.hv[2];
        int d = this.hv[3];
        int e = this.hv[4];
        int f = this.hv[5];
        int g = this.hv[6];
        int h = this.hv[7];
        i = 0;
        while (i < 64) {
            int s1 = (e << 26 | e >>> 6) ^ (e << 21 | e >>> 11) ^ (e << 7 | e >>> 25);
            int t1 = h + s1 + k[i] + this.w[i++] + (e & f) + (~e & g);
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + ((b << 30 | b >>> 2) ^ (b << 19 | b >>> 13) ^ (b << 10 | b >>> 22)) + (b & c) + (d & (b ^ c));
        }
        this.hv[0] = this.hv[0] + a;
        this.hv[1] = this.hv[1] + b;
        this.hv[2] = this.hv[2] + c;
        this.hv[3] = this.hv[3] + d;
        this.hv[4] = this.hv[4] + e;
        this.hv[5] = this.hv[5] + f;
        this.hv[6] = this.hv[6] + g;
        this.hv[7] = this.hv[7] + h;
        this.wOffset = 0;
    }

    private static byte[] concat(byte[] in1, byte[] in2) {
        byte[] out = new byte[in1.length + in2.length];
        System.arraycopy(in1, 0, out, 0, in1.length);
        System.arraycopy(in2, 0, out, in1.length, in2.length);
        return out;
    }

    private static void printHash(byte[] hash) {
        String res = "";
        for (int i = 0; i < hash.length; ++i) {
            if ((hash[i] & 0xF0) == 0) {
                res = res + "0";
            }
            res = res + Integer.toHexString(hash[i] & 0xFF);
            if (i % 4 != 3) continue;
            res = res + " ";
        }
        System.out.println("Hash: " + res);
    }
}

