/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.constants.ConfigurationParameter;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.util.ConfigurationParameters;
import com.filenet.apiimpl.util.BaseLogger;
import com.filenet.apiimpl.util.EnumValues;
import com.filenet.apiimpl.util.SubSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigValueLookup {
    private static final BaseLogger logger = BaseLogger.getBaseLogger(ConfigValueLookup.class, SubSystem.API);
    private static HashMap cache = null;
    public static final String DEFAULT_ENGINE_URL = "Engine";
    public static final String RETRY_INTERVAL = "RetryInterval";
    public static final String MAXIMUM_RETRY = "MaximumRetry";
    public static final String DB_RETRY_INTERVAL = "DBRetryInterval";
    public static final String DB_MAXIMUM_RETRY = "DBMaximumRetry";
    public static final String LOCAL_ENGINE_PATH = "LocalEnginePath";
    public static final String REMOTE_ENGINE_PATH = "RemoteEnginePath";
    public static final String LOCAL_CONTENT_PATH = "LocalContentPath";
    public static final String REMOTE_CONTENT_PATH = "RemoteContentPath";
    public static final String LOCAL_CONTENT_AFFINITY_PATH = "LocalContentAffinityPath";
    public static final String REMOTE_CONTENT_AFFINITY_PATH = "RemoteContentAffinityPath";
    public static final String CHEETAH_BC_MODE = "CheetahBCMode";
    public static final String JAAS_CONFIGURATION_NAME = "JAASConfigurationName";
    public static final String JBOSS_JAAS_CONFIGURATION_NAME = "JBossJAASConfigurationName";
    public static final String EXPIRE_SESSION_INTERVAL = "ExpireSessionInterval";
    public static final String CMC_CD_BATCH_SIZE = "CmcCdBatchSize";
    public static final String CMC_USER_SPECIFIC = "FileNet.CMC.UserSpecific";
    public static final String FORCE_FORWARD_ONLY_RESULT = "ForceForwardOnlyResultSetType";
    public static final String USE_LOCAL_AUTHENTICATION = "com.filenet.api.useLocalAuthentication";
    public static final String ACCESS_MANAGER_CACHE_SIZE = "com.filenet.engine.accessManagerSize";
    public static final String SERVER_INSTANCE_NAME = "com.filenet.gcd.ServerInstanceName";
    public static final String VIRTUAL_SERVER_NAME = "com.filenet.gcd.VirtualServerName";
    public static final String JDBC_DRIVER_INFO = "com.filenet.gcd.jdbcdriverinfo";
    public static final String DDL_TRACING = "com.filenet.db.ddlTracing";
    public static final String ZOS_LOB_SEQUENCE_NAME = "com.filenet.db.zOSLOBSequenceName";
    public static final String ZOS_CREATE_LOB_TABLESPACES = "com.filenet.db.zOSCreateLOBTablespaces";
    public static final String ZOS_ENABLE_DEFAULT_TABLESPACE = "com.filenet.db.zOSEnableDefaultTablespace";
    public static final String DISABLE_PROVIDER_CACHE = "com.filenet.engine.security.DisableProviderCache";
    public static final String SECURITY_TRACE_EXCESSIVE = "com.filenet.engine.security.TraceExcessive";
    public static final String ENABLE_SHARED_PERSISTENCE = "com.filenet.engine.EnableSharedPersistence";
    public static final String SHARED_PERSISTENCE_LENGTH_TRIGGER = "com.filenet.engine.SharedPersistenceLengthTrigger";
    public static final String ENABLE_VERTICAL_SLICING = "com.filenet.engine.EnableVerticalSlicing";
    public static final String VERTICAL_SLICING_COLUMN_TRIGGER = "com.filenet.engine.VerticalSlicingColumnTrigger";
    public static final String MAX_OVERFLOW_TABLES = "com.filenet.engine.MaxOverflowTables";
    public static final String SKIP_UPDATE_ROW_LOCK = "com.filenet.engine.SkipUpdateRowLock";
    public static final String NON_PAGED_QUERY_FASTN = "com.filenet.engine.NonPagedQueryFastN";
    public static final String NON_PAGED_QUERY_OVERFLOW_FASTN = "com.filenet.engine.NonPagedQueryOverflowFastN";
    public static final String DB2_LONGSTRING_LOWER_FUNC = "com.filenet.engine.DB2LongStringLowerFunc";
    public static final String TABLE_OVERFLOW_ROWLENGTH_TRIGGER = "com.filenet.engine.TableOverflowRowlengthTrigger";
    public static final String TABLE_OVERFLOW_ROWLENGTH_PAD = "com.filenet.engine.TableOverflowRowlengthPad";
    public static final String ENABLE_REPLICATION = "com.filenet.replication.EnableReplication";
    public static final String ALLOW_NON_IS_REPL_GROUPS = "com.filenet.replication.AllowNonISGroups";
    public static final String REPL_LEGACY_MOVE_CONTENT = "com.filenet.replication.EnableLegacyMoveContentBehaviour";
    public static final String REPL_DISABLE_IS_BIDI = "com.filenet.replication.DisableISBiDi";
    public static final String ENABLE_CIRCULAR = "com.filenet.imex.EnableCircular";
    public static final String EXPORT_ST_ACE = "com.filenet.imex.exportSecurityTemplateACEs";
    public static final String MDCACHE_LOAD_WAIT = "com.filenet.engine.metadatacache.LoadWaitTime";
    public static final String MAX_UPGRADER_TASKS = "com.filenet.engine.upgrade.MaxUpgraderTasks";
    public static final String AUTO_UPGRADE_DISABLED = "com.filenet.engine.upgrade.AutoUpgradeDisabled";
    public static final String REPLICATION_UPGRADE_DISABLED = "com.filenet.engine.upgrade.ReplicationUpgradeDisabled";
    public static final String UPGRADE_SPECIFIC_OBJECT_STORES = "com.filenet.engine.upgrade.ObjectStores";
    public static final String USERS_CAN_USE_OBJECT_STORE = "com.filenet.engine.upgrade.UsersCanUseObjectStore";
    public static final String TASKS_CAN_USE_OBJECT_STORE = "com.filenet.engine.upgrade.TasksCanUseObjectStore";
    public static final String DEFAULT_LOCALE = "com.filenet.engine.init.DefaultLocale";
    public static final String SILENCE_LOCALE_WARNINGS = "com.filenet.engine.init.SilenceLocaleWarnings";
    public static final String USER_UNIQUEID_ATTR_IS_BINARY = "com.filenet.engine.security.userUniqueIdAttributeIsBinary";
    public static final String GROUP_UNIQUEID_ATTR_IS_BINARY = "com.filenet.engine.security.groupUniqueIdAttributeIsBinary";
    public static final String ENABLE_SUBJECT_CACHE = "com.filenet.engine.security.EnableSubjectCache";
    public static final String SUBJECT_CACHE_TTL_SECONDS = "com.filenet.engine.security.SubjectCacheTTLSeconds";
    public static final String WSI_DEFAULT_NAMESPACE_PERMITTED = "WSIDefaultNamespacePermitted";
    public static final String WSI_TYPE_ATTRIBUTE_REQUIRED = "WSITypeAttributeRequired";
    public static final String WSI_NEEDS_WSIHEADER = "com.filenet.authentication.wsi.needsWSIHeader";
    public static final String WSI_DESER_SPILL_CUTOVER = "FileNet.WSI.SpillCutover";
    public static final String WSI_DESER_BUFSIZE = "FileNet.WSI.DeserializationBufferSize";
    public static final String WSI_HTTP_CHUNK_SIZE = "FileNet.WSI.HttpChunkSize";
    public static final String WSI_HTTP_FAULT_RESPONSE_CODE = "FileNet.WSI.HttpFaultResponseCode";
    public static final String WSI_HTTP_SUCCESS_RESPONSE_CODE = "FileNet.WSI.HttpSuccessResponseCode";
    public static final String WSI_STAX_XML_OUTPUT_FACTORY = "FileNet.WSI.stax.XMLOutputFactory";
    public static final String WSI_STAX_XML_INPUT_FACTORY = "FileNet.WSI.stax.XMLInputFactory";
    public static final String WSI_ENABLE_DIME = "FileNet.WSI.EnableDIME";
    public static final String BUILD_VERSION = "BuildVersion";
    public static final String PRODUCT_VERSION = "ProductVersion";
    public static final String PRODUCT_NAME = "ProductName";
    public static final String TRACE_READER_CLASS = "TraceReaderClass";
    public static final String TRACE_OUTPUT_PROPERTIES = "TraceOutputProperties";
    public static final String TRACE_MAX_CHARS = "TraceMaxChars";
    public static final String TRACE_MAX_BYTES = "TraceMaxBytes";
    public static final String TRACE_BYTE_RADIX = "TraceByteRadix";
    public static final String SKIP_TLC = "skipTLC";
    public static final String MAX_ROLLING_FILE_SIZE = "MaxRollingFileSize";
    public static final String MAX_ROLLING_FILE_BACKUPS = "MaxRollingFileBackups";
    public static final String LOG_ENCODING = "LogFileEncoding";
    public static final String MAX_MA_BUFFER_SIZE = "MaxMemoryAppenderBufferSize";
    public static final String CONTENT_EJB_MIN_POOL_SIZE = "com.filenet.ejb.content.MinPoolSize";
    public static final String CONTENT_EJB_EXPIRY_INTERVAL = "com.filenet.ejb.content.ExpiryInterval";
    public static final String CONTENT_EJB_ACTIVE_EXPIRY_TIME = "com.filenet.ejb.content.ActiveExpiryTime";
    public static final String CONTENT_EJB_IDLE_EXPIRY_TIME = "com.filenet.ejb.content.IdleExpiryTime";
    public static final String CONTENT_EJB_AGE_LIMIT = "com.filenet.ejb.content.AgeLimit";
    public static final String CONTENT_EJB_ALLOW_UPLOAD_FAILOVER = "com.filenet.ejb.content.AllowUploadFailoverAfterFirstChunk";
    public static final String CONTENT_EJB_IGNORE_SIZE_FOR_AFFINTY = "com.filenet.ejb.content.IgnoreSizeForAffinity";
    public static final String CONTENT_STITCH_SEMAPHORE_COUNT = "Content.StitchSemaphoreCount";
    public static final String CONTENT_STITCH_SEMAPHORE_DELAY = "Content.StitchSemaphoreDelay";
    public static final String CONTENT_DELETE_DELAY_SECONDS = "Content.DeleteDelaySeconds";
    public static final String CONTENT_DB_RETRY_INSERT_ATTEMPTS = "Content.DbRetryInsertAttempts";
    public static final String CONTENT_DB_RETRY_STITCH_ATTEMPTS = "Content.DbRetryStitchAttempts";
    public static final String CONTENT_DB_RETRY_WAIT = "Content.DbRetryWaitMilliSec";
    public static final String CONTENT_EXISTS_RETRY_ATTEMPTS = "Content.ExistsRetryAttempts";
    public static final String CONTENT_EXISTS_RETRY_WAIT = "Content.ExistsRetryWait";
    public static final String CONTENT_RENAME_FILE_RETRY_WAIT = "Content.RenameFileRetryWait";
    public static final String CONTENT_RETRIEVE_RETRY_WAIT = "Content.RetrievalRetryWait";
    public static final String CONTENT_UPLOAD_DELETE_BATCH_SIZE = "Content.UploadDeleteBatchSize";
    public static final String CONTENT_UPLOAD_DELETE_WAIT_INTERVAL = "Content.UploadDeleteWaitIntervalMilliSec";
    public static final String CONTENT_UPLOAD_FILE_PER_CHUNK = "Content.UploadFilePerChunk";
    public static final String CONTENT_UPLOAD_STREAM_TTL = "Content.UploadStreamTTLMilliSec";
    public static final String CONTENT_UPLOAD_USE_DB_INPUT_STREAM = "Content.upload.useDBInputStream";
    public static final String CONTENT_DBSTREAM_INIT_WAIT = "Content.DbStreamInitWaitMilliSec";
    public static final String CONTENT_DBSTREAM_INIT_RETRIES = "Content.DbStreamInitRetries";
    public static final String CONTENT_DBSTREAM_USE_CHUNKS = "Content.DbStreamChunksEnabled";
    public static final String CONTENT_DBSTREAM_CHUNK_SIZE = "Content.DbStreamChunkSize";
    public static final String CONTENT_DBSTREAM_TO_FILE = "Content.DbStreamToFile";
    public static final String CONTENT_MAX_ELEMENTS_RETURNED_WITH_CONTENT = "Content.MaxElementsReturnedWithContent";
    public static final String CONTENT_STATE_CLEANUP_INTERVAL_SECONDS = "Content.StateCleanupIntervalSeconds";
    public static final String CONTENT_GET_CONTENT_STATE_IDLE_TTL = "Content.GetContentStateIdleTTLSeconds";
    public static final String CONTENT_PUT_CONTENT_STATE_IDLE_TTL = "Content.PutContentStateIdleTTLSeconds";
    public static final String CONTENT_RUN_GC_ON_FILE_RENAME_FAILURE = "Content.RunGcOnFileRenameFailure";
    public static final String CONTENT_UPLOAD_FD_SYNC_FOR_DB_ENABLED = "Content.upload.FdSyncForDBEnabled";
    public static final boolean CONTENT_UPLOAD_FD_SYNC_FOR_DB_ENABLED_DEFAULT = false;
    public static final String CONTENT_UPLOAD_FD_SYNC_ENABLED = "Content.upload.FdSyncEnabled";
    public static final boolean CONTENT_UPLOAD_FD_SYNC_ENABLED_DEFAULT = true;
    public static final String CONTENT_STREAM_TTL = "Content.StreamTTLSeconds";
    public static final String CONTENT_STREAM_IDLE_TTL = "Content.StreamIdleTTLSeconds";
    public static final String CONTENT_STREAM_AFFINITY_UPLOAD_TTL_MULTIPLIER = "Content.StreamAffinityUploadTTLMultiplier";
    public static final String CONTENT_STREAM_AFFINITY_DOWNLOAD_TTL_MULTIPLIER = "Content.StreamAffinityDownloadTTLMultiplier";
    public static final String CONTENT_AUDIT_CONTENT_QUEUE_DELETE = "Content.AuditContentQueueDelete";
    public static final String CONTENT_COMMIT_UPDATE_BEFORE_SELECT = "Content.CommitUpdateBeforeSelect";
    public static final String CONTENT_DB_CONNECT_ERROR_SLEEP = "Content.DbConnectErrorSleep";
    public static final String CONTENT_DISPATCH_NO_WORK_MAX_WAIT = "Content.DispatchNoworkMaxWait";
    public static final String CONTENT_DISPATCHER_RESOLVES_BATCHES = "Content.DispatcherResolvesBatches";
    public static final String CONTENT_FX_DEV_BACKOFF_DURATION = "Content.FxdevBackoffDuration";
    public static final String CONTENT_TEMP_LEASE_EXPIRATION = "Content.TempLeaseExpiration";
    public static final String CONTENT_USE_ADVANCED_QUEUE_MGMT = "Content.UseAdvancedQueueManagement";
    public static final String CONTENT_CQ_STATEMENT_ISOLATION_LEVEL = "Content.ContentQueueStatementSerialization";
    public static final String CONTENT_CQ_ENABLE_MSSQL_NOLOCK = "Content.ContentQueueSQLNolockEnabled";
    public static final String CONTENT_CQ_ENABLE_DB2_NOLOCK = "Content.ContentQueueDB2NolockEnabled";
    public static final String CONTENT_CQ_ENABLE_DELETE_STMT_ISO = "Content.ContentQueueDeleteLockEnabled";
    public static final String CONTENT_CQ_ENABLE_AUXILIARY_STMT_ISO = "Content.ContentQueueAuxiliaryLockEnabled";
    public static final String CONTENT_CQ_INSTANCE_NAME = "Content.ContentQueueInstanceName";
    public static final String CONTENT_CQ_MSSQL_GLOBAL_LOCK_LITERAL = "Content.SQLGlobalLockLiteral";
    public static final String CONTENT_CQ_MSSQL_INSTANCE_LOCK_LITERAL = "Content.SQLInstanceLockLiteral";
    public static final String CONTENT_CQ_WORKERS_PULL_BATCHES = "Content.CQWorkersPullBatches";
    public static final String CONTENT_CONFIRM_DELETE_USING_SIGNATURE = "Content.ConfirmDeletedUsingSignature";
    public static final String CONTENT_CONFIRM_DELETE_FILES_PER_QUERY = "Content.ConfirmDeletedFilesPerQuery";
    public static final String CONTENT_DELAY_SECONDS_CLEANUP_BEFORE_DELETE = "Content.DelaySecondsCleanupBeforeDelete";
    public static final String CONTENT_FCP_POOL_IDLE_TIMEOUT = "Content.FcpPoolIdleTimeoutSeconds";
    public static final String CONTENT_FCP_POOL_PREF_SIZE = "Content.FcpPoolPreferredSize";
    public static final String CONTENT_FCP_POOL_MAX_IN_USE = "Content.FcpPoolMaxInUse";
    public static final String CONTENT_FCP_POOL_MAX_WAIT = "Content.FcpPoolMaxWaitSeconds";
    public static final String CONTENT_CENTERA_REGISTER_APPNAME = "Content.CenteraAppName";
    public static final String CONTENT_CENTERA_REGISTER_APPVERS = "Content.CenteraAppVers";
    public static final String CONTENT_CENTERA_ENABLE_BLOB_PURGE = "Content.CenteraEnableBlobPurge";
    public static final String CONTENT_CENTERA_CLUSTER_TIME_INTERVAL = "Content.CenteraClusterTimeInterval";
    public static final String CONTENT_HCP_PCH_TRACK_THREADS = "Content.HcpPCHTrackThreads";
    public static final String CONTENT_HCP_DISABLE_PCH = "Content.HcpDisablePCH";
    public static final String CONTENT_HCP_OUTPUT_STREAM_CHUNK_SIZE = "Content.HcpOutputStreamChunkSize";
    public static final String CONTENT_HCP_CONNECTION_TIMEOUT = "Content.HcpConnectionTimeout";
    public static final String CONTENT_HCP_READ_TIMEOUT = "Content.HcpReadTimeout";
    public static final String CONTENT_HCP_FIXED_LENGTH_STREAMING = "Content.HcpFixedLengthStreaming";
    public static final String CONTENT_HCP_DISABLE_CONNECTION_TEST_FILE = "Content.HcpDisableConnectionTestFile";
    public static final String CONTENT_HCP_ALLOW_AUTHN_COOKIE_TRACING = "Content.HcpAllowAuthorizationCookieTracing";
    public static final String CONTENT_HCP_ENABLE_CONTENT_LENGTH_HEADER = "Content.HcpEnableContentLengthHeader";
    public static final String CONTENT_HCP_READ_TIMEOUT_BUMP_PER_MB = "Content.HcpReadTimeoutBumpPerMb";
    public static final String CONTENT_HCP_CONNECTION_TIMEOUT_BUMP_PER_MB = "Content.HcpConnectionTimeoutBumpPerMb";
    public static final String CONTENT_HCP_DISABLE_REDIRECTS = "Content.HcpDisableRedirects";
    public static final String CONTENT_HCP_VALIDATE_HCP_HEADERS_ON_OK = "Content.HcpValidateHcpHeadersOnOK";
    public static final String CONTENT_HCP_MAX_ZERO_LENGTH_STREAM_READS = "Content.HcpMaxZeroLengthStreamReads";
    public static final String CONTENT_HCP_CONNECTION_CLOSE_GET = "Content.HcpConnectionCloseGET";
    public static final String CONTENT_HCP_CONNECTION_CLOSE_HEAD = "Content.HcpConnectionCloseHEAD";
    public static final String CONTENT_HCP_CONNECTION_CLOSE_PUT = "Content.HcpConnectionClosePUT";
    public static final String CONTENT_HCP_CONNECTION_CLOSE_DELETE = "Content.HcpConnectionCloseDELETE";
    public static final String CONTENT_HCP_DISABLE_2GB_SIZE_LIMIT = "Content.HcpDisable2GbSizeLimit";
    public static final String CONTENT_HCP_DELETION_ALLOWED_LITERAL = "Content.HcpDeletionAllowedLiteral";
    public static final String CONTENT_HCP_DELETION_PROHIBITED_LITERAL = "Content.HcpDeletionProhibitedLiteral";
    public static final String CONTENT_HCP_INITIAL_UNSPECIFIED_LITERAL = "Content.HcpInitialUnspecifiedLiteral";
    public static final String CONTENT_HCP_PREVENT_DEVICE_INDEXING = "Content.HcpPreventDeviceIndexing";
    public static final String CONTENT_IS_BACKOFF_ENABLED = "Content.ISBackoffEnabled";
    public static final String CONTENT_IS_SSI_CSM_POLLING_INTERVALS = "Content.ssi.CSMPollingIntervals";
    public static final String CONTENT_IICE_DELETE_PASS_THRU_ENABLED = "Content.IICEDeletePassThruEnabled";
    public static final String CONTENT_IICE_SESSION_POOL_ENABLED = "Content.IICESessionPoolEnabled";
    public static final String CONTENT_IICE_REMOTE_SESSION_POOL_ENABLED = "Content.IICERemoteSessionPoolEnabled";
    public static final String CONTENT_IICE_MAX_DELETE_RETRIES = "Content.IICEMaxDeleteRetries";
    public static final String CONTENT_CMOD_WRITE_SEGMENTS_TO_FILE = "Content.CMODWriteSegmentsToFile";
    public static final String CONTENT_CMOD_WRITE_TO_FILE_LIMIT = "Content.CMODWriteToFileLimit";
    public static final String CONTENT_CMOD_SEGMENT_FILE_RETRY_ATTEMPTS = "Content.CMODSegmentFileRetryAttempts";
    public static final String CONTENT_CMOD_SEGMENT_FILE_RETRY_SLEEP = "Content.CMODSegmentFileSleepDuration";
    public static final String CONTENT_CMOD_SEEK_BUFFER_SIZE = "Content.CMODSeekBufferSize";
    public static final String CONTENT_CMOD_APPLET_DIRECTORY = "Content.CMODAppletDirectory";
    public static final String CONTENT_CMOD_TRACE_DIRECTORY = "Content.CMODTraceDirectory";
    public static final String CONTENT_CMOD_DISABLE_TESTPHASE_LOCKDOWN = "Content.CMODDisableTestPhaseLockdown";
    public static final String CONTENT_CMOD_ENABLE_ODFOLDER_CACHE = "Content.CMODEnableODFolderCache";
    public static final String CONTENT_TSM_TSMJAVAAPI_VERSION = "Content.TsmJavaApi";
    public static final String CONTENT_TSM_CLOSE_AFTER_RETRIEVAL = "Content.TsmCloseAfterRetrieval";
    public static final String CONTENT_TSM_MGMTCLASSCACHE_MAX_ENTRIES = "Content.TsmMgmtClassCacheMaxEntries";
    public static final String CONTENT_TSM_MGMTCLASSCACHE_TTL_SECONDS = "Content.TsmMgmtClassCacheTTLSeconds";
    public static final String CONTENT_TSM_LOG_FILES_DIRECTORY = "Content.TsmLogFilesDirectory";
    public static final String CONTENT_TSM_RETENTION_DELETE_GRACE_PERIOD = "Content.TsmRetentionDeleteGracePeriod";
    public static final String CONTENT_TSM_PCH_TRACK_THREADS = "Content.TsmPCHTrackThreads";
    public static final String CONTENT_TSM_DISABLE_PCH = "Content.TsmDisablePCH";
    public static final String CONTENT_TSM_REGEN_OPTION_FILES = "Content.TsmRegenerateOptionFiles";
    public static final String CONTENT_TSM_MAX_TAPE_READERS = "Content.TsmMaxTapeReaders";
    public static final String CONTENT_TSM_USE_INTERNAL_MOUNT_WAIT = "Content.TsmUseInternalMountWait";
    public static final String CONTENT_TSM_DONT_CLOSE_AFTER_TAPE_READ = "Content.TsmDontCloseAfterTapeRead";
    public static final String CONTENT_TSM_SEEK_BUFFER_SIZE = "Content.TsmSeekBufferSize";
    public static final String CONTENT_TSM_USE_MOUNT_WAIT = "Content.TsmUseMountWait";
    public static final String CONTENT_CFS_FED_DATABASE_JNDINAME = "Content.CFS.JNDINAME";
    public static final String CONTENT_CFS_FED_DATABASE_JNDINAMEXA = "Content.CFS.JNDINAMEXA";
    public static final String CONTENT_CFS_WORKERS_PULL_BATCHES = "Content.CFS.WorkersPullBatches";
    public static final String CONTENT_CFS_AGENT_WAIT_INTERVAL = "Content.CFS.ImportAgentWaitInterval";
    public static final String CONTENT_CACHE_TIME_CONSIDER_ABANDONED_NO_ACTIVITY = "Content.CacheNoActivityTime";
    public static final String CONTENT_CACHE_WAIT_FOR_MORE_PROGRESS = "Content.CacheWaitForMoreProgress";
    public static final String CONTENT_CACHE_TRANSFER_SIZE = "Content.CacheTransferSize";
    public static final String CONTENT_CACHE_INBOUND_MOVER_TASKS = "Content.CacheInboundMoverTasks";
    public static final String CONTENT_CACHE_INBOUND_MOVER_RESCHEDULE_DELAY = "Content.CacheInboundMoverRescheduleDelay";
    public static final String CONTENT_CACHE_INBOUND_MOVER_CONFIG_CHECK_INTERVAL = "Content.CacheInboundMoverConfigCheckInterval";
    public static final String CONTENT_CACHE_INBOUND_MOVER_MAX_ATTEMPTS = "Content.CacheInboundMoverMaxAttempts";
    public static final String CONTENT_CACHE_GLOBAL_OPERATIONS_PERIOD = "Content.CacheGlobalOperationsPeriod";
    public static final String CONTENT_CACHE_SWEEP_PERIOD = "com.filenet.engine.ContentCacheSweepPeriod";
    public static final String CONTENT_CACHE_CLEAR_DELAY = "com.filenet.engine.ClearContentCacheDelay";
    public static final String CONTENT_CACHE_CONSIDER_OLD_TIME = "com.filenet.engine.ContentCacheConsiderOldTime";
    public static final String CONTENT_CACHE_INVALID_ELEMENT_TASKS = "Content.CacheInvalidElementTasks";
    public static final String CONTENT_CACHE_INVALID_HANDLER_RESCHEDULE_DELAY = "Content.CacheInvalidHandlerRescheduleDelay";
    public static final String CONTENT_CACHE_INVALID_HANDLER_ERROR_RESCHEDULE_DELAY = "Content.CacheInvalidHandlerErrorRescheduleDelay";
    public static final String CONTENT_CACHE_INVALID_HANDLER_CONFIG_CHECK_INTERVAL = "Content.CacheInvalidHandlerConfigCheckInterval";
    public static final String CONTENT_CACHE_INVALID_HANDLER_MAX_ATTEMPTS = "Content.CacheInvalidHandlerMaxAttempts";
    public static final String CONTENT_CACHE_INVALID_HANDLER_MAX_ERROR_RETRYS = "Content.CacheInvalidHandlerMaxErrorRetries";
    public static final String CONTENT_CACHE_ABANDON_CLEANUP_AGE_SECONDS = "Content.CacheAbandonCleanupAgeSeconds";
    public static final String CONTENT_CACHE_ABANDON_POLL_PERIOD_SECONDS = "Content.CacheAbandonPollPeriodSeconds";
    public static final String CONTENT_CACHE_ABANDON_MUST_BE_UNCHANGED = "Content.CacheAbandonMustBeUnchanged";
    public static final String CONTENT_CACHE_MONITOR_RESCHEDULE_PERIOD = "Content.CacheMonitorTaskPeriod";
    public static final String CONTENT_CACHE_MONITOR_DIFFERENT_SITE_COUNTER_UPDATE_INTERVAL = "Content.CacheMonitorDifferentSiteCounterUpdateInterval";
    public static final String CONTENT_CACHE_PHYSAREA_GLOBAL_CONTROL_TTL = "Content.CacheGlobalControlFileTTL";
    public static final String CONTENT_CACHE_POPULATION_ABANDON_FILE_AGE = "Content.CachePopulationAbandonFileAge";
    public static final String CONTENT_CACHE_BUDDY_FILE_UPDATE_SIZE_INTERVAL = "Content.CacheBuddyFileUpateSizeInterval";
    public static final String CONTENT_CACHE_MAX_BKG_READ_BUFFER_SIZE = "Content.CacheSourceBkgReaderMaxBufferSizeK";
    public static final String CONTENT_CACHE_MAX_BKG_READ_BUFFERS = "Content.CacheSourceBkgReaderMaxBuffers";
    public static final String CONTENT_CACHE_MAX_PER_BUFFER_PORTION_TIME = "Content.CacheSourceMaxPerBufferPortionTime";
    public static final String CONTENT_CACHE_MAX_PER_BUFFER_PORTION_SIZEK = "Content.CacheSourceMaxPerBufferPortionSizeK";
    public static final String CBR_BROKER_CACHE_REFRESH_SECONDS = "com.filenet.cbr.brokerCacheRefreshSeconds";
    public static final String CBR_BROKER_CACHE_REFRESH_SECONDS_ON_ERROR = "com.filenet.cbr.brokerCacheRefreshSecondsOnError";
    public static final String CBR_VERITY_RANK_CHANGE = "CBR.RankConsistency";
    public static final String RETENTION_MAX_CLOCK_SKEW_SECONDS = "Retention.MaximumClockSkewSeconds";
    public static final String RETENTION_WARN_COMPATIBIITY_MODE = "Retention.WarnCompatibilityMode";
    public static final String CBR_NONCE_CACHE_MAX_CAPACITY = "CBR.NonceCacheMaxCapacity";
    public static final String CBR_NONCE_CACHE_INITIAL_CAPACITY = "CBR.NonceCacheInitialCapacity";
    public static final String CBR_NONCE_CACHE_TIME_TO_LIVE_SECONDS = "CBR.NonceCacheTimeToLiveSeconds";
    public static final String CBR_TIMESTAMP_MAX_PRE_SKEW_SECONDS = "CBR.TimestampMaxPreSkewSeconds";
    public static final String CBR_TIMESTAMP_MAX_POST_SKEW_SECONDS = "CBR.TimestampMaxPostSkewSeconds";
    public static final String TEXT_SEARCH_THREAD_ENABLE = "TextSearchThreadEnable";
    public static final String TEXT_SEARCH_THREAD_ROWLIMIT = "TextSearchThreadRowLimit";
    public static final String TEXT_SEARCH_THREAD_INDEXES = "TextSearchThreadIndexCount";
    public static final String TEXT_SEARCH_MAX_ROWLIMIT = "TextSearchMaxRowLimit";
    public static final String CBR_TS_SERVER_UNAVAILABLE_RETRY_INTERVAL = "CBR.TS.UnavailableRetryInterval";
    public static final String CBR_TS_SERVER_AVAILABLE_PING_INTERVAL = "CBR.TS.AvailablePingInterval";
    public static final String CBR_TS_LEASE_EXPIRY_TIME_INTERVAL = "CBR.TS.LeaseExpiryTimeInterval";
    public static final String CBR_TS_SERVER_DETECT_OVERLOAD_RATIO = "CBR.TS.ServerDetectOverloadRatio";
    public static final String CBR_TS_QUERY_POOL_SIZE = "CBR.TS.QueryPoolSize";
    public static final String CBR_TS_COLLECTION_POOL_SIZE = "CBR.TS.CollectionPoolSize";
    public static final String CBR_TS_TSS_POOL_SIZE = "CBR.TS.TSSPoolSize";
    public static final String CBR_TS_CACHE_TTL = "CBR.TS.CacheTTLSeconds";
    public static final String CBR_TS_REISSUE_IDX_BATCH_SIZE = "CBR.TS.ReissueIndexBatchSize";
    public static final String CBR_TS_REISSUE_IDX_SELECT_SIZE = "CBR.TS.ReissueIndexSelectSize";
    public static final String CBR_CONTENT_FETCH_SERVER_URL_OVERRIDE = "CBR.IdxContentFetchServerURL";
    public static final String USER_DIR = "user.dir";
    public static final String USER_HOME = "user.home";
    public static final String JAVA_HOME = "java.home";
    public static final String CONFIG_AUTO_REFRESH_ENABLED = "Config.AutoRefreshEnabled";
    public static final String CONFIG_AUTO_REFRESH_INTERVAL = "Config.AutoRefreshIntervalSeconds";
    public static final String FCLM_STACKING_HELPER_STANZA = "FCLMStackingHelperStanza";
    public static final String MAX_CONTAINMENT_NAME_PARENTHESIZED_VALUE = "com.filenet.engine.MaxContainmentParenthesizeValue";
    public static final String LOGGER_REFRESH_INTERVAL = "com.filenet.engine.LoggerRefreshInterval";
    public static final String SKIP_USAGECOUNTING = "com.filenet.engine.SkipUsageCounting";
    private static final ClientConfig client = new ClientConfig();
    private static final Properties props = new Properties();
    private static boolean autoRefresh = false;
    private static final int DEFAULT_AUTO_REFRESH_SEC = 300;
    private static long autoRefreshInterval = 300000L;
    private static long lastAutoRefreshCheck = System.currentTimeMillis();
    private static long lastAutoRefresh = 0L;
    private static List autoRefreshConfigFiles = new LinkedList();

    public static int getValueAsInt(String name, int defaultValue) {
        String v = ConfigValueLookup.getValue(name, null);
        if (v == null) {
            return defaultValue;
        }
        int ret = defaultValue;
        try {
            ret = new Integer(v);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return ret;
    }

    public static long getValueAsLong(String name, long defaultValue) {
        String value = ConfigValueLookup.getValue(name, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float getValueAsFloat(String name, float defaultValue) {
        String value = ConfigValueLookup.getValue(name, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static boolean getValueAsBoolean(String name, boolean defaultValue) {
        String value = ConfigValueLookup.getValue(name, null);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultValue;
    }

    public static HashMap getCache() {
        if (cache == null) {
            cache = new HashMap();
        }
        return cache;
    }

    public static synchronized HashMap getCachedValues() {
        return (HashMap)ConfigValueLookup.getCache().clone();
    }

    public static synchronized String getValue(String name, String defaultValue) {
        long curTime;
        if (autoRefresh && (curTime = System.currentTimeMillis()) - lastAutoRefreshCheck > autoRefreshInterval) {
            lastAutoRefreshCheck = curTime;
            ConfigValueLookup.refreshConfig();
        }
        if (ConfigValueLookup.getCache().containsKey(name)) {
            String v = (String)ConfigValueLookup.getCache().get(name);
            return v != null ? v : defaultValue;
        }
        String v = ConfigValueLookup.lookupValue(name);
        ConfigValueLookup.getCache().put(name, v);
        if (logger != null && logger.isSummaryTraceEnabled()) {
            logger.traceSummary("Configuration for:" + name + " value:" + (v != null ? v : defaultValue) + " applied");
        }
        return v != null ? v : defaultValue;
    }

    public static void setValue(String key, String value) {
        if (key != null & value != null) {
            if (props.getProperty(key) == null) {
                props.setProperty(key, value);
            }
            ConfigValueLookup.getCache().put(key, value);
        }
    }

    public static synchronized void clearCache() {
        ConfigValueLookup.getCache().clear();
    }

    public static Map getConfiguredValues() {
        Map configuredValuesMap = (Map)props.clone();
        Field[] fields = ConfigValueLookup.class.getFields();
        for (int idx = 0; idx < fields.length; ++idx) {
            String propertyValue;
            if (!String.class.equals(fields[idx].getType())) continue;
            String propertyName = null;
            try {
                propertyName = (String)fields[idx].get(null);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (propertyName == null || propertyName.equals(USER_DIR) || propertyName.equals(USER_HOME) || propertyName.equals(JAVA_HOME) || (propertyValue = ConfigValueLookup.getPrivilegedProperty(propertyName)) == null) continue;
            configuredValuesMap.put(propertyName, propertyValue);
        }
        HashMap cachedValues = ConfigValueLookup.getCachedValues();
        for (String propertyName : cachedValues.keySet()) {
            if (cachedValues.get(propertyName) == null) continue;
            configuredValuesMap.put(propertyName, cachedValues.get(propertyName));
        }
        Properties sysProps = ConfigValueLookup.getPrivilegedProperties();
        Iterator<Object> properties = null;
        if (sysProps != null) {
            properties = sysProps.keySet().iterator();
        }
        while (properties != null && properties.hasNext()) {
            String propertyValue;
            String propertyName = (String)properties.next();
            if (!propertyName.startsWith("com.filenet.") || (propertyValue = ConfigValueLookup.getPrivilegedProperty(propertyName)) == null) continue;
            configuredValuesMap.put(propertyName, propertyValue);
        }
        return configuredValuesMap;
    }

    public static String lookupValue(String name) {
        return ConfigValueLookup.lookupValue(props, name);
    }

    private static synchronized void refreshConfig() {
        for (String configFile : autoRefreshConfigFiles) {
            Properties refreshedProps = ConfigValueLookup.refreshProperties(configFile);
            if (null == refreshedProps) continue;
            String configProp = refreshedProps.getProperty(CONFIG_AUTO_REFRESH_ENABLED);
            autoRefresh = Boolean.valueOf(configProp);
            if (!autoRefresh) {
                return;
            }
            configProp = refreshedProps.getProperty(CONFIG_AUTO_REFRESH_INTERVAL);
            if (null != configProp) {
                try {
                    int newIntervalSec = Integer.parseInt(configProp);
                    autoRefreshInterval = newIntervalSec * 1000;
                }
                catch (NumberFormatException e) {
                    if (logger != null) {
                        logger.traceDetail("Invalid value for: Config.AutoRefreshIntervalSeconds.  Reverting to default seconds: 300");
                    }
                    autoRefreshInterval = 300000L;
                }
            } else {
                autoRefreshInterval = 300000L;
            }
            Enumeration<Object> keys = refreshedProps.keys();
            while (keys.hasMoreElements()) {
                String propName = (String)keys.nextElement();
                ConfigValueLookup.getCache().remove(propName);
                if (logger == null) continue;
                logger.traceDetail("ConfigValueLookup: refreshing property: " + propName);
            }
            props.putAll((Map<?, ?>)refreshedProps);
        }
    }

    private static String lookupValue(Map properties, String name) {
        Object v;
        String sysProp = ConfigValueLookup.getPrivilegedProperty(name);
        if (sysProp != null) {
            return sysProp;
        }
        Object object = v = properties == null ? null : (Object)properties.get(name);
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    private static final String getPrivilegedProperty(final String propertyName) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propertyName);
            }
        };
        try {
            return (String)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static final Properties getPrivilegedProperties() {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        };
        try {
            return (Properties)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static final boolean getPrivilegedCanRead(final File someFile) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return someFile.canRead();
            }
        };
        try {
            Boolean canRead = (Boolean)AccessController.doPrivileged(paProp);
            return canRead;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static final String getPrivilegedAbsolutePath(final File someFile) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                return someFile.getAbsolutePath();
            }
        };
        try {
            return (String)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private static final FileInputStream getPrivilegedFIS(final File someFile) {
        PrivilegedAction paProp = new PrivilegedAction(){

            public Object run() {
                try {
                    return new FileInputStream(someFile);
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
        };
        try {
            return (FileInputStream)AccessController.doPrivileged(paProp);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ConfigurationParameters parameters) {
        ClientConfig clientConfig = client;
        synchronized (clientConfig) {
            if (ConfigValueLookup.client.initialized) {
                throw new EngineRuntimeException(ExceptionCode.API_INITIALIZED);
            }
            ConfigValueLookup.initParameters();
            if (parameters != null) {
                ConfigValueLookup.client.parameters.setParameters(parameters);
            }
            ConfigValueLookup.client.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getParameter(ConfigurationParameter parameter) {
        if (parameter == null) {
            throw new EngineRuntimeException(ExceptionCode.E_NULL_ARGUMENT, "parameter");
        }
        ClientConfig clientConfig = client;
        synchronized (clientConfig) {
            ConfigValueLookup.initParameters();
            return ConfigValueLookup.client.parameters.getParameter(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initParameters() {
        if (ConfigValueLookup.client.parameters != null) {
            return;
        }
        ConfigurationParameters parameters = new ConfigurationParameters();
        Properties properties = props;
        synchronized (properties) {
            parameters.loadMap(props);
        }
        HashMap<ConfigurationParameter, String> map = new HashMap<ConfigurationParameter, String>();
        for (int i = 0; i < EnumValues.CONFIGURATION_PARAMETERS.length; ++i) {
            ConfigurationParameter parameter = EnumValues.CONFIGURATION_PARAMETERS[i];
            String key = parameter.getStringValue();
            String value = ConfigValueLookup.lookupValue(null, key);
            if (value == null) {
                value = ConfigValueLookup.lookupValue(null, key.toLowerCase());
            }
            if (value == null) continue;
            map.put(parameter, value);
        }
        parameters.loadMap(map);
        ConfigValueLookup.client.parameters = parameters;
    }

    public static boolean getBoolean(ConfigurationParameter parameter, boolean defaultValue) {
        Object value = ConfigValueLookup.getParameter(parameter);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static boolean getBoolean(ConfigurationParameters parameters, ConfigurationParameter parameter, boolean defaultValue) {
        Object value = parameters.getParameter(parameter);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static boolean getBooleanDefault(ConfigurationParameters parameters, ConfigurationParameter parameter, boolean defaultValue) {
        Object value = parameters.getParameter(parameter);
        if (!(value instanceof Boolean)) {
            value = ConfigValueLookup.getParameter(parameter);
        }
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public static int getInt(ConfigurationParameter parameter, int defaultValue) {
        Object value = ConfigValueLookup.getParameter(parameter);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public static int getInt(ConfigurationParameters parameters, ConfigurationParameter parameter, int defaultValue) {
        Object value = parameters.getParameter(parameter);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public static int getIntDefault(ConfigurationParameters parameters, ConfigurationParameter parameter, int defaultValue) {
        Object value = parameters.getParameter(parameter);
        if (!(value instanceof Integer)) {
            value = ConfigValueLookup.getParameter(parameter);
        }
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    public static long getLong(ConfigurationParameter parameter, long defaultValue) {
        Object value = ConfigValueLookup.getParameter(parameter);
        return value instanceof Long ? (Long)value : defaultValue;
    }

    public static long getLong(ConfigurationParameters parameters, ConfigurationParameter parameter, long defaultValue) {
        Object value = parameters.getParameter(parameter);
        return value instanceof Long ? (Long)value : defaultValue;
    }

    public static long getLongDefault(ConfigurationParameters parameters, ConfigurationParameter parameter, long defaultValue) {
        Object value = parameters.getParameter(parameter);
        if (!(value instanceof Long)) {
            value = ConfigValueLookup.getParameter(parameter);
        }
        return value instanceof Long ? (Long)value : defaultValue;
    }

    private static void mergeProperties(String basename) {
        props.putAll((Map<?, ?>)ConfigValueLookup.loadProperties(basename, null));
    }

    public static void mergeProperties(String basename, Class loadingClass) {
        props.putAll((Map<?, ?>)ConfigValueLookup.loadProperties(basename, loadingClass));
    }

    public static void enableAutoRefresh(String configFile, int refreshInterval) {
        autoRefresh = true;
        autoRefreshInterval = refreshInterval;
        autoRefreshConfigFiles.add(configFile);
    }

    private static Properties loadProperties(String basename, Class loadingClass) {
        Properties properties;
        block17: {
            properties = new Properties();
            try {
                File javadir;
                String userDir = ConfigValueLookup.getPrivilegedProperty(USER_DIR);
                String userHome = ConfigValueLookup.getPrivilegedProperty(USER_HOME);
                String javaHome = ConfigValueLookup.getPrivilegedProperty(JAVA_HOME);
                File curdir = userDir == null ? null : new File(userDir, basename);
                File homedir = userHome == null ? null : new File(userHome, basename);
                File file = javadir = javaHome == null ? null : new File(javaHome, basename);
                if (curdir != null && ConfigValueLookup.getPrivilegedCanRead(curdir)) {
                    FileInputStream curdirFIS = ConfigValueLookup.getPrivilegedFIS(curdir);
                    if (curdirFIS != null) {
                        if (logger != null) {
                            logger.info("Loading configuration file: " + curdir);
                        }
                        properties.load(curdirFIS);
                    }
                } else if (homedir != null && ConfigValueLookup.getPrivilegedCanRead(homedir)) {
                    FileInputStream homedirFIS = ConfigValueLookup.getPrivilegedFIS(homedir);
                    if (homedirFIS != null) {
                        if (logger != null) {
                            logger.info("Loading configuration file: " + homedir);
                        }
                        properties.load(homedirFIS);
                    }
                } else if (javadir != null && ConfigValueLookup.getPrivilegedCanRead(javadir)) {
                    FileInputStream javadirFIS = ConfigValueLookup.getPrivilegedFIS(javadir);
                    if (javadirFIS != null) {
                        if (logger != null) {
                            logger.info("Loading configuration file: " + javadir);
                        }
                        properties.load(javadirFIS);
                    }
                } else {
                    InputStream is = ConfigValueLookup.class.getClassLoader().getResourceAsStream(basename);
                    if (is == null && loadingClass != null) {
                        is = loadingClass.getResourceAsStream(basename);
                    }
                    if (is != null) {
                        if (logger != null) {
                            logger.info("Loading configuration resource: " + basename);
                        }
                        properties.load(is);
                    }
                }
            }
            catch (Throwable t) {
                String classname;
                String string = classname = loadingClass == null ? "" : " (" + loadingClass.getName() + ")";
                if (logger == null) break block17;
                logger.error("Error reading properties file: " + basename + classname, t);
            }
        }
        return properties;
    }

    private static Properties refreshProperties(String basename) {
        Properties properties = null;
        try {
            long lastModifiedTime;
            File javadir;
            File propertyFile = null;
            String userDir = ConfigValueLookup.getPrivilegedProperty(USER_DIR);
            String userHome = ConfigValueLookup.getPrivilegedProperty(USER_HOME);
            String javaHome = ConfigValueLookup.getPrivilegedProperty(JAVA_HOME);
            File curdir = userDir == null ? null : new File(userDir, basename);
            File homedir = userHome == null ? null : new File(userHome, basename);
            File file = javadir = javaHome == null ? null : new File(javaHome, basename);
            if (curdir != null && ConfigValueLookup.getPrivilegedCanRead(curdir)) {
                propertyFile = curdir;
            } else if (homedir != null && ConfigValueLookup.getPrivilegedCanRead(homedir)) {
                propertyFile = homedir;
            } else if (javadir != null && ConfigValueLookup.getPrivilegedCanRead(javadir)) {
                propertyFile = javadir;
            }
            if (null != propertyFile && (lastModifiedTime = propertyFile.lastModified()) > lastAutoRefresh) {
                FileInputStream propertyFileFIS;
                lastAutoRefresh = lastModifiedTime;
                String filePath = ConfigValueLookup.getPrivilegedAbsolutePath(propertyFile);
                if (filePath == null) {
                    filePath = propertyFile.getPath();
                }
                if ((propertyFileFIS = ConfigValueLookup.getPrivilegedFIS(propertyFile)) != null) {
                    if (logger != null) {
                        logger.info("Re-Loading configuration file: " + filePath);
                    }
                    properties = new Properties();
                    properties.load(propertyFileFIS);
                }
            }
        }
        catch (Throwable t) {
            if (logger != null) {
                logger.error("Error reading properties file: " + basename, t);
            }
            properties = null;
        }
        return properties;
    }

    static {
        String userDir = ConfigValueLookup.getPrivilegedProperty(USER_DIR);
        String userHome = ConfigValueLookup.getPrivilegedProperty(USER_HOME);
        String javaHome = ConfigValueLookup.getPrivilegedProperty(JAVA_HOME);
        if (userDir == null) {
            userDir = "<unknown>";
        }
        if (userHome == null) {
            userHome = "<unknown>";
        }
        if (javaHome == null) {
            javaHome = "<unknown>";
        }
        if (logger != null) {
            logger.info("Configuration property file search order:\n    user.dir = " + userDir + "\n    " + USER_HOME + " = " + userHome + "\n    " + JAVA_HOME + " = " + javaHome);
        }
        ConfigValueLookup.mergeProperties("Engine.properties");
        ConfigValueLookup.mergeProperties("FileNet.properties");
        ConfigValueLookup.mergeProperties("FileNetBuild.properties", ConfigValueLookup.class);
        ConfigValueLookup.mergeProperties("CEMPBoot.properties");
        autoRefresh = ConfigValueLookup.getValueAsBoolean(CONFIG_AUTO_REFRESH_ENABLED, false);
        if (autoRefresh) {
            int autoRefreshIntervalSeconds = ConfigValueLookup.getValueAsInt(CONFIG_AUTO_REFRESH_INTERVAL, 300);
            autoRefreshInterval = autoRefreshIntervalSeconds * 1000;
            autoRefreshConfigFiles.add("FileNet.properties");
        }
    }

    private static final class ClientConfig {
        ConfigurationParameters parameters = null;
        boolean initialized = false;

        private ClientConfig() {
        }
    }
}

