/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.apiimpl.smm.PCH;
import com.filenet.apiimpl.util.Cache;
import com.filenet.apiimpl.util.CacheEntry;
import com.filenet.pch.Event;
import com.filenet.pch.Meter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class ConcurrentCache
extends Cache {
    private Map idMap = new ConcurrentHashMap();
    private Map valueMap = null;
    Event pchCacheAttempts;
    Event pchCacheHits;
    Meter pchCacheEntries;
    boolean pchMonitoring;
    private static int LRU_QUEUE_MAX_FACTOR = 8;
    private volatile LRUNode lruHead;
    private volatile LRUNode lruTail = this.lruHead = new LRUNode(null);
    private volatile int lruCount = 0;
    private static AtomicReferenceFieldUpdater headUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentCache.class, LRUNode.class, "lruHead");
    private static AtomicReferenceFieldUpdater tailUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentCache.class, LRUNode.class, "lruTail");
    private static AtomicReferenceFieldUpdater nextUpdater = AtomicReferenceFieldUpdater.newUpdater(LRUNode.class, LRUNode.class, "next");
    private static AtomicIntegerFieldUpdater countUpdater = AtomicIntegerFieldUpdater.newUpdater(ConcurrentCache.class, "lruCount");

    private ConcurrentCache() {
    }

    private boolean isPCHRunning() {
        if (!this.pchMonitoring) {
            return false;
        }
        return PCH.isRunning;
    }

    public ConcurrentCache(boolean needsByValue, int ttlVal, int maxEntriesVal, String objectStoreName, String cacheName, String category, boolean pchMonitoringVal) {
        if (needsByValue) {
            this.valueMap = new ConcurrentHashMap();
        }
        this.ttl = ttlVal;
        this.maxEntries = maxEntriesVal;
        this.pchMonitoring = pchMonitoringVal;
        if (this.isPCHRunning()) {
            if (objectStoreName == null && category == null) {
                this.pchCacheAttempts = PCH.lookupEventByServer(cacheName, "Cache Attempt Count");
                this.pchCacheHits = PCH.lookupEventByServer(cacheName, "Cache Hit Count");
                this.pchCacheEntries = PCH.lookupMeterByServer(cacheName, "Cache Entries");
            } else if (objectStoreName == null) {
                this.pchCacheAttempts = PCH.lookupEventByServerCategory(category, cacheName, "Cache Attempt Count");
                this.pchCacheHits = PCH.lookupEventByServerCategory(category, cacheName, "Cache Hit Count");
                this.pchCacheEntries = PCH.lookupMeterByServerCategory(category, cacheName, "Cache Entries");
            } else {
                this.pchCacheAttempts = PCH.lookupEventByObjectStore(objectStoreName, cacheName, "Cache Attempt Count");
                this.pchCacheHits = PCH.lookupEventByObjectStore(objectStoreName, cacheName, "Cache Hit Count");
                this.pchCacheEntries = PCH.lookupMeterByObjectStore(objectStoreName, cacheName, "Cache Entries");
            }
        }
    }

    public ConcurrentCache(boolean needsByValue, int ttlVal, int maxEntriesVal, String objectStoreName, String cacheName, boolean pchMonitoringVal) {
        this(needsByValue, ttlVal, maxEntriesVal, objectStoreName, cacheName, null, pchMonitoringVal);
    }

    public ConcurrentCache(boolean needsByValue, int ttlVal, int maxEntriesVal) {
        this(needsByValue, ttlVal, maxEntriesVal, null, null, null, false);
    }

    public int size() {
        return this.idMap.size();
    }

    public void dump() {
        System.out.println("*** Dumping " + this.size() + " idMap entries");
        Iterator it = this.idMap.entrySet().iterator();
        while (it.hasNext()) {
            System.out.println("    " + it.next().toString());
        }
        if (this.valueMap != null) {
            System.out.println("*** Dumping " + this.valueMap.size() + " valueMap entries");
            it = this.valueMap.entrySet().iterator();
            while (it.hasNext()) {
                System.out.println("    " + it.next().toString());
            }
        }
        System.out.println("*** LRU queue contains " + this.lruCount + " nodes");
        int validNodes = 0;
        LRUNode node = this.lruHead.next;
        while (node != null) {
            if (node.entry == null) {
                System.out.println("    Null entry node " + node.toString());
            } else if (node.isValid()) {
                System.out.println("    Valid node referencing " + node.entry.toString() + ", id=" + node.entry.getId().toString());
                ++validNodes;
            } else {
                System.out.println("    Invalid node referencing " + node.entry.toString() + ", id=" + node.entry.getId().toString());
            }
            node = node.next;
        }
        System.out.println("*** " + validNodes + " valid LRU nodes");
    }

    public void add(CacheEntry ce) {
        ce.setExpiry(this.ttl > 0 ? System.currentTimeMillis() + (long)(this.ttl * 1000) : 0L);
        LRUNode add = null;
        if (this.maxEntries != 0) {
            ce.lruNode = add = new LRUNode(ce);
        }
        CacheEntry repValue = null;
        if (this.valueMap != null && ce.getValue() != null) {
            repValue = this.valueMap.put(ce.getValue(), ce);
        }
        CacheEntry replaced = this.idMap.put(ce.getId(), ce);
        if (this.maxEntries != 0) {
            this.enqueue(add);
            if (replaced != null && replaced != ce) {
                replaced.lruNode = null;
            }
            if (repValue != null && repValue != ce) {
                repValue.lruNode = null;
            }
            this.evict();
        }
        if (this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    private void remove(CacheEntry ce) {
        CacheEntry removed = (CacheEntry)this.idMap.remove(ce.getId());
        if (removed == ce) {
            ce.lruNode = null;
        } else if (removed != null) {
            this.idMap.put(removed.getId(), removed);
        }
        if (this.valueMap != null && ce.getValue() != null) {
            removed = (CacheEntry)this.valueMap.remove(ce.getValue());
            if (removed == ce) {
                ce.lruNode = null;
            } else if (removed != null) {
                this.valueMap.put(removed.getValue(), removed);
            }
        }
    }

    public void removeCacheEntry(CacheEntry ce) {
        this.remove(ce);
        if (this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    public CacheEntry find(Object id) {
        if (this.isPCHRunning()) {
            this.pchCacheAttempts.recordEvent();
        }
        if (id == null) {
            return null;
        }
        CacheEntry ce = (CacheEntry)this.idMap.get(id);
        if (ce != null) {
            if (!ce.hasExpired()) {
                this.promote(ce);
                if (this.isPCHRunning()) {
                    this.pchCacheHits.recordEvent();
                }
                return ce;
            }
            this.remove(ce);
            if (this.isPCHRunning()) {
                this.pchCacheEntries.setValue((long)this.idMap.size());
            }
        }
        return null;
    }

    public CacheEntry findByValue(Object value) {
        if (this.isPCHRunning()) {
            this.pchCacheAttempts.recordEvent();
        }
        if (this.valueMap == null) {
            return null;
        }
        CacheEntry ce = (CacheEntry)this.valueMap.get(value);
        if (ce != null) {
            if (!ce.hasExpired()) {
                this.promote(ce);
                if (this.isPCHRunning()) {
                    this.pchCacheHits.recordEvent();
                }
                return ce;
            }
            this.remove(ce);
            if (this.isPCHRunning()) {
                this.pchCacheEntries.setValue((long)this.idMap.size());
            }
        }
        return null;
    }

    public void purge(Object id) {
        CacheEntry ce = (CacheEntry)this.idMap.remove(id);
        if (ce != null) {
            CacheEntry removed;
            ce.lruNode = null;
            if (ce.getValue() != null && this.valueMap != null && (removed = (CacheEntry)this.valueMap.remove(ce.getValue())) != null && !id.equals(removed.getId())) {
                this.valueMap.put(removed.getValue(), removed);
            }
        }
        if (this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    public void setMaxEntries(int maxEntriesVal) {
        super.setMaxEntries(maxEntriesVal);
        if (this.evict() && this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    private void promote(CacheEntry ce) {
        LRUNode newQ;
        if (this.maxEntries == 0) {
            return;
        }
        ce.lruNode = newQ = new LRUNode(ce);
        this.enqueue(newQ);
        if (this.evict() && this.isPCHRunning()) {
            this.pchCacheEntries.setValue((long)this.idMap.size());
        }
    }

    private void enqueue(LRUNode enq) {
        LRUNode tail;
        while (true) {
            if (!enq.isValid()) {
                return;
            }
            tail = this.lruTail;
            LRUNode next = tail.next;
            if (tail != this.lruTail) continue;
            if (next == null) {
                if (!nextUpdater.compareAndSet(tail, next, enq)) continue;
                break;
            }
            tailUpdater.compareAndSet(this, tail, next);
        }
        tailUpdater.compareAndSet(this, tail, enq);
        countUpdater.incrementAndGet(this);
    }

    private boolean evict() {
        if (this.maxEntries == 0) {
            return false;
        }
        boolean evicted = false;
        while (true) {
            LRUNode head = this.lruHead;
            LRUNode tail = this.lruTail;
            LRUNode next = head.next;
            if (head != this.lruHead) continue;
            if (head == tail) {
                if (next == null) {
                    return evicted;
                }
                tailUpdater.compareAndSet(this, tail, next);
                continue;
            }
            if (next.isValid() && !this.needEvictions()) break;
            if (!headUpdater.compareAndSet(this, head, next)) continue;
            countUpdater.decrementAndGet(this);
            if (!next.isValid()) continue;
            this.remove(next.entry);
            evicted = true;
        }
        return evicted;
    }

    private boolean needEvictions() {
        return this.idMap.size() > this.maxEntries || countUpdater.get(this) > this.maxEntries * LRU_QUEUE_MAX_FACTOR;
    }

    static class LRUNode {
        volatile CacheEntry entry;
        volatile LRUNode next;

        LRUNode(CacheEntry entry) {
            this.entry = entry;
            this.next = null;
        }

        boolean isValid() {
            return this.entry != null && this.entry.lruNode == this;
        }
    }
}

