/*
 * Decompiled with CFR 0.152.
 */
package com.filenet.apiimpl.util;

import com.filenet.api.action.Create;
import com.filenet.api.constants.Cardinality;
import com.filenet.api.constants.PropertySettability;
import com.filenet.api.constants.PropertyState;
import com.filenet.api.constants.TypeID;
import com.filenet.api.core.EngineObject;
import com.filenet.api.core.Factory;
import com.filenet.api.core.IndependentlyPersistableObject;
import com.filenet.api.core.ObjectStore;
import com.filenet.api.core.RepositoryObject;
import com.filenet.api.core.VersionSeries;
import com.filenet.api.core.Versionable;
import com.filenet.api.exception.EngineRuntimeException;
import com.filenet.api.exception.ExceptionCode;
import com.filenet.api.meta.PropertyDescription;
import com.filenet.api.property.Properties;
import com.filenet.api.property.Property;
import com.filenet.api.property.PropertyEngineObject;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.util.Id;

public class CachePropIE {
    private EngineObject engineObj = null;
    private PropertyDescription propDesc = null;
    private String propName = null;
    private TypeID propType = null;

    public CachePropIE(EngineObject engineObj, PropertyDescription propDesc) {
        this.engineObj = engineObj;
        this.propDesc = propDesc;
        this.propName = propDesc.get_SymbolicName();
        this.propType = propDesc.get_DataType();
    }

    public boolean isValueSet() {
        if (this.propDesc.get_Cardinality() != Cardinality.SINGLE) {
            return true;
        }
        Properties props = this.engineObj.getProperties();
        if (props.isPropertyPresent(this.propName)) {
            Property prop = props.get(this.propName);
            PropertyState ps = prop.getState();
            if (ps == PropertyState.VALUE || ps == PropertyState.REFERENCE) {
                return true;
            }
            if (ps == PropertyState.UNEVALUATED) {
                Object val = CachePropIE.getPropValue(this.propType, prop);
                return val != null;
            }
            return false;
        }
        Object DefaultValue = this.getDefaultValue();
        return DefaultValue != null;
    }

    private Object getDefaultValue() {
        String defaultPropName;
        if (this.propName == "Id" && this.engineObj instanceof IndependentlyPersistableObject) {
            Create cr = (Create)((IndependentlyPersistableObject)this.engineObj).getPendingActions()[0];
            return new Id(cr.getObjectId());
        }
        if (this.propName == "MajorVersionNumber") {
            return new Integer(0);
        }
        if (this.propName == "MinorVersionNumber") {
            return new Integer(1);
        }
        if (this.propName == "VersionStatus") {
            return new Integer(3);
        }
        if (this.propName == "IsReserved") {
            return Boolean.TRUE;
        }
        if (this.propName == "VersionSeries" && this.engineObj instanceof Versionable) {
            ObjectStore objStore = ((RepositoryObject)((Object)this.engineObj)).getObjectStore();
            Id vsId = Id.createId();
            VersionSeries vs = Factory.VersionSeries.getInstance(objStore, vsId);
            vs.getProperties().get("Id").setObjectValue(vsId);
            this.engineObj.getProperties().get("VersionSeries").setObjectValue(vs);
            return vs;
        }
        switch (this.propDesc.get_DataType().getValue()) {
            case 1: {
                defaultPropName = "PropertyDefaultBinary";
                break;
            }
            case 2: {
                defaultPropName = "PropertyDefaultBoolean";
                break;
            }
            case 3: {
                defaultPropName = "PropertyDefaultDateTime";
                break;
            }
            case 4: {
                defaultPropName = "PropertyDefaultFloat64";
                break;
            }
            case 5: {
                defaultPropName = "PropertyDefaultId";
                break;
            }
            case 6: {
                defaultPropName = "PropertyDefaultInteger32";
                break;
            }
            case 7: {
                defaultPropName = "PropertyDefaultObject";
                break;
            }
            case 8: {
                defaultPropName = "PropertyDefaultString";
                break;
            }
            default: {
                throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED);
            }
        }
        Properties props = this.propDesc.getProperties();
        if (props.isPropertyPresent(defaultPropName)) {
            Property prop = props.get(defaultPropName);
            PropertyState ps = prop.getState();
            if (ps == PropertyState.VALUE) {
                return prop.getObjectValue();
            }
            if (ps == PropertyState.REFERENCE) {
                return ((PropertyEngineObject)prop).fetchIndependentObject(this.propFilter());
            }
        }
        return null;
    }

    public int getAccess() {
        Properties props = this.engineObj.getProperties();
        if (props.isPropertyPresent(this.propName)) {
            Property prop = props.get(this.propName);
            if (prop.isSettable() && this.propDesc.get_Settability() != PropertySettability.READ_ONLY) {
                return 7;
            }
            return 1;
        }
        if (this.propDesc.get_Settability() == PropertySettability.READ_ONLY) {
            return 1;
        }
        return 7;
    }

    public TypeID getTypeID() {
        return this.propType;
    }

    public PropertyDescription getPropertyDescription() {
        return this.propDesc;
    }

    public String getName() {
        return this.propName;
    }

    private PropertyFilter propFilter() {
        PropertyFilter pf = new PropertyFilter();
        pf.setLevelDependents(true);
        pf.addExcludeProperty("QueryOperatorDescriptions");
        return pf;
    }

    private static Object getPropValue(TypeID propType, Property prop) {
        switch (propType.getValue()) {
            case 1: {
                return prop.getBinaryValue();
            }
            case 2: {
                return prop.getBooleanValue();
            }
            case 3: {
                return prop.getDateTimeValue();
            }
            case 4: {
                return prop.getFloat64Value();
            }
            case 5: {
                return prop.getIdValue();
            }
            case 6: {
                return prop.getInteger32Value();
            }
            case 7: {
                return prop.getObjectValue();
            }
            case 8: {
                return prop.getStringValue();
            }
        }
        throw new EngineRuntimeException(ExceptionCode.E_UNEXPECTED);
    }
}

